<?php

namespace PHPMaker2024\cidp24;

// Page object
$MusersEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fmusersedit" id="fmusersedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { musers: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fmusersedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmusersedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["UserCode", [fields.UserCode.visible && fields.UserCode.required ? ew.Validators.required(fields.UserCode.caption) : null], fields.UserCode.isInvalid],
            ["_UserName", [fields._UserName.visible && fields._UserName.required ? ew.Validators.required(fields._UserName.caption) : null], fields._UserName.isInvalid],
            ["_Password", [fields._Password.visible && fields._Password.required ? ew.Validators.required(fields._Password.caption) : null, ew.Validators.passwordStrength], fields._Password.isInvalid],
            ["ConfirmPwd", [fields.ConfirmPwd.visible && fields.ConfirmPwd.required ? ew.Validators.required(fields.ConfirmPwd.caption) : null], fields.ConfirmPwd.isInvalid],
            ["FirstName", [fields.FirstName.visible && fields.FirstName.required ? ew.Validators.required(fields.FirstName.caption) : null], fields.FirstName.isInvalid],
            ["LastName", [fields.LastName.visible && fields.LastName.required ? ew.Validators.required(fields.LastName.caption) : null], fields.LastName.isInvalid],
            ["Level", [fields.Level.visible && fields.Level.required ? ew.Validators.required(fields.Level.caption) : null], fields.Level.isInvalid],
            ["Role", [fields.Role.visible && fields.Role.required ? ew.Validators.required(fields.Role.caption) : null], fields.Role.isInvalid],
            ["Clearance", [fields.Clearance.visible && fields.Clearance.required ? ew.Validators.required(fields.Clearance.caption) : null], fields.Clearance.isInvalid],
            ["Active", [fields.Active.visible && fields.Active.required ? ew.Validators.required(fields.Active.caption) : null, ew.Validators.integer], fields.Active.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.email], fields._Email.isInvalid],
            ["Telephone", [fields.Telephone.visible && fields.Telephone.required ? ew.Validators.required(fields.Telephone.caption) : null], fields.Telephone.isInvalid],
            ["Mobile", [fields.Mobile.visible && fields.Mobile.required ? ew.Validators.required(fields.Mobile.caption) : null], fields.Mobile.isInvalid],
            ["Position", [fields.Position.visible && fields.Position.required ? ew.Validators.required(fields.Position.caption) : null], fields.Position.isInvalid],
            ["ReportsTo", [fields.ReportsTo.visible && fields.ReportsTo.required ? ew.Validators.required(fields.ReportsTo.caption) : null, ew.Validators.integer], fields.ReportsTo.isInvalid],
            ["_Profile", [fields._Profile.visible && fields._Profile.required ? ew.Validators.required(fields._Profile.caption) : null], fields._Profile.isInvalid],
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null, ew.Validators.integer], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null, ew.Validators.integer], fields.DistrictCode.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Level": <?= $Page->Level->toClientList($Page) ?>,
            "Role": <?= $Page->Role->toClientList($Page) ?>,
            "Clearance": <?= $Page->Clearance->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="musers">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->UserCode->Visible) { // UserCode ?>
    <div id="r_UserCode"<?= $Page->UserCode->rowAttributes() ?>>
        <label id="elh_musers_UserCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->UserCode->caption() ?><?= $Page->UserCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->UserCode->cellAttributes() ?>>
<span id="el_musers_UserCode">
<span<?= $Page->UserCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->UserCode->getDisplayValue($Page->UserCode->EditValue))) ?>"></span>
<input type="hidden" data-table="musers" data-field="x_UserCode" data-hidden="1" name="x_UserCode" id="x_UserCode" value="<?= HtmlEncode($Page->UserCode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_UserName->Visible) { // UserName ?>
    <div id="r__UserName"<?= $Page->_UserName->rowAttributes() ?>>
        <label id="elh_musers__UserName" for="x__UserName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_UserName->caption() ?><?= $Page->_UserName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_UserName->cellAttributes() ?>>
<span id="el_musers__UserName">
<input type="<?= $Page->_UserName->getInputTextType() ?>" name="x__UserName" id="x__UserName" data-table="musers" data-field="x__UserName" value="<?= $Page->_UserName->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_UserName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_UserName->formatPattern()) ?>"<?= $Page->_UserName->editAttributes() ?> aria-describedby="x__UserName_help">
<?= $Page->_UserName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_UserName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Password->Visible) { // Password ?>
    <div id="r__Password"<?= $Page->_Password->rowAttributes() ?>>
        <label id="elh_musers__Password" for="x__Password" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Password->caption() ?><?= $Page->_Password->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Password->cellAttributes() ?>>
<span id="el_musers__Password">
<div class="input-group" id="ig__Password">
    <input type="password" autocomplete="new-password" data-password-strength="pst__Password" data-table="musers" data-field="x__Password" name="x__Password" id="x__Password" value="<?= $Page->_Password->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_Password->getPlaceHolder()) ?>"<?= $Page->_Password->editAttributes() ?> aria-describedby="x__Password_help">
    <button type="button" class="btn btn-default ew-toggle-password" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
    <button type="button" class="btn btn-default ew-password-generator rounded-end" title="<?= HtmlTitle($Language->phrase("GeneratePassword")) ?>" data-password-field="x__Password" data-password-confirm="c__Password" data-password-strength="pst__Password"><?= $Language->phrase("GeneratePassword") ?></button>
</div>
<div class="progress ew-password-strength-bar form-text mt-1 d-none" id="pst__Password" role="progressbar">
    <div class="progress-bar"></div>
</div>
<?= $Page->_Password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ConfirmPwd->Visible) { // ConfirmPwd ?>
    <div id="r_ConfirmPwd"<?= $Page->ConfirmPwd->rowAttributes() ?>>
        <label id="elh_musers_ConfirmPwd" for="x_ConfirmPwd" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ConfirmPwd->caption() ?><?= $Page->ConfirmPwd->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ConfirmPwd->cellAttributes() ?>>
<span id="el_musers_ConfirmPwd">
<div class="input-group">
    <input type="password" name="x_ConfirmPwd" id="x_ConfirmPwd" autocomplete="new-password" data-table="musers" data-field="x_ConfirmPwd" value="<?= $Page->ConfirmPwd->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->ConfirmPwd->getPlaceHolder()) ?>"<?= $Page->ConfirmPwd->editAttributes() ?> aria-describedby="x_ConfirmPwd_help">
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
</div>
<?= $Page->ConfirmPwd->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ConfirmPwd->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FirstName->Visible) { // FirstName ?>
    <div id="r_FirstName"<?= $Page->FirstName->rowAttributes() ?>>
        <label id="elh_musers_FirstName" for="x_FirstName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FirstName->caption() ?><?= $Page->FirstName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FirstName->cellAttributes() ?>>
<span id="el_musers_FirstName">
<input type="<?= $Page->FirstName->getInputTextType() ?>" name="x_FirstName" id="x_FirstName" data-table="musers" data-field="x_FirstName" value="<?= $Page->FirstName->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->FirstName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FirstName->formatPattern()) ?>"<?= $Page->FirstName->editAttributes() ?> aria-describedby="x_FirstName_help">
<?= $Page->FirstName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FirstName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->LastName->Visible) { // LastName ?>
    <div id="r_LastName"<?= $Page->LastName->rowAttributes() ?>>
        <label id="elh_musers_LastName" for="x_LastName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->LastName->caption() ?><?= $Page->LastName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->LastName->cellAttributes() ?>>
<span id="el_musers_LastName">
<input type="<?= $Page->LastName->getInputTextType() ?>" name="x_LastName" id="x_LastName" data-table="musers" data-field="x_LastName" value="<?= $Page->LastName->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->LastName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LastName->formatPattern()) ?>"<?= $Page->LastName->editAttributes() ?> aria-describedby="x_LastName_help">
<?= $Page->LastName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->LastName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Level->Visible) { // Level ?>
    <div id="r_Level"<?= $Page->Level->rowAttributes() ?>>
        <label id="elh_musers_Level" for="x_Level" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Level->caption() ?><?= $Page->Level->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Level->cellAttributes() ?>>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
<span id="el_musers_Level">
<span class="form-control-plaintext"><?= $Page->Level->getDisplayValue($Page->Level->EditValue) ?></span>
</span>
<?php } else { ?>
<span id="el_musers_Level">
    <select
        id="x_Level"
        name="x_Level"
        class="form-select ew-select<?= $Page->Level->isInvalidClass() ?>"
        <?php if (!$Page->Level->IsNativeSelect) { ?>
        data-select2-id="fmusersedit_x_Level"
        <?php } ?>
        data-table="musers"
        data-field="x_Level"
        data-value-separator="<?= $Page->Level->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Level->getPlaceHolder()) ?>"
        <?= $Page->Level->editAttributes() ?>>
        <?= $Page->Level->selectOptionListHtml("x_Level") ?>
    </select>
    <?= $Page->Level->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Level->getErrorMessage() ?></div>
<?= $Page->Level->Lookup->getParamTag($Page, "p_x_Level") ?>
<?php if (!$Page->Level->IsNativeSelect) { ?>
<script>
loadjs.ready("fmusersedit", function() {
    var options = { name: "x_Level", selectId: "fmusersedit_x_Level" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmusersedit.lists.Level?.lookupOptions.length) {
        options.data = { id: "x_Level", form: "fmusersedit" };
    } else {
        options.ajax = { id: "x_Level", form: "fmusersedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.musers.fields.Level.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Role->Visible) { // Role ?>
    <div id="r_Role"<?= $Page->Role->rowAttributes() ?>>
        <label id="elh_musers_Role" for="x_Role" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Role->caption() ?><?= $Page->Role->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Role->cellAttributes() ?>>
<span id="el_musers_Role">
    <select
        id="x_Role"
        name="x_Role"
        class="form-select ew-select<?= $Page->Role->isInvalidClass() ?>"
        <?php if (!$Page->Role->IsNativeSelect) { ?>
        data-select2-id="fmusersedit_x_Role"
        <?php } ?>
        data-table="musers"
        data-field="x_Role"
        data-value-separator="<?= $Page->Role->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Role->getPlaceHolder()) ?>"
        <?= $Page->Role->editAttributes() ?>>
        <?= $Page->Role->selectOptionListHtml("x_Role") ?>
    </select>
    <?= $Page->Role->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Role->getErrorMessage() ?></div>
<?= $Page->Role->Lookup->getParamTag($Page, "p_x_Role") ?>
<?php if (!$Page->Role->IsNativeSelect) { ?>
<script>
loadjs.ready("fmusersedit", function() {
    var options = { name: "x_Role", selectId: "fmusersedit_x_Role" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmusersedit.lists.Role?.lookupOptions.length) {
        options.data = { id: "x_Role", form: "fmusersedit" };
    } else {
        options.ajax = { id: "x_Role", form: "fmusersedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.musers.fields.Role.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Clearance->Visible) { // Clearance ?>
    <div id="r_Clearance"<?= $Page->Clearance->rowAttributes() ?>>
        <label id="elh_musers_Clearance" for="x_Clearance" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Clearance->caption() ?><?= $Page->Clearance->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Clearance->cellAttributes() ?>>
<span id="el_musers_Clearance">
    <select
        id="x_Clearance"
        name="x_Clearance"
        class="form-select ew-select<?= $Page->Clearance->isInvalidClass() ?>"
        <?php if (!$Page->Clearance->IsNativeSelect) { ?>
        data-select2-id="fmusersedit_x_Clearance"
        <?php } ?>
        data-table="musers"
        data-field="x_Clearance"
        data-value-separator="<?= $Page->Clearance->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Clearance->getPlaceHolder()) ?>"
        <?= $Page->Clearance->editAttributes() ?>>
        <?= $Page->Clearance->selectOptionListHtml("x_Clearance") ?>
    </select>
    <?= $Page->Clearance->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Clearance->getErrorMessage() ?></div>
<?= $Page->Clearance->Lookup->getParamTag($Page, "p_x_Clearance") ?>
<?php if (!$Page->Clearance->IsNativeSelect) { ?>
<script>
loadjs.ready("fmusersedit", function() {
    var options = { name: "x_Clearance", selectId: "fmusersedit_x_Clearance" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmusersedit.lists.Clearance?.lookupOptions.length) {
        options.data = { id: "x_Clearance", form: "fmusersedit" };
    } else {
        options.ajax = { id: "x_Clearance", form: "fmusersedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.musers.fields.Clearance.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
    <div id="r_Active"<?= $Page->Active->rowAttributes() ?>>
        <label id="elh_musers_Active" for="x_Active" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Active->caption() ?><?= $Page->Active->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Active->cellAttributes() ?>>
<span id="el_musers_Active">
<input type="<?= $Page->Active->getInputTextType() ?>" name="x_Active" id="x_Active" data-table="musers" data-field="x_Active" value="<?= $Page->Active->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Active->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Active->formatPattern()) ?>"<?= $Page->Active->editAttributes() ?> aria-describedby="x_Active_help">
<?= $Page->Active->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Active->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label id="elh_musers__Email" for="x__Email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Email->caption() ?><?= $Page->_Email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Email->cellAttributes() ?>>
<span id="el_musers__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="musers" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
<?= $Page->_Email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Telephone->Visible) { // Telephone ?>
    <div id="r_Telephone"<?= $Page->Telephone->rowAttributes() ?>>
        <label id="elh_musers_Telephone" for="x_Telephone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Telephone->caption() ?><?= $Page->Telephone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Telephone->cellAttributes() ?>>
<span id="el_musers_Telephone">
<input type="<?= $Page->Telephone->getInputTextType() ?>" name="x_Telephone" id="x_Telephone" data-table="musers" data-field="x_Telephone" value="<?= $Page->Telephone->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->Telephone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Telephone->formatPattern()) ?>"<?= $Page->Telephone->editAttributes() ?> aria-describedby="x_Telephone_help">
<?= $Page->Telephone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Telephone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Mobile->Visible) { // Mobile ?>
    <div id="r_Mobile"<?= $Page->Mobile->rowAttributes() ?>>
        <label id="elh_musers_Mobile" for="x_Mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Mobile->caption() ?><?= $Page->Mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Mobile->cellAttributes() ?>>
<span id="el_musers_Mobile">
<input type="<?= $Page->Mobile->getInputTextType() ?>" name="x_Mobile" id="x_Mobile" data-table="musers" data-field="x_Mobile" value="<?= $Page->Mobile->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Mobile->formatPattern()) ?>"<?= $Page->Mobile->editAttributes() ?> aria-describedby="x_Mobile_help">
<?= $Page->Mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Position->Visible) { // Position ?>
    <div id="r_Position"<?= $Page->Position->rowAttributes() ?>>
        <label id="elh_musers_Position" for="x_Position" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Position->caption() ?><?= $Page->Position->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Position->cellAttributes() ?>>
<span id="el_musers_Position">
<input type="<?= $Page->Position->getInputTextType() ?>" name="x_Position" id="x_Position" data-table="musers" data-field="x_Position" value="<?= $Page->Position->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Position->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Position->formatPattern()) ?>"<?= $Page->Position->editAttributes() ?> aria-describedby="x_Position_help">
<?= $Page->Position->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Position->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ReportsTo->Visible) { // ReportsTo ?>
    <div id="r_ReportsTo"<?= $Page->ReportsTo->rowAttributes() ?>>
        <label id="elh_musers_ReportsTo" for="x_ReportsTo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ReportsTo->caption() ?><?= $Page->ReportsTo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ReportsTo->cellAttributes() ?>>
<span id="el_musers_ReportsTo">
<input type="<?= $Page->ReportsTo->getInputTextType() ?>" name="x_ReportsTo" id="x_ReportsTo" data-table="musers" data-field="x_ReportsTo" value="<?= $Page->ReportsTo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ReportsTo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReportsTo->formatPattern()) ?>"<?= $Page->ReportsTo->editAttributes() ?> aria-describedby="x_ReportsTo_help">
<?= $Page->ReportsTo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ReportsTo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Profile->Visible) { // Profile ?>
    <div id="r__Profile"<?= $Page->_Profile->rowAttributes() ?>>
        <label id="elh_musers__Profile" for="x__Profile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Profile->caption() ?><?= $Page->_Profile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Profile->cellAttributes() ?>>
<span id="el_musers__Profile">
<textarea data-table="musers" data-field="x__Profile" name="x__Profile" id="x__Profile" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->_Profile->getPlaceHolder()) ?>"<?= $Page->_Profile->editAttributes() ?> aria-describedby="x__Profile_help"><?= $Page->_Profile->EditValue ?></textarea>
<?= $Page->_Profile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Profile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_musers_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el_musers_ProvinceCode">
<input type="<?= $Page->ProvinceCode->getInputTextType() ?>" name="x_ProvinceCode" id="x_ProvinceCode" data-table="musers" data-field="x_ProvinceCode" value="<?= $Page->ProvinceCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProvinceCode->formatPattern()) ?>"<?= $Page->ProvinceCode->editAttributes() ?> aria-describedby="x_ProvinceCode_help">
<?= $Page->ProvinceCode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_musers_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el_musers_DistrictCode">
<input type="<?= $Page->DistrictCode->getInputTextType() ?>" name="x_DistrictCode" id="x_DistrictCode" data-table="musers" data-field="x_DistrictCode" value="<?= $Page->DistrictCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictCode->formatPattern()) ?>"<?= $Page->DistrictCode->editAttributes() ?> aria-describedby="x_DistrictCode_help">
<?= $Page->DistrictCode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?php
    if (in_array("security_matrix", explode(",", $Page->getCurrentDetailTable())) && $security_matrix->DetailEdit) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("security_matrix", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "SecurityMatrixGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmusersedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmusersedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("musers");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
