<?php

namespace PHPMaker2024\cidp24;

// Page object
$GrnViewSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { grn_view: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fgrn_viewsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fgrn_viewsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProvinceName", [], fields.ProvinceName.isInvalid],
            ["DistrictName", [], fields.DistrictName.isInvalid],
            ["SeedlingsReceived", [ew.Validators.float], fields.SeedlingsReceived.isInvalid],
            ["SeedsReceived", [ew.Validators.float], fields.SeedsReceived.isInvalid],
            ["SeedType", [], fields.SeedType.isInvalid],
            ["GRN", [], fields.GRN.isInvalid],
            ["FarmingSeason", [ew.Validators.integer], fields.FarmingSeason.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgrn_viewsearch" id="fgrn_viewsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="grn_view">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ProvinceName->Visible) { // ProvinceName ?>
    <div id="r_ProvinceName" class="row"<?= $Page->ProvinceName->rowAttributes() ?>>
        <label for="x_ProvinceName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grn_view_ProvinceName"><?= $Page->ProvinceName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ProvinceName" id="z_ProvinceName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProvinceName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grn_view_ProvinceName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProvinceName->getInputTextType() ?>" name="x_ProvinceName" id="x_ProvinceName" data-table="grn_view" data-field="x_ProvinceName" value="<?= $Page->ProvinceName->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->ProvinceName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProvinceName->formatPattern()) ?>"<?= $Page->ProvinceName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProvinceName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
    <div id="r_DistrictName" class="row"<?= $Page->DistrictName->rowAttributes() ?>>
        <label for="x_DistrictName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grn_view_DistrictName"><?= $Page->DistrictName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_DistrictName" id="z_DistrictName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grn_view_DistrictName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DistrictName->getInputTextType() ?>" name="x_DistrictName" id="x_DistrictName" data-table="grn_view" data-field="x_DistrictName" value="<?= $Page->DistrictName->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictName->formatPattern()) ?>"<?= $Page->DistrictName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedlingsReceived->Visible) { // SeedlingsReceived ?>
    <div id="r_SeedlingsReceived" class="row"<?= $Page->SeedlingsReceived->rowAttributes() ?>>
        <label for="x_SeedlingsReceived" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grn_view_SeedlingsReceived"><?= $Page->SeedlingsReceived->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SeedlingsReceived" id="z_SeedlingsReceived" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedlingsReceived->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grn_view_SeedlingsReceived" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedlingsReceived->getInputTextType() ?>" name="x_SeedlingsReceived" id="x_SeedlingsReceived" data-table="grn_view" data-field="x_SeedlingsReceived" value="<?= $Page->SeedlingsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsReceived->formatPattern()) ?>"<?= $Page->SeedlingsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsReceived->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedsReceived->Visible) { // SeedsReceived ?>
    <div id="r_SeedsReceived" class="row"<?= $Page->SeedsReceived->rowAttributes() ?>>
        <label for="x_SeedsReceived" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grn_view_SeedsReceived"><?= $Page->SeedsReceived->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SeedsReceived" id="z_SeedsReceived" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedsReceived->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grn_view_SeedsReceived" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedsReceived->getInputTextType() ?>" name="x_SeedsReceived" id="x_SeedsReceived" data-table="grn_view" data-field="x_SeedsReceived" value="<?= $Page->SeedsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedsReceived->formatPattern()) ?>"<?= $Page->SeedsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedsReceived->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
    <div id="r_SeedType" class="row"<?= $Page->SeedType->rowAttributes() ?>>
        <label for="x_SeedType" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grn_view_SeedType"><?= $Page->SeedType->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_SeedType" id="z_SeedType" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedType->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grn_view_SeedType" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedType->getInputTextType() ?>" name="x_SeedType" id="x_SeedType" data-table="grn_view" data-field="x_SeedType" value="<?= $Page->SeedType->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedType->formatPattern()) ?>"<?= $Page->SeedType->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
    <div id="r_GRN" class="row"<?= $Page->GRN->rowAttributes() ?>>
        <label for="x_GRN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grn_view_GRN"><?= $Page->GRN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_GRN" id="z_GRN" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->GRN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grn_view_GRN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x_GRN" id="x_GRN" data-table="grn_view" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
    <div id="r_FarmingSeason" class="row"<?= $Page->FarmingSeason->rowAttributes() ?>>
        <label for="x_FarmingSeason" class="<?= $Page->LeftColumnClass ?>"><span id="elh_grn_view_FarmingSeason"><?= $Page->FarmingSeason->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmingSeason" id="z_FarmingSeason" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmingSeason->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_grn_view_FarmingSeason" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmingSeason->getInputTextType() ?>" name="x_FarmingSeason" id="x_FarmingSeason" data-table="grn_view" data-field="x_FarmingSeason" value="<?= $Page->FarmingSeason->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmingSeason->formatPattern()) ?>"<?= $Page->FarmingSeason->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgrn_viewsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgrn_viewsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fgrn_viewsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("grn_view");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
