<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("GrantBeneficiaryGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fgrant_beneficiarygrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { grant_beneficiary: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fgrant_beneficiarygrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["GrantNo", [fields.GrantNo.visible && fields.GrantNo.required ? ew.Validators.required(fields.GrantNo.caption) : null, ew.Validators.integer], fields.GrantNo.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["AmountDisbursed", [fields.AmountDisbursed.visible && fields.AmountDisbursed.required ? ew.Validators.required(fields.AmountDisbursed.caption) : null, ew.Validators.float], fields.AmountDisbursed.isInvalid],
            ["ApplicationDate", [fields.ApplicationDate.visible && fields.ApplicationDate.required ? ew.Validators.required(fields.ApplicationDate.caption) : null, ew.Validators.datetime(fields.ApplicationDate.clientFormatPattern)], fields.ApplicationDate.isInvalid],
            ["AmountAppliedFor", [fields.AmountAppliedFor.visible && fields.AmountAppliedFor.required ? ew.Validators.required(fields.AmountAppliedFor.caption) : null, ew.Validators.float], fields.AmountAppliedFor.isInvalid],
            ["ReplyDate", [fields.ReplyDate.visible && fields.ReplyDate.required ? ew.Validators.required(fields.ReplyDate.caption) : null, ew.Validators.datetime(fields.ReplyDate.clientFormatPattern)], fields.ReplyDate.isInvalid],
            ["Approved", [fields.Approved.visible && fields.Approved.required ? ew.Validators.required(fields.Approved.caption) : null], fields.Approved.isInvalid],
            ["ReasonsForRejection", [fields.ReasonsForRejection.visible && fields.ReasonsForRejection.required ? ew.Validators.required(fields.ReasonsForRejection.caption) : null], fields.ReasonsForRejection.isInvalid],
            ["Purpose", [fields.Purpose.visible && fields.Purpose.required ? ew.Validators.required(fields.Purpose.caption) : null], fields.Purpose.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["GrantNo",false],["NRC",false],["AmountDisbursed",false],["ApplicationDate",false],["AmountAppliedFor",false],["ReplyDate",false],["Approved",true],["ReasonsForRejection",false],["Purpose",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "NRC": <?= $Grid->NRC->toClientList($Grid) ?>,
            "Approved": <?= $Grid->Approved->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fgrant_beneficiarygrid" class="ew-form ew-list-form">
<div id="gmp_grant_beneficiary" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_grant_beneficiarygrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->GrantNo->Visible) { // GrantNo ?>
        <th data-name="GrantNo" class="<?= $Grid->GrantNo->headerCellClass() ?>"><div id="elh_grant_beneficiary_GrantNo" class="grant_beneficiary_GrantNo"><?= $Grid->renderFieldHeader($Grid->GrantNo) ?></div></th>
<?php } ?>
<?php if ($Grid->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Grid->NRC->headerCellClass() ?>"><div id="elh_grant_beneficiary_NRC" class="grant_beneficiary_NRC"><?= $Grid->renderFieldHeader($Grid->NRC) ?></div></th>
<?php } ?>
<?php if ($Grid->AmountDisbursed->Visible) { // AmountDisbursed ?>
        <th data-name="AmountDisbursed" class="<?= $Grid->AmountDisbursed->headerCellClass() ?>"><div id="elh_grant_beneficiary_AmountDisbursed" class="grant_beneficiary_AmountDisbursed"><?= $Grid->renderFieldHeader($Grid->AmountDisbursed) ?></div></th>
<?php } ?>
<?php if ($Grid->ApplicationDate->Visible) { // ApplicationDate ?>
        <th data-name="ApplicationDate" class="<?= $Grid->ApplicationDate->headerCellClass() ?>"><div id="elh_grant_beneficiary_ApplicationDate" class="grant_beneficiary_ApplicationDate"><?= $Grid->renderFieldHeader($Grid->ApplicationDate) ?></div></th>
<?php } ?>
<?php if ($Grid->AmountAppliedFor->Visible) { // AmountAppliedFor ?>
        <th data-name="AmountAppliedFor" class="<?= $Grid->AmountAppliedFor->headerCellClass() ?>"><div id="elh_grant_beneficiary_AmountAppliedFor" class="grant_beneficiary_AmountAppliedFor"><?= $Grid->renderFieldHeader($Grid->AmountAppliedFor) ?></div></th>
<?php } ?>
<?php if ($Grid->ReplyDate->Visible) { // ReplyDate ?>
        <th data-name="ReplyDate" class="<?= $Grid->ReplyDate->headerCellClass() ?>"><div id="elh_grant_beneficiary_ReplyDate" class="grant_beneficiary_ReplyDate"><?= $Grid->renderFieldHeader($Grid->ReplyDate) ?></div></th>
<?php } ?>
<?php if ($Grid->Approved->Visible) { // Approved ?>
        <th data-name="Approved" class="<?= $Grid->Approved->headerCellClass() ?>"><div id="elh_grant_beneficiary_Approved" class="grant_beneficiary_Approved"><?= $Grid->renderFieldHeader($Grid->Approved) ?></div></th>
<?php } ?>
<?php if ($Grid->ReasonsForRejection->Visible) { // ReasonsForRejection ?>
        <th data-name="ReasonsForRejection" class="<?= $Grid->ReasonsForRejection->headerCellClass() ?>"><div id="elh_grant_beneficiary_ReasonsForRejection" class="grant_beneficiary_ReasonsForRejection"><?= $Grid->renderFieldHeader($Grid->ReasonsForRejection) ?></div></th>
<?php } ?>
<?php if ($Grid->Purpose->Visible) { // Purpose ?>
        <th data-name="Purpose" class="<?= $Grid->Purpose->headerCellClass() ?>"><div id="elh_grant_beneficiary_Purpose" class="grant_beneficiary_Purpose"><?= $Grid->renderFieldHeader($Grid->Purpose) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->GrantNo->Visible) { // GrantNo ?>
        <td data-name="GrantNo"<?= $Grid->GrantNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->GrantNo->getSessionValue() != "") { ?>
<span<?= $Grid->GrantNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->GrantNo->getDisplayValue($Grid->GrantNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_GrantNo" name="x<?= $Grid->RowIndex ?>_GrantNo" value="<?= HtmlEncode($Grid->GrantNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_GrantNo" class="el_grant_beneficiary_GrantNo">
<input type="<?= $Grid->GrantNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_GrantNo" id="x<?= $Grid->RowIndex ?>_GrantNo" data-table="grant_beneficiary" data-field="x_GrantNo" value="<?= $Grid->GrantNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->GrantNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->GrantNo->formatPattern()) ?>"<?= $Grid->GrantNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->GrantNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_GrantNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_GrantNo" id="o<?= $Grid->RowIndex ?>_GrantNo" value="<?= HtmlEncode($Grid->GrantNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->GrantNo->getSessionValue() != "") { ?>
<span<?= $Grid->GrantNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->GrantNo->getDisplayValue($Grid->GrantNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_GrantNo" name="x<?= $Grid->RowIndex ?>_GrantNo" value="<?= HtmlEncode($Grid->GrantNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_GrantNo" class="el_grant_beneficiary_GrantNo">
<input type="<?= $Grid->GrantNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_GrantNo" id="x<?= $Grid->RowIndex ?>_GrantNo" data-table="grant_beneficiary" data-field="x_GrantNo" value="<?= $Grid->GrantNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->GrantNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->GrantNo->formatPattern()) ?>"<?= $Grid->GrantNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->GrantNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_GrantNo" class="el_grant_beneficiary_GrantNo">
<span<?= $Grid->GrantNo->viewAttributes() ?>>
<?= $Grid->GrantNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_GrantNo" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_GrantNo" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_GrantNo" value="<?= HtmlEncode($Grid->GrantNo->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_GrantNo" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_GrantNo" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_GrantNo" value="<?= HtmlEncode($Grid->GrantNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Grid->NRC->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_NRC" class="el_grant_beneficiary_NRC">
<?php
if (IsRTL()) {
    $Grid->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Grid->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_NRC" id="sv_x<?= $Grid->RowIndex ?>_NRC" value="<?= RemoveHtml($Grid->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="13" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="grant_beneficiary" data-field="x_NRC" data-input="sv_x<?= $Grid->RowIndex ?>_NRC" data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("fgrant_beneficiarygrid", function() {
    fgrant_beneficiarygrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.grant_beneficiary.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_NRC" class="el_grant_beneficiary_NRC">
<?php
if (IsRTL()) {
    $Grid->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Grid->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_NRC" id="sv_x<?= $Grid->RowIndex ?>_NRC" value="<?= RemoveHtml($Grid->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="13" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="grant_beneficiary" data-field="x_NRC" data-input="sv_x<?= $Grid->RowIndex ?>_NRC" data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("fgrant_beneficiarygrid", function() {
    fgrant_beneficiarygrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.grant_beneficiary.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_NRC" class="el_grant_beneficiary_NRC">
<span<?= $Grid->NRC->viewAttributes() ?>>
<?= $Grid->NRC->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_NRC" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_NRC" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_NRC" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_NRC" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->AmountDisbursed->Visible) { // AmountDisbursed ?>
        <td data-name="AmountDisbursed"<?= $Grid->AmountDisbursed->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_AmountDisbursed" class="el_grant_beneficiary_AmountDisbursed">
<input type="<?= $Grid->AmountDisbursed->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AmountDisbursed" id="x<?= $Grid->RowIndex ?>_AmountDisbursed" data-table="grant_beneficiary" data-field="x_AmountDisbursed" value="<?= $Grid->AmountDisbursed->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->AmountDisbursed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AmountDisbursed->formatPattern()) ?>"<?= $Grid->AmountDisbursed->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AmountDisbursed->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_AmountDisbursed" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_AmountDisbursed" id="o<?= $Grid->RowIndex ?>_AmountDisbursed" value="<?= HtmlEncode($Grid->AmountDisbursed->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_AmountDisbursed" class="el_grant_beneficiary_AmountDisbursed">
<input type="<?= $Grid->AmountDisbursed->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AmountDisbursed" id="x<?= $Grid->RowIndex ?>_AmountDisbursed" data-table="grant_beneficiary" data-field="x_AmountDisbursed" value="<?= $Grid->AmountDisbursed->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->AmountDisbursed->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AmountDisbursed->formatPattern()) ?>"<?= $Grid->AmountDisbursed->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AmountDisbursed->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_AmountDisbursed" class="el_grant_beneficiary_AmountDisbursed">
<span<?= $Grid->AmountDisbursed->viewAttributes() ?>>
<?= $Grid->AmountDisbursed->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_AmountDisbursed" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_AmountDisbursed" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_AmountDisbursed" value="<?= HtmlEncode($Grid->AmountDisbursed->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_AmountDisbursed" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_AmountDisbursed" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_AmountDisbursed" value="<?= HtmlEncode($Grid->AmountDisbursed->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ApplicationDate->Visible) { // ApplicationDate ?>
        <td data-name="ApplicationDate"<?= $Grid->ApplicationDate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ApplicationDate" class="el_grant_beneficiary_ApplicationDate">
<input type="<?= $Grid->ApplicationDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ApplicationDate" id="x<?= $Grid->RowIndex ?>_ApplicationDate" data-table="grant_beneficiary" data-field="x_ApplicationDate" value="<?= $Grid->ApplicationDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->ApplicationDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ApplicationDate->formatPattern()) ?>"<?= $Grid->ApplicationDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ApplicationDate->getErrorMessage() ?></div>
<?php if (!$Grid->ApplicationDate->ReadOnly && !$Grid->ApplicationDate->Disabled && !isset($Grid->ApplicationDate->EditAttrs["readonly"]) && !isset($Grid->ApplicationDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrant_beneficiarygrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrant_beneficiarygrid", "x<?= $Grid->RowIndex ?>_ApplicationDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ApplicationDate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ApplicationDate" id="o<?= $Grid->RowIndex ?>_ApplicationDate" value="<?= HtmlEncode($Grid->ApplicationDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ApplicationDate" class="el_grant_beneficiary_ApplicationDate">
<input type="<?= $Grid->ApplicationDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ApplicationDate" id="x<?= $Grid->RowIndex ?>_ApplicationDate" data-table="grant_beneficiary" data-field="x_ApplicationDate" value="<?= $Grid->ApplicationDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->ApplicationDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ApplicationDate->formatPattern()) ?>"<?= $Grid->ApplicationDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ApplicationDate->getErrorMessage() ?></div>
<?php if (!$Grid->ApplicationDate->ReadOnly && !$Grid->ApplicationDate->Disabled && !isset($Grid->ApplicationDate->EditAttrs["readonly"]) && !isset($Grid->ApplicationDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrant_beneficiarygrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrant_beneficiarygrid", "x<?= $Grid->RowIndex ?>_ApplicationDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ApplicationDate" class="el_grant_beneficiary_ApplicationDate">
<span<?= $Grid->ApplicationDate->viewAttributes() ?>>
<?= $Grid->ApplicationDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ApplicationDate" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_ApplicationDate" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_ApplicationDate" value="<?= HtmlEncode($Grid->ApplicationDate->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_ApplicationDate" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_ApplicationDate" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_ApplicationDate" value="<?= HtmlEncode($Grid->ApplicationDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->AmountAppliedFor->Visible) { // AmountAppliedFor ?>
        <td data-name="AmountAppliedFor"<?= $Grid->AmountAppliedFor->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_AmountAppliedFor" class="el_grant_beneficiary_AmountAppliedFor">
<input type="<?= $Grid->AmountAppliedFor->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AmountAppliedFor" id="x<?= $Grid->RowIndex ?>_AmountAppliedFor" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" value="<?= $Grid->AmountAppliedFor->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->AmountAppliedFor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AmountAppliedFor->formatPattern()) ?>"<?= $Grid->AmountAppliedFor->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AmountAppliedFor->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_AmountAppliedFor" id="o<?= $Grid->RowIndex ?>_AmountAppliedFor" value="<?= HtmlEncode($Grid->AmountAppliedFor->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_AmountAppliedFor" class="el_grant_beneficiary_AmountAppliedFor">
<input type="<?= $Grid->AmountAppliedFor->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AmountAppliedFor" id="x<?= $Grid->RowIndex ?>_AmountAppliedFor" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" value="<?= $Grid->AmountAppliedFor->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->AmountAppliedFor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AmountAppliedFor->formatPattern()) ?>"<?= $Grid->AmountAppliedFor->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AmountAppliedFor->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_AmountAppliedFor" class="el_grant_beneficiary_AmountAppliedFor">
<span<?= $Grid->AmountAppliedFor->viewAttributes() ?>>
<?= $Grid->AmountAppliedFor->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_AmountAppliedFor" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_AmountAppliedFor" value="<?= HtmlEncode($Grid->AmountAppliedFor->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_AmountAppliedFor" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_AmountAppliedFor" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_AmountAppliedFor" value="<?= HtmlEncode($Grid->AmountAppliedFor->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ReplyDate->Visible) { // ReplyDate ?>
        <td data-name="ReplyDate"<?= $Grid->ReplyDate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ReplyDate" class="el_grant_beneficiary_ReplyDate">
<input type="<?= $Grid->ReplyDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ReplyDate" id="x<?= $Grid->RowIndex ?>_ReplyDate" data-table="grant_beneficiary" data-field="x_ReplyDate" value="<?= $Grid->ReplyDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->ReplyDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ReplyDate->formatPattern()) ?>"<?= $Grid->ReplyDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ReplyDate->getErrorMessage() ?></div>
<?php if (!$Grid->ReplyDate->ReadOnly && !$Grid->ReplyDate->Disabled && !isset($Grid->ReplyDate->EditAttrs["readonly"]) && !isset($Grid->ReplyDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrant_beneficiarygrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrant_beneficiarygrid", "x<?= $Grid->RowIndex ?>_ReplyDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ReplyDate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ReplyDate" id="o<?= $Grid->RowIndex ?>_ReplyDate" value="<?= HtmlEncode($Grid->ReplyDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ReplyDate" class="el_grant_beneficiary_ReplyDate">
<input type="<?= $Grid->ReplyDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ReplyDate" id="x<?= $Grid->RowIndex ?>_ReplyDate" data-table="grant_beneficiary" data-field="x_ReplyDate" value="<?= $Grid->ReplyDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->ReplyDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ReplyDate->formatPattern()) ?>"<?= $Grid->ReplyDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ReplyDate->getErrorMessage() ?></div>
<?php if (!$Grid->ReplyDate->ReadOnly && !$Grid->ReplyDate->Disabled && !isset($Grid->ReplyDate->EditAttrs["readonly"]) && !isset($Grid->ReplyDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgrant_beneficiarygrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgrant_beneficiarygrid", "x<?= $Grid->RowIndex ?>_ReplyDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ReplyDate" class="el_grant_beneficiary_ReplyDate">
<span<?= $Grid->ReplyDate->viewAttributes() ?>>
<?= $Grid->ReplyDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ReplyDate" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_ReplyDate" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_ReplyDate" value="<?= HtmlEncode($Grid->ReplyDate->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_ReplyDate" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_ReplyDate" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_ReplyDate" value="<?= HtmlEncode($Grid->ReplyDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Approved->Visible) { // Approved ?>
        <td data-name="Approved"<?= $Grid->Approved->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_Approved" class="el_grant_beneficiary_Approved">
<template id="tp_x<?= $Grid->RowIndex ?>_Approved">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="grant_beneficiary" data-field="x_Approved" name="x<?= $Grid->RowIndex ?>_Approved" id="x<?= $Grid->RowIndex ?>_Approved"<?= $Grid->Approved->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_Approved" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_Approved"
    name="x<?= $Grid->RowIndex ?>_Approved"
    value="<?= HtmlEncode($Grid->Approved->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_Approved"
    data-target="dsl_x<?= $Grid->RowIndex ?>_Approved"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->Approved->isInvalidClass() ?>"
    data-table="grant_beneficiary"
    data-field="x_Approved"
    data-value-separator="<?= $Grid->Approved->displayValueSeparatorAttribute() ?>"
    <?= $Grid->Approved->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->Approved->getErrorMessage() ?></div>
<?= $Grid->Approved->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Approved") ?>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_Approved" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Approved" id="o<?= $Grid->RowIndex ?>_Approved" value="<?= HtmlEncode($Grid->Approved->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_Approved" class="el_grant_beneficiary_Approved">
<template id="tp_x<?= $Grid->RowIndex ?>_Approved">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="grant_beneficiary" data-field="x_Approved" name="x<?= $Grid->RowIndex ?>_Approved" id="x<?= $Grid->RowIndex ?>_Approved"<?= $Grid->Approved->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_Approved" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_Approved"
    name="x<?= $Grid->RowIndex ?>_Approved"
    value="<?= HtmlEncode($Grid->Approved->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x<?= $Grid->RowIndex ?>_Approved"
    data-target="dsl_x<?= $Grid->RowIndex ?>_Approved"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->Approved->isInvalidClass() ?>"
    data-table="grant_beneficiary"
    data-field="x_Approved"
    data-value-separator="<?= $Grid->Approved->displayValueSeparatorAttribute() ?>"
    <?= $Grid->Approved->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->Approved->getErrorMessage() ?></div>
<?= $Grid->Approved->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Approved") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_Approved" class="el_grant_beneficiary_Approved">
<span<?= $Grid->Approved->viewAttributes() ?>>
<?= $Grid->Approved->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_Approved" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_Approved" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_Approved" value="<?= HtmlEncode($Grid->Approved->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_Approved" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_Approved" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_Approved" value="<?= HtmlEncode($Grid->Approved->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ReasonsForRejection->Visible) { // ReasonsForRejection ?>
        <td data-name="ReasonsForRejection"<?= $Grid->ReasonsForRejection->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ReasonsForRejection" class="el_grant_beneficiary_ReasonsForRejection">
<input type="<?= $Grid->ReasonsForRejection->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ReasonsForRejection" id="x<?= $Grid->RowIndex ?>_ReasonsForRejection" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" value="<?= $Grid->ReasonsForRejection->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->ReasonsForRejection->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ReasonsForRejection->formatPattern()) ?>"<?= $Grid->ReasonsForRejection->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ReasonsForRejection->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ReasonsForRejection" id="o<?= $Grid->RowIndex ?>_ReasonsForRejection" value="<?= HtmlEncode($Grid->ReasonsForRejection->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ReasonsForRejection" class="el_grant_beneficiary_ReasonsForRejection">
<input type="<?= $Grid->ReasonsForRejection->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ReasonsForRejection" id="x<?= $Grid->RowIndex ?>_ReasonsForRejection" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" value="<?= $Grid->ReasonsForRejection->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->ReasonsForRejection->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ReasonsForRejection->formatPattern()) ?>"<?= $Grid->ReasonsForRejection->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ReasonsForRejection->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_ReasonsForRejection" class="el_grant_beneficiary_ReasonsForRejection">
<span<?= $Grid->ReasonsForRejection->viewAttributes() ?>>
<?= $Grid->ReasonsForRejection->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_ReasonsForRejection" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_ReasonsForRejection" value="<?= HtmlEncode($Grid->ReasonsForRejection->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_ReasonsForRejection" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_ReasonsForRejection" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_ReasonsForRejection" value="<?= HtmlEncode($Grid->ReasonsForRejection->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Purpose->Visible) { // Purpose ?>
        <td data-name="Purpose"<?= $Grid->Purpose->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_Purpose" class="el_grant_beneficiary_Purpose">
<input type="<?= $Grid->Purpose->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Purpose" id="x<?= $Grid->RowIndex ?>_Purpose" data-table="grant_beneficiary" data-field="x_Purpose" value="<?= $Grid->Purpose->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->Purpose->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Purpose->formatPattern()) ?>"<?= $Grid->Purpose->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Purpose->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="grant_beneficiary" data-field="x_Purpose" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Purpose" id="o<?= $Grid->RowIndex ?>_Purpose" value="<?= HtmlEncode($Grid->Purpose->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_Purpose" class="el_grant_beneficiary_Purpose">
<input type="<?= $Grid->Purpose->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Purpose" id="x<?= $Grid->RowIndex ?>_Purpose" data-table="grant_beneficiary" data-field="x_Purpose" value="<?= $Grid->Purpose->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->Purpose->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Purpose->formatPattern()) ?>"<?= $Grid->Purpose->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Purpose->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_grant_beneficiary_Purpose" class="el_grant_beneficiary_Purpose">
<span<?= $Grid->Purpose->viewAttributes() ?>>
<?= $Grid->Purpose->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="grant_beneficiary" data-field="x_Purpose" data-hidden="1" name="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_Purpose" id="fgrant_beneficiarygrid$x<?= $Grid->RowIndex ?>_Purpose" value="<?= HtmlEncode($Grid->Purpose->FormValue) ?>">
<input type="hidden" data-table="grant_beneficiary" data-field="x_Purpose" data-hidden="1" data-old name="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_Purpose" id="fgrant_beneficiarygrid$o<?= $Grid->RowIndex ?>_Purpose" value="<?= HtmlEncode($Grid->Purpose->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fgrant_beneficiarygrid","load"], () => fgrant_beneficiarygrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fgrant_beneficiarygrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("grant_beneficiary");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
