<?php

namespace PHPMaker2024\cidp24;

// Page object
$GoodsReceivedNoteSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { goods_received_note: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fgoods_received_notesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fgoods_received_notesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["SupplierCode", [ew.Validators.integer], fields.SupplierCode.isInvalid],
            ["GRN", [], fields.GRN.isInvalid],
            ["District", [], fields.District.isInvalid],
            ["FarmingSeason", [], fields.FarmingSeason.isInvalid],
            ["SeedlingsReceived", [ew.Validators.float], fields.SeedlingsReceived.isInvalid],
            ["SeedsReceived", [ew.Validators.float], fields.SeedsReceived.isInvalid],
            ["SeedType", [], fields.SeedType.isInvalid],
            ["GoodsDescription", [], fields.GoodsDescription.isInvalid],
            ["DateReceived", [ew.Validators.datetime(fields.DateReceived.clientFormatPattern)], fields.DateReceived.isInvalid],
            ["ReceivedBy", [], fields.ReceivedBy.isInvalid],
            ["AuthorizedBy", [], fields.AuthorizedBy.isInvalid],
            ["GoodsReceived", [], fields.GoodsReceived.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "SupplierCode": <?= $Page->SupplierCode->toClientList($Page) ?>,
            "District": <?= $Page->District->toClientList($Page) ?>,
            "FarmingSeason": <?= $Page->FarmingSeason->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgoods_received_notesearch" id="fgoods_received_notesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="goods_received_note">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->SupplierCode->Visible) { // SupplierCode ?>
    <div id="r_SupplierCode" class="row"<?= $Page->SupplierCode->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_SupplierCode"><?= $Page->SupplierCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SupplierCode" id="z_SupplierCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SupplierCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_SupplierCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_SupplierCode"
        name="x_SupplierCode"
        class="form-control ew-select<?= $Page->SupplierCode->isInvalidClass() ?>"
        data-select2-id="fgoods_received_notesearch_x_SupplierCode"
        data-table="goods_received_note"
        data-field="x_SupplierCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->SupplierCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->SupplierCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SupplierCode->getPlaceHolder()) ?>"
        <?= $Page->SupplierCode->editAttributes() ?>>
        <?= $Page->SupplierCode->selectOptionListHtml("x_SupplierCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SupplierCode->getErrorMessage(false) ?></div>
<?= $Page->SupplierCode->Lookup->getParamTag($Page, "p_x_SupplierCode") ?>
<script>
loadjs.ready("fgoods_received_notesearch", function() {
    var options = { name: "x_SupplierCode", selectId: "fgoods_received_notesearch_x_SupplierCode" };
    if (fgoods_received_notesearch.lists.SupplierCode?.lookupOptions.length) {
        options.data = { id: "x_SupplierCode", form: "fgoods_received_notesearch" };
    } else {
        options.ajax = { id: "x_SupplierCode", form: "fgoods_received_notesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.SupplierCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
    <div id="r_GRN" class="row"<?= $Page->GRN->rowAttributes() ?>>
        <label for="x_GRN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_GRN"><?= $Page->GRN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_GRN" id="z_GRN" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->GRN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_GRN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x_GRN" id="x_GRN" data-table="goods_received_note" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->District->Visible) { // District ?>
    <div id="r_District" class="row"<?= $Page->District->rowAttributes() ?>>
        <label for="x_District" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_District"><?= $Page->District->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_District" id="z_District" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->District->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_District" class="ew-search-field ew-search-field-single">
    <select
        id="x_District"
        name="x_District"
        class="form-control ew-select<?= $Page->District->isInvalidClass() ?>"
        data-select2-id="fgoods_received_notesearch_x_District"
        data-table="goods_received_note"
        data-field="x_District"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->District->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->District->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>"
        <?= $Page->District->editAttributes() ?>>
        <?= $Page->District->selectOptionListHtml("x_District") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->District->getErrorMessage(false) ?></div>
<?= $Page->District->Lookup->getParamTag($Page, "p_x_District") ?>
<script>
loadjs.ready("fgoods_received_notesearch", function() {
    var options = { name: "x_District", selectId: "fgoods_received_notesearch_x_District" };
    if (fgoods_received_notesearch.lists.District?.lookupOptions.length) {
        options.data = { id: "x_District", form: "fgoods_received_notesearch" };
    } else {
        options.ajax = { id: "x_District", form: "fgoods_received_notesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.District.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
    <div id="r_FarmingSeason" class="row"<?= $Page->FarmingSeason->rowAttributes() ?>>
        <label for="x_FarmingSeason" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_FarmingSeason"><?= $Page->FarmingSeason->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmingSeason" id="z_FarmingSeason" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmingSeason->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_FarmingSeason" class="ew-search-field ew-search-field-single">
    <select
        id="x_FarmingSeason"
        name="x_FarmingSeason"
        class="form-control ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
        data-select2-id="fgoods_received_notesearch_x_FarmingSeason"
        data-table="goods_received_note"
        data-field="x_FarmingSeason"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmingSeason->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Page->FarmingSeason->editAttributes() ?>>
        <?= $Page->FarmingSeason->selectOptionListHtml("x_FarmingSeason") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage(false) ?></div>
<?= $Page->FarmingSeason->Lookup->getParamTag($Page, "p_x_FarmingSeason") ?>
<script>
loadjs.ready("fgoods_received_notesearch", function() {
    var options = { name: "x_FarmingSeason", selectId: "fgoods_received_notesearch_x_FarmingSeason" };
    if (fgoods_received_notesearch.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x_FarmingSeason", form: "fgoods_received_notesearch" };
    } else {
        options.ajax = { id: "x_FarmingSeason", form: "fgoods_received_notesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.FarmingSeason.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedlingsReceived->Visible) { // SeedlingsReceived ?>
    <div id="r_SeedlingsReceived" class="row"<?= $Page->SeedlingsReceived->rowAttributes() ?>>
        <label for="x_SeedlingsReceived" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_SeedlingsReceived"><?= $Page->SeedlingsReceived->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SeedlingsReceived" id="z_SeedlingsReceived" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedlingsReceived->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_SeedlingsReceived" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedlingsReceived->getInputTextType() ?>" name="x_SeedlingsReceived" id="x_SeedlingsReceived" data-table="goods_received_note" data-field="x_SeedlingsReceived" value="<?= $Page->SeedlingsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsReceived->formatPattern()) ?>"<?= $Page->SeedlingsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsReceived->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedsReceived->Visible) { // SeedsReceived ?>
    <div id="r_SeedsReceived" class="row"<?= $Page->SeedsReceived->rowAttributes() ?>>
        <label for="x_SeedsReceived" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_SeedsReceived"><?= $Page->SeedsReceived->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SeedsReceived" id="z_SeedsReceived" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedsReceived->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_SeedsReceived" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedsReceived->getInputTextType() ?>" name="x_SeedsReceived" id="x_SeedsReceived" data-table="goods_received_note" data-field="x_SeedsReceived" value="<?= $Page->SeedsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedsReceived->formatPattern()) ?>"<?= $Page->SeedsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedsReceived->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
    <div id="r_SeedType" class="row"<?= $Page->SeedType->rowAttributes() ?>>
        <label for="x_SeedType" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_SeedType"><?= $Page->SeedType->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_SeedType" id="z_SeedType" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedType->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_SeedType" class="ew-search-field ew-search-field-single">
    <select
        id="x_SeedType"
        name="x_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="fgoods_received_notesearch_x_SeedType"
        <?php } ?>
        data-table="goods_received_note"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage(false) ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("fgoods_received_notesearch", function() {
    var options = { name: "x_SeedType", selectId: "fgoods_received_notesearch_x_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgoods_received_notesearch.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x_SeedType", form: "fgoods_received_notesearch" };
    } else {
        options.ajax = { id: "x_SeedType", form: "fgoods_received_notesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.goods_received_note.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->GoodsDescription->Visible) { // GoodsDescription ?>
    <div id="r_GoodsDescription" class="row"<?= $Page->GoodsDescription->rowAttributes() ?>>
        <label for="x_GoodsDescription" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_GoodsDescription"><?= $Page->GoodsDescription->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_GoodsDescription" id="z_GoodsDescription" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->GoodsDescription->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_GoodsDescription" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->GoodsDescription->getInputTextType() ?>" name="x_GoodsDescription" id="x_GoodsDescription" data-table="goods_received_note" data-field="x_GoodsDescription" value="<?= $Page->GoodsDescription->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->GoodsDescription->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GoodsDescription->formatPattern()) ?>"<?= $Page->GoodsDescription->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GoodsDescription->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DateReceived->Visible) { // DateReceived ?>
    <div id="r_DateReceived" class="row"<?= $Page->DateReceived->rowAttributes() ?>>
        <label for="x_DateReceived" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_DateReceived"><?= $Page->DateReceived->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DateReceived" id="z_DateReceived" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DateReceived->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_DateReceived" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DateReceived->getInputTextType() ?>" name="x_DateReceived" id="x_DateReceived" data-table="goods_received_note" data-field="x_DateReceived" value="<?= $Page->DateReceived->EditValue ?>" placeholder="<?= HtmlEncode($Page->DateReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateReceived->formatPattern()) ?>"<?= $Page->DateReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateReceived->getErrorMessage(false) ?></div>
<?php if (!$Page->DateReceived->ReadOnly && !$Page->DateReceived->Disabled && !isset($Page->DateReceived->EditAttrs["readonly"]) && !isset($Page->DateReceived->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgoods_received_notesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgoods_received_notesearch", "x_DateReceived", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ReceivedBy->Visible) { // ReceivedBy ?>
    <div id="r_ReceivedBy" class="row"<?= $Page->ReceivedBy->rowAttributes() ?>>
        <label for="x_ReceivedBy" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_ReceivedBy"><?= $Page->ReceivedBy->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ReceivedBy" id="z_ReceivedBy" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ReceivedBy->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_ReceivedBy" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ReceivedBy->getInputTextType() ?>" name="x_ReceivedBy" id="x_ReceivedBy" data-table="goods_received_note" data-field="x_ReceivedBy" value="<?= $Page->ReceivedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ReceivedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReceivedBy->formatPattern()) ?>"<?= $Page->ReceivedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ReceivedBy->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AuthorizedBy->Visible) { // AuthorizedBy ?>
    <div id="r_AuthorizedBy" class="row"<?= $Page->AuthorizedBy->rowAttributes() ?>>
        <label for="x_AuthorizedBy" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_AuthorizedBy"><?= $Page->AuthorizedBy->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_AuthorizedBy" id="z_AuthorizedBy" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AuthorizedBy->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_AuthorizedBy" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AuthorizedBy->getInputTextType() ?>" name="x_AuthorizedBy" id="x_AuthorizedBy" data-table="goods_received_note" data-field="x_AuthorizedBy" value="<?= $Page->AuthorizedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorizedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorizedBy->formatPattern()) ?>"<?= $Page->AuthorizedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AuthorizedBy->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->GoodsReceived->Visible) { // GoodsReceived ?>
    <div id="r_GoodsReceived" class="row"<?= $Page->GoodsReceived->rowAttributes() ?>>
        <label for="x_GoodsReceived" class="<?= $Page->LeftColumnClass ?>"><span id="elh_goods_received_note_GoodsReceived"><?= $Page->GoodsReceived->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_GoodsReceived" id="z_GoodsReceived" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->GoodsReceived->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_goods_received_note_GoodsReceived" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->GoodsReceived->getInputTextType() ?>" name="x_GoodsReceived" id="x_GoodsReceived" data-table="goods_received_note" data-field="x_GoodsReceived" value="<?= $Page->GoodsReceived->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->GoodsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GoodsReceived->formatPattern()) ?>"<?= $Page->GoodsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GoodsReceived->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgoods_received_notesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgoods_received_notesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fgoods_received_notesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("goods_received_note");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
