<?php

namespace PHPMaker2024\cidp24;

// Page object
$GoodsReceivedNoteList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { goods_received_note: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["SupplierCode", [fields.SupplierCode.visible && fields.SupplierCode.required ? ew.Validators.required(fields.SupplierCode.caption) : null, ew.Validators.integer], fields.SupplierCode.isInvalid],
            ["GRN", [fields.GRN.visible && fields.GRN.required ? ew.Validators.required(fields.GRN.caption) : null], fields.GRN.isInvalid],
            ["District", [fields.District.visible && fields.District.required ? ew.Validators.required(fields.District.caption) : null], fields.District.isInvalid],
            ["FarmingSeason", [fields.FarmingSeason.visible && fields.FarmingSeason.required ? ew.Validators.required(fields.FarmingSeason.caption) : null], fields.FarmingSeason.isInvalid],
            ["SeedlingsReceived", [fields.SeedlingsReceived.visible && fields.SeedlingsReceived.required ? ew.Validators.required(fields.SeedlingsReceived.caption) : null, ew.Validators.float], fields.SeedlingsReceived.isInvalid],
            ["SeedsReceived", [fields.SeedsReceived.visible && fields.SeedsReceived.required ? ew.Validators.required(fields.SeedsReceived.caption) : null, ew.Validators.float], fields.SeedsReceived.isInvalid],
            ["SeedType", [fields.SeedType.visible && fields.SeedType.required ? ew.Validators.required(fields.SeedType.caption) : null], fields.SeedType.isInvalid],
            ["GoodsDescription", [fields.GoodsDescription.visible && fields.GoodsDescription.required ? ew.Validators.required(fields.GoodsDescription.caption) : null], fields.GoodsDescription.isInvalid],
            ["DateReceived", [fields.DateReceived.visible && fields.DateReceived.required ? ew.Validators.required(fields.DateReceived.caption) : null, ew.Validators.datetime(fields.DateReceived.clientFormatPattern)], fields.DateReceived.isInvalid],
            ["ReceivedBy", [fields.ReceivedBy.visible && fields.ReceivedBy.required ? ew.Validators.required(fields.ReceivedBy.caption) : null], fields.ReceivedBy.isInvalid],
            ["AuthorizedBy", [fields.AuthorizedBy.visible && fields.AuthorizedBy.required ? ew.Validators.required(fields.AuthorizedBy.caption) : null], fields.AuthorizedBy.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["SupplierCode",false],["GRN",false],["District",false],["FarmingSeason",false],["SeedlingsReceived",false],["SeedsReceived",false],["SeedType",false],["GoodsDescription",false],["DateReceived",false],["ReceivedBy",false],["AuthorizedBy",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "SupplierCode": <?= $Page->SupplierCode->toClientList($Page) ?>,
            "District": <?= $Page->District->toClientList($Page) ?>,
            "FarmingSeason": <?= $Page->FarmingSeason->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.14.0", "preview");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fgoods_received_notesrch" id="fgoods_received_notesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fgoods_received_notesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { goods_received_note: currentTable } });
var currentForm;
var fgoods_received_notesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fgoods_received_notesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fgoods_received_notesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fgoods_received_notesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fgoods_received_notesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fgoods_received_notesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="goods_received_note">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_goods_received_note" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_goods_received_notelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->SupplierCode->Visible) { // SupplierCode ?>
        <th data-name="SupplierCode" class="<?= $Page->SupplierCode->headerCellClass() ?>"><div id="elh_goods_received_note_SupplierCode" class="goods_received_note_SupplierCode"><?= $Page->renderFieldHeader($Page->SupplierCode) ?></div></th>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
        <th data-name="GRN" class="<?= $Page->GRN->headerCellClass() ?>"><div id="elh_goods_received_note_GRN" class="goods_received_note_GRN"><?= $Page->renderFieldHeader($Page->GRN) ?></div></th>
<?php } ?>
<?php if ($Page->District->Visible) { // District ?>
        <th data-name="District" class="<?= $Page->District->headerCellClass() ?>"><div id="elh_goods_received_note_District" class="goods_received_note_District"><?= $Page->renderFieldHeader($Page->District) ?></div></th>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <th data-name="FarmingSeason" class="<?= $Page->FarmingSeason->headerCellClass() ?>"><div id="elh_goods_received_note_FarmingSeason" class="goods_received_note_FarmingSeason"><?= $Page->renderFieldHeader($Page->FarmingSeason) ?></div></th>
<?php } ?>
<?php if ($Page->SeedlingsReceived->Visible) { // SeedlingsReceived ?>
        <th data-name="SeedlingsReceived" class="<?= $Page->SeedlingsReceived->headerCellClass() ?>"><div id="elh_goods_received_note_SeedlingsReceived" class="goods_received_note_SeedlingsReceived"><?= $Page->renderFieldHeader($Page->SeedlingsReceived) ?></div></th>
<?php } ?>
<?php if ($Page->SeedsReceived->Visible) { // SeedsReceived ?>
        <th data-name="SeedsReceived" class="<?= $Page->SeedsReceived->headerCellClass() ?>"><div id="elh_goods_received_note_SeedsReceived" class="goods_received_note_SeedsReceived"><?= $Page->renderFieldHeader($Page->SeedsReceived) ?></div></th>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
        <th data-name="SeedType" class="<?= $Page->SeedType->headerCellClass() ?>"><div id="elh_goods_received_note_SeedType" class="goods_received_note_SeedType"><?= $Page->renderFieldHeader($Page->SeedType) ?></div></th>
<?php } ?>
<?php if ($Page->GoodsDescription->Visible) { // GoodsDescription ?>
        <th data-name="GoodsDescription" class="<?= $Page->GoodsDescription->headerCellClass() ?>"><div id="elh_goods_received_note_GoodsDescription" class="goods_received_note_GoodsDescription"><?= $Page->renderFieldHeader($Page->GoodsDescription) ?></div></th>
<?php } ?>
<?php if ($Page->DateReceived->Visible) { // DateReceived ?>
        <th data-name="DateReceived" class="<?= $Page->DateReceived->headerCellClass() ?>"><div id="elh_goods_received_note_DateReceived" class="goods_received_note_DateReceived"><?= $Page->renderFieldHeader($Page->DateReceived) ?></div></th>
<?php } ?>
<?php if ($Page->ReceivedBy->Visible) { // ReceivedBy ?>
        <th data-name="ReceivedBy" class="<?= $Page->ReceivedBy->headerCellClass() ?>"><div id="elh_goods_received_note_ReceivedBy" class="goods_received_note_ReceivedBy"><?= $Page->renderFieldHeader($Page->ReceivedBy) ?></div></th>
<?php } ?>
<?php if ($Page->AuthorizedBy->Visible) { // AuthorizedBy ?>
        <th data-name="AuthorizedBy" class="<?= $Page->AuthorizedBy->headerCellClass() ?>"><div id="elh_goods_received_note_AuthorizedBy" class="goods_received_note_AuthorizedBy"><?= $Page->renderFieldHeader($Page->AuthorizedBy) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->SupplierCode->Visible) { // SupplierCode ?>
        <td data-name="SupplierCode"<?= $Page->SupplierCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SupplierCode" class="el_goods_received_note_SupplierCode">
    <select
        id="x<?= $Page->RowIndex ?>_SupplierCode"
        name="x<?= $Page->RowIndex ?>_SupplierCode"
        class="form-control ew-select<?= $Page->SupplierCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SupplierCode"
        data-table="goods_received_note"
        data-field="x_SupplierCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->SupplierCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->SupplierCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SupplierCode->getPlaceHolder()) ?>"
        <?= $Page->SupplierCode->editAttributes() ?>>
        <?= $Page->SupplierCode->selectOptionListHtml("x{$Page->RowIndex}_SupplierCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SupplierCode->getErrorMessage() ?></div>
<?= $Page->SupplierCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SupplierCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SupplierCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SupplierCode" };
    if (<?= $Page->FormName ?>.lists.SupplierCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SupplierCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SupplierCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.SupplierCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_SupplierCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SupplierCode" id="o<?= $Page->RowIndex ?>_SupplierCode" value="<?= HtmlEncode($Page->SupplierCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SupplierCode" class="el_goods_received_note_SupplierCode">
    <select
        id="x<?= $Page->RowIndex ?>_SupplierCode"
        name="x<?= $Page->RowIndex ?>_SupplierCode"
        class="form-control ew-select<?= $Page->SupplierCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SupplierCode"
        data-table="goods_received_note"
        data-field="x_SupplierCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->SupplierCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->SupplierCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SupplierCode->getPlaceHolder()) ?>"
        <?= $Page->SupplierCode->editAttributes() ?>>
        <?= $Page->SupplierCode->selectOptionListHtml("x{$Page->RowIndex}_SupplierCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SupplierCode->getErrorMessage() ?></div>
<?= $Page->SupplierCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SupplierCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SupplierCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SupplierCode" };
    if (<?= $Page->FormName ?>.lists.SupplierCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SupplierCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SupplierCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.SupplierCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
<input type="hidden" data-table="goods_received_note" data-field="x_SupplierCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SupplierCode" id="o<?= $Page->RowIndex ?>_SupplierCode" value="<?= HtmlEncode($Page->SupplierCode->OldValue ?? $Page->SupplierCode->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SupplierCode" class="el_goods_received_note_SupplierCode">
<span<?= $Page->SupplierCode->viewAttributes() ?>>
<?= $Page->SupplierCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="goods_received_note" data-field="x_SupplierCode" data-hidden="1" name="x<?= $Page->RowIndex ?>_SupplierCode" id="x<?= $Page->RowIndex ?>_SupplierCode" value="<?= HtmlEncode($Page->SupplierCode->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->GRN->Visible) { // GRN ?>
        <td data-name="GRN"<?= $Page->GRN->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_GRN" class="el_goods_received_note_GRN">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_GRN" id="x<?= $Page->RowIndex ?>_GRN" data-table="goods_received_note" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_GRN" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_GRN" id="o<?= $Page->RowIndex ?>_GRN" value="<?= HtmlEncode($Page->GRN->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_GRN" class="el_goods_received_note_GRN">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_GRN" id="x<?= $Page->RowIndex ?>_GRN" data-table="goods_received_note" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="30" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
<input type="hidden" data-table="goods_received_note" data-field="x_GRN" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_GRN" id="o<?= $Page->RowIndex ?>_GRN" value="<?= HtmlEncode($Page->GRN->OldValue ?? $Page->GRN->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_GRN" class="el_goods_received_note_GRN">
<span<?= $Page->GRN->viewAttributes() ?>>
<?= $Page->GRN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="goods_received_note" data-field="x_GRN" data-hidden="1" name="x<?= $Page->RowIndex ?>_GRN" id="x<?= $Page->RowIndex ?>_GRN" value="<?= HtmlEncode($Page->GRN->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->District->Visible) { // District ?>
        <td data-name="District"<?= $Page->District->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_District" class="el_goods_received_note_District">
    <select
        id="x<?= $Page->RowIndex ?>_District"
        name="x<?= $Page->RowIndex ?>_District"
        class="form-control ew-select<?= $Page->District->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_District"
        data-table="goods_received_note"
        data-field="x_District"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->District->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->District->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>"
        <?= $Page->District->editAttributes() ?>>
        <?= $Page->District->selectOptionListHtml("x{$Page->RowIndex}_District") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->District->getErrorMessage() ?></div>
<?= $Page->District->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_District") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_District", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_District" };
    if (<?= $Page->FormName ?>.lists.District?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_District", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_District", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.District.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_District" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_District" id="o<?= $Page->RowIndex ?>_District" value="<?= HtmlEncode($Page->District->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_District" class="el_goods_received_note_District">
    <select
        id="x<?= $Page->RowIndex ?>_District"
        name="x<?= $Page->RowIndex ?>_District"
        class="form-control ew-select<?= $Page->District->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_District"
        data-table="goods_received_note"
        data-field="x_District"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->District->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->District->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>"
        <?= $Page->District->editAttributes() ?>>
        <?= $Page->District->selectOptionListHtml("x{$Page->RowIndex}_District") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->District->getErrorMessage() ?></div>
<?= $Page->District->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_District") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_District", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_District" };
    if (<?= $Page->FormName ?>.lists.District?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_District", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_District", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.District.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_District" class="el_goods_received_note_District">
<span<?= $Page->District->viewAttributes() ?>>
<?= $Page->District->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <td data-name="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_FarmingSeason" class="el_goods_received_note_FarmingSeason">
    <select
        id="x<?= $Page->RowIndex ?>_FarmingSeason"
        name="x<?= $Page->RowIndex ?>_FarmingSeason"
        class="form-control ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmingSeason"
        data-table="goods_received_note"
        data-field="x_FarmingSeason"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmingSeason->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Page->FarmingSeason->editAttributes() ?>>
        <?= $Page->FarmingSeason->selectOptionListHtml("x{$Page->RowIndex}_FarmingSeason") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage() ?></div>
<?= $Page->FarmingSeason->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmingSeason") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FarmingSeason", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmingSeason" };
    if (<?= $Page->FormName ?>.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FarmingSeason", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FarmingSeason", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.FarmingSeason.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_FarmingSeason" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmingSeason" id="o<?= $Page->RowIndex ?>_FarmingSeason" value="<?= HtmlEncode($Page->FarmingSeason->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_FarmingSeason" class="el_goods_received_note_FarmingSeason">
    <select
        id="x<?= $Page->RowIndex ?>_FarmingSeason"
        name="x<?= $Page->RowIndex ?>_FarmingSeason"
        class="form-control ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmingSeason"
        data-table="goods_received_note"
        data-field="x_FarmingSeason"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmingSeason->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Page->FarmingSeason->editAttributes() ?>>
        <?= $Page->FarmingSeason->selectOptionListHtml("x{$Page->RowIndex}_FarmingSeason") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage() ?></div>
<?= $Page->FarmingSeason->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmingSeason") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FarmingSeason", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmingSeason" };
    if (<?= $Page->FormName ?>.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FarmingSeason", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FarmingSeason", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.goods_received_note.fields.FarmingSeason.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_FarmingSeason" class="el_goods_received_note_FarmingSeason">
<span<?= $Page->FarmingSeason->viewAttributes() ?>>
<?= $Page->FarmingSeason->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->SeedlingsReceived->Visible) { // SeedlingsReceived ?>
        <td data-name="SeedlingsReceived"<?= $Page->SeedlingsReceived->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedlingsReceived" class="el_goods_received_note_SeedlingsReceived">
<input type="<?= $Page->SeedlingsReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_SeedlingsReceived" id="x<?= $Page->RowIndex ?>_SeedlingsReceived" data-table="goods_received_note" data-field="x_SeedlingsReceived" value="<?= $Page->SeedlingsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsReceived->formatPattern()) ?>"<?= $Page->SeedlingsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsReceived->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_SeedlingsReceived" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SeedlingsReceived" id="o<?= $Page->RowIndex ?>_SeedlingsReceived" value="<?= HtmlEncode($Page->SeedlingsReceived->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedlingsReceived" class="el_goods_received_note_SeedlingsReceived">
<input type="<?= $Page->SeedlingsReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_SeedlingsReceived" id="x<?= $Page->RowIndex ?>_SeedlingsReceived" data-table="goods_received_note" data-field="x_SeedlingsReceived" value="<?= $Page->SeedlingsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsReceived->formatPattern()) ?>"<?= $Page->SeedlingsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsReceived->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedlingsReceived" class="el_goods_received_note_SeedlingsReceived">
<span<?= $Page->SeedlingsReceived->viewAttributes() ?>>
<?= $Page->SeedlingsReceived->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->SeedsReceived->Visible) { // SeedsReceived ?>
        <td data-name="SeedsReceived"<?= $Page->SeedsReceived->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedsReceived" class="el_goods_received_note_SeedsReceived">
<input type="<?= $Page->SeedsReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_SeedsReceived" id="x<?= $Page->RowIndex ?>_SeedsReceived" data-table="goods_received_note" data-field="x_SeedsReceived" value="<?= $Page->SeedsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedsReceived->formatPattern()) ?>"<?= $Page->SeedsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedsReceived->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_SeedsReceived" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SeedsReceived" id="o<?= $Page->RowIndex ?>_SeedsReceived" value="<?= HtmlEncode($Page->SeedsReceived->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedsReceived" class="el_goods_received_note_SeedsReceived">
<input type="<?= $Page->SeedsReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_SeedsReceived" id="x<?= $Page->RowIndex ?>_SeedsReceived" data-table="goods_received_note" data-field="x_SeedsReceived" value="<?= $Page->SeedsReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedsReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedsReceived->formatPattern()) ?>"<?= $Page->SeedsReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedsReceived->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedsReceived" class="el_goods_received_note_SeedsReceived">
<span<?= $Page->SeedsReceived->viewAttributes() ?>>
<?= $Page->SeedsReceived->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->SeedType->Visible) { // SeedType ?>
        <td data-name="SeedType"<?= $Page->SeedType->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedType" class="el_goods_received_note_SeedType">
    <select
        id="x<?= $Page->RowIndex ?>_SeedType"
        name="x<?= $Page->RowIndex ?>_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType"
        <?php } ?>
        data-table="goods_received_note"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x{$Page->RowIndex}_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SeedType", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.goods_received_note.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_SeedType" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SeedType" id="o<?= $Page->RowIndex ?>_SeedType" value="<?= HtmlEncode($Page->SeedType->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedType" class="el_goods_received_note_SeedType">
    <select
        id="x<?= $Page->RowIndex ?>_SeedType"
        name="x<?= $Page->RowIndex ?>_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType"
        <?php } ?>
        data-table="goods_received_note"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x{$Page->RowIndex}_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage() ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SeedType", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SeedType", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.goods_received_note.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_SeedType" class="el_goods_received_note_SeedType">
<span<?= $Page->SeedType->viewAttributes() ?>>
<?= $Page->SeedType->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->GoodsDescription->Visible) { // GoodsDescription ?>
        <td data-name="GoodsDescription"<?= $Page->GoodsDescription->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_GoodsDescription" class="el_goods_received_note_GoodsDescription">
<input type="<?= $Page->GoodsDescription->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_GoodsDescription" id="x<?= $Page->RowIndex ?>_GoodsDescription" data-table="goods_received_note" data-field="x_GoodsDescription" value="<?= $Page->GoodsDescription->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->GoodsDescription->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GoodsDescription->formatPattern()) ?>"<?= $Page->GoodsDescription->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GoodsDescription->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_GoodsDescription" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_GoodsDescription" id="o<?= $Page->RowIndex ?>_GoodsDescription" value="<?= HtmlEncode($Page->GoodsDescription->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_GoodsDescription" class="el_goods_received_note_GoodsDescription">
<input type="<?= $Page->GoodsDescription->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_GoodsDescription" id="x<?= $Page->RowIndex ?>_GoodsDescription" data-table="goods_received_note" data-field="x_GoodsDescription" value="<?= $Page->GoodsDescription->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->GoodsDescription->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GoodsDescription->formatPattern()) ?>"<?= $Page->GoodsDescription->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GoodsDescription->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_GoodsDescription" class="el_goods_received_note_GoodsDescription">
<span<?= $Page->GoodsDescription->viewAttributes() ?>>
<?= $Page->GoodsDescription->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DateReceived->Visible) { // DateReceived ?>
        <td data-name="DateReceived"<?= $Page->DateReceived->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_DateReceived" class="el_goods_received_note_DateReceived">
<input type="<?= $Page->DateReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DateReceived" id="x<?= $Page->RowIndex ?>_DateReceived" data-table="goods_received_note" data-field="x_DateReceived" value="<?= $Page->DateReceived->EditValue ?>" placeholder="<?= HtmlEncode($Page->DateReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateReceived->formatPattern()) ?>"<?= $Page->DateReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateReceived->getErrorMessage() ?></div>
<?php if (!$Page->DateReceived->ReadOnly && !$Page->DateReceived->Disabled && !isset($Page->DateReceived->EditAttrs["readonly"]) && !isset($Page->DateReceived->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_DateReceived", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_DateReceived" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DateReceived" id="o<?= $Page->RowIndex ?>_DateReceived" value="<?= HtmlEncode($Page->DateReceived->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_DateReceived" class="el_goods_received_note_DateReceived">
<input type="<?= $Page->DateReceived->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DateReceived" id="x<?= $Page->RowIndex ?>_DateReceived" data-table="goods_received_note" data-field="x_DateReceived" value="<?= $Page->DateReceived->EditValue ?>" placeholder="<?= HtmlEncode($Page->DateReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateReceived->formatPattern()) ?>"<?= $Page->DateReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateReceived->getErrorMessage() ?></div>
<?php if (!$Page->DateReceived->ReadOnly && !$Page->DateReceived->Disabled && !isset($Page->DateReceived->EditAttrs["readonly"]) && !isset($Page->DateReceived->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["<?= $Page->FormName ?>", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("<?= $Page->FormName ?>", "x<?= $Page->RowIndex ?>_DateReceived", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_DateReceived" class="el_goods_received_note_DateReceived">
<span<?= $Page->DateReceived->viewAttributes() ?>>
<?= $Page->DateReceived->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->ReceivedBy->Visible) { // ReceivedBy ?>
        <td data-name="ReceivedBy"<?= $Page->ReceivedBy->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_ReceivedBy" class="el_goods_received_note_ReceivedBy">
<input type="<?= $Page->ReceivedBy->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ReceivedBy" id="x<?= $Page->RowIndex ?>_ReceivedBy" data-table="goods_received_note" data-field="x_ReceivedBy" value="<?= $Page->ReceivedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ReceivedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReceivedBy->formatPattern()) ?>"<?= $Page->ReceivedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ReceivedBy->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_ReceivedBy" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ReceivedBy" id="o<?= $Page->RowIndex ?>_ReceivedBy" value="<?= HtmlEncode($Page->ReceivedBy->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_ReceivedBy" class="el_goods_received_note_ReceivedBy">
<input type="<?= $Page->ReceivedBy->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ReceivedBy" id="x<?= $Page->RowIndex ?>_ReceivedBy" data-table="goods_received_note" data-field="x_ReceivedBy" value="<?= $Page->ReceivedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ReceivedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReceivedBy->formatPattern()) ?>"<?= $Page->ReceivedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ReceivedBy->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_ReceivedBy" class="el_goods_received_note_ReceivedBy">
<span<?= $Page->ReceivedBy->viewAttributes() ?>>
<?= $Page->ReceivedBy->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->AuthorizedBy->Visible) { // AuthorizedBy ?>
        <td data-name="AuthorizedBy"<?= $Page->AuthorizedBy->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_AuthorizedBy" class="el_goods_received_note_AuthorizedBy">
<input type="<?= $Page->AuthorizedBy->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AuthorizedBy" id="x<?= $Page->RowIndex ?>_AuthorizedBy" data-table="goods_received_note" data-field="x_AuthorizedBy" value="<?= $Page->AuthorizedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorizedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorizedBy->formatPattern()) ?>"<?= $Page->AuthorizedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AuthorizedBy->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="goods_received_note" data-field="x_AuthorizedBy" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_AuthorizedBy" id="o<?= $Page->RowIndex ?>_AuthorizedBy" value="<?= HtmlEncode($Page->AuthorizedBy->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_AuthorizedBy" class="el_goods_received_note_AuthorizedBy">
<input type="<?= $Page->AuthorizedBy->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AuthorizedBy" id="x<?= $Page->RowIndex ?>_AuthorizedBy" data-table="goods_received_note" data-field="x_AuthorizedBy" value="<?= $Page->AuthorizedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorizedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorizedBy->formatPattern()) ?>"<?= $Page->AuthorizedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AuthorizedBy->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_goods_received_note_AuthorizedBy" class="el_goods_received_note_AuthorizedBy">
<span<?= $Page->AuthorizedBy->viewAttributes() ?>>
<?= $Page->AuthorizedBy->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("goods_received_note");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
