<?php

namespace PHPMaker2024\cidp24;

// Page object
$FieldInspectionReportSummary = &$Page;
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Field_Inspection_Report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<a id="top"></a>
<!-- Content Container -->
<div id="ew-report" class="ew-report container-fluid">
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<div class="btn-toolbar ew-toolbar">
<?php
if (!$Page->DrillDownInPanel) {
    $Page->ExportOptions->render("body");
    $Page->SearchOptions->render("body");
    $Page->FilterOptions->render("body");
}
?>
</div>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<form name="fField_Inspection_Reportsrch" id="fField_Inspection_Reportsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fField_Inspection_Reportsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Field_Inspection_Report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
var fField_Inspection_Reportsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fField_Inspection_Reportsrch")
        .setPageId("summary")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "FieldType": <?= $Page->FieldType->toClientList($Page) ?>,
            "FarmerName": <?= $Page->FarmerName->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
            "CampName": <?= $Page->CampName->toClientList($Page) ?>,
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
<?php
if (!$Page->FieldType->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FieldType" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FieldType->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FieldType"
            name="x_FieldType[]"
            class="form-control ew-select<?= $Page->FieldType->isInvalidClass() ?>"
            data-select2-id="fField_Inspection_Reportsrch_x_FieldType"
            data-table="Field_Inspection_Report"
            data-field="x_FieldType"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FieldType->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FieldType->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FieldType->editAttributes() ?>>
            <?= $Page->FieldType->selectOptionListHtml("x_FieldType", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fField_Inspection_Reportsrch", function() {
            var options = {
                name: "x_FieldType",
                selectId: "fField_Inspection_Reportsrch_x_FieldType",
                ajax: { id: "x_FieldType", form: "fField_Inspection_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Field_Inspection_Report.fields.FieldType.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
<?php
if (!$Page->FarmerName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmerName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmerName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmerName"
            name="x_FarmerName[]"
            class="form-control ew-select<?= $Page->FarmerName->isInvalidClass() ?>"
            data-select2-id="fField_Inspection_Reportsrch_x_FarmerName"
            data-table="Field_Inspection_Report"
            data-field="x_FarmerName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmerName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmerName->editAttributes() ?>>
            <?= $Page->FarmerName->selectOptionListHtml("x_FarmerName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fField_Inspection_Reportsrch", function() {
            var options = {
                name: "x_FarmerName",
                selectId: "fField_Inspection_Reportsrch_x_FarmerName",
                ajax: { id: "x_FarmerName", form: "fField_Inspection_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Field_Inspection_Report.fields.FarmerName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
<?php
if (!$Page->Gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Gender"
            name="x_Gender[]"
            class="form-control ew-select<?= $Page->Gender->isInvalidClass() ?>"
            data-select2-id="fField_Inspection_Reportsrch_x_Gender"
            data-table="Field_Inspection_Report"
            data-field="x_Gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Gender->editAttributes() ?>>
            <?= $Page->Gender->selectOptionListHtml("x_Gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fField_Inspection_Reportsrch", function() {
            var options = {
                name: "x_Gender",
                selectId: "fField_Inspection_Reportsrch_x_Gender",
                ajax: { id: "x_Gender", form: "fField_Inspection_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Field_Inspection_Report.fields.Gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
<?php
if (!$Page->MaritalStatus->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_MaritalStatus" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->MaritalStatus->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_MaritalStatus"
            name="x_MaritalStatus[]"
            class="form-control ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
            data-select2-id="fField_Inspection_Reportsrch_x_MaritalStatus"
            data-table="Field_Inspection_Report"
            data-field="x_MaritalStatus"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->MaritalStatus->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->MaritalStatus->editAttributes() ?>>
            <?= $Page->MaritalStatus->selectOptionListHtml("x_MaritalStatus", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fField_Inspection_Reportsrch", function() {
            var options = {
                name: "x_MaritalStatus",
                selectId: "fField_Inspection_Reportsrch_x_MaritalStatus",
                ajax: { id: "x_MaritalStatus", form: "fField_Inspection_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Field_Inspection_Report.fields.MaritalStatus.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->CampName->Visible) { // CampName ?>
<?php
if (!$Page->CampName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_CampName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->CampName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_CampName"
            name="x_CampName[]"
            class="form-control ew-select<?= $Page->CampName->isInvalidClass() ?>"
            data-select2-id="fField_Inspection_Reportsrch_x_CampName"
            data-table="Field_Inspection_Report"
            data-field="x_CampName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->CampName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->CampName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->CampName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->CampName->editAttributes() ?>>
            <?= $Page->CampName->selectOptionListHtml("x_CampName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->CampName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fField_Inspection_Reportsrch", function() {
            var options = {
                name: "x_CampName",
                selectId: "fField_Inspection_Reportsrch_x_CampName",
                ajax: { id: "x_CampName", form: "fField_Inspection_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Field_Inspection_Report.fields.CampName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
<?php
if (!$Page->DistrictName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictName"
            name="x_DistrictName[]"
            class="form-control ew-select<?= $Page->DistrictName->isInvalidClass() ?>"
            data-select2-id="fField_Inspection_Reportsrch_x_DistrictName"
            data-table="Field_Inspection_Report"
            data-field="x_DistrictName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictName->editAttributes() ?>>
            <?= $Page->DistrictName->selectOptionListHtml("x_DistrictName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fField_Inspection_Reportsrch", function() {
            var options = {
                name: "x_DistrictName",
                selectId: "fField_Inspection_Reportsrch_x_DistrictName",
                ajax: { id: "x_DistrictName", form: "fField_Inspection_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Field_Inspection_Report.fields.DistrictName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if ($Page->ShowReport) { ?>
<!-- Summary report (begin) -->
<main class="report-summary<?= ($Page->TotalGroups == 0) ? " ew-no-record" : "" ?>">
<?php
while ($Page->GroupCount <= count($Page->GroupRecords) && $Page->GroupCount <= $Page->DisplayGroups) {
?>
<?php
    // Show header
    if ($Page->ShowHeader) {
?>
<?php if ($Page->GroupCount > 1) { ?>
</tbody>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?= $Page->PageBreakHtml ?>
<?php } ?>
<div class="<?= $Page->ReportContainerClass ?>">
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Top pager -->
<div class="card-header ew-grid-upper-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<!-- Report grid (begin) -->
<div id="gmp_Field_Inspection_Report" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>">
<table class="<?= $Page->TableClass ?>">
<thead>
	<!-- Table header -->
    <tr class="ew-table-header">
<?php if ($Page->FarmNo->Visible) { ?>
    <?php if ($Page->FarmNo->ShowGroupHeaderAsRow) { ?>
    <th data-name="FarmNo"<?= $Page->FarmNo->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->FarmNo->groupToggleIcon() ?></th>
    <?php } else { ?>
    <th data-name="FarmNo" class="<?= $Page->FarmNo->headerCellClass() ?>"><div class="Field_Inspection_Report_FarmNo"><?= $Page->renderFieldHeader($Page->FarmNo) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { ?>
    <?php if ($Page->FarmerName->ShowGroupHeaderAsRow) { ?>
    <th data-name="FarmerName">&nbsp;</th>
    <?php } else { ?>
    <th data-name="FarmerName" class="<?= $Page->FarmerName->headerCellClass() ?>"><div class="Field_Inspection_Report_FarmerName"><?= $Page->renderFieldHeader($Page->FarmerName) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { ?>
    <th data-name="FarmSize" class="<?= $Page->FarmSize->headerCellClass() ?>"><div class="Field_Inspection_Report_FarmSize"><?= $Page->renderFieldHeader($Page->FarmSize) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
    <th data-name="FarmSizeEstimated" class="<?= $Page->FarmSizeEstimated->headerCellClass() ?>"><div class="Field_Inspection_Report_FarmSizeEstimated"><?= $Page->renderFieldHeader($Page->FarmSizeEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
    <th data-name="TreesPlantedEstimated" class="<?= $Page->TreesPlantedEstimated->headerCellClass() ?>"><div class="Field_Inspection_Report_TreesPlantedEstimated"><?= $Page->renderFieldHeader($Page->TreesPlantedEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
    <th data-name="FarmSizeVerified" class="<?= $Page->FarmSizeVerified->headerCellClass() ?>"><div class="Field_Inspection_Report_FarmSizeVerified"><?= $Page->renderFieldHeader($Page->FarmSizeVerified) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
    <th data-name="TreesPlantedVerified" class="<?= $Page->TreesPlantedVerified->headerCellClass() ?>"><div class="Field_Inspection_Report_TreesPlantedVerified"><?= $Page->renderFieldHeader($Page->TreesPlantedVerified) ?></div></th>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { ?>
    <th data-name="PlantsReplaced" class="<?= $Page->PlantsReplaced->headerCellClass() ?>"><div class="Field_Inspection_Report_PlantsReplaced"><?= $Page->renderFieldHeader($Page->PlantsReplaced) ?></div></th>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { ?>
    <th data-name="FungicidesReceived" class="<?= $Page->FungicidesReceived->headerCellClass() ?>"><div class="Field_Inspection_Report_FungicidesReceived"><?= $Page->renderFieldHeader($Page->FungicidesReceived) ?></div></th>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { ?>
    <th data-name="PescticidesReceived" class="<?= $Page->PescticidesReceived->headerCellClass() ?>"><div class="Field_Inspection_Report_PescticidesReceived"><?= $Page->renderFieldHeader($Page->PescticidesReceived) ?></div></th>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { ?>
    <th data-name="DiseasePresence" class="<?= $Page->DiseasePresence->headerCellClass() ?>"><div class="Field_Inspection_Report_DiseasePresence"><?= $Page->renderFieldHeader($Page->DiseasePresence) ?></div></th>
<?php } ?>
<?php if ($Page->OldTreesNo->Visible) { ?>
    <th data-name="OldTreesNo" class="<?= $Page->OldTreesNo->headerCellClass() ?>"><div class="Field_Inspection_Report_OldTreesNo"><?= $Page->renderFieldHeader($Page->OldTreesNo) ?></div></th>
<?php } ?>
    </tr>
</thead>
<tbody>
<?php
        if ($Page->TotalGroups == 0) {
            break; // Show header only
        }
        $Page->ShowHeader = false;
    } // End show header
?>
<?php

    // Build detail SQL
    $where = DetailFilterSql($Page->FarmNo, $Page->getSqlFirstGroupField(), $Page->FarmNo->groupValue(), $Page->Dbid);
    AddFilter($Page->PageFirstGroupFilter, $where, "OR");
    AddFilter($where, $Page->Filter);
    $sql = $Page->buildReportSql($Page->getSqlSelect(), $Page->getSqlFrom(), $Page->getSqlWhere(), $Page->getSqlGroupBy(), $Page->getSqlHaving(), $Page->getSqlOrderBy(), $where, $Page->Sort);
    $rs = $sql->executeQuery();
    $Page->DetailRecords = $rs?->fetchAll() ?? [];
    $Page->DetailRecordCount = count($Page->DetailRecords);

    // Load detail records
    $Page->FarmNo->Records = &$Page->DetailRecords;
    $Page->FarmNo->LevelBreak = true; // Set field level break
        $Page->GroupCounter[1] = $Page->GroupCount;
        $Page->FarmNo->getCnt($Page->FarmNo->Records); // Get record count
?>
<?php if ($Page->FarmNo->Visible && $Page->FarmNo->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 1;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmNo->Visible) { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->FarmNo->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="FarmNo" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 1) ?>"<?= $Page->FarmNo->cellAttributes() ?>>
            <span class="ew-summary-caption Field_Inspection_Report_FarmNo"><?= $Page->renderFieldHeader($Page->FarmNo) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->FarmNo->viewAttributes() ?>><?= $Page->FarmNo->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->FarmNo->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->FarmerName->getDistinctValues($Page->FarmNo->Records, $Page->FarmerName->getSort());
    $Page->setGroupCount(count($Page->FarmerName->DistinctValues), $Page->GroupCounter[1]);
    $Page->GroupCounter[2] = 0; // Init group count index
    foreach ($Page->FarmerName->DistinctValues as $FarmerName) { // Load records for this distinct value
        $Page->FarmerName->setGroupValue($FarmerName); // Set group value
        $Page->FarmerName->getDistinctRecords($Page->FarmNo->Records, $Page->FarmerName->groupValue());
        $Page->FarmerName->LevelBreak = true; // Set field level break
        $Page->GroupCounter[2]++;
        $Page->FarmerName->getCnt($Page->FarmerName->Records); // Get record count
        $Page->setGroupCount($Page->FarmerName->Count, $Page->GroupCounter[1], $Page->GroupCounter[2]);
?>
<?php if ($Page->FarmerName->Visible && $Page->FarmerName->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->FarmerName->setDbValue($FarmerName); // Set current value for FarmerName
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 2;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmNo->Visible) { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { ?>
        <td data-field="FarmerName"<?= $Page->FarmerName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->FarmerName->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="FarmerName" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 2) ?>"<?= $Page->FarmerName->cellAttributes() ?>>
            <span class="ew-summary-caption Field_Inspection_Report_FarmerName"><?= $Page->renderFieldHeader($Page->FarmerName) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->FarmerName->viewAttributes() ?>><?= $Page->FarmerName->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->FarmerName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
        $Page->RecordCount = 0; // Reset record count
        foreach ($Page->FarmerName->Records as $record) {
            $Page->RecordCount++;
            $Page->RecordIndex++;
            $Page->loadRowValues($record);
?>
<?php
        // Render detail row
        $Page->resetAttributes();
        $Page->RowType = RowType::DETAIL;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmNo->Visible) { ?>
    <?php if ($Page->FarmNo->ShowGroupHeaderAsRow) { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>><span<?= $Page->FarmNo->viewAttributes() ?>><?= $Page->FarmNo->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { ?>
    <?php if ($Page->FarmerName->ShowGroupHeaderAsRow) { ?>
        <td data-field="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>><span<?= $Page->FarmerName->viewAttributes() ?>><?= $Page->FarmerName->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { ?>
        <td data-field="FarmSize"<?= $Page->FarmSize->cellAttributes() ?>>
<span<?= $Page->FarmSize->viewAttributes() ?>>
<?= $Page->FarmSize->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { ?>
        <td data-field="PlantsReplaced"<?= $Page->PlantsReplaced->cellAttributes() ?>>
<span<?= $Page->PlantsReplaced->viewAttributes() ?>>
<?= $Page->PlantsReplaced->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { ?>
        <td data-field="FungicidesReceived"<?= $Page->FungicidesReceived->cellAttributes() ?>>
<span<?= $Page->FungicidesReceived->viewAttributes() ?>>
<?= $Page->FungicidesReceived->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { ?>
        <td data-field="PescticidesReceived"<?= $Page->PescticidesReceived->cellAttributes() ?>>
<span<?= $Page->PescticidesReceived->viewAttributes() ?>>
<?= $Page->PescticidesReceived->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { ?>
        <td data-field="DiseasePresence"<?= $Page->DiseasePresence->cellAttributes() ?>>
<span<?= $Page->DiseasePresence->viewAttributes() ?>>
<?= $Page->DiseasePresence->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->OldTreesNo->Visible) { ?>
        <td data-field="OldTreesNo"<?= $Page->OldTreesNo->cellAttributes() ?>>
<span<?= $Page->OldTreesNo->viewAttributes() ?>>
<?= $Page->OldTreesNo->getViewValue() ?></span>
</td>
<?php } ?>
    </tr>
<?php
    }
?>
<?php if ($Page->TotalGroups > 0) { ?>
<?php
    $Page->FarmSizeEstimated->getSum($Page->FarmerName->Records, false); // Get Sum
    $Page->TreesPlantedEstimated->getSum($Page->FarmerName->Records, false); // Get Sum
    $Page->FarmSizeVerified->getSum($Page->FarmerName->Records, false); // Get Sum
    $Page->TreesPlantedVerified->getSum($Page->FarmerName->Records, false); // Get Sum
    $Page->PlantsReplaced->getSum($Page->FarmerName->Records, false); // Get Sum
    $Page->FungicidesReceived->getSum($Page->FarmerName->Records, false); // Get Sum
    $Page->PescticidesReceived->getSum($Page->FarmerName->Records, false); // Get Sum
    $Page->OldTreesNo->getSum($Page->FarmerName->Records, false); // Get Sum
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GROUP;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowGroupLevel = 2;
    $Page->renderRow();
?>
<?php if ($Page->FarmerName->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmNo->Visible) { ?>
    <?php if ($Page->FarmNo->ShowGroupHeaderAsRow) { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 1) { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->FarmNo->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { ?>
    <?php if ($Page->FarmerName->ShowGroupHeaderAsRow) { ?>
        <td data-field="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 2) { ?>
        <td data-field="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->FarmerName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { ?>
        <td data-field="FarmSize"<?= $Page->FarmerName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmerName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeEstimated->viewAttributes() ?>><?= $Page->FarmSizeEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->FarmerName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>><?= $Page->TreesPlantedEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmerName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeVerified->viewAttributes() ?>><?= $Page->FarmSizeVerified->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->FarmerName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedVerified->viewAttributes() ?>><?= $Page->TreesPlantedVerified->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { ?>
        <td data-field="PlantsReplaced"<?= $Page->FarmerName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->PlantsReplaced->viewAttributes() ?>><?= $Page->PlantsReplaced->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { ?>
        <td data-field="FungicidesReceived"<?= $Page->FarmerName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FungicidesReceived->viewAttributes() ?>><?= $Page->FungicidesReceived->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { ?>
        <td data-field="PescticidesReceived"<?= $Page->FarmerName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->PescticidesReceived->viewAttributes() ?>><?= $Page->PescticidesReceived->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { ?>
        <td data-field="DiseasePresence"<?= $Page->FarmerName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->OldTreesNo->Visible) { ?>
        <td data-field="OldTreesNo"<?= $Page->FarmerName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->OldTreesNo->viewAttributes() ?>><?= $Page->OldTreesNo->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmNo->Visible) { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->SubGroupColumnCount + $Page->DetailColumnCount > 0) { ?>
        <td colspan="<?= ($Page->SubGroupColumnCount + $Page->DetailColumnCount) ?>"<?= $Page->FarmerName->cellAttributes() ?>><?= str_replace(["%v", "%c"], [$Page->FarmerName->GroupViewValue, $Page->FarmerName->caption()], $Language->phrase("RptSumHead")) ?> <span class="ew-dir-ltr">(<?= FormatNumber($Page->FarmerName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td>
<?php } ?>
    </tr>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmNo->Visible) { ?>
        <td data-field="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= ($Page->GroupColumnCount - 1) ?>"<?= $Page->FarmerName->cellAttributes() ?>><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { ?>
        <td data-field="FarmSize"<?= $Page->FarmerName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { ?>
        <td data-field="PlantsReplaced"<?= $Page->PlantsReplaced->cellAttributes() ?>>
<span<?= $Page->PlantsReplaced->viewAttributes() ?>>
<?= $Page->PlantsReplaced->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { ?>
        <td data-field="FungicidesReceived"<?= $Page->FungicidesReceived->cellAttributes() ?>>
<span<?= $Page->FungicidesReceived->viewAttributes() ?>>
<?= $Page->FungicidesReceived->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { ?>
        <td data-field="PescticidesReceived"<?= $Page->PescticidesReceived->cellAttributes() ?>>
<span<?= $Page->PescticidesReceived->viewAttributes() ?>>
<?= $Page->PescticidesReceived->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { ?>
        <td data-field="DiseasePresence"<?= $Page->FarmerName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->OldTreesNo->Visible) { ?>
        <td data-field="OldTreesNo"<?= $Page->OldTreesNo->cellAttributes() ?>>
<span<?= $Page->OldTreesNo->viewAttributes() ?>>
<?= $Page->OldTreesNo->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
<?php } ?>
<?php
    } // End group level 1
?>
<?php

    // Next group
    $Page->loadGroupRowValues();

    // Show header if page break
    if ($Page->isExport()) {
        $Page->ShowHeader = ($Page->ExportPageBreakCount == 0) ? false : ($Page->GroupCount % $Page->ExportPageBreakCount == 0);
    }

    // Page_Breaking server event
    if ($Page->ShowHeader) {
        $Page->pageBreaking($Page->ShowHeader, $Page->PageBreakHtml);
    }
    $Page->GroupCount++;
} // End while
?>
<?php if ($Page->TotalGroups > 0) { ?>
</tbody>
<tfoot>
<?php
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GRAND;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowAttrs["class"] = "ew-rpt-grand-summary";
    $Page->renderRow();
?>
<?php if ($Page->FarmNo->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"></td>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { ?>
        <td data-field="FarmSize"<?= $Page->FarmSize->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeEstimated->viewAttributes() ?>><?= $Page->FarmSizeEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>><?= $Page->TreesPlantedEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeVerified->viewAttributes() ?>><?= $Page->FarmSizeVerified->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedVerified->viewAttributes() ?>><?= $Page->TreesPlantedVerified->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { ?>
        <td data-field="PlantsReplaced"<?= $Page->PlantsReplaced->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->PlantsReplaced->viewAttributes() ?>><?= $Page->PlantsReplaced->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { ?>
        <td data-field="FungicidesReceived"<?= $Page->FungicidesReceived->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FungicidesReceived->viewAttributes() ?>><?= $Page->FungicidesReceived->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { ?>
        <td data-field="PescticidesReceived"<?= $Page->PescticidesReceived->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->PescticidesReceived->viewAttributes() ?>><?= $Page->PescticidesReceived->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { ?>
        <td data-field="DiseasePresence"<?= $Page->DiseasePresence->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->OldTreesNo->Visible) { ?>
        <td data-field="OldTreesNo"<?= $Page->OldTreesNo->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->OldTreesNo->viewAttributes() ?>><?= $Page->OldTreesNo->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { ?>
        <td data-field="FarmSize"<?= $Page->FarmSize->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { ?>
        <td data-field="PlantsReplaced"<?= $Page->PlantsReplaced->cellAttributes() ?>>
<span<?= $Page->PlantsReplaced->viewAttributes() ?>>
<?= $Page->PlantsReplaced->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { ?>
        <td data-field="FungicidesReceived"<?= $Page->FungicidesReceived->cellAttributes() ?>>
<span<?= $Page->FungicidesReceived->viewAttributes() ?>>
<?= $Page->FungicidesReceived->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { ?>
        <td data-field="PescticidesReceived"<?= $Page->PescticidesReceived->cellAttributes() ?>>
<span<?= $Page->PescticidesReceived->viewAttributes() ?>>
<?= $Page->PescticidesReceived->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { ?>
        <td data-field="DiseasePresence"<?= $Page->DiseasePresence->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->OldTreesNo->Visible) { ?>
        <td data-field="OldTreesNo"<?= $Page->OldTreesNo->cellAttributes() ?>>
<span<?= $Page->OldTreesNo->viewAttributes() ?>>
<?= $Page->OldTreesNo->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
</tfoot>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?php } ?>
</main>
<!-- /.report-summary -->
<!-- Summary report (end) -->
<?php } ?>
</div>
<!-- /.ew-report -->
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
