<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmerList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farmer: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null], fields.FarmerNo.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerName", [fields.FarmerName.visible && fields.FarmerName.required ? ew.Validators.required(fields.FarmerName.caption) : null], fields.FarmerName.isInvalid],
            ["FarmerType", [fields.FarmerType.visible && fields.FarmerType.required ? ew.Validators.required(fields.FarmerType.caption) : null, ew.Validators.integer], fields.FarmerType.isInvalid],
            ["DOB", [fields.DOB.visible && fields.DOB.required ? ew.Validators.required(fields.DOB.caption) : null], fields.DOB.isInvalid],
            ["Age", [fields.Age.visible && fields.Age.required ? ew.Validators.required(fields.Age.caption) : null, ew.Validators.float], fields.Age.isInvalid],
            ["Gender", [fields.Gender.visible && fields.Gender.required ? ew.Validators.required(fields.Gender.caption) : null], fields.Gender.isInvalid],
            ["MaritalStatus", [fields.MaritalStatus.visible && fields.MaritalStatus.required ? ew.Validators.required(fields.MaritalStatus.caption) : null], fields.MaritalStatus.isInvalid],
            ["PhoneNo", [fields.PhoneNo.visible && fields.PhoneNo.required ? ew.Validators.required(fields.PhoneNo.caption) : null], fields.PhoneNo.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.email], fields._Email.isInvalid],
            ["FarmerOrg", [fields.FarmerOrg.visible && fields.FarmerOrg.required ? ew.Validators.required(fields.FarmerOrg.caption) : null], fields.FarmerOrg.isInvalid],
            ["FarmerOrgPosition", [fields.FarmerOrgPosition.visible && fields.FarmerOrgPosition.required ? ew.Validators.required(fields.FarmerOrgPosition.caption) : null], fields.FarmerOrgPosition.isInvalid],
            ["AgeGroup", [fields.AgeGroup.visible && fields.AgeGroup.required ? ew.Validators.required(fields.AgeGroup.caption) : null], fields.AgeGroup.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FarmerName",false],["FarmerType",false],["DOB",false],["Age",false],["Gender",false],["MaritalStatus",false],["PhoneNo",false],["_Email",false],["FarmerOrg",false],["FarmerOrgPosition",false],["AgeGroup",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "FarmerNo": <?= $Page->FarmerNo->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FarmerName": <?= $Page->FarmerName->toClientList($Page) ?>,
            "FarmerType": <?= $Page->FarmerType->toClientList($Page) ?>,
            "Age": <?= $Page->Age->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
            "FarmerOrg": <?= $Page->FarmerOrg->toClientList($Page) ?>,
            "FarmerOrgPosition": <?= $Page->FarmerOrgPosition->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.14.0", "preview");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "village") {
    if ($Page->MasterRecordExists) {
        include_once "views/VillageMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffarmersrch" id="ffarmersrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="ffarmersrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farmer: currentTable } });
var currentForm;
var ffarmersrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarmersrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "FarmerNo": <?= $Page->FarmerNo->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FarmerName": <?= $Page->FarmerName->toClientList($Page) ?>,
            "FarmerType": <?= $Page->FarmerType->toClientList($Page) ?>,
            "Age": <?= $Page->Age->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
<?php
if (!$Page->ProvinceCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ProvinceCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ProvinceCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ProvinceCode"
            name="x_ProvinceCode[]"
            class="form-control ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_ProvinceCode"
            data-table="farmer"
            data-field="x_ProvinceCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ProvinceCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ProvinceCode->editAttributes() ?>>
            <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_ProvinceCode",
                selectId: "ffarmersrch_x_ProvinceCode",
                ajax: { id: "x_ProvinceCode", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.ProvinceCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
<?php
if (!$Page->DistrictCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictCode"
            name="x_DistrictCode[]"
            class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_DistrictCode"
            data-table="farmer"
            data-field="x_DistrictCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictCode->editAttributes() ?>>
            <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_DistrictCode",
                selectId: "ffarmersrch_x_DistrictCode",
                ajax: { id: "x_DistrictCode", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.DistrictCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
<?php
if (!$Page->CampCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_CampCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->CampCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_CampCode"
            name="x_CampCode[]"
            class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_CampCode"
            data-table="farmer"
            data-field="x_CampCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->CampCode->editAttributes() ?>>
            <?= $Page->CampCode->selectOptionListHtml("x_CampCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_CampCode",
                selectId: "ffarmersrch_x_CampCode",
                ajax: { id: "x_CampCode", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.CampCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
<?php
if (!$Page->VillageCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_VillageCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->VillageCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_VillageCode"
            name="x_VillageCode[]"
            class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_VillageCode"
            data-table="farmer"
            data-field="x_VillageCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->VillageCode->editAttributes() ?>>
            <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_VillageCode",
                selectId: "ffarmersrch_x_VillageCode",
                ajax: { id: "x_VillageCode", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.VillageCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
<?php
if (!$Page->FarmerNo->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmerNo" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmerNo->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmerNo"
            name="x_FarmerNo[]"
            class="form-control ew-select<?= $Page->FarmerNo->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_FarmerNo"
            data-table="farmer"
            data-field="x_FarmerNo"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerNo->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmerNo->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmerNo->editAttributes() ?>>
            <?= $Page->FarmerNo->selectOptionListHtml("x_FarmerNo", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_FarmerNo",
                selectId: "ffarmersrch_x_FarmerNo",
                ajax: { id: "x_FarmerNo", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.FarmerNo.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
<?php
if (!$Page->NRC->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_NRC" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->NRC->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_NRC"
            name="x_NRC[]"
            class="form-control ew-select<?= $Page->NRC->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_NRC"
            data-table="farmer"
            data-field="x_NRC"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->NRC->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->NRC->editAttributes() ?>>
            <?= $Page->NRC->selectOptionListHtml("x_NRC", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_NRC",
                selectId: "ffarmersrch_x_NRC",
                ajax: { id: "x_NRC", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.NRC.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
<?php
if (!$Page->FarmerName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmerName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmerName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmerName"
            name="x_FarmerName[]"
            class="form-control ew-select<?= $Page->FarmerName->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_FarmerName"
            data-table="farmer"
            data-field="x_FarmerName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmerName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmerName->editAttributes() ?>>
            <?= $Page->FarmerName->selectOptionListHtml("x_FarmerName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_FarmerName",
                selectId: "ffarmersrch_x_FarmerName",
                ajax: { id: "x_FarmerName", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.FarmerName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmerType->Visible) { // FarmerType ?>
<?php
if (!$Page->FarmerType->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmerType" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmerType->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmerType"
            name="x_FarmerType[]"
            class="form-control ew-select<?= $Page->FarmerType->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_FarmerType"
            data-table="farmer"
            data-field="x_FarmerType"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerType->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmerType->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmerType->editAttributes() ?>>
            <?= $Page->FarmerType->selectOptionListHtml("x_FarmerType", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmerType->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_FarmerType",
                selectId: "ffarmersrch_x_FarmerType",
                ajax: { id: "x_FarmerType", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.FarmerType.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
<?php
if (!$Page->Age->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Age" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Age->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Age"
            name="x_Age[]"
            class="form-control ew-select<?= $Page->Age->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_Age"
            data-table="farmer"
            data-field="x_Age"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Age->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Age->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Age->editAttributes() ?>>
            <?= $Page->Age->selectOptionListHtml("x_Age", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Age->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_Age",
                selectId: "ffarmersrch_x_Age",
                ajax: { id: "x_Age", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.Age.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
<?php
if (!$Page->Gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Gender"
            name="x_Gender[]"
            class="form-control ew-select<?= $Page->Gender->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_Gender"
            data-table="farmer"
            data-field="x_Gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Gender->editAttributes() ?>>
            <?= $Page->Gender->selectOptionListHtml("x_Gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_Gender",
                selectId: "ffarmersrch_x_Gender",
                ajax: { id: "x_Gender", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.Gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
<?php
if (!$Page->MaritalStatus->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_MaritalStatus" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->MaritalStatus->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_MaritalStatus"
            name="x_MaritalStatus[]"
            class="form-control ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
            data-select2-id="ffarmersrch_x_MaritalStatus"
            data-table="farmer"
            data-field="x_MaritalStatus"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->MaritalStatus->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->MaritalStatus->editAttributes() ?>>
            <?= $Page->MaritalStatus->selectOptionListHtml("x_MaritalStatus", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmersrch", function() {
            var options = {
                name: "x_MaritalStatus",
                selectId: "ffarmersrch_x_MaritalStatus",
                ajax: { id: "x_MaritalStatus", form: "ffarmersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farmer.fields.MaritalStatus.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffarmersrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffarmersrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffarmersrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffarmersrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farmer">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "village" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="village">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<input type="hidden" name="fk_VillageCode" value="<?= HtmlEncode($Page->VillageCode->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_farmer" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_farmerlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div id="elh_farmer_ProvinceCode" class="farmer_ProvinceCode"><?= $Page->renderFieldHeader($Page->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_farmer_DistrictCode" class="farmer_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_farmer_CampCode" class="farmer_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_farmer_VillageCode" class="farmer_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Page->FarmerNo->headerCellClass() ?>"><div id="elh_farmer_FarmerNo" class="farmer_FarmerNo"><?= $Page->renderFieldHeader($Page->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_farmer_NRC" class="farmer_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <th data-name="FarmerName" class="<?= $Page->FarmerName->headerCellClass() ?>"><div id="elh_farmer_FarmerName" class="farmer_FarmerName"><?= $Page->renderFieldHeader($Page->FarmerName) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerType->Visible) { // FarmerType ?>
        <th data-name="FarmerType" class="<?= $Page->FarmerType->headerCellClass() ?>"><div id="elh_farmer_FarmerType" class="farmer_FarmerType"><?= $Page->renderFieldHeader($Page->FarmerType) ?></div></th>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
        <th data-name="DOB" class="<?= $Page->DOB->headerCellClass() ?>"><div id="elh_farmer_DOB" class="farmer_DOB"><?= $Page->renderFieldHeader($Page->DOB) ?></div></th>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
        <th data-name="Age" class="<?= $Page->Age->headerCellClass() ?>"><div id="elh_farmer_Age" class="farmer_Age"><?= $Page->renderFieldHeader($Page->Age) ?></div></th>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
        <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div id="elh_farmer_Gender" class="farmer_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
        <th data-name="MaritalStatus" class="<?= $Page->MaritalStatus->headerCellClass() ?>"><div id="elh_farmer_MaritalStatus" class="farmer_MaritalStatus"><?= $Page->renderFieldHeader($Page->MaritalStatus) ?></div></th>
<?php } ?>
<?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
        <th data-name="PhoneNo" class="<?= $Page->PhoneNo->headerCellClass() ?>"><div id="elh_farmer_PhoneNo" class="farmer_PhoneNo"><?= $Page->renderFieldHeader($Page->PhoneNo) ?></div></th>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
        <th data-name="_Email" class="<?= $Page->_Email->headerCellClass() ?>"><div id="elh_farmer__Email" class="farmer__Email"><?= $Page->renderFieldHeader($Page->_Email) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerOrg->Visible) { // FarmerOrg ?>
        <th data-name="FarmerOrg" class="<?= $Page->FarmerOrg->headerCellClass() ?>"><div id="elh_farmer_FarmerOrg" class="farmer_FarmerOrg"><?= $Page->renderFieldHeader($Page->FarmerOrg) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
        <th data-name="FarmerOrgPosition" class="<?= $Page->FarmerOrgPosition->headerCellClass() ?>"><div id="elh_farmer_FarmerOrgPosition" class="farmer_FarmerOrgPosition"><?= $Page->renderFieldHeader($Page->FarmerOrgPosition) ?></div></th>
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { // AgeGroup ?>
        <th data-name="AgeGroup" class="<?= $Page->AgeGroup->headerCellClass() ?>"><div id="elh_farmer_AgeGroup" class="farmer_AgeGroup"><?= $Page->renderFieldHeader($Page->AgeGroup) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_ProvinceCode" name="x<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_ProvinceCode" class="el_farmer_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farmer" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ProvinceCode" id="o<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_ProvinceCode" name="x<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_ProvinceCode" class="el_farmer_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_ProvinceCode" class="el_farmer_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_DistrictCode" name="x<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_DistrictCode" class="el_farmer_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farmer" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DistrictCode" id="o<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_DistrictCode" name="x<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_DistrictCode" class="el_farmer_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_DistrictCode" class="el_farmer_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_CampCode" name="x<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_CampCode" class="el_farmer_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        data-table="farmer"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" };
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farmer" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_CampCode" id="o<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_CampCode" name="x<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_CampCode" class="el_farmer_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        data-table="farmer"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" };
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_CampCode" class="el_farmer_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_VillageCode" name="x<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_VillageCode" class="el_farmer_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        data-table="farmer"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" };
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farmer" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_VillageCode" id="o<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_VillageCode" name="x<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_VillageCode" class="el_farmer_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        data-table="farmer"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" };
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_VillageCode" class="el_farmer_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Page->FarmerNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerNo" class="el_farmer_FarmerNo"></span>
<input type="hidden" data-table="farmer" data-field="x_FarmerNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerNo" id="o<?= $Page->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Page->FarmerNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerNo" class="el_farmer_FarmerNo">
<span<?= $Page->FarmerNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FarmerNo->getDisplayValue($Page->FarmerNo->EditValue))) ?>"></span>
<input type="hidden" data-table="farmer" data-field="x_FarmerNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_FarmerNo" id="x<?= $Page->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Page->FarmerNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerNo" class="el_farmer_FarmerNo">
<span<?= $Page->FarmerNo->viewAttributes() ?>>
<?= $Page->FarmerNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="farmer" data-field="x_FarmerNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_FarmerNo" id="x<?= $Page->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Page->FarmerNo->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_NRC" class="el_farmer_NRC">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" data-table="farmer" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_NRC" class="el_farmer_NRC">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" data-table="farmer" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_NRC" class="el_farmer_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <td data-name="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerName" class="el_farmer_FarmerName">
<input type="<?= $Page->FarmerName->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerName" id="x<?= $Page->RowIndex ?>_FarmerName" data-table="farmer" data-field="x_FarmerName" value="<?= $Page->FarmerName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerName->formatPattern()) ?>"<?= $Page->FarmerName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_FarmerName" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerName" id="o<?= $Page->RowIndex ?>_FarmerName" value="<?= HtmlEncode($Page->FarmerName->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerName" class="el_farmer_FarmerName">
<input type="<?= $Page->FarmerName->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerName" id="x<?= $Page->RowIndex ?>_FarmerName" data-table="farmer" data-field="x_FarmerName" value="<?= $Page->FarmerName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerName->formatPattern()) ?>"<?= $Page->FarmerName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerName" class="el_farmer_FarmerName">
<span<?= $Page->FarmerName->viewAttributes() ?>>
<?= $Page->FarmerName->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerType->Visible) { // FarmerType ?>
        <td data-name="FarmerType"<?= $Page->FarmerType->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerType" class="el_farmer_FarmerType">
<?php
if (IsRTL()) {
    $Page->FarmerType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_FarmerType" class="ew-auto-suggest">
    <input type="<?= $Page->FarmerType->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_FarmerType" id="sv_x<?= $Page->RowIndex ?>_FarmerType" value="<?= RemoveHtml($Page->FarmerType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerType->formatPattern()) ?>"<?= $Page->FarmerType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farmer" data-field="x_FarmerType" data-input="sv_x<?= $Page->RowIndex ?>_FarmerType" data-value-separator="<?= $Page->FarmerType->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_FarmerType" id="x<?= $Page->RowIndex ?>_FarmerType" value="<?= HtmlEncode($Page->FarmerType->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->FarmerType->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_FarmerType","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->FarmerType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farmer.fields.FarmerType.autoSuggestOptions));
});
</script>
<?= $Page->FarmerType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmerType") ?>
</span>
<input type="hidden" data-table="farmer" data-field="x_FarmerType" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerType" id="o<?= $Page->RowIndex ?>_FarmerType" value="<?= HtmlEncode($Page->FarmerType->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerType" class="el_farmer_FarmerType">
<?php
if (IsRTL()) {
    $Page->FarmerType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_FarmerType" class="ew-auto-suggest">
    <input type="<?= $Page->FarmerType->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_FarmerType" id="sv_x<?= $Page->RowIndex ?>_FarmerType" value="<?= RemoveHtml($Page->FarmerType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerType->formatPattern()) ?>"<?= $Page->FarmerType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farmer" data-field="x_FarmerType" data-input="sv_x<?= $Page->RowIndex ?>_FarmerType" data-value-separator="<?= $Page->FarmerType->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_FarmerType" id="x<?= $Page->RowIndex ?>_FarmerType" value="<?= HtmlEncode($Page->FarmerType->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->FarmerType->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_FarmerType","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->FarmerType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farmer.fields.FarmerType.autoSuggestOptions));
});
</script>
<?= $Page->FarmerType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmerType") ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerType" class="el_farmer_FarmerType">
<span<?= $Page->FarmerType->viewAttributes() ?>>
<?= $Page->FarmerType->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DOB->Visible) { // DOB ?>
        <td data-name="DOB"<?= $Page->DOB->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_DOB" class="el_farmer_DOB">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DOB" id="x<?= $Page->RowIndex ?>_DOB" data-table="farmer" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_DOB" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DOB" id="o<?= $Page->RowIndex ?>_DOB" value="<?= HtmlEncode($Page->DOB->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_DOB" class="el_farmer_DOB">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DOB" id="x<?= $Page->RowIndex ?>_DOB" data-table="farmer" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_DOB" class="el_farmer_DOB">
<span<?= $Page->DOB->viewAttributes() ?>>
<?= $Page->DOB->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Age->Visible) { // Age ?>
        <td data-name="Age"<?= $Page->Age->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_Age" class="el_farmer_Age">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Age" id="x<?= $Page->RowIndex ?>_Age" data-table="farmer" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_Age" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Age" id="o<?= $Page->RowIndex ?>_Age" value="<?= HtmlEncode($Page->Age->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_Age" class="el_farmer_Age">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Age" id="x<?= $Page->RowIndex ?>_Age" data-table="farmer" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_Age" class="el_farmer_Age">
<span<?= $Page->Age->viewAttributes() ?>>
<?= $Page->Age->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Gender->Visible) { // Gender ?>
        <td data-name="Gender"<?= $Page->Gender->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_Gender" class="el_farmer_Gender">
    <select
        id="x<?= $Page->RowIndex ?>_Gender"
        name="x<?= $Page->RowIndex ?>_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Gender"
        <?php } ?>
        data-table="farmer"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x{$Page->RowIndex}_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Gender", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Gender", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Gender", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farmer" data-field="x_Gender" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Gender" id="o<?= $Page->RowIndex ?>_Gender" value="<?= HtmlEncode($Page->Gender->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_Gender" class="el_farmer_Gender">
    <select
        id="x<?= $Page->RowIndex ?>_Gender"
        name="x<?= $Page->RowIndex ?>_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Gender"
        <?php } ?>
        data-table="farmer"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x{$Page->RowIndex}_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Gender", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Gender", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Gender", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_Gender" class="el_farmer_Gender">
<span<?= $Page->Gender->viewAttributes() ?>>
<?= $Page->Gender->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
        <td data-name="MaritalStatus"<?= $Page->MaritalStatus->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_MaritalStatus" class="el_farmer_MaritalStatus">
    <select
        id="x<?= $Page->RowIndex ?>_MaritalStatus"
        name="x<?= $Page->RowIndex ?>_MaritalStatus"
        class="form-select ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
        <?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_MaritalStatus"
        <?php } ?>
        data-table="farmer"
        data-field="x_MaritalStatus"
        data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
        <?= $Page->MaritalStatus->editAttributes() ?>>
        <?= $Page->MaritalStatus->selectOptionListHtml("x{$Page->RowIndex}_MaritalStatus") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage() ?></div>
<?= $Page->MaritalStatus->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_MaritalStatus") ?>
<?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_MaritalStatus", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_MaritalStatus" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.MaritalStatus?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_MaritalStatus", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_MaritalStatus", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.MaritalStatus.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farmer" data-field="x_MaritalStatus" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_MaritalStatus" id="o<?= $Page->RowIndex ?>_MaritalStatus" value="<?= HtmlEncode($Page->MaritalStatus->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_MaritalStatus" class="el_farmer_MaritalStatus">
    <select
        id="x<?= $Page->RowIndex ?>_MaritalStatus"
        name="x<?= $Page->RowIndex ?>_MaritalStatus"
        class="form-select ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
        <?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_MaritalStatus"
        <?php } ?>
        data-table="farmer"
        data-field="x_MaritalStatus"
        data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
        <?= $Page->MaritalStatus->editAttributes() ?>>
        <?= $Page->MaritalStatus->selectOptionListHtml("x{$Page->RowIndex}_MaritalStatus") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage() ?></div>
<?= $Page->MaritalStatus->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_MaritalStatus") ?>
<?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_MaritalStatus", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_MaritalStatus" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.MaritalStatus?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_MaritalStatus", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_MaritalStatus", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.MaritalStatus.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_MaritalStatus" class="el_farmer_MaritalStatus">
<span<?= $Page->MaritalStatus->viewAttributes() ?>>
<?= $Page->MaritalStatus->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
        <td data-name="PhoneNo"<?= $Page->PhoneNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_PhoneNo" class="el_farmer_PhoneNo">
<input type="<?= $Page->PhoneNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PhoneNo" id="x<?= $Page->RowIndex ?>_PhoneNo" data-table="farmer" data-field="x_PhoneNo" value="<?= $Page->PhoneNo->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PhoneNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PhoneNo->formatPattern()) ?>"<?= $Page->PhoneNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PhoneNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_PhoneNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_PhoneNo" id="o<?= $Page->RowIndex ?>_PhoneNo" value="<?= HtmlEncode($Page->PhoneNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_PhoneNo" class="el_farmer_PhoneNo">
<input type="<?= $Page->PhoneNo->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_PhoneNo" id="x<?= $Page->RowIndex ?>_PhoneNo" data-table="farmer" data-field="x_PhoneNo" value="<?= $Page->PhoneNo->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PhoneNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PhoneNo->formatPattern()) ?>"<?= $Page->PhoneNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PhoneNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_PhoneNo" class="el_farmer_PhoneNo">
<span<?= $Page->PhoneNo->viewAttributes() ?>>
<?= $Page->PhoneNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->_Email->Visible) { // Email ?>
        <td data-name="_Email"<?= $Page->_Email->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer__Email" class="el_farmer__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>__Email" id="x<?= $Page->RowIndex ?>__Email" data-table="farmer" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x__Email" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>__Email" id="o<?= $Page->RowIndex ?>__Email" value="<?= HtmlEncode($Page->_Email->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer__Email" class="el_farmer__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>__Email" id="x<?= $Page->RowIndex ?>__Email" data-table="farmer" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer__Email" class="el_farmer__Email">
<span<?= $Page->_Email->viewAttributes() ?>>
<?= $Page->_Email->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerOrg->Visible) { // FarmerOrg ?>
        <td data-name="FarmerOrg"<?= $Page->FarmerOrg->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerOrg" class="el_farmer_FarmerOrg">
    <select
        id="x<?= $Page->RowIndex ?>_FarmerOrg"
        name="x<?= $Page->RowIndex ?>_FarmerOrg"
        class="form-control ew-select<?= $Page->FarmerOrg->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmerOrg"
        data-table="farmer"
        data-field="x_FarmerOrg"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerOrg->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->FarmerOrg->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmerOrg->getPlaceHolder()) ?>"
        <?= $Page->FarmerOrg->editAttributes() ?>>
        <?= $Page->FarmerOrg->selectOptionListHtml("x{$Page->RowIndex}_FarmerOrg") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmerOrg->getErrorMessage() ?></div>
<?= $Page->FarmerOrg->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmerOrg") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FarmerOrg", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmerOrg" };
    if (<?= $Page->FormName ?>.lists.FarmerOrg?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FarmerOrg", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FarmerOrg", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.FarmerOrg.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="farmer" data-field="x_FarmerOrg" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerOrg" id="o<?= $Page->RowIndex ?>_FarmerOrg" value="<?= HtmlEncode($Page->FarmerOrg->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerOrg" class="el_farmer_FarmerOrg">
    <select
        id="x<?= $Page->RowIndex ?>_FarmerOrg"
        name="x<?= $Page->RowIndex ?>_FarmerOrg"
        class="form-control ew-select<?= $Page->FarmerOrg->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmerOrg"
        data-table="farmer"
        data-field="x_FarmerOrg"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerOrg->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->FarmerOrg->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmerOrg->getPlaceHolder()) ?>"
        <?= $Page->FarmerOrg->editAttributes() ?>>
        <?= $Page->FarmerOrg->selectOptionListHtml("x{$Page->RowIndex}_FarmerOrg") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmerOrg->getErrorMessage() ?></div>
<?= $Page->FarmerOrg->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmerOrg") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FarmerOrg", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmerOrg" };
    if (<?= $Page->FormName ?>.lists.FarmerOrg?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FarmerOrg", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FarmerOrg", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.FarmerOrg.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerOrg" class="el_farmer_FarmerOrg">
<span<?= $Page->FarmerOrg->viewAttributes() ?>>
<?= $Page->FarmerOrg->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
        <td data-name="FarmerOrgPosition"<?= $Page->FarmerOrgPosition->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerOrgPosition" class="el_farmer_FarmerOrgPosition">
    <select
        id="x<?= $Page->RowIndex ?>_FarmerOrgPosition"
        name="x<?= $Page->RowIndex ?>_FarmerOrgPosition"
        class="form-select ew-select<?= $Page->FarmerOrgPosition->isInvalidClass() ?>"
        <?php if (!$Page->FarmerOrgPosition->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmerOrgPosition"
        <?php } ?>
        data-table="farmer"
        data-field="x_FarmerOrgPosition"
        data-value-separator="<?= $Page->FarmerOrgPosition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmerOrgPosition->getPlaceHolder()) ?>"
        <?= $Page->FarmerOrgPosition->editAttributes() ?>>
        <?= $Page->FarmerOrgPosition->selectOptionListHtml("x{$Page->RowIndex}_FarmerOrgPosition") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmerOrgPosition->getErrorMessage() ?></div>
<?= $Page->FarmerOrgPosition->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmerOrgPosition") ?>
<?php if (!$Page->FarmerOrgPosition->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FarmerOrgPosition", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmerOrgPosition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.FarmerOrgPosition?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FarmerOrgPosition", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FarmerOrgPosition", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.FarmerOrgPosition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farmer" data-field="x_FarmerOrgPosition" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerOrgPosition" id="o<?= $Page->RowIndex ?>_FarmerOrgPosition" value="<?= HtmlEncode($Page->FarmerOrgPosition->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerOrgPosition" class="el_farmer_FarmerOrgPosition">
    <select
        id="x<?= $Page->RowIndex ?>_FarmerOrgPosition"
        name="x<?= $Page->RowIndex ?>_FarmerOrgPosition"
        class="form-select ew-select<?= $Page->FarmerOrgPosition->isInvalidClass() ?>"
        <?php if (!$Page->FarmerOrgPosition->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmerOrgPosition"
        <?php } ?>
        data-table="farmer"
        data-field="x_FarmerOrgPosition"
        data-value-separator="<?= $Page->FarmerOrgPosition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmerOrgPosition->getPlaceHolder()) ?>"
        <?= $Page->FarmerOrgPosition->editAttributes() ?>>
        <?= $Page->FarmerOrgPosition->selectOptionListHtml("x{$Page->RowIndex}_FarmerOrgPosition") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmerOrgPosition->getErrorMessage() ?></div>
<?= $Page->FarmerOrgPosition->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FarmerOrgPosition") ?>
<?php if (!$Page->FarmerOrgPosition->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FarmerOrgPosition", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FarmerOrgPosition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.FarmerOrgPosition?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FarmerOrgPosition", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FarmerOrgPosition", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.FarmerOrgPosition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_FarmerOrgPosition" class="el_farmer_FarmerOrgPosition">
<span<?= $Page->FarmerOrgPosition->viewAttributes() ?>>
<?= $Page->FarmerOrgPosition->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->AgeGroup->Visible) { // AgeGroup ?>
        <td data-name="AgeGroup"<?= $Page->AgeGroup->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_AgeGroup" class="el_farmer_AgeGroup">
<input type="<?= $Page->AgeGroup->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AgeGroup" id="x<?= $Page->RowIndex ?>_AgeGroup" data-table="farmer" data-field="x_AgeGroup" value="<?= $Page->AgeGroup->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->AgeGroup->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AgeGroup->formatPattern()) ?>"<?= $Page->AgeGroup->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AgeGroup->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_AgeGroup" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_AgeGroup" id="o<?= $Page->RowIndex ?>_AgeGroup" value="<?= HtmlEncode($Page->AgeGroup->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_AgeGroup" class="el_farmer_AgeGroup">
<input type="<?= $Page->AgeGroup->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_AgeGroup" id="x<?= $Page->RowIndex ?>_AgeGroup" data-table="farmer" data-field="x_AgeGroup" value="<?= $Page->AgeGroup->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->AgeGroup->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AgeGroup->formatPattern()) ?>"<?= $Page->AgeGroup->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AgeGroup->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farmer_AgeGroup" class="el_farmer_AgeGroup">
<span<?= $Page->AgeGroup->viewAttributes() ?>>
<?= $Page->AgeGroup->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farmer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
