<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("FarmerGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ffarmergrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { farmer: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarmergrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null], fields.FarmerNo.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerName", [fields.FarmerName.visible && fields.FarmerName.required ? ew.Validators.required(fields.FarmerName.caption) : null], fields.FarmerName.isInvalid],
            ["FarmerType", [fields.FarmerType.visible && fields.FarmerType.required ? ew.Validators.required(fields.FarmerType.caption) : null, ew.Validators.integer], fields.FarmerType.isInvalid],
            ["DOB", [fields.DOB.visible && fields.DOB.required ? ew.Validators.required(fields.DOB.caption) : null], fields.DOB.isInvalid],
            ["Age", [fields.Age.visible && fields.Age.required ? ew.Validators.required(fields.Age.caption) : null, ew.Validators.float], fields.Age.isInvalid],
            ["Gender", [fields.Gender.visible && fields.Gender.required ? ew.Validators.required(fields.Gender.caption) : null], fields.Gender.isInvalid],
            ["MaritalStatus", [fields.MaritalStatus.visible && fields.MaritalStatus.required ? ew.Validators.required(fields.MaritalStatus.caption) : null], fields.MaritalStatus.isInvalid],
            ["PhoneNo", [fields.PhoneNo.visible && fields.PhoneNo.required ? ew.Validators.required(fields.PhoneNo.caption) : null], fields.PhoneNo.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.email], fields._Email.isInvalid],
            ["FarmerOrg", [fields.FarmerOrg.visible && fields.FarmerOrg.required ? ew.Validators.required(fields.FarmerOrg.caption) : null], fields.FarmerOrg.isInvalid],
            ["FarmerOrgPosition", [fields.FarmerOrgPosition.visible && fields.FarmerOrgPosition.required ? ew.Validators.required(fields.FarmerOrgPosition.caption) : null], fields.FarmerOrgPosition.isInvalid],
            ["AgeGroup", [fields.AgeGroup.visible && fields.AgeGroup.required ? ew.Validators.required(fields.AgeGroup.caption) : null], fields.AgeGroup.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FarmerName",false],["FarmerType",false],["DOB",false],["Age",false],["Gender",false],["MaritalStatus",false],["PhoneNo",false],["_Email",false],["FarmerOrg",false],["FarmerOrgPosition",false],["AgeGroup",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Grid->ProvinceCode->toClientList($Grid) ?>,
            "DistrictCode": <?= $Grid->DistrictCode->toClientList($Grid) ?>,
            "CampCode": <?= $Grid->CampCode->toClientList($Grid) ?>,
            "VillageCode": <?= $Grid->VillageCode->toClientList($Grid) ?>,
            "FarmerType": <?= $Grid->FarmerType->toClientList($Grid) ?>,
            "Gender": <?= $Grid->Gender->toClientList($Grid) ?>,
            "MaritalStatus": <?= $Grid->MaritalStatus->toClientList($Grid) ?>,
            "FarmerOrg": <?= $Grid->FarmerOrg->toClientList($Grid) ?>,
            "FarmerOrgPosition": <?= $Grid->FarmerOrgPosition->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ffarmergrid" class="ew-form ew-list-form">
<div id="gmp_farmer" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_farmergrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->headerCellClass() ?>"><div id="elh_farmer_ProvinceCode" class="farmer_ProvinceCode"><?= $Grid->renderFieldHeader($Grid->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Grid->DistrictCode->headerCellClass() ?>"><div id="elh_farmer_DistrictCode" class="farmer_DistrictCode"><?= $Grid->renderFieldHeader($Grid->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Grid->CampCode->headerCellClass() ?>"><div id="elh_farmer_CampCode" class="farmer_CampCode"><?= $Grid->renderFieldHeader($Grid->CampCode) ?></div></th>
<?php } ?>
<?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Grid->VillageCode->headerCellClass() ?>"><div id="elh_farmer_VillageCode" class="farmer_VillageCode"><?= $Grid->renderFieldHeader($Grid->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Grid->FarmerNo->headerCellClass() ?>"><div id="elh_farmer_FarmerNo" class="farmer_FarmerNo"><?= $Grid->renderFieldHeader($Grid->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Grid->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Grid->NRC->headerCellClass() ?>"><div id="elh_farmer_NRC" class="farmer_NRC"><?= $Grid->renderFieldHeader($Grid->NRC) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmerName->Visible) { // FarmerName ?>
        <th data-name="FarmerName" class="<?= $Grid->FarmerName->headerCellClass() ?>"><div id="elh_farmer_FarmerName" class="farmer_FarmerName"><?= $Grid->renderFieldHeader($Grid->FarmerName) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmerType->Visible) { // FarmerType ?>
        <th data-name="FarmerType" class="<?= $Grid->FarmerType->headerCellClass() ?>"><div id="elh_farmer_FarmerType" class="farmer_FarmerType"><?= $Grid->renderFieldHeader($Grid->FarmerType) ?></div></th>
<?php } ?>
<?php if ($Grid->DOB->Visible) { // DOB ?>
        <th data-name="DOB" class="<?= $Grid->DOB->headerCellClass() ?>"><div id="elh_farmer_DOB" class="farmer_DOB"><?= $Grid->renderFieldHeader($Grid->DOB) ?></div></th>
<?php } ?>
<?php if ($Grid->Age->Visible) { // Age ?>
        <th data-name="Age" class="<?= $Grid->Age->headerCellClass() ?>"><div id="elh_farmer_Age" class="farmer_Age"><?= $Grid->renderFieldHeader($Grid->Age) ?></div></th>
<?php } ?>
<?php if ($Grid->Gender->Visible) { // Gender ?>
        <th data-name="Gender" class="<?= $Grid->Gender->headerCellClass() ?>"><div id="elh_farmer_Gender" class="farmer_Gender"><?= $Grid->renderFieldHeader($Grid->Gender) ?></div></th>
<?php } ?>
<?php if ($Grid->MaritalStatus->Visible) { // MaritalStatus ?>
        <th data-name="MaritalStatus" class="<?= $Grid->MaritalStatus->headerCellClass() ?>"><div id="elh_farmer_MaritalStatus" class="farmer_MaritalStatus"><?= $Grid->renderFieldHeader($Grid->MaritalStatus) ?></div></th>
<?php } ?>
<?php if ($Grid->PhoneNo->Visible) { // PhoneNo ?>
        <th data-name="PhoneNo" class="<?= $Grid->PhoneNo->headerCellClass() ?>"><div id="elh_farmer_PhoneNo" class="farmer_PhoneNo"><?= $Grid->renderFieldHeader($Grid->PhoneNo) ?></div></th>
<?php } ?>
<?php if ($Grid->_Email->Visible) { // Email ?>
        <th data-name="_Email" class="<?= $Grid->_Email->headerCellClass() ?>"><div id="elh_farmer__Email" class="farmer__Email"><?= $Grid->renderFieldHeader($Grid->_Email) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmerOrg->Visible) { // FarmerOrg ?>
        <th data-name="FarmerOrg" class="<?= $Grid->FarmerOrg->headerCellClass() ?>"><div id="elh_farmer_FarmerOrg" class="farmer_FarmerOrg"><?= $Grid->renderFieldHeader($Grid->FarmerOrg) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
        <th data-name="FarmerOrgPosition" class="<?= $Grid->FarmerOrgPosition->headerCellClass() ?>"><div id="elh_farmer_FarmerOrgPosition" class="farmer_FarmerOrgPosition"><?= $Grid->renderFieldHeader($Grid->FarmerOrgPosition) ?></div></th>
<?php } ?>
<?php if ($Grid->AgeGroup->Visible) { // AgeGroup ?>
        <th data-name="AgeGroup" class="<?= $Grid->AgeGroup->headerCellClass() ?>"><div id="elh_farmer_AgeGroup" class="farmer_AgeGroup"><?= $Grid->renderFieldHeader($Grid->AgeGroup) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Grid->ProvinceCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_ProvinceCode" class="el_farmer_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farmer" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProvinceCode" id="o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_ProvinceCode" class="el_farmer_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_ProvinceCode" class="el_farmer_ProvinceCode">
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<?= $Grid->ProvinceCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_ProvinceCode" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarmergrid$x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_ProvinceCode" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarmergrid$o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Grid->DistrictCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_DistrictCode" class="el_farmer_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farmer" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DistrictCode" id="o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_DistrictCode" class="el_farmer_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_DistrictCode" class="el_farmer_DistrictCode">
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<?= $Grid->DistrictCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_DistrictCode" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_DistrictCode" id="ffarmergrid$x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_DistrictCode" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_DistrictCode" id="ffarmergrid$o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Grid->CampCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->CampCode->getSessionValue() != "") { ?>
<span<?= $Grid->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->CampCode->getDisplayValue($Grid->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_CampCode" name="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_CampCode" class="el_farmer_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_CampCode"
        data-table="farmer"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_CampCode" };
    if (ffarmergrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farmer" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_CampCode" id="o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->CampCode->getSessionValue() != "") { ?>
<span<?= $Grid->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->CampCode->getDisplayValue($Grid->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_CampCode" name="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_CampCode" class="el_farmer_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_CampCode"
        data-table="farmer"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_CampCode" };
    if (ffarmergrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_CampCode" class="el_farmer_CampCode">
<span<?= $Grid->CampCode->viewAttributes() ?>>
<?= $Grid->CampCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_CampCode" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_CampCode" id="ffarmergrid$x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_CampCode" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_CampCode" id="ffarmergrid$o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Grid->VillageCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->VillageCode->getSessionValue() != "") { ?>
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->VillageCode->getDisplayValue($Grid->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_VillageCode" name="x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_VillageCode" class="el_farmer_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_VillageCode"
        data-table="farmer"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_VillageCode" };
    if (ffarmergrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farmer" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_VillageCode" id="o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->VillageCode->getSessionValue() != "") { ?>
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->VillageCode->getDisplayValue($Grid->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_VillageCode" name="x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_VillageCode" class="el_farmer_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_VillageCode"
        data-table="farmer"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_VillageCode" };
    if (ffarmergrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_VillageCode" class="el_farmer_VillageCode">
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<?= $Grid->VillageCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_VillageCode" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_VillageCode" id="ffarmergrid$x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_VillageCode" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_VillageCode" id="ffarmergrid$o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Grid->FarmerNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerNo" class="el_farmer_FarmerNo"></span>
<input type="hidden" data-table="farmer" data-field="x_FarmerNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmerNo" id="o<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerNo" class="el_farmer_FarmerNo">
<span<?= $Grid->FarmerNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->FarmerNo->getDisplayValue($Grid->FarmerNo->EditValue))) ?>"></span>
<input type="hidden" data-table="farmer" data-field="x_FarmerNo" data-hidden="1" name="x<?= $Grid->RowIndex ?>_FarmerNo" id="x<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerNo" class="el_farmer_FarmerNo">
<span<?= $Grid->FarmerNo->viewAttributes() ?>>
<?= $Grid->FarmerNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_FarmerNo" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerNo" id="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_FarmerNo" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerNo" id="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="farmer" data-field="x_FarmerNo" data-hidden="1" name="x<?= $Grid->RowIndex ?>_FarmerNo" id="x<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Grid->NRC->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_NRC" class="el_farmer_NRC">
<input type="<?= $Grid->NRC->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" data-table="farmer" data-field="x_NRC" value="<?= $Grid->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_NRC" class="el_farmer_NRC">
<input type="<?= $Grid->NRC->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NRC" id="x<?= $Grid->RowIndex ?>_NRC" data-table="farmer" data-field="x_NRC" value="<?= $Grid->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NRC->formatPattern()) ?>"<?= $Grid->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_NRC" class="el_farmer_NRC">
<span<?= $Grid->NRC->viewAttributes() ?>>
<?= $Grid->NRC->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_NRC" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_NRC" id="ffarmergrid$x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_NRC" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_NRC" id="ffarmergrid$o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmerName->Visible) { // FarmerName ?>
        <td data-name="FarmerName"<?= $Grid->FarmerName->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerName" class="el_farmer_FarmerName">
<input type="<?= $Grid->FarmerName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmerName" id="x<?= $Grid->RowIndex ?>_FarmerName" data-table="farmer" data-field="x_FarmerName" value="<?= $Grid->FarmerName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerName->formatPattern()) ?>"<?= $Grid->FarmerName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmerName->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_FarmerName" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmerName" id="o<?= $Grid->RowIndex ?>_FarmerName" value="<?= HtmlEncode($Grid->FarmerName->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerName" class="el_farmer_FarmerName">
<input type="<?= $Grid->FarmerName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmerName" id="x<?= $Grid->RowIndex ?>_FarmerName" data-table="farmer" data-field="x_FarmerName" value="<?= $Grid->FarmerName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerName->formatPattern()) ?>"<?= $Grid->FarmerName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmerName->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerName" class="el_farmer_FarmerName">
<span<?= $Grid->FarmerName->viewAttributes() ?>>
<?= $Grid->FarmerName->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_FarmerName" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerName" id="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerName" value="<?= HtmlEncode($Grid->FarmerName->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_FarmerName" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerName" id="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerName" value="<?= HtmlEncode($Grid->FarmerName->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmerType->Visible) { // FarmerType ?>
        <td data-name="FarmerType"<?= $Grid->FarmerType->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerType" class="el_farmer_FarmerType">
<?php
if (IsRTL()) {
    $Grid->FarmerType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_FarmerType" class="ew-auto-suggest">
    <input type="<?= $Grid->FarmerType->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_FarmerType" id="sv_x<?= $Grid->RowIndex ?>_FarmerType" value="<?= RemoveHtml($Grid->FarmerType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->FarmerType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->FarmerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerType->formatPattern()) ?>"<?= $Grid->FarmerType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farmer" data-field="x_FarmerType" data-input="sv_x<?= $Grid->RowIndex ?>_FarmerType" data-value-separator="<?= $Grid->FarmerType->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_FarmerType" id="x<?= $Grid->RowIndex ?>_FarmerType" value="<?= HtmlEncode($Grid->FarmerType->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->FarmerType->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarmergrid", function() {
    ffarmergrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_FarmerType","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->FarmerType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farmer.fields.FarmerType.autoSuggestOptions));
});
</script>
<?= $Grid->FarmerType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FarmerType") ?>
</span>
<input type="hidden" data-table="farmer" data-field="x_FarmerType" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmerType" id="o<?= $Grid->RowIndex ?>_FarmerType" value="<?= HtmlEncode($Grid->FarmerType->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerType" class="el_farmer_FarmerType">
<?php
if (IsRTL()) {
    $Grid->FarmerType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_FarmerType" class="ew-auto-suggest">
    <input type="<?= $Grid->FarmerType->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_FarmerType" id="sv_x<?= $Grid->RowIndex ?>_FarmerType" value="<?= RemoveHtml($Grid->FarmerType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->FarmerType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->FarmerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerType->formatPattern()) ?>"<?= $Grid->FarmerType->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farmer" data-field="x_FarmerType" data-input="sv_x<?= $Grid->RowIndex ?>_FarmerType" data-value-separator="<?= $Grid->FarmerType->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_FarmerType" id="x<?= $Grid->RowIndex ?>_FarmerType" value="<?= HtmlEncode($Grid->FarmerType->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->FarmerType->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarmergrid", function() {
    ffarmergrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_FarmerType","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->FarmerType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farmer.fields.FarmerType.autoSuggestOptions));
});
</script>
<?= $Grid->FarmerType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FarmerType") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerType" class="el_farmer_FarmerType">
<span<?= $Grid->FarmerType->viewAttributes() ?>>
<?= $Grid->FarmerType->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_FarmerType" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerType" id="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerType" value="<?= HtmlEncode($Grid->FarmerType->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_FarmerType" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerType" id="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerType" value="<?= HtmlEncode($Grid->FarmerType->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DOB->Visible) { // DOB ?>
        <td data-name="DOB"<?= $Grid->DOB->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_DOB" class="el_farmer_DOB">
<input type="<?= $Grid->DOB->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DOB" id="x<?= $Grid->RowIndex ?>_DOB" data-table="farmer" data-field="x_DOB" value="<?= $Grid->DOB->EditValue ?>" placeholder="<?= HtmlEncode($Grid->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DOB->formatPattern()) ?>"<?= $Grid->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DOB->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_DOB" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DOB" id="o<?= $Grid->RowIndex ?>_DOB" value="<?= HtmlEncode($Grid->DOB->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_DOB" class="el_farmer_DOB">
<input type="<?= $Grid->DOB->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_DOB" id="x<?= $Grid->RowIndex ?>_DOB" data-table="farmer" data-field="x_DOB" value="<?= $Grid->DOB->EditValue ?>" placeholder="<?= HtmlEncode($Grid->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->DOB->formatPattern()) ?>"<?= $Grid->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->DOB->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_DOB" class="el_farmer_DOB">
<span<?= $Grid->DOB->viewAttributes() ?>>
<?= $Grid->DOB->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_DOB" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_DOB" id="ffarmergrid$x<?= $Grid->RowIndex ?>_DOB" value="<?= HtmlEncode($Grid->DOB->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_DOB" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_DOB" id="ffarmergrid$o<?= $Grid->RowIndex ?>_DOB" value="<?= HtmlEncode($Grid->DOB->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Age->Visible) { // Age ?>
        <td data-name="Age"<?= $Grid->Age->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_Age" class="el_farmer_Age">
<input type="<?= $Grid->Age->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Age" id="x<?= $Grid->RowIndex ?>_Age" data-table="farmer" data-field="x_Age" value="<?= $Grid->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Age->formatPattern()) ?>"<?= $Grid->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Age->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_Age" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Age" id="o<?= $Grid->RowIndex ?>_Age" value="<?= HtmlEncode($Grid->Age->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_Age" class="el_farmer_Age">
<input type="<?= $Grid->Age->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Age" id="x<?= $Grid->RowIndex ?>_Age" data-table="farmer" data-field="x_Age" value="<?= $Grid->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Age->formatPattern()) ?>"<?= $Grid->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Age->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_Age" class="el_farmer_Age">
<span<?= $Grid->Age->viewAttributes() ?>>
<?= $Grid->Age->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_Age" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_Age" id="ffarmergrid$x<?= $Grid->RowIndex ?>_Age" value="<?= HtmlEncode($Grid->Age->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_Age" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_Age" id="ffarmergrid$o<?= $Grid->RowIndex ?>_Age" value="<?= HtmlEncode($Grid->Age->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Gender->Visible) { // Gender ?>
        <td data-name="Gender"<?= $Grid->Gender->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_Gender" class="el_farmer_Gender">
    <select
        id="x<?= $Grid->RowIndex ?>_Gender"
        name="x<?= $Grid->RowIndex ?>_Gender"
        class="form-select ew-select<?= $Grid->Gender->isInvalidClass() ?>"
        <?php if (!$Grid->Gender->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_Gender"
        <?php } ?>
        data-table="farmer"
        data-field="x_Gender"
        data-value-separator="<?= $Grid->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Gender->getPlaceHolder()) ?>"
        <?= $Grid->Gender->editAttributes() ?>>
        <?= $Grid->Gender->selectOptionListHtml("x{$Grid->RowIndex}_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Gender->getErrorMessage() ?></div>
<?= $Grid->Gender->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Gender") ?>
<?php if (!$Grid->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Gender", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Gender", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Gender", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farmer" data-field="x_Gender" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Gender" id="o<?= $Grid->RowIndex ?>_Gender" value="<?= HtmlEncode($Grid->Gender->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_Gender" class="el_farmer_Gender">
    <select
        id="x<?= $Grid->RowIndex ?>_Gender"
        name="x<?= $Grid->RowIndex ?>_Gender"
        class="form-select ew-select<?= $Grid->Gender->isInvalidClass() ?>"
        <?php if (!$Grid->Gender->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_Gender"
        <?php } ?>
        data-table="farmer"
        data-field="x_Gender"
        data-value-separator="<?= $Grid->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->Gender->getPlaceHolder()) ?>"
        <?= $Grid->Gender->editAttributes() ?>>
        <?= $Grid->Gender->selectOptionListHtml("x{$Grid->RowIndex}_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->Gender->getErrorMessage() ?></div>
<?= $Grid->Gender->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_Gender") ?>
<?php if (!$Grid->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_Gender", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_Gender", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_Gender", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_Gender" class="el_farmer_Gender">
<span<?= $Grid->Gender->viewAttributes() ?>>
<?= $Grid->Gender->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_Gender" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_Gender" id="ffarmergrid$x<?= $Grid->RowIndex ?>_Gender" value="<?= HtmlEncode($Grid->Gender->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_Gender" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_Gender" id="ffarmergrid$o<?= $Grid->RowIndex ?>_Gender" value="<?= HtmlEncode($Grid->Gender->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->MaritalStatus->Visible) { // MaritalStatus ?>
        <td data-name="MaritalStatus"<?= $Grid->MaritalStatus->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_MaritalStatus" class="el_farmer_MaritalStatus">
    <select
        id="x<?= $Grid->RowIndex ?>_MaritalStatus"
        name="x<?= $Grid->RowIndex ?>_MaritalStatus"
        class="form-select ew-select<?= $Grid->MaritalStatus->isInvalidClass() ?>"
        <?php if (!$Grid->MaritalStatus->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_MaritalStatus"
        <?php } ?>
        data-table="farmer"
        data-field="x_MaritalStatus"
        data-value-separator="<?= $Grid->MaritalStatus->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->MaritalStatus->getPlaceHolder()) ?>"
        <?= $Grid->MaritalStatus->editAttributes() ?>>
        <?= $Grid->MaritalStatus->selectOptionListHtml("x{$Grid->RowIndex}_MaritalStatus") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->MaritalStatus->getErrorMessage() ?></div>
<?= $Grid->MaritalStatus->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_MaritalStatus") ?>
<?php if (!$Grid->MaritalStatus->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_MaritalStatus", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_MaritalStatus" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.MaritalStatus?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_MaritalStatus", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_MaritalStatus", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.MaritalStatus.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farmer" data-field="x_MaritalStatus" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_MaritalStatus" id="o<?= $Grid->RowIndex ?>_MaritalStatus" value="<?= HtmlEncode($Grid->MaritalStatus->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_MaritalStatus" class="el_farmer_MaritalStatus">
    <select
        id="x<?= $Grid->RowIndex ?>_MaritalStatus"
        name="x<?= $Grid->RowIndex ?>_MaritalStatus"
        class="form-select ew-select<?= $Grid->MaritalStatus->isInvalidClass() ?>"
        <?php if (!$Grid->MaritalStatus->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_MaritalStatus"
        <?php } ?>
        data-table="farmer"
        data-field="x_MaritalStatus"
        data-value-separator="<?= $Grid->MaritalStatus->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->MaritalStatus->getPlaceHolder()) ?>"
        <?= $Grid->MaritalStatus->editAttributes() ?>>
        <?= $Grid->MaritalStatus->selectOptionListHtml("x{$Grid->RowIndex}_MaritalStatus") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->MaritalStatus->getErrorMessage() ?></div>
<?= $Grid->MaritalStatus->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_MaritalStatus") ?>
<?php if (!$Grid->MaritalStatus->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_MaritalStatus", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_MaritalStatus" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.MaritalStatus?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_MaritalStatus", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_MaritalStatus", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.MaritalStatus.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_MaritalStatus" class="el_farmer_MaritalStatus">
<span<?= $Grid->MaritalStatus->viewAttributes() ?>>
<?= $Grid->MaritalStatus->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_MaritalStatus" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_MaritalStatus" id="ffarmergrid$x<?= $Grid->RowIndex ?>_MaritalStatus" value="<?= HtmlEncode($Grid->MaritalStatus->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_MaritalStatus" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_MaritalStatus" id="ffarmergrid$o<?= $Grid->RowIndex ?>_MaritalStatus" value="<?= HtmlEncode($Grid->MaritalStatus->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PhoneNo->Visible) { // PhoneNo ?>
        <td data-name="PhoneNo"<?= $Grid->PhoneNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_PhoneNo" class="el_farmer_PhoneNo">
<input type="<?= $Grid->PhoneNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PhoneNo" id="x<?= $Grid->RowIndex ?>_PhoneNo" data-table="farmer" data-field="x_PhoneNo" value="<?= $Grid->PhoneNo->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->PhoneNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PhoneNo->formatPattern()) ?>"<?= $Grid->PhoneNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PhoneNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_PhoneNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PhoneNo" id="o<?= $Grid->RowIndex ?>_PhoneNo" value="<?= HtmlEncode($Grid->PhoneNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_PhoneNo" class="el_farmer_PhoneNo">
<input type="<?= $Grid->PhoneNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PhoneNo" id="x<?= $Grid->RowIndex ?>_PhoneNo" data-table="farmer" data-field="x_PhoneNo" value="<?= $Grid->PhoneNo->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->PhoneNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PhoneNo->formatPattern()) ?>"<?= $Grid->PhoneNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PhoneNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_PhoneNo" class="el_farmer_PhoneNo">
<span<?= $Grid->PhoneNo->viewAttributes() ?>>
<?= $Grid->PhoneNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_PhoneNo" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_PhoneNo" id="ffarmergrid$x<?= $Grid->RowIndex ?>_PhoneNo" value="<?= HtmlEncode($Grid->PhoneNo->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_PhoneNo" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_PhoneNo" id="ffarmergrid$o<?= $Grid->RowIndex ?>_PhoneNo" value="<?= HtmlEncode($Grid->PhoneNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_Email->Visible) { // Email ?>
        <td data-name="_Email"<?= $Grid->_Email->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer__Email" class="el_farmer__Email">
<input type="<?= $Grid->_Email->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__Email" id="x<?= $Grid->RowIndex ?>__Email" data-table="farmer" data-field="x__Email" value="<?= $Grid->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_Email->formatPattern()) ?>"<?= $Grid->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_Email->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x__Email" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__Email" id="o<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer__Email" class="el_farmer__Email">
<input type="<?= $Grid->_Email->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__Email" id="x<?= $Grid->RowIndex ?>__Email" data-table="farmer" data-field="x__Email" value="<?= $Grid->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_Email->formatPattern()) ?>"<?= $Grid->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_Email->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer__Email" class="el_farmer__Email">
<span<?= $Grid->_Email->viewAttributes() ?>>
<?= $Grid->_Email->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x__Email" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>__Email" id="ffarmergrid$x<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x__Email" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>__Email" id="ffarmergrid$o<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmerOrg->Visible) { // FarmerOrg ?>
        <td data-name="FarmerOrg"<?= $Grid->FarmerOrg->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerOrg" class="el_farmer_FarmerOrg">
    <select
        id="x<?= $Grid->RowIndex ?>_FarmerOrg"
        name="x<?= $Grid->RowIndex ?>_FarmerOrg"
        class="form-control ew-select<?= $Grid->FarmerOrg->isInvalidClass() ?>"
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_FarmerOrg"
        data-table="farmer"
        data-field="x_FarmerOrg"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->FarmerOrg->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->FarmerOrg->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FarmerOrg->getPlaceHolder()) ?>"
        <?= $Grid->FarmerOrg->editAttributes() ?>>
        <?= $Grid->FarmerOrg->selectOptionListHtml("x{$Grid->RowIndex}_FarmerOrg") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FarmerOrg->getErrorMessage() ?></div>
<?= $Grid->FarmerOrg->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FarmerOrg") ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FarmerOrg", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_FarmerOrg" };
    if (ffarmergrid.lists.FarmerOrg?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FarmerOrg", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FarmerOrg", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.FarmerOrg.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="farmer" data-field="x_FarmerOrg" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmerOrg" id="o<?= $Grid->RowIndex ?>_FarmerOrg" value="<?= HtmlEncode($Grid->FarmerOrg->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerOrg" class="el_farmer_FarmerOrg">
    <select
        id="x<?= $Grid->RowIndex ?>_FarmerOrg"
        name="x<?= $Grid->RowIndex ?>_FarmerOrg"
        class="form-control ew-select<?= $Grid->FarmerOrg->isInvalidClass() ?>"
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_FarmerOrg"
        data-table="farmer"
        data-field="x_FarmerOrg"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->FarmerOrg->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->FarmerOrg->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FarmerOrg->getPlaceHolder()) ?>"
        <?= $Grid->FarmerOrg->editAttributes() ?>>
        <?= $Grid->FarmerOrg->selectOptionListHtml("x{$Grid->RowIndex}_FarmerOrg") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FarmerOrg->getErrorMessage() ?></div>
<?= $Grid->FarmerOrg->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FarmerOrg") ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FarmerOrg", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_FarmerOrg" };
    if (ffarmergrid.lists.FarmerOrg?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FarmerOrg", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FarmerOrg", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.FarmerOrg.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerOrg" class="el_farmer_FarmerOrg">
<span<?= $Grid->FarmerOrg->viewAttributes() ?>>
<?= $Grid->FarmerOrg->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_FarmerOrg" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerOrg" id="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerOrg" value="<?= HtmlEncode($Grid->FarmerOrg->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_FarmerOrg" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerOrg" id="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerOrg" value="<?= HtmlEncode($Grid->FarmerOrg->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
        <td data-name="FarmerOrgPosition"<?= $Grid->FarmerOrgPosition->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerOrgPosition" class="el_farmer_FarmerOrgPosition">
    <select
        id="x<?= $Grid->RowIndex ?>_FarmerOrgPosition"
        name="x<?= $Grid->RowIndex ?>_FarmerOrgPosition"
        class="form-select ew-select<?= $Grid->FarmerOrgPosition->isInvalidClass() ?>"
        <?php if (!$Grid->FarmerOrgPosition->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_FarmerOrgPosition"
        <?php } ?>
        data-table="farmer"
        data-field="x_FarmerOrgPosition"
        data-value-separator="<?= $Grid->FarmerOrgPosition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FarmerOrgPosition->getPlaceHolder()) ?>"
        <?= $Grid->FarmerOrgPosition->editAttributes() ?>>
        <?= $Grid->FarmerOrgPosition->selectOptionListHtml("x{$Grid->RowIndex}_FarmerOrgPosition") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FarmerOrgPosition->getErrorMessage() ?></div>
<?= $Grid->FarmerOrgPosition->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FarmerOrgPosition") ?>
<?php if (!$Grid->FarmerOrgPosition->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FarmerOrgPosition", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_FarmerOrgPosition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.FarmerOrgPosition?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FarmerOrgPosition", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FarmerOrgPosition", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.FarmerOrgPosition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farmer" data-field="x_FarmerOrgPosition" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmerOrgPosition" id="o<?= $Grid->RowIndex ?>_FarmerOrgPosition" value="<?= HtmlEncode($Grid->FarmerOrgPosition->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerOrgPosition" class="el_farmer_FarmerOrgPosition">
    <select
        id="x<?= $Grid->RowIndex ?>_FarmerOrgPosition"
        name="x<?= $Grid->RowIndex ?>_FarmerOrgPosition"
        class="form-select ew-select<?= $Grid->FarmerOrgPosition->isInvalidClass() ?>"
        <?php if (!$Grid->FarmerOrgPosition->IsNativeSelect) { ?>
        data-select2-id="ffarmergrid_x<?= $Grid->RowIndex ?>_FarmerOrgPosition"
        <?php } ?>
        data-table="farmer"
        data-field="x_FarmerOrgPosition"
        data-value-separator="<?= $Grid->FarmerOrgPosition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->FarmerOrgPosition->getPlaceHolder()) ?>"
        <?= $Grid->FarmerOrgPosition->editAttributes() ?>>
        <?= $Grid->FarmerOrgPosition->selectOptionListHtml("x{$Grid->RowIndex}_FarmerOrgPosition") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->FarmerOrgPosition->getErrorMessage() ?></div>
<?= $Grid->FarmerOrgPosition->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_FarmerOrgPosition") ?>
<?php if (!$Grid->FarmerOrgPosition->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_FarmerOrgPosition", selectId: "ffarmergrid_x<?= $Grid->RowIndex ?>_FarmerOrgPosition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmergrid.lists.FarmerOrgPosition?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_FarmerOrgPosition", form: "ffarmergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_FarmerOrgPosition", form: "ffarmergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.FarmerOrgPosition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_FarmerOrgPosition" class="el_farmer_FarmerOrgPosition">
<span<?= $Grid->FarmerOrgPosition->viewAttributes() ?>>
<?= $Grid->FarmerOrgPosition->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_FarmerOrgPosition" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerOrgPosition" id="ffarmergrid$x<?= $Grid->RowIndex ?>_FarmerOrgPosition" value="<?= HtmlEncode($Grid->FarmerOrgPosition->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_FarmerOrgPosition" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerOrgPosition" id="ffarmergrid$o<?= $Grid->RowIndex ?>_FarmerOrgPosition" value="<?= HtmlEncode($Grid->FarmerOrgPosition->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->AgeGroup->Visible) { // AgeGroup ?>
        <td data-name="AgeGroup"<?= $Grid->AgeGroup->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_AgeGroup" class="el_farmer_AgeGroup">
<input type="<?= $Grid->AgeGroup->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AgeGroup" id="x<?= $Grid->RowIndex ?>_AgeGroup" data-table="farmer" data-field="x_AgeGroup" value="<?= $Grid->AgeGroup->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Grid->AgeGroup->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AgeGroup->formatPattern()) ?>"<?= $Grid->AgeGroup->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AgeGroup->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farmer" data-field="x_AgeGroup" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_AgeGroup" id="o<?= $Grid->RowIndex ?>_AgeGroup" value="<?= HtmlEncode($Grid->AgeGroup->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_AgeGroup" class="el_farmer_AgeGroup">
<input type="<?= $Grid->AgeGroup->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AgeGroup" id="x<?= $Grid->RowIndex ?>_AgeGroup" data-table="farmer" data-field="x_AgeGroup" value="<?= $Grid->AgeGroup->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Grid->AgeGroup->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AgeGroup->formatPattern()) ?>"<?= $Grid->AgeGroup->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AgeGroup->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farmer_AgeGroup" class="el_farmer_AgeGroup">
<span<?= $Grid->AgeGroup->viewAttributes() ?>>
<?= $Grid->AgeGroup->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farmer" data-field="x_AgeGroup" data-hidden="1" name="ffarmergrid$x<?= $Grid->RowIndex ?>_AgeGroup" id="ffarmergrid$x<?= $Grid->RowIndex ?>_AgeGroup" value="<?= HtmlEncode($Grid->AgeGroup->FormValue) ?>">
<input type="hidden" data-table="farmer" data-field="x_AgeGroup" data-hidden="1" data-old name="ffarmergrid$o<?= $Grid->RowIndex ?>_AgeGroup" id="ffarmergrid$o<?= $Grid->RowIndex ?>_AgeGroup" value="<?= HtmlEncode($Grid->AgeGroup->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ffarmergrid","load"], () => ffarmergrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ffarmergrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farmer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
