<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmerAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farmer: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ffarmeradd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarmeradd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerName", [fields.FarmerName.visible && fields.FarmerName.required ? ew.Validators.required(fields.FarmerName.caption) : null], fields.FarmerName.isInvalid],
            ["FarmerType", [fields.FarmerType.visible && fields.FarmerType.required ? ew.Validators.required(fields.FarmerType.caption) : null, ew.Validators.integer], fields.FarmerType.isInvalid],
            ["DOB", [fields.DOB.visible && fields.DOB.required ? ew.Validators.required(fields.DOB.caption) : null], fields.DOB.isInvalid],
            ["Age", [fields.Age.visible && fields.Age.required ? ew.Validators.required(fields.Age.caption) : null, ew.Validators.float], fields.Age.isInvalid],
            ["Gender", [fields.Gender.visible && fields.Gender.required ? ew.Validators.required(fields.Gender.caption) : null], fields.Gender.isInvalid],
            ["MaritalStatus", [fields.MaritalStatus.visible && fields.MaritalStatus.required ? ew.Validators.required(fields.MaritalStatus.caption) : null], fields.MaritalStatus.isInvalid],
            ["PhoneNo", [fields.PhoneNo.visible && fields.PhoneNo.required ? ew.Validators.required(fields.PhoneNo.caption) : null], fields.PhoneNo.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.email], fields._Email.isInvalid],
            ["Dependants", [fields.Dependants.visible && fields.Dependants.required ? ew.Validators.required(fields.Dependants.caption) : null, ew.Validators.integer], fields.Dependants.isInvalid],
            ["MaleChildren", [fields.MaleChildren.visible && fields.MaleChildren.required ? ew.Validators.required(fields.MaleChildren.caption) : null, ew.Validators.integer], fields.MaleChildren.isInvalid],
            ["FemaleChildren", [fields.FemaleChildren.visible && fields.FemaleChildren.required ? ew.Validators.required(fields.FemaleChildren.caption) : null, ew.Validators.integer], fields.FemaleChildren.isInvalid],
            ["HouseholdHead", [fields.HouseholdHead.visible && fields.HouseholdHead.required ? ew.Validators.required(fields.HouseholdHead.caption) : null], fields.HouseholdHead.isInvalid],
            ["FarmerOrg", [fields.FarmerOrg.visible && fields.FarmerOrg.required ? ew.Validators.required(fields.FarmerOrg.caption) : null], fields.FarmerOrg.isInvalid],
            ["FarmerOrgPosition", [fields.FarmerOrgPosition.visible && fields.FarmerOrgPosition.required ? ew.Validators.required(fields.FarmerOrgPosition.caption) : null], fields.FarmerOrgPosition.isInvalid],
            ["JoiningDate", [fields.JoiningDate.visible && fields.JoiningDate.required ? ew.Validators.required(fields.JoiningDate.caption) : null, ew.Validators.datetime(fields.JoiningDate.clientFormatPattern)], fields.JoiningDate.isInvalid],
            ["Comments", [fields.Comments.visible && fields.Comments.required ? ew.Validators.required(fields.Comments.caption) : null], fields.Comments.isInvalid],
            ["AgeGroup", [fields.AgeGroup.visible && fields.AgeGroup.required ? ew.Validators.required(fields.AgeGroup.caption) : null], fields.AgeGroup.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "FarmerType": <?= $Page->FarmerType->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
            "HouseholdHead": <?= $Page->HouseholdHead->toClientList($Page) ?>,
            "FarmerOrg": <?= $Page->FarmerOrg->toClientList($Page) ?>,
            "FarmerOrgPosition": <?= $Page->FarmerOrgPosition->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarmeradd" id="ffarmeradd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farmer">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "village") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="village">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<input type="hidden" name="fk_VillageCode" value="<?= HtmlEncode($Page->VillageCode->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_farmer_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x_ProvinceCode" name="x_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farmer_ProvinceCode">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmeradd_x_ProvinceCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <?= $Page->ProvinceCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarmeradd_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmeradd.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_farmer_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x_DistrictCode" name="x_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farmer_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarmeradd_x_DistrictCode"
        <?php } ?>
        data-table="farmer"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarmeradd_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmeradd.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <label id="elh_farmer_CampCode" for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CampCode->caption() ?><?= $Page->CampCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x_CampCode" name="x_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farmer_CampCode">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmeradd_x_CampCode"
        data-table="farmer"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <?= $Page->CampCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_CampCode", selectId: "ffarmeradd_x_CampCode" };
    if (ffarmeradd.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <label id="elh_farmer_VillageCode" for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VillageCode->caption() ?><?= $Page->VillageCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x_VillageCode" name="x_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farmer_VillageCode">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmeradd_x_VillageCode"
        data-table="farmer"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <?= $Page->VillageCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_VillageCode", selectId: "ffarmeradd_x_VillageCode" };
    if (ffarmeradd.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_farmer_NRC" for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<span id="el_farmer_NRC">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="farmer" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?> aria-describedby="x_NRC_help">
<?= $Page->NRC->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
    <div id="r_FarmerName"<?= $Page->FarmerName->rowAttributes() ?>>
        <label id="elh_farmer_FarmerName" for="x_FarmerName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmerName->caption() ?><?= $Page->FarmerName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmerName->cellAttributes() ?>>
<span id="el_farmer_FarmerName">
<input type="<?= $Page->FarmerName->getInputTextType() ?>" name="x_FarmerName" id="x_FarmerName" data-table="farmer" data-field="x_FarmerName" value="<?= $Page->FarmerName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerName->formatPattern()) ?>"<?= $Page->FarmerName->editAttributes() ?> aria-describedby="x_FarmerName_help">
<?= $Page->FarmerName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmerType->Visible) { // FarmerType ?>
    <div id="r_FarmerType"<?= $Page->FarmerType->rowAttributes() ?>>
        <label id="elh_farmer_FarmerType" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmerType->caption() ?><?= $Page->FarmerType->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmerType->cellAttributes() ?>>
<span id="el_farmer_FarmerType">
<?php
if (IsRTL()) {
    $Page->FarmerType->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_FarmerType" class="ew-auto-suggest">
    <input type="<?= $Page->FarmerType->getInputTextType() ?>" class="form-control" name="sv_x_FarmerType" id="sv_x_FarmerType" value="<?= RemoveHtml($Page->FarmerType->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->FarmerType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerType->formatPattern()) ?>"<?= $Page->FarmerType->editAttributes() ?> aria-describedby="x_FarmerType_help">
</span>
<selection-list hidden class="form-control" data-table="farmer" data-field="x_FarmerType" data-input="sv_x_FarmerType" data-value-separator="<?= $Page->FarmerType->displayValueSeparatorAttribute() ?>" name="x_FarmerType" id="x_FarmerType" value="<?= HtmlEncode($Page->FarmerType->CurrentValue) ?>"></selection-list>
<?= $Page->FarmerType->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmerType->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarmeradd", function() {
    ffarmeradd.createAutoSuggest(Object.assign({"id":"x_FarmerType","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->FarmerType->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farmer.fields.FarmerType.autoSuggestOptions));
});
</script>
<?= $Page->FarmerType->Lookup->getParamTag($Page, "p_x_FarmerType") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
    <div id="r_DOB"<?= $Page->DOB->rowAttributes() ?>>
        <label id="elh_farmer_DOB" for="x_DOB" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DOB->caption() ?><?= $Page->DOB->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DOB->cellAttributes() ?>>
<span id="el_farmer_DOB">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x_DOB" id="x_DOB" data-table="farmer" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?> aria-describedby="x_DOB_help">
<?= $Page->DOB->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
    <div id="r_Age"<?= $Page->Age->rowAttributes() ?>>
        <label id="elh_farmer_Age" for="x_Age" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Age->caption() ?><?= $Page->Age->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Age->cellAttributes() ?>>
<span id="el_farmer_Age">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x_Age" id="x_Age" data-table="farmer" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?> aria-describedby="x_Age_help">
<?= $Page->Age->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender"<?= $Page->Gender->rowAttributes() ?>>
        <label id="elh_farmer_Gender" for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Gender->caption() ?><?= $Page->Gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Gender->cellAttributes() ?>>
<span id="el_farmer_Gender">
    <select
        id="x_Gender"
        name="x_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="ffarmeradd_x_Gender"
        <?php } ?>
        data-table="farmer"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x_Gender") ?>
    </select>
    <?= $Page->Gender->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_Gender", selectId: "ffarmeradd_x_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmeradd.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x_Gender", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_Gender", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
    <div id="r_MaritalStatus"<?= $Page->MaritalStatus->rowAttributes() ?>>
        <label id="elh_farmer_MaritalStatus" for="x_MaritalStatus" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MaritalStatus->caption() ?><?= $Page->MaritalStatus->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MaritalStatus->cellAttributes() ?>>
<span id="el_farmer_MaritalStatus">
    <select
        id="x_MaritalStatus"
        name="x_MaritalStatus"
        class="form-select ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
        <?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
        data-select2-id="ffarmeradd_x_MaritalStatus"
        <?php } ?>
        data-table="farmer"
        data-field="x_MaritalStatus"
        data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
        <?= $Page->MaritalStatus->editAttributes() ?>>
        <?= $Page->MaritalStatus->selectOptionListHtml("x_MaritalStatus") ?>
    </select>
    <?= $Page->MaritalStatus->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage() ?></div>
<?= $Page->MaritalStatus->Lookup->getParamTag($Page, "p_x_MaritalStatus") ?>
<?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_MaritalStatus", selectId: "ffarmeradd_x_MaritalStatus" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmeradd.lists.MaritalStatus?.lookupOptions.length) {
        options.data = { id: "x_MaritalStatus", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_MaritalStatus", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.MaritalStatus.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
    <div id="r_PhoneNo"<?= $Page->PhoneNo->rowAttributes() ?>>
        <label id="elh_farmer_PhoneNo" for="x_PhoneNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PhoneNo->caption() ?><?= $Page->PhoneNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PhoneNo->cellAttributes() ?>>
<span id="el_farmer_PhoneNo">
<input type="<?= $Page->PhoneNo->getInputTextType() ?>" name="x_PhoneNo" id="x_PhoneNo" data-table="farmer" data-field="x_PhoneNo" value="<?= $Page->PhoneNo->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PhoneNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PhoneNo->formatPattern()) ?>"<?= $Page->PhoneNo->editAttributes() ?> aria-describedby="x_PhoneNo_help">
<?= $Page->PhoneNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PhoneNo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label id="elh_farmer__Email" for="x__Email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Email->caption() ?><?= $Page->_Email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Email->cellAttributes() ?>>
<span id="el_farmer__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="farmer" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
<?= $Page->_Email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Dependants->Visible) { // Dependants ?>
    <div id="r_Dependants"<?= $Page->Dependants->rowAttributes() ?>>
        <label id="elh_farmer_Dependants" for="x_Dependants" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Dependants->caption() ?><?= $Page->Dependants->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Dependants->cellAttributes() ?>>
<span id="el_farmer_Dependants">
<input type="<?= $Page->Dependants->getInputTextType() ?>" name="x_Dependants" id="x_Dependants" data-table="farmer" data-field="x_Dependants" value="<?= $Page->Dependants->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Dependants->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Dependants->formatPattern()) ?>"<?= $Page->Dependants->editAttributes() ?> aria-describedby="x_Dependants_help">
<?= $Page->Dependants->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Dependants->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MaleChildren->Visible) { // MaleChildren ?>
    <div id="r_MaleChildren"<?= $Page->MaleChildren->rowAttributes() ?>>
        <label id="elh_farmer_MaleChildren" for="x_MaleChildren" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MaleChildren->caption() ?><?= $Page->MaleChildren->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MaleChildren->cellAttributes() ?>>
<span id="el_farmer_MaleChildren">
<input type="<?= $Page->MaleChildren->getInputTextType() ?>" name="x_MaleChildren" id="x_MaleChildren" data-table="farmer" data-field="x_MaleChildren" value="<?= $Page->MaleChildren->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->MaleChildren->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->MaleChildren->formatPattern()) ?>"<?= $Page->MaleChildren->editAttributes() ?> aria-describedby="x_MaleChildren_help">
<?= $Page->MaleChildren->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->MaleChildren->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FemaleChildren->Visible) { // FemaleChildren ?>
    <div id="r_FemaleChildren"<?= $Page->FemaleChildren->rowAttributes() ?>>
        <label id="elh_farmer_FemaleChildren" for="x_FemaleChildren" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FemaleChildren->caption() ?><?= $Page->FemaleChildren->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FemaleChildren->cellAttributes() ?>>
<span id="el_farmer_FemaleChildren">
<input type="<?= $Page->FemaleChildren->getInputTextType() ?>" name="x_FemaleChildren" id="x_FemaleChildren" data-table="farmer" data-field="x_FemaleChildren" value="<?= $Page->FemaleChildren->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FemaleChildren->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FemaleChildren->formatPattern()) ?>"<?= $Page->FemaleChildren->editAttributes() ?> aria-describedby="x_FemaleChildren_help">
<?= $Page->FemaleChildren->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FemaleChildren->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->HouseholdHead->Visible) { // HouseholdHead ?>
    <div id="r_HouseholdHead"<?= $Page->HouseholdHead->rowAttributes() ?>>
        <label id="elh_farmer_HouseholdHead" for="x_HouseholdHead" class="<?= $Page->LeftColumnClass ?>"><?= $Page->HouseholdHead->caption() ?><?= $Page->HouseholdHead->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->HouseholdHead->cellAttributes() ?>>
<span id="el_farmer_HouseholdHead">
    <select
        id="x_HouseholdHead"
        name="x_HouseholdHead"
        class="form-select ew-select<?= $Page->HouseholdHead->isInvalidClass() ?>"
        <?php if (!$Page->HouseholdHead->IsNativeSelect) { ?>
        data-select2-id="ffarmeradd_x_HouseholdHead"
        <?php } ?>
        data-table="farmer"
        data-field="x_HouseholdHead"
        data-value-separator="<?= $Page->HouseholdHead->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->HouseholdHead->getPlaceHolder()) ?>"
        <?= $Page->HouseholdHead->editAttributes() ?>>
        <?= $Page->HouseholdHead->selectOptionListHtml("x_HouseholdHead") ?>
    </select>
    <?= $Page->HouseholdHead->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->HouseholdHead->getErrorMessage() ?></div>
<?= $Page->HouseholdHead->Lookup->getParamTag($Page, "p_x_HouseholdHead") ?>
<?php if (!$Page->HouseholdHead->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_HouseholdHead", selectId: "ffarmeradd_x_HouseholdHead" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmeradd.lists.HouseholdHead?.lookupOptions.length) {
        options.data = { id: "x_HouseholdHead", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_HouseholdHead", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.HouseholdHead.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmerOrg->Visible) { // FarmerOrg ?>
    <div id="r_FarmerOrg"<?= $Page->FarmerOrg->rowAttributes() ?>>
        <label id="elh_farmer_FarmerOrg" for="x_FarmerOrg" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmerOrg->caption() ?><?= $Page->FarmerOrg->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmerOrg->cellAttributes() ?>>
<span id="el_farmer_FarmerOrg">
    <select
        id="x_FarmerOrg"
        name="x_FarmerOrg"
        class="form-control ew-select<?= $Page->FarmerOrg->isInvalidClass() ?>"
        data-select2-id="ffarmeradd_x_FarmerOrg"
        data-table="farmer"
        data-field="x_FarmerOrg"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerOrg->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->FarmerOrg->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmerOrg->getPlaceHolder()) ?>"
        <?= $Page->FarmerOrg->editAttributes() ?>>
        <?= $Page->FarmerOrg->selectOptionListHtml("x_FarmerOrg") ?>
    </select>
    <?= $Page->FarmerOrg->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->FarmerOrg->getErrorMessage() ?></div>
<?= $Page->FarmerOrg->Lookup->getParamTag($Page, "p_x_FarmerOrg") ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_FarmerOrg", selectId: "ffarmeradd_x_FarmerOrg" };
    if (ffarmeradd.lists.FarmerOrg?.lookupOptions.length) {
        options.data = { id: "x_FarmerOrg", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_FarmerOrg", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farmer.fields.FarmerOrg.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmerOrgPosition->Visible) { // FarmerOrgPosition ?>
    <div id="r_FarmerOrgPosition"<?= $Page->FarmerOrgPosition->rowAttributes() ?>>
        <label id="elh_farmer_FarmerOrgPosition" for="x_FarmerOrgPosition" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmerOrgPosition->caption() ?><?= $Page->FarmerOrgPosition->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmerOrgPosition->cellAttributes() ?>>
<span id="el_farmer_FarmerOrgPosition">
    <select
        id="x_FarmerOrgPosition"
        name="x_FarmerOrgPosition"
        class="form-select ew-select<?= $Page->FarmerOrgPosition->isInvalidClass() ?>"
        <?php if (!$Page->FarmerOrgPosition->IsNativeSelect) { ?>
        data-select2-id="ffarmeradd_x_FarmerOrgPosition"
        <?php } ?>
        data-table="farmer"
        data-field="x_FarmerOrgPosition"
        data-value-separator="<?= $Page->FarmerOrgPosition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmerOrgPosition->getPlaceHolder()) ?>"
        <?= $Page->FarmerOrgPosition->editAttributes() ?>>
        <?= $Page->FarmerOrgPosition->selectOptionListHtml("x_FarmerOrgPosition") ?>
    </select>
    <?= $Page->FarmerOrgPosition->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->FarmerOrgPosition->getErrorMessage() ?></div>
<?= $Page->FarmerOrgPosition->Lookup->getParamTag($Page, "p_x_FarmerOrgPosition") ?>
<?php if (!$Page->FarmerOrgPosition->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmeradd", function() {
    var options = { name: "x_FarmerOrgPosition", selectId: "ffarmeradd_x_FarmerOrgPosition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmeradd.lists.FarmerOrgPosition?.lookupOptions.length) {
        options.data = { id: "x_FarmerOrgPosition", form: "ffarmeradd" };
    } else {
        options.ajax = { id: "x_FarmerOrgPosition", form: "ffarmeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farmer.fields.FarmerOrgPosition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->JoiningDate->Visible) { // JoiningDate ?>
    <div id="r_JoiningDate"<?= $Page->JoiningDate->rowAttributes() ?>>
        <label id="elh_farmer_JoiningDate" for="x_JoiningDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->JoiningDate->caption() ?><?= $Page->JoiningDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->JoiningDate->cellAttributes() ?>>
<span id="el_farmer_JoiningDate">
<input type="<?= $Page->JoiningDate->getInputTextType() ?>" name="x_JoiningDate" id="x_JoiningDate" data-table="farmer" data-field="x_JoiningDate" value="<?= $Page->JoiningDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->JoiningDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->JoiningDate->formatPattern()) ?>"<?= $Page->JoiningDate->editAttributes() ?> aria-describedby="x_JoiningDate_help">
<?= $Page->JoiningDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->JoiningDate->getErrorMessage() ?></div>
<?php if (!$Page->JoiningDate->ReadOnly && !$Page->JoiningDate->Disabled && !isset($Page->JoiningDate->EditAttrs["readonly"]) && !isset($Page->JoiningDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffarmeradd", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffarmeradd", "x_JoiningDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
    <div id="r_Comments"<?= $Page->Comments->rowAttributes() ?>>
        <label id="elh_farmer_Comments" for="x_Comments" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Comments->caption() ?><?= $Page->Comments->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Comments->cellAttributes() ?>>
<span id="el_farmer_Comments">
<input type="<?= $Page->Comments->getInputTextType() ?>" name="x_Comments" id="x_Comments" data-table="farmer" data-field="x_Comments" value="<?= $Page->Comments->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Comments->formatPattern()) ?>"<?= $Page->Comments->editAttributes() ?> aria-describedby="x_Comments_help">
<?= $Page->Comments->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Comments->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { // AgeGroup ?>
    <div id="r_AgeGroup"<?= $Page->AgeGroup->rowAttributes() ?>>
        <label id="elh_farmer_AgeGroup" for="x_AgeGroup" class="<?= $Page->LeftColumnClass ?>"><?= $Page->AgeGroup->caption() ?><?= $Page->AgeGroup->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->AgeGroup->cellAttributes() ?>>
<span id="el_farmer_AgeGroup">
<input type="<?= $Page->AgeGroup->getInputTextType() ?>" name="x_AgeGroup" id="x_AgeGroup" data-table="farmer" data-field="x_AgeGroup" value="<?= $Page->AgeGroup->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->AgeGroup->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AgeGroup->formatPattern()) ?>"<?= $Page->AgeGroup->editAttributes() ?> aria-describedby="x_AgeGroup_help">
<?= $Page->AgeGroup->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->AgeGroup->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?php
    if (in_array("farm", explode(",", $Page->getCurrentDetailTable())) && $farm->DetailAdd) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("farm", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "FarmGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffarmeradd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarmeradd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farmer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
