<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmView2Search = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_view2: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffarm_view2search, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarm_view2search")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["Age", [], fields.Age.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["Province", [], fields.Province.isInvalid],
            ["District", [], fields.District.isInvalid],
            ["NumberOfFields", [ew.Validators.integer], fields.NumberOfFields.isInvalid],
            ["EstimatedTotalSize", [ew.Validators.float], fields.EstimatedTotalSize.isInvalid],
            ["VerifiedSize", [ew.Validators.float], fields.VerifiedSize.isInvalid],
            ["TreesPlantedEstimated", [ew.Validators.float], fields.TreesPlantedEstimated.isInvalid],
            ["TreesPlantedVerified", [ew.Validators.float], fields.TreesPlantedVerified.isInvalid],
            ["CampName", [], fields.CampName.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarm_view2search" id="ffarm_view2search" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm_view2">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->Age->Visible) { // Age ?>
    <div id="r_Age" class="row"<?= $Page->Age->rowAttributes() ?>>
        <label for="x_Age" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_Age"><?= $Page->Age->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Age" id="z_Age" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Age->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_Age" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x_Age" id="x_Age" data-table="farm_view2" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender" class="row"<?= $Page->Gender->rowAttributes() ?>>
        <label for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_Gender"><?= $Page->Gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Gender" id="z_Gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_Gender" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Gender->getInputTextType() ?>" name="x_Gender" id="x_Gender" data-table="farm_view2" data-field="x_Gender" value="<?= $Page->Gender->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Gender->formatPattern()) ?>"<?= $Page->Gender->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Province->Visible) { // Province ?>
    <div id="r_Province" class="row"<?= $Page->Province->rowAttributes() ?>>
        <label for="x_Province" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_Province"><?= $Page->Province->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Province" id="z_Province" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Province->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_Province" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Province->getInputTextType() ?>" name="x_Province" id="x_Province" data-table="farm_view2" data-field="x_Province" value="<?= $Page->Province->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->Province->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Province->formatPattern()) ?>"<?= $Page->Province->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Province->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->District->Visible) { // District ?>
    <div id="r_District" class="row"<?= $Page->District->rowAttributes() ?>>
        <label for="x_District" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_District"><?= $Page->District->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_District" id="z_District" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->District->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_District" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->District->getInputTextType() ?>" name="x_District" id="x_District" data-table="farm_view2" data-field="x_District" value="<?= $Page->District->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->District->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->District->formatPattern()) ?>"<?= $Page->District->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->District->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NumberOfFields->Visible) { // NumberOfFields ?>
    <div id="r_NumberOfFields" class="row"<?= $Page->NumberOfFields->rowAttributes() ?>>
        <label for="x_NumberOfFields" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_NumberOfFields"><?= $Page->NumberOfFields->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_NumberOfFields" id="z_NumberOfFields" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NumberOfFields->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_NumberOfFields" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NumberOfFields->getInputTextType() ?>" name="x_NumberOfFields" id="x_NumberOfFields" data-table="farm_view2" data-field="x_NumberOfFields" value="<?= $Page->NumberOfFields->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->NumberOfFields->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NumberOfFields->formatPattern()) ?>"<?= $Page->NumberOfFields->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NumberOfFields->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->EstimatedTotalSize->Visible) { // EstimatedTotalSize ?>
    <div id="r_EstimatedTotalSize" class="row"<?= $Page->EstimatedTotalSize->rowAttributes() ?>>
        <label for="x_EstimatedTotalSize" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_EstimatedTotalSize"><?= $Page->EstimatedTotalSize->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_EstimatedTotalSize" id="z_EstimatedTotalSize" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->EstimatedTotalSize->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_EstimatedTotalSize" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->EstimatedTotalSize->getInputTextType() ?>" name="x_EstimatedTotalSize" id="x_EstimatedTotalSize" data-table="farm_view2" data-field="x_EstimatedTotalSize" value="<?= $Page->EstimatedTotalSize->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->EstimatedTotalSize->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EstimatedTotalSize->formatPattern()) ?>"<?= $Page->EstimatedTotalSize->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EstimatedTotalSize->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->VerifiedSize->Visible) { // VerifiedSize ?>
    <div id="r_VerifiedSize" class="row"<?= $Page->VerifiedSize->rowAttributes() ?>>
        <label for="x_VerifiedSize" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_VerifiedSize"><?= $Page->VerifiedSize->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_VerifiedSize" id="z_VerifiedSize" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->VerifiedSize->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_VerifiedSize" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->VerifiedSize->getInputTextType() ?>" name="x_VerifiedSize" id="x_VerifiedSize" data-table="farm_view2" data-field="x_VerifiedSize" value="<?= $Page->VerifiedSize->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->VerifiedSize->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->VerifiedSize->formatPattern()) ?>"<?= $Page->VerifiedSize->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->VerifiedSize->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
    <div id="r_TreesPlantedEstimated" class="row"<?= $Page->TreesPlantedEstimated->rowAttributes() ?>>
        <label for="x_TreesPlantedEstimated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_TreesPlantedEstimated"><?= $Page->TreesPlantedEstimated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_TreesPlantedEstimated" id="z_TreesPlantedEstimated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_TreesPlantedEstimated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesPlantedEstimated->getInputTextType() ?>" name="x_TreesPlantedEstimated" id="x_TreesPlantedEstimated" data-table="farm_view2" data-field="x_TreesPlantedEstimated" value="<?= $Page->TreesPlantedEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedEstimated->formatPattern()) ?>"<?= $Page->TreesPlantedEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedEstimated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
    <div id="r_TreesPlantedVerified" class="row"<?= $Page->TreesPlantedVerified->rowAttributes() ?>>
        <label for="x_TreesPlantedVerified" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_TreesPlantedVerified"><?= $Page->TreesPlantedVerified->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_TreesPlantedVerified" id="z_TreesPlantedVerified" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_TreesPlantedVerified" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesPlantedVerified->getInputTextType() ?>" name="x_TreesPlantedVerified" id="x_TreesPlantedVerified" data-table="farm_view2" data-field="x_TreesPlantedVerified" value="<?= $Page->TreesPlantedVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedVerified->formatPattern()) ?>"<?= $Page->TreesPlantedVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedVerified->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CampName->Visible) { // CampName ?>
    <div id="r_CampName" class="row"<?= $Page->CampName->rowAttributes() ?>>
        <label for="x_CampName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_view2_CampName"><?= $Page->CampName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_CampName" id="z_CampName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CampName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_view2_CampName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->CampName->getInputTextType() ?>" name="x_CampName" id="x_CampName" data-table="farm_view2" data-field="x_CampName" value="<?= $Page->CampName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->CampName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->CampName->formatPattern()) ?>"<?= $Page->CampName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->CampName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffarm_view2search"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarm_view2search"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ffarm_view2search" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_view2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
