<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmSeedAllocateSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_seed_allocate: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffarm_seed_allocatesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarm_seed_allocatesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProvinceCode", [], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [], fields.DistrictCode.isInvalid],
            ["CampCode", [], fields.CampCode.isInvalid],
            ["VillageCode", [], fields.VillageCode.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["FarmerNo", [ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [ew.Validators.integer], fields.FarmNo.isInvalid],
            ["FarmingSeason", [], fields.FarmingSeason.isInvalid],
            ["TransNo", [ew.Validators.integer], fields.TransNo.isInvalid],
            ["SourcesOfSeedlings", [], fields.SourcesOfSeedlings.isInvalid],
            ["GRN", [], fields.GRN.isInvalid],
            ["TreesAllocated", [], fields.TreesAllocated.isInvalid],
            ["SeedType", [], fields.SeedType.isInvalid],
            ["TransDate", [ew.Validators.datetime(fields.TransDate.clientFormatPattern)], fields.TransDate.isInvalid],
            ["PreparedBy", [], fields.PreparedBy.isInvalid],
            ["AuthorisedBy", [], fields.AuthorisedBy.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FarmingSeason": <?= $Page->FarmingSeason->toClientList($Page) ?>,
            "SourcesOfSeedlings": <?= $Page->SourcesOfSeedlings->toClientList($Page) ?>,
            "GRN": <?= $Page->GRN->toClientList($Page) ?>,
            "SeedType": <?= $Page->SeedType->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarm_seed_allocatesearch" id="ffarm_seed_allocatesearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("FarmSeedAllocateList")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm_seed_allocate">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_farm_seed_allocate_ProvinceCode" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_ProvinceCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocatesearch_x_ProvinceCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarm_seed_allocatesearch_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocatesearch.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarm_seed_allocatesearch" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarm_seed_allocatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_seed_allocate_DistrictCode" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_DistrictCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocatesearch_x_DistrictCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarm_seed_allocatesearch_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocatesearch.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarm_seed_allocatesearch" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarm_seed_allocatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_seed_allocate_CampCode" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_CampCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocatesearch_x_CampCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    var options = { name: "x_CampCode", selectId: "ffarm_seed_allocatesearch_x_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocatesearch.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarm_seed_allocatesearch" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarm_seed_allocatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_seed_allocate_VillageCode" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_VillageCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-select ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        <?php if (!$Page->VillageCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocatesearch_x_VillageCode"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_VillageCode"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<?php if (!$Page->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    var options = { name: "x_VillageCode", selectId: "ffarm_seed_allocatesearch_x_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocatesearch.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarm_seed_allocatesearch" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarm_seed_allocatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_seed_allocate_NRC" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_NRC" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x_NRC" id="sv_x_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm_seed_allocate" data-field="x_NRC" data-input="sv_x_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x_NRC" id="x_NRC" value="<?= HtmlEncode($Page->NRC->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    ffarm_seed_allocatesearch.createAutoSuggest(Object.assign({"id":"x_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm_seed_allocate.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
</span></template>
<template id="tpx_farm_seed_allocate_FarmerNo" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_FarmerNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x_FarmerNo" id="x_FarmerNo" data-table="farm_seed_allocate" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_seed_allocate_FarmNo" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_FarmNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x_FarmNo" id="x_FarmNo" data-table="farm_seed_allocate" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_seed_allocate_FarmingSeason" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_FarmingSeason" class="ew-search-field ew-search-field-single">
    <select
        id="x_FarmingSeason"
        name="x_FarmingSeason"
        class="form-select ew-select<?= $Page->FarmingSeason->isInvalidClass() ?>"
        <?php if (!$Page->FarmingSeason->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocatesearch_x_FarmingSeason"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_FarmingSeason"
        data-value-separator="<?= $Page->FarmingSeason->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>"
        <?= $Page->FarmingSeason->editAttributes() ?>>
        <?= $Page->FarmingSeason->selectOptionListHtml("x_FarmingSeason") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage(false) ?></div>
<?= $Page->FarmingSeason->Lookup->getParamTag($Page, "p_x_FarmingSeason") ?>
<?php if (!$Page->FarmingSeason->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    var options = { name: "x_FarmingSeason", selectId: "ffarm_seed_allocatesearch_x_FarmingSeason" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocatesearch.lists.FarmingSeason?.lookupOptions.length) {
        options.data = { id: "x_FarmingSeason", form: "ffarm_seed_allocatesearch" };
    } else {
        options.ajax = { id: "x_FarmingSeason", form: "ffarm_seed_allocatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.FarmingSeason.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_seed_allocate_TransNo" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_TransNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TransNo->getInputTextType() ?>" name="x_TransNo" id="x_TransNo" data-table="farm_seed_allocate" data-field="x_TransNo" value="<?= $Page->TransNo->EditValue ?>" placeholder="<?= HtmlEncode($Page->TransNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TransNo->formatPattern()) ?>"<?= $Page->TransNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TransNo->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_seed_allocate_SourcesOfSeedlings" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_SourcesOfSeedlings" class="ew-search-field ew-search-field-single">
    <select
        id="x_SourcesOfSeedlings"
        name="x_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocatesearch_x_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage(false) ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    var options = { name: "x_SourcesOfSeedlings", selectId: "ffarm_seed_allocatesearch_x_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocatesearch.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x_SourcesOfSeedlings", form: "ffarm_seed_allocatesearch" };
    } else {
        options.ajax = { id: "x_SourcesOfSeedlings", form: "ffarm_seed_allocatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_seed_allocate_GRN" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_GRN" class="ew-search-field ew-search-field-single">
    <select
        id="x_GRN"
        name="x_GRN"
        class="form-control ew-select<?= $Page->GRN->isInvalidClass() ?>"
        data-select2-id="ffarm_seed_allocatesearch_x_GRN"
        data-table="farm_seed_allocate"
        data-field="x_GRN"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->GRN->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->GRN->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>"
        <?= $Page->GRN->editAttributes() ?>>
        <?= $Page->GRN->selectOptionListHtml("x_GRN") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->GRN->getErrorMessage(false) ?></div>
<?= $Page->GRN->Lookup->getParamTag($Page, "p_x_GRN") ?>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    var options = { name: "x_GRN", selectId: "ffarm_seed_allocatesearch_x_GRN" };
    if (ffarm_seed_allocatesearch.lists.GRN?.lookupOptions.length) {
        options.data = { id: "x_GRN", form: "ffarm_seed_allocatesearch" };
    } else {
        options.ajax = { id: "x_GRN", form: "ffarm_seed_allocatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm_seed_allocate.fields.GRN.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_farm_seed_allocate_TreesAllocated" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_TreesAllocated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesAllocated->getInputTextType() ?>" name="x_TreesAllocated" id="x_TreesAllocated" data-table="farm_seed_allocate" data-field="x_TreesAllocated" value="<?= $Page->TreesAllocated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesAllocated->formatPattern()) ?>"<?= $Page->TreesAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesAllocated->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_seed_allocate_SeedType" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_SeedType" class="ew-search-field ew-search-field-single">
    <select
        id="x_SeedType"
        name="x_SeedType"
        class="form-select ew-select<?= $Page->SeedType->isInvalidClass() ?>"
        <?php if (!$Page->SeedType->IsNativeSelect) { ?>
        data-select2-id="ffarm_seed_allocatesearch_x_SeedType"
        <?php } ?>
        data-table="farm_seed_allocate"
        data-field="x_SeedType"
        data-value-separator="<?= $Page->SeedType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>"
        <?= $Page->SeedType->editAttributes() ?>>
        <?= $Page->SeedType->selectOptionListHtml("x_SeedType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage(false) ?></div>
<?= $Page->SeedType->Lookup->getParamTag($Page, "p_x_SeedType") ?>
<?php if (!$Page->SeedType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_seed_allocatesearch", function() {
    var options = { name: "x_SeedType", selectId: "ffarm_seed_allocatesearch_x_SeedType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_seed_allocatesearch.lists.SeedType?.lookupOptions.length) {
        options.data = { id: "x_SeedType", form: "ffarm_seed_allocatesearch" };
    } else {
        options.ajax = { id: "x_SeedType", form: "ffarm_seed_allocatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_seed_allocate.fields.SeedType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_seed_allocate_TransDate" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_TransDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TransDate->getInputTextType() ?>" name="x_TransDate" id="x_TransDate" data-table="farm_seed_allocate" data-field="x_TransDate" value="<?= $Page->TransDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->TransDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TransDate->formatPattern()) ?>"<?= $Page->TransDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TransDate->getErrorMessage(false) ?></div>
<?php if (!$Page->TransDate->ReadOnly && !$Page->TransDate->Disabled && !isset($Page->TransDate->EditAttrs["readonly"]) && !isset($Page->TransDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffarm_seed_allocatesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffarm_seed_allocatesearch", "x_TransDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_seed_allocate_PreparedBy" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_PreparedBy" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PreparedBy->getInputTextType() ?>" name="x_PreparedBy" id="x_PreparedBy" data-table="farm_seed_allocate" data-field="x_PreparedBy" value="<?= $Page->PreparedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PreparedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PreparedBy->formatPattern()) ?>"<?= $Page->PreparedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PreparedBy->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_seed_allocate_AuthorisedBy" class="farm_seed_allocatesearch"><span id="el_farm_seed_allocate_AuthorisedBy" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AuthorisedBy->getInputTextType() ?>" name="x_AuthorisedBy" id="x_AuthorisedBy" data-table="farm_seed_allocate" data-field="x_AuthorisedBy" value="<?= $Page->AuthorisedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorisedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorisedBy->formatPattern()) ?>"<?= $Page->AuthorisedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AuthorisedBy->getErrorMessage(false) ?></div>
</span></template>
<div id="farm_seed_allocate_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "ProvinceCode",
                type: "integer",
                label: currentTable.fields.ProvinceCode.caption,
                operators: currentTable.fields.ProvinceCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.ProvinceCode.validators),
                data: {
                    format: currentTable.fields.ProvinceCode.clientFormatPattern
                }
            },
            {
                id: "DistrictCode",
                type: "integer",
                label: currentTable.fields.DistrictCode.caption,
                operators: currentTable.fields.DistrictCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.DistrictCode.validators),
                data: {
                    format: currentTable.fields.DistrictCode.clientFormatPattern
                }
            },
            {
                id: "CampCode",
                type: "integer",
                label: currentTable.fields.CampCode.caption,
                operators: currentTable.fields.CampCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.CampCode.validators),
                data: {
                    format: currentTable.fields.CampCode.clientFormatPattern
                }
            },
            {
                id: "VillageCode",
                type: "integer",
                label: currentTable.fields.VillageCode.caption,
                operators: currentTable.fields.VillageCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.VillageCode.validators),
                data: {
                    format: currentTable.fields.VillageCode.clientFormatPattern
                }
            },
            {
                id: "NRC",
                type: "string",
                label: currentTable.fields.NRC.caption,
                operators: currentTable.fields.NRC.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.NRC.validators),
                data: {
                    format: currentTable.fields.NRC.clientFormatPattern
                }
            },
            {
                id: "FarmerNo",
                type: "integer",
                label: currentTable.fields.FarmerNo.caption,
                operators: currentTable.fields.FarmerNo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.FarmerNo.validators),
                data: {
                    format: currentTable.fields.FarmerNo.clientFormatPattern
                }
            },
            {
                id: "FarmNo",
                type: "integer",
                label: currentTable.fields.FarmNo.caption,
                operators: currentTable.fields.FarmNo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.FarmNo.validators),
                data: {
                    format: currentTable.fields.FarmNo.clientFormatPattern
                }
            },
            {
                id: "FarmingSeason",
                type: "integer",
                label: currentTable.fields.FarmingSeason.caption,
                operators: currentTable.fields.FarmingSeason.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.FarmingSeason.validators),
                data: {
                    format: currentTable.fields.FarmingSeason.clientFormatPattern
                }
            },
            {
                id: "TransNo",
                type: "integer",
                label: currentTable.fields.TransNo.caption,
                operators: currentTable.fields.TransNo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.TransNo.validators),
                data: {
                    format: currentTable.fields.TransNo.clientFormatPattern
                }
            },
            {
                id: "SourcesOfSeedlings",
                type: "integer",
                label: currentTable.fields.SourcesOfSeedlings.caption,
                operators: currentTable.fields.SourcesOfSeedlings.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.SourcesOfSeedlings.validators),
                data: {
                    format: currentTable.fields.SourcesOfSeedlings.clientFormatPattern
                }
            },
            {
                id: "GRN",
                type: "string",
                label: currentTable.fields.GRN.caption,
                operators: currentTable.fields.GRN.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.GRN.validators),
                data: {
                    format: currentTable.fields.GRN.clientFormatPattern
                }
            },
            {
                id: "TreesAllocated",
                type: "integer",
                label: currentTable.fields.TreesAllocated.caption,
                operators: currentTable.fields.TreesAllocated.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.TreesAllocated.validators),
                data: {
                    format: currentTable.fields.TreesAllocated.clientFormatPattern
                }
            },
            {
                id: "SeedType",
                type: "string",
                label: currentTable.fields.SeedType.caption,
                operators: currentTable.fields.SeedType.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.SeedType.validators),
                data: {
                    format: currentTable.fields.SeedType.clientFormatPattern
                }
            },
            {
                id: "TransDate",
                type: "datetime",
                label: currentTable.fields.TransDate.caption,
                operators: currentTable.fields.TransDate.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.TransDate.validators),
                data: {
                    format: currentTable.fields.TransDate.clientFormatPattern
                }
            },
            {
                id: "PreparedBy",
                type: "string",
                label: currentTable.fields.PreparedBy.caption,
                operators: currentTable.fields.PreparedBy.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.PreparedBy.validators),
                data: {
                    format: currentTable.fields.PreparedBy.clientFormatPattern
                }
            },
            {
                id: "AuthorisedBy",
                type: "string",
                label: currentTable.fields.AuthorisedBy.caption,
                operators: currentTable.fields.AuthorisedBy.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarm_seed_allocatesearch.fields.AuthorisedBy.validators),
                data: {
                    format: currentTable.fields.AuthorisedBy.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#farm_seed_allocate_query_builder"),
        args = {},
        rules = ew.parseJson($("#ffarm_seed_allocatesearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#ffarm_seed_allocatesearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="ffarm_seed_allocatesearch" formaction="<?= HtmlEncode(GetUrl("FarmSeedAllocateList")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarm_seed_allocatesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="ffarm_seed_allocatesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_seed_allocate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
