<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffarmsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarmsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProvinceCode", [], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [], fields.DistrictCode.isInvalid],
            ["CampCode", [], fields.CampCode.isInvalid],
            ["VillageCode", [], fields.VillageCode.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["FarmNo", [ew.Validators.integer], fields.FarmNo.isInvalid],
            ["FieldType", [], fields.FieldType.isInvalid],
            ["Ownership", [], fields.Ownership.isInvalid],
            ["SeedlingsAllocated", [ew.Validators.float], fields.SeedlingsAllocated.isInvalid],
            ["TreesPlantedEstimated", [ew.Validators.float], fields.TreesPlantedEstimated.isInvalid],
            ["FarmSizeEstimated", [ew.Validators.float], fields.FarmSizeEstimated.isInvalid],
            ["FarmSizeVerified", [ew.Validators.float], fields.FarmSizeVerified.isInvalid],
            ["TreesPlantedVerified", [ew.Validators.float], fields.TreesPlantedVerified.isInvalid],
            ["SourcesOfSeedlings", [], fields.SourcesOfSeedlings.isInvalid],
            ["InspecationReport", [], fields.InspecationReport.isInvalid],
            ["ClearedLand", [], fields.ClearedLand.isInvalid],
            ["OldTrees", [], fields.OldTrees.isInvalid],
            ["FarmSize", [], fields.FarmSize.isInvalid],
            ["Latitude", [ew.Validators.float], fields.Latitude.isInvalid],
            ["Longitude", [ew.Validators.float], fields.Longitude.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FieldType": <?= $Page->FieldType->toClientList($Page) ?>,
            "Ownership": <?= $Page->Ownership->toClientList($Page) ?>,
            "SourcesOfSeedlings": <?= $Page->SourcesOfSeedlings->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarmsearch" id="ffarmsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("FarmList")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_farm_ProvinceCode" class="farmsearch"><span id="el_farm_ProvinceCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmsearch_x_ProvinceCode"
        <?php } ?>
        data-table="farm"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarmsearch_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmsearch.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_DistrictCode" class="farmsearch"><span id="el_farm_DistrictCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="ffarmsearch_x_DistrictCode"
        data-table="farm"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarmsearch_x_DistrictCode" };
    if (ffarmsearch.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_farm_CampCode" class="farmsearch"><span id="el_farm_CampCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmsearch_x_CampCode"
        data-table="farm"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_CampCode", selectId: "ffarmsearch_x_CampCode" };
    if (ffarmsearch.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_farm_VillageCode" class="farmsearch"><span id="el_farm_VillageCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmsearch_x_VillageCode"
        data-table="farm"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_VillageCode", selectId: "ffarmsearch_x_VillageCode" };
    if (ffarmsearch.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_farm_NRC" class="farmsearch"><span id="el_farm_NRC" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x_NRC" id="sv_x_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm" data-field="x_NRC" data-input="sv_x_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x_NRC" id="x_NRC" value="<?= HtmlEncode($Page->NRC->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffarmsearch", function() {
    ffarmsearch.createAutoSuggest(Object.assign({"id":"x_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
</span></template>
<template id="tpx_farm_FarmNo" class="farmsearch"><span id="el_farm_FarmNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x_FarmNo" id="x_FarmNo" data-table="farm" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_FieldType" class="farmsearch"><span id="el_farm_FieldType" class="ew-search-field ew-search-field-single">
    <select
        id="x_FieldType"
        name="x_FieldType"
        class="form-select ew-select<?= $Page->FieldType->isInvalidClass() ?>"
        <?php if (!$Page->FieldType->IsNativeSelect) { ?>
        data-select2-id="ffarmsearch_x_FieldType"
        <?php } ?>
        data-table="farm"
        data-field="x_FieldType"
        data-value-separator="<?= $Page->FieldType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>"
        <?= $Page->FieldType->editAttributes() ?>>
        <?= $Page->FieldType->selectOptionListHtml("x_FieldType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage(false) ?></div>
<?= $Page->FieldType->Lookup->getParamTag($Page, "p_x_FieldType") ?>
<?php if (!$Page->FieldType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_FieldType", selectId: "ffarmsearch_x_FieldType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmsearch.lists.FieldType?.lookupOptions.length) {
        options.data = { id: "x_FieldType", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_FieldType", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.FieldType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_Ownership" class="farmsearch"><span id="el_farm_Ownership" class="ew-search-field ew-search-field-single">
    <select
        id="x_Ownership"
        name="x_Ownership"
        class="form-select ew-select<?= $Page->Ownership->isInvalidClass() ?>"
        <?php if (!$Page->Ownership->IsNativeSelect) { ?>
        data-select2-id="ffarmsearch_x_Ownership"
        <?php } ?>
        data-table="farm"
        data-field="x_Ownership"
        data-value-separator="<?= $Page->Ownership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Ownership->getPlaceHolder()) ?>"
        <?= $Page->Ownership->editAttributes() ?>>
        <?= $Page->Ownership->selectOptionListHtml("x_Ownership") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Ownership->getErrorMessage(false) ?></div>
<?= $Page->Ownership->Lookup->getParamTag($Page, "p_x_Ownership") ?>
<?php if (!$Page->Ownership->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_Ownership", selectId: "ffarmsearch_x_Ownership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmsearch.lists.Ownership?.lookupOptions.length) {
        options.data = { id: "x_Ownership", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_Ownership", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.Ownership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_SeedlingsAllocated" class="farmsearch"><span id="el_farm_SeedlingsAllocated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedlingsAllocated->getInputTextType() ?>" name="x_SeedlingsAllocated" id="x_SeedlingsAllocated" data-table="farm" data-field="x_SeedlingsAllocated" value="<?= $Page->SeedlingsAllocated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsAllocated->formatPattern()) ?>"<?= $Page->SeedlingsAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsAllocated->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_TreesPlantedEstimated" class="farmsearch"><span id="el_farm_TreesPlantedEstimated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesPlantedEstimated->getInputTextType() ?>" name="x_TreesPlantedEstimated" id="x_TreesPlantedEstimated" data-table="farm" data-field="x_TreesPlantedEstimated" value="<?= $Page->TreesPlantedEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedEstimated->formatPattern()) ?>"<?= $Page->TreesPlantedEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedEstimated->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_FarmSizeEstimated" class="farmsearch"><span id="el_farm_FarmSizeEstimated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmSizeEstimated->getInputTextType() ?>" name="x_FarmSizeEstimated" id="x_FarmSizeEstimated" data-table="farm" data-field="x_FarmSizeEstimated" value="<?= $Page->FarmSizeEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmSizeEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSizeEstimated->formatPattern()) ?>"<?= $Page->FarmSizeEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmSizeEstimated->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_FarmSizeVerified" class="farmsearch"><span id="el_farm_FarmSizeVerified" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmSizeVerified->getInputTextType() ?>" name="x_FarmSizeVerified" id="x_FarmSizeVerified" data-table="farm" data-field="x_FarmSizeVerified" value="<?= $Page->FarmSizeVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmSizeVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSizeVerified->formatPattern()) ?>"<?= $Page->FarmSizeVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmSizeVerified->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_TreesPlantedVerified" class="farmsearch"><span id="el_farm_TreesPlantedVerified" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesPlantedVerified->getInputTextType() ?>" name="x_TreesPlantedVerified" id="x_TreesPlantedVerified" data-table="farm" data-field="x_TreesPlantedVerified" value="<?= $Page->TreesPlantedVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedVerified->formatPattern()) ?>"<?= $Page->TreesPlantedVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedVerified->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_SourcesOfSeedlings" class="farmsearch"><span id="el_farm_SourcesOfSeedlings" class="ew-search-field ew-search-field-single">
    <select
        id="x_SourcesOfSeedlings"
        name="x_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="ffarmsearch_x_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x_SourcesOfSeedlings") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage(false) ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmsearch", function() {
    var options = { name: "x_SourcesOfSeedlings", selectId: "ffarmsearch_x_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmsearch.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x_SourcesOfSeedlings", form: "ffarmsearch" };
    } else {
        options.ajax = { id: "x_SourcesOfSeedlings", form: "ffarmsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_farm_InspecationReport" class="farmsearch"><span id="el_farm_InspecationReport" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->InspecationReport->getInputTextType() ?>" name="x_InspecationReport" id="x_InspecationReport" data-table="farm" data-field="x_InspecationReport" value="<?= $Page->InspecationReport->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->InspecationReport->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InspecationReport->formatPattern()) ?>"<?= $Page->InspecationReport->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InspecationReport->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_ClearedLand" class="farmsearch"><span id="el_farm_ClearedLand" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ClearedLand->getInputTextType() ?>" name="x_ClearedLand" id="x_ClearedLand" data-table="farm" data-field="x_ClearedLand" value="<?= $Page->ClearedLand->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ClearedLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearedLand->formatPattern()) ?>"<?= $Page->ClearedLand->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ClearedLand->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_OldTrees" class="farmsearch"><span id="el_farm_OldTrees" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->OldTrees->getInputTextType() ?>" name="x_OldTrees" id="x_OldTrees" data-table="farm" data-field="x_OldTrees" value="<?= $Page->OldTrees->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->OldTrees->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OldTrees->formatPattern()) ?>"<?= $Page->OldTrees->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OldTrees->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_FarmSize" class="farmsearch"><span id="el_farm_FarmSize" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmSize->getInputTextType() ?>" name="x_FarmSize" id="x_FarmSize" data-table="farm" data-field="x_FarmSize" value="<?= $Page->FarmSize->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmSize->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSize->formatPattern()) ?>"<?= $Page->FarmSize->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmSize->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_Latitude" class="farmsearch"><span id="el_farm_Latitude" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Latitude->getInputTextType() ?>" name="x_Latitude" id="x_Latitude" data-table="farm" data-field="x_Latitude" value="<?= $Page->Latitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Latitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Latitude->formatPattern()) ?>"<?= $Page->Latitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Latitude->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_farm_Longitude" class="farmsearch"><span id="el_farm_Longitude" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Longitude->getInputTextType() ?>" name="x_Longitude" id="x_Longitude" data-table="farm" data-field="x_Longitude" value="<?= $Page->Longitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Longitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Longitude->formatPattern()) ?>"<?= $Page->Longitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Longitude->getErrorMessage(false) ?></div>
</span></template>
<div id="farm_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "ProvinceCode",
                type: "integer",
                label: currentTable.fields.ProvinceCode.caption,
                operators: currentTable.fields.ProvinceCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.ProvinceCode.validators),
                data: {
                    format: currentTable.fields.ProvinceCode.clientFormatPattern
                }
            },
            {
                id: "DistrictCode",
                type: "integer",
                label: currentTable.fields.DistrictCode.caption,
                operators: currentTable.fields.DistrictCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.DistrictCode.validators),
                data: {
                    format: currentTable.fields.DistrictCode.clientFormatPattern
                }
            },
            {
                id: "CampCode",
                type: "integer",
                label: currentTable.fields.CampCode.caption,
                operators: currentTable.fields.CampCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.CampCode.validators),
                data: {
                    format: currentTable.fields.CampCode.clientFormatPattern
                }
            },
            {
                id: "VillageCode",
                type: "integer",
                label: currentTable.fields.VillageCode.caption,
                operators: currentTable.fields.VillageCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.VillageCode.validators),
                data: {
                    format: currentTable.fields.VillageCode.clientFormatPattern
                }
            },
            {
                id: "NRC",
                type: "string",
                label: currentTable.fields.NRC.caption,
                operators: currentTable.fields.NRC.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.NRC.validators),
                data: {
                    format: currentTable.fields.NRC.clientFormatPattern
                }
            },
            {
                id: "FarmNo",
                type: "integer",
                label: currentTable.fields.FarmNo.caption,
                operators: currentTable.fields.FarmNo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.FarmNo.validators),
                data: {
                    format: currentTable.fields.FarmNo.clientFormatPattern
                }
            },
            {
                id: "FieldType",
                type: "integer",
                label: currentTable.fields.FieldType.caption,
                operators: currentTable.fields.FieldType.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.FieldType.validators),
                data: {
                    format: currentTable.fields.FieldType.clientFormatPattern
                }
            },
            {
                id: "Ownership",
                type: "integer",
                label: currentTable.fields.Ownership.caption,
                operators: currentTable.fields.Ownership.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.Ownership.validators),
                data: {
                    format: currentTable.fields.Ownership.clientFormatPattern
                }
            },
            {
                id: "SeedlingsAllocated",
                type: "double",
                label: currentTable.fields.SeedlingsAllocated.caption,
                operators: currentTable.fields.SeedlingsAllocated.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.SeedlingsAllocated.validators),
                data: {
                    format: currentTable.fields.SeedlingsAllocated.clientFormatPattern
                }
            },
            {
                id: "TreesPlantedEstimated",
                type: "double",
                label: currentTable.fields.TreesPlantedEstimated.caption,
                operators: currentTable.fields.TreesPlantedEstimated.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.TreesPlantedEstimated.validators),
                data: {
                    format: currentTable.fields.TreesPlantedEstimated.clientFormatPattern
                }
            },
            {
                id: "FarmSizeEstimated",
                type: "double",
                label: currentTable.fields.FarmSizeEstimated.caption,
                operators: currentTable.fields.FarmSizeEstimated.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.FarmSizeEstimated.validators),
                data: {
                    format: currentTable.fields.FarmSizeEstimated.clientFormatPattern
                }
            },
            {
                id: "FarmSizeVerified",
                type: "double",
                label: currentTable.fields.FarmSizeVerified.caption,
                operators: currentTable.fields.FarmSizeVerified.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.FarmSizeVerified.validators),
                data: {
                    format: currentTable.fields.FarmSizeVerified.clientFormatPattern
                }
            },
            {
                id: "TreesPlantedVerified",
                type: "double",
                label: currentTable.fields.TreesPlantedVerified.caption,
                operators: currentTable.fields.TreesPlantedVerified.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.TreesPlantedVerified.validators),
                data: {
                    format: currentTable.fields.TreesPlantedVerified.clientFormatPattern
                }
            },
            {
                id: "SourcesOfSeedlings",
                type: "integer",
                label: currentTable.fields.SourcesOfSeedlings.caption,
                operators: currentTable.fields.SourcesOfSeedlings.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.SourcesOfSeedlings.validators),
                data: {
                    format: currentTable.fields.SourcesOfSeedlings.clientFormatPattern
                }
            },
            {
                id: "InspecationReport",
                type: "string",
                label: currentTable.fields.InspecationReport.caption,
                operators: currentTable.fields.InspecationReport.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.InspecationReport.validators),
                data: {
                    format: currentTable.fields.InspecationReport.clientFormatPattern
                }
            },
            {
                id: "ClearedLand",
                type: "string",
                label: currentTable.fields.ClearedLand.caption,
                operators: currentTable.fields.ClearedLand.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.ClearedLand.validators),
                data: {
                    format: currentTable.fields.ClearedLand.clientFormatPattern
                }
            },
            {
                id: "OldTrees",
                type: "string",
                label: currentTable.fields.OldTrees.caption,
                operators: currentTable.fields.OldTrees.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.OldTrees.validators),
                data: {
                    format: currentTable.fields.OldTrees.clientFormatPattern
                }
            },
            {
                id: "FarmSize",
                type: "string",
                label: currentTable.fields.FarmSize.caption,
                operators: currentTable.fields.FarmSize.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.FarmSize.validators),
                data: {
                    format: currentTable.fields.FarmSize.clientFormatPattern
                }
            },
            {
                id: "Latitude",
                type: "double",
                label: currentTable.fields.Latitude.caption,
                operators: currentTable.fields.Latitude.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.Latitude.validators),
                data: {
                    format: currentTable.fields.Latitude.clientFormatPattern
                }
            },
            {
                id: "Longitude",
                type: "double",
                label: currentTable.fields.Longitude.caption,
                operators: currentTable.fields.Longitude.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffarmsearch.fields.Longitude.validators),
                data: {
                    format: currentTable.fields.Longitude.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#farm_query_builder"),
        args = {},
        rules = ew.parseJson($("#ffarmsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#ffarmsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="ffarmsearch" formaction="<?= HtmlEncode(GetUrl("FarmList")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarmsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="ffarmsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
