<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FieldType", [fields.FieldType.visible && fields.FieldType.required ? ew.Validators.required(fields.FieldType.caption) : null], fields.FieldType.isInvalid],
            ["Ownership", [fields.Ownership.visible && fields.Ownership.required ? ew.Validators.required(fields.Ownership.caption) : null], fields.Ownership.isInvalid],
            ["SeedlingsAllocated", [fields.SeedlingsAllocated.visible && fields.SeedlingsAllocated.required ? ew.Validators.required(fields.SeedlingsAllocated.caption) : null], fields.SeedlingsAllocated.isInvalid],
            ["TreesPlantedEstimated", [fields.TreesPlantedEstimated.visible && fields.TreesPlantedEstimated.required ? ew.Validators.required(fields.TreesPlantedEstimated.caption) : null, ew.Validators.float], fields.TreesPlantedEstimated.isInvalid],
            ["TreesPlantedVerified", [fields.TreesPlantedVerified.visible && fields.TreesPlantedVerified.required ? ew.Validators.required(fields.TreesPlantedVerified.caption) : null, ew.Validators.float], fields.TreesPlantedVerified.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FieldType",false],["Ownership",false],["SeedlingsAllocated",false],["TreesPlantedEstimated",false],["TreesPlantedVerified",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FieldType": <?= $Page->FieldType->toClientList($Page) ?>,
            "Ownership": <?= $Page->Ownership->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.14.0", "preview");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "farmer") {
    if ($Page->MasterRecordExists) {
        include_once "views/FarmerMaster.php";
    }
}
?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "village") {
    if ($Page->MasterRecordExists) {
        include_once "views/VillageMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffarmsrch" id="ffarmsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="ffarmsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm: currentTable } });
var currentForm;
var ffarmsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarmsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FarmNo": <?= $Page->FarmNo->toClientList($Page) ?>,
            "FarmerNo": <?= $Page->FarmerNo->toClientList($Page) ?>,
            "Ownership": <?= $Page->Ownership->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
<?php
if (!$Page->ProvinceCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ProvinceCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ProvinceCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ProvinceCode"
            name="x_ProvinceCode[]"
            class="form-control ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
            data-select2-id="ffarmsrch_x_ProvinceCode"
            data-table="farm"
            data-field="x_ProvinceCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ProvinceCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ProvinceCode->editAttributes() ?>>
            <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmsrch", function() {
            var options = {
                name: "x_ProvinceCode",
                selectId: "ffarmsrch_x_ProvinceCode",
                ajax: { id: "x_ProvinceCode", form: "ffarmsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farm.fields.ProvinceCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
<?php
if (!$Page->DistrictCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictCode"
            name="x_DistrictCode[]"
            class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
            data-select2-id="ffarmsrch_x_DistrictCode"
            data-table="farm"
            data-field="x_DistrictCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictCode->editAttributes() ?>>
            <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmsrch", function() {
            var options = {
                name: "x_DistrictCode",
                selectId: "ffarmsrch_x_DistrictCode",
                ajax: { id: "x_DistrictCode", form: "ffarmsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farm.fields.DistrictCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
<?php
if (!$Page->CampCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_CampCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->CampCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_CampCode"
            name="x_CampCode[]"
            class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
            data-select2-id="ffarmsrch_x_CampCode"
            data-table="farm"
            data-field="x_CampCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->CampCode->editAttributes() ?>>
            <?= $Page->CampCode->selectOptionListHtml("x_CampCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmsrch", function() {
            var options = {
                name: "x_CampCode",
                selectId: "ffarmsrch_x_CampCode",
                ajax: { id: "x_CampCode", form: "ffarmsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farm.fields.CampCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
<?php
if (!$Page->VillageCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_VillageCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->VillageCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_VillageCode"
            name="x_VillageCode[]"
            class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
            data-select2-id="ffarmsrch_x_VillageCode"
            data-table="farm"
            data-field="x_VillageCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->VillageCode->editAttributes() ?>>
            <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmsrch", function() {
            var options = {
                name: "x_VillageCode",
                selectId: "ffarmsrch_x_VillageCode",
                ajax: { id: "x_VillageCode", form: "ffarmsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farm.fields.VillageCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
<?php
if (!$Page->NRC->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_NRC" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->NRC->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_NRC"
            name="x_NRC[]"
            class="form-control ew-select<?= $Page->NRC->isInvalidClass() ?>"
            data-select2-id="ffarmsrch_x_NRC"
            data-table="farm"
            data-field="x_NRC"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->NRC->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->NRC->editAttributes() ?>>
            <?= $Page->NRC->selectOptionListHtml("x_NRC", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmsrch", function() {
            var options = {
                name: "x_NRC",
                selectId: "ffarmsrch_x_NRC",
                ajax: { id: "x_NRC", form: "ffarmsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farm.fields.NRC.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
<?php
if (!$Page->FarmNo->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmNo" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmNo->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmNo"
            name="x_FarmNo[]"
            class="form-control ew-select<?= $Page->FarmNo->isInvalidClass() ?>"
            data-select2-id="ffarmsrch_x_FarmNo"
            data-table="farm"
            data-field="x_FarmNo"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmNo->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmNo->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmNo->editAttributes() ?>>
            <?= $Page->FarmNo->selectOptionListHtml("x_FarmNo", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmsrch", function() {
            var options = {
                name: "x_FarmNo",
                selectId: "ffarmsrch_x_FarmNo",
                ajax: { id: "x_FarmNo", form: "ffarmsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farm.fields.FarmNo.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
<?php
if (!$Page->FarmerNo->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmerNo" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmerNo->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmerNo"
            name="x_FarmerNo[]"
            class="form-control ew-select<?= $Page->FarmerNo->isInvalidClass() ?>"
            data-select2-id="ffarmsrch_x_FarmerNo"
            data-table="farm"
            data-field="x_FarmerNo"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerNo->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmerNo->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmerNo->editAttributes() ?>>
            <?= $Page->FarmerNo->selectOptionListHtml("x_FarmerNo", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmsrch", function() {
            var options = {
                name: "x_FarmerNo",
                selectId: "ffarmsrch_x_FarmerNo",
                ajax: { id: "x_FarmerNo", form: "ffarmsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farm.fields.FarmerNo.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Ownership->Visible) { // Ownership ?>
<?php
if (!$Page->Ownership->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Ownership" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Ownership->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Ownership"
            name="x_Ownership[]"
            class="form-control ew-select<?= $Page->Ownership->isInvalidClass() ?>"
            data-select2-id="ffarmsrch_x_Ownership"
            data-table="farm"
            data-field="x_Ownership"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Ownership->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Ownership->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Ownership->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Ownership->editAttributes() ?>>
            <?= $Page->Ownership->selectOptionListHtml("x_Ownership", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Ownership->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffarmsrch", function() {
            var options = {
                name: "x_Ownership",
                selectId: "ffarmsrch_x_Ownership",
                ajax: { id: "x_Ownership", form: "ffarmsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.farm.fields.Ownership.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffarmsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffarmsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffarmsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffarmsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "farmer" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="farmer">
<input type="hidden" name="fk_NRC" value="<?= HtmlEncode($Page->NRC->getSessionValue()) ?>">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "village" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="village">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<input type="hidden" name="fk_VillageCode" value="<?= HtmlEncode($Page->VillageCode->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_farm" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_farmlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div id="elh_farm_ProvinceCode" class="farm_ProvinceCode"><?= $Page->renderFieldHeader($Page->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_farm_DistrictCode" class="farm_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_farm_CampCode" class="farm_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_farm_VillageCode" class="farm_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_farm_NRC" class="farm_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
        <th data-name="FieldType" class="<?= $Page->FieldType->headerCellClass() ?>"><div id="elh_farm_FieldType" class="farm_FieldType"><?= $Page->renderFieldHeader($Page->FieldType) ?></div></th>
<?php } ?>
<?php if ($Page->Ownership->Visible) { // Ownership ?>
        <th data-name="Ownership" class="<?= $Page->Ownership->headerCellClass() ?>"><div id="elh_farm_Ownership" class="farm_Ownership"><?= $Page->renderFieldHeader($Page->Ownership) ?></div></th>
<?php } ?>
<?php if ($Page->SeedlingsAllocated->Visible) { // SeedlingsAllocated ?>
        <th data-name="SeedlingsAllocated" class="<?= $Page->SeedlingsAllocated->headerCellClass() ?>"><div id="elh_farm_SeedlingsAllocated" class="farm_SeedlingsAllocated"><?= $Page->renderFieldHeader($Page->SeedlingsAllocated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <th data-name="TreesPlantedEstimated" class="<?= $Page->TreesPlantedEstimated->headerCellClass() ?>"><div id="elh_farm_TreesPlantedEstimated" class="farm_TreesPlantedEstimated"><?= $Page->renderFieldHeader($Page->TreesPlantedEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <th data-name="TreesPlantedVerified" class="<?= $Page->TreesPlantedVerified->headerCellClass() ?>"><div id="elh_farm_TreesPlantedVerified" class="farm_TreesPlantedVerified"><?= $Page->renderFieldHeader($Page->TreesPlantedVerified) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_ProvinceCode" name="x<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_ProvinceCode" class="el_farm_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ProvinceCode" id="o<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_ProvinceCode" name="x<?= $Page->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_ProvinceCode" class="el_farm_ProvinceCode">
    <select
        id="x<?= $Page->RowIndex ?>_ProvinceCode"
        name="x<?= $Page->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x{$Page->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_ProvinceCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_ProvinceCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_ProvinceCode" class="el_farm_ProvinceCode">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_DistrictCode" name="x<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_DistrictCode" class="el_farm_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        data-table="farm"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" };
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DistrictCode" id="o<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_DistrictCode" name="x<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_DistrictCode" class="el_farm_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        data-table="farm"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" };
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_DistrictCode" class="el_farm_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_CampCode" name="x<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_CampCode" class="el_farm_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        data-table="farm"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" };
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_CampCode" id="o<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_CampCode" name="x<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_CampCode" class="el_farm_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        data-table="farm"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" };
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_CampCode" class="el_farm_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_VillageCode" name="x<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_VillageCode" class="el_farm_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        data-table="farm"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" };
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_VillageCode" id="o<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_VillageCode" name="x<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_VillageCode" class="el_farm_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        data-table="farm"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" };
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_VillageCode" class="el_farm_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->NRC->getSessionValue() != "") { ?>
<span<?= $Page->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->NRC->getDisplayValue($Page->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_NRC" name="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_NRC" class="el_farm_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_NRC" id="sv_x<?= $Page->RowIndex ?>_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm" data-field="x_NRC" data-input="sv_x<?= $Page->RowIndex ?>_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->NRC->getSessionValue() != "") { ?>
<span<?= $Page->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->NRC->getDisplayValue($Page->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_NRC" name="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_NRC" class="el_farm_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_NRC" id="sv_x<?= $Page->RowIndex ?>_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="farm" data-field="x_NRC" data-input="sv_x<?= $Page->RowIndex ?>_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_NRC") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_NRC" class="el_farm_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FieldType->Visible) { // FieldType ?>
        <td data-name="FieldType"<?= $Page->FieldType->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_FieldType" class="el_farm_FieldType">
    <select
        id="x<?= $Page->RowIndex ?>_FieldType"
        name="x<?= $Page->RowIndex ?>_FieldType"
        class="form-select ew-select<?= $Page->FieldType->isInvalidClass() ?>"
        <?php if (!$Page->FieldType->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FieldType"
        <?php } ?>
        data-table="farm"
        data-field="x_FieldType"
        data-value-separator="<?= $Page->FieldType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>"
        <?= $Page->FieldType->editAttributes() ?>>
        <?= $Page->FieldType->selectOptionListHtml("x{$Page->RowIndex}_FieldType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage() ?></div>
<?= $Page->FieldType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FieldType") ?>
<?php if (!$Page->FieldType->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FieldType", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FieldType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.FieldType?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FieldType", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FieldType", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.FieldType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm" data-field="x_FieldType" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FieldType" id="o<?= $Page->RowIndex ?>_FieldType" value="<?= HtmlEncode($Page->FieldType->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_FieldType" class="el_farm_FieldType">
    <select
        id="x<?= $Page->RowIndex ?>_FieldType"
        name="x<?= $Page->RowIndex ?>_FieldType"
        class="form-select ew-select<?= $Page->FieldType->isInvalidClass() ?>"
        <?php if (!$Page->FieldType->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FieldType"
        <?php } ?>
        data-table="farm"
        data-field="x_FieldType"
        data-value-separator="<?= $Page->FieldType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>"
        <?= $Page->FieldType->editAttributes() ?>>
        <?= $Page->FieldType->selectOptionListHtml("x{$Page->RowIndex}_FieldType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage() ?></div>
<?= $Page->FieldType->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_FieldType") ?>
<?php if (!$Page->FieldType->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_FieldType", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_FieldType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.FieldType?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_FieldType", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_FieldType", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.FieldType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_FieldType" class="el_farm_FieldType">
<span<?= $Page->FieldType->viewAttributes() ?>>
<?= $Page->FieldType->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Ownership->Visible) { // Ownership ?>
        <td data-name="Ownership"<?= $Page->Ownership->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_Ownership" class="el_farm_Ownership">
    <select
        id="x<?= $Page->RowIndex ?>_Ownership"
        name="x<?= $Page->RowIndex ?>_Ownership"
        class="form-select ew-select<?= $Page->Ownership->isInvalidClass() ?>"
        <?php if (!$Page->Ownership->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Ownership"
        <?php } ?>
        data-table="farm"
        data-field="x_Ownership"
        data-value-separator="<?= $Page->Ownership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Ownership->getPlaceHolder()) ?>"
        <?= $Page->Ownership->editAttributes() ?>>
        <?= $Page->Ownership->selectOptionListHtml("x{$Page->RowIndex}_Ownership") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Ownership->getErrorMessage() ?></div>
<?= $Page->Ownership->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Ownership") ?>
<?php if (!$Page->Ownership->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Ownership", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Ownership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Ownership?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Ownership", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Ownership", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.Ownership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="farm" data-field="x_Ownership" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Ownership" id="o<?= $Page->RowIndex ?>_Ownership" value="<?= HtmlEncode($Page->Ownership->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_Ownership" class="el_farm_Ownership">
    <select
        id="x<?= $Page->RowIndex ?>_Ownership"
        name="x<?= $Page->RowIndex ?>_Ownership"
        class="form-select ew-select<?= $Page->Ownership->isInvalidClass() ?>"
        <?php if (!$Page->Ownership->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Ownership"
        <?php } ?>
        data-table="farm"
        data-field="x_Ownership"
        data-value-separator="<?= $Page->Ownership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Ownership->getPlaceHolder()) ?>"
        <?= $Page->Ownership->editAttributes() ?>>
        <?= $Page->Ownership->selectOptionListHtml("x{$Page->RowIndex}_Ownership") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Ownership->getErrorMessage() ?></div>
<?= $Page->Ownership->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Ownership") ?>
<?php if (!$Page->Ownership->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Ownership", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Ownership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Ownership?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Ownership", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Ownership", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.Ownership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_Ownership" class="el_farm_Ownership">
<span<?= $Page->Ownership->viewAttributes() ?>>
<?= $Page->Ownership->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->SeedlingsAllocated->Visible) { // SeedlingsAllocated ?>
        <td data-name="SeedlingsAllocated"<?= $Page->SeedlingsAllocated->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_SeedlingsAllocated" class="el_farm_SeedlingsAllocated">
<input type="<?= $Page->SeedlingsAllocated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_SeedlingsAllocated" id="x<?= $Page->RowIndex ?>_SeedlingsAllocated" data-table="farm" data-field="x_SeedlingsAllocated" value="<?= $Page->SeedlingsAllocated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->SeedlingsAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedlingsAllocated->formatPattern()) ?>"<?= $Page->SeedlingsAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedlingsAllocated->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm" data-field="x_SeedlingsAllocated" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SeedlingsAllocated" id="o<?= $Page->RowIndex ?>_SeedlingsAllocated" value="<?= HtmlEncode($Page->SeedlingsAllocated->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_SeedlingsAllocated" class="el_farm_SeedlingsAllocated">
<span<?= $Page->SeedlingsAllocated->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->SeedlingsAllocated->getDisplayValue($Page->SeedlingsAllocated->EditValue))) ?>"></span>
<input type="hidden" data-table="farm" data-field="x_SeedlingsAllocated" data-hidden="1" name="x<?= $Page->RowIndex ?>_SeedlingsAllocated" id="x<?= $Page->RowIndex ?>_SeedlingsAllocated" value="<?= HtmlEncode($Page->SeedlingsAllocated->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_SeedlingsAllocated" class="el_farm_SeedlingsAllocated">
<span<?= $Page->SeedlingsAllocated->viewAttributes() ?>>
<?= $Page->SeedlingsAllocated->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <td data-name="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_TreesPlantedEstimated" class="el_farm_TreesPlantedEstimated">
<input type="<?= $Page->TreesPlantedEstimated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TreesPlantedEstimated" id="x<?= $Page->RowIndex ?>_TreesPlantedEstimated" data-table="farm" data-field="x_TreesPlantedEstimated" value="<?= $Page->TreesPlantedEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedEstimated->formatPattern()) ?>"<?= $Page->TreesPlantedEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedEstimated->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm" data-field="x_TreesPlantedEstimated" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TreesPlantedEstimated" id="o<?= $Page->RowIndex ?>_TreesPlantedEstimated" value="<?= HtmlEncode($Page->TreesPlantedEstimated->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_TreesPlantedEstimated" class="el_farm_TreesPlantedEstimated">
<input type="<?= $Page->TreesPlantedEstimated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TreesPlantedEstimated" id="x<?= $Page->RowIndex ?>_TreesPlantedEstimated" data-table="farm" data-field="x_TreesPlantedEstimated" value="<?= $Page->TreesPlantedEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedEstimated->formatPattern()) ?>"<?= $Page->TreesPlantedEstimated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedEstimated->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_TreesPlantedEstimated" class="el_farm_TreesPlantedEstimated">
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <td data-name="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_TreesPlantedVerified" class="el_farm_TreesPlantedVerified">
<input type="<?= $Page->TreesPlantedVerified->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TreesPlantedVerified" id="x<?= $Page->RowIndex ?>_TreesPlantedVerified" data-table="farm" data-field="x_TreesPlantedVerified" value="<?= $Page->TreesPlantedVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedVerified->formatPattern()) ?>"<?= $Page->TreesPlantedVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedVerified->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm" data-field="x_TreesPlantedVerified" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_TreesPlantedVerified" id="o<?= $Page->RowIndex ?>_TreesPlantedVerified" value="<?= HtmlEncode($Page->TreesPlantedVerified->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_TreesPlantedVerified" class="el_farm_TreesPlantedVerified">
<input type="<?= $Page->TreesPlantedVerified->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_TreesPlantedVerified" id="x<?= $Page->RowIndex ?>_TreesPlantedVerified" data-table="farm" data-field="x_TreesPlantedVerified" value="<?= $Page->TreesPlantedVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedVerified->formatPattern()) ?>"<?= $Page->TreesPlantedVerified->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesPlantedVerified->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_farm_TreesPlantedVerified" class="el_farm_TreesPlantedVerified">
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
