<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmInspectionSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_inspection: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffarm_inspectionsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffarm_inspectionsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProvinceCode", [], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [], fields.DistrictCode.isInvalid],
            ["CampCode", [], fields.CampCode.isInvalid],
            ["VillageCode", [], fields.VillageCode.isInvalid],
            ["NRC", [], fields.NRC.isInvalid],
            ["FarmerNo", [ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [ew.Validators.integer], fields.FarmNo.isInvalid],
            ["InspectionTransNo", [ew.Validators.integer], fields.InspectionTransNo.isInvalid],
            ["PlantsDead", [ew.Validators.integer], fields.PlantsDead.isInvalid],
            ["PlantsVerifiedNo", [ew.Validators.integer], fields.PlantsVerifiedNo.isInvalid],
            ["PlantsReplaced", [ew.Validators.integer], fields.PlantsReplaced.isInvalid],
            ["FungicidesReceived", [ew.Validators.float], fields.FungicidesReceived.isInvalid],
            ["PescticidesReceived", [ew.Validators.float], fields.PescticidesReceived.isInvalid],
            ["DiseasePresence", [], fields.DiseasePresence.isInvalid],
            ["AvailableLand", [ew.Validators.float], fields.AvailableLand.isInvalid],
            ["LandForCashewCleared", [ew.Validators.float], fields.LandForCashewCleared.isInvalid],
            ["HolesDug", [ew.Validators.integer], fields.HolesDug.isInvalid],
            ["VerifiedSeedlingArea", [ew.Validators.float], fields.VerifiedSeedlingArea.isInvalid],
            ["OldTreesNo", [ew.Validators.integer], fields.OldTreesNo.isInvalid],
            ["InspectionReport", [], fields.InspectionReport.isInvalid],
            ["InspectionDate", [ew.Validators.datetime(fields.InspectionDate.clientFormatPattern)], fields.InspectionDate.isInvalid],
            ["InspectedBy", [], fields.InspectedBy.isInvalid],
            ["AuthorisedBy", [], fields.AuthorisedBy.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "DiseasePresence": <?= $Page->DiseasePresence->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarm_inspectionsearch" id="ffarm_inspectionsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm_inspection">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode" class="row"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProvinceCode" id="z_ProvinceCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProvinceCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_ProvinceCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionsearch_x_ProvinceCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage(false) ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionsearch", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarm_inspectionsearch_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionsearch.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarm_inspectionsearch" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarm_inspectionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode" class="row"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_DistrictCode"><?= $Page->DistrictCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DistrictCode" id="z_DistrictCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_DistrictCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionsearch_x_DistrictCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionsearch", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarm_inspectionsearch_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionsearch.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarm_inspectionsearch" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarm_inspectionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode" class="row"<?= $Page->CampCode->rowAttributes() ?>>
        <label for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_CampCode"><?= $Page->CampCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_CampCode" id="z_CampCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CampCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_CampCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionsearch_x_CampCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage(false) ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionsearch", function() {
    var options = { name: "x_CampCode", selectId: "ffarm_inspectionsearch_x_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionsearch.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarm_inspectionsearch" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarm_inspectionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode" class="row"<?= $Page->VillageCode->rowAttributes() ?>>
        <label for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_VillageCode"><?= $Page->VillageCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_VillageCode" id="z_VillageCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->VillageCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_VillageCode" class="ew-search-field ew-search-field-single">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-select ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        <?php if (!$Page->VillageCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionsearch_x_VillageCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_VillageCode"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage(false) ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<?php if (!$Page->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionsearch", function() {
    var options = { name: "x_VillageCode", selectId: "ffarm_inspectionsearch_x_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionsearch.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarm_inspectionsearch" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarm_inspectionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC" class="row"<?= $Page->NRC->rowAttributes() ?>>
        <label for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_NRC"><?= $Page->NRC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NRC" id="z_NRC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NRC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_NRC" class="ew-search-field ew-search-field-single">
    <select
        id="x_NRC"
        name="x_NRC"
        class="form-select ew-select<?= $Page->NRC->isInvalidClass() ?>"
        <?php if (!$Page->NRC->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionsearch_x_NRC"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_NRC"
        data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
        <?= $Page->NRC->editAttributes() ?>>
        <?= $Page->NRC->selectOptionListHtml("x_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage(false) ?></div>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
<?php if (!$Page->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionsearch", function() {
    var options = { name: "x_NRC", selectId: "ffarm_inspectionsearch_x_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionsearch.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x_NRC", form: "ffarm_inspectionsearch" };
    } else {
        options.ajax = { id: "x_NRC", form: "ffarm_inspectionsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
    <div id="r_FarmerNo" class="row"<?= $Page->FarmerNo->rowAttributes() ?>>
        <label for="x_FarmerNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_FarmerNo"><?= $Page->FarmerNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmerNo" id="z_FarmerNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmerNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_FarmerNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x_FarmerNo" id="x_FarmerNo" data-table="farm_inspection" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
    <div id="r_FarmNo" class="row"<?= $Page->FarmNo->rowAttributes() ?>>
        <label for="x_FarmNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_FarmNo"><?= $Page->FarmNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmNo" id="z_FarmNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_FarmNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x_FarmNo" id="x_FarmNo" data-table="farm_inspection" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->InspectionTransNo->Visible) { // InspectionTransNo ?>
    <div id="r_InspectionTransNo" class="row"<?= $Page->InspectionTransNo->rowAttributes() ?>>
        <label for="x_InspectionTransNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_InspectionTransNo"><?= $Page->InspectionTransNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_InspectionTransNo" id="z_InspectionTransNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->InspectionTransNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_InspectionTransNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->InspectionTransNo->getInputTextType() ?>" name="x_InspectionTransNo" id="x_InspectionTransNo" data-table="farm_inspection" data-field="x_InspectionTransNo" value="<?= $Page->InspectionTransNo->EditValue ?>" placeholder="<?= HtmlEncode($Page->InspectionTransNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InspectionTransNo->formatPattern()) ?>"<?= $Page->InspectionTransNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InspectionTransNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlantsDead->Visible) { // PlantsDead ?>
    <div id="r_PlantsDead" class="row"<?= $Page->PlantsDead->rowAttributes() ?>>
        <label for="x_PlantsDead" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_PlantsDead"><?= $Page->PlantsDead->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_PlantsDead" id="z_PlantsDead" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlantsDead->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_PlantsDead" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PlantsDead->getInputTextType() ?>" name="x_PlantsDead" id="x_PlantsDead" data-table="farm_inspection" data-field="x_PlantsDead" value="<?= $Page->PlantsDead->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsDead->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsDead->formatPattern()) ?>"<?= $Page->PlantsDead->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsDead->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlantsVerifiedNo->Visible) { // PlantsVerifiedNo ?>
    <div id="r_PlantsVerifiedNo" class="row"<?= $Page->PlantsVerifiedNo->rowAttributes() ?>>
        <label for="x_PlantsVerifiedNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_PlantsVerifiedNo"><?= $Page->PlantsVerifiedNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_PlantsVerifiedNo" id="z_PlantsVerifiedNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlantsVerifiedNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_PlantsVerifiedNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PlantsVerifiedNo->getInputTextType() ?>" name="x_PlantsVerifiedNo" id="x_PlantsVerifiedNo" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" value="<?= $Page->PlantsVerifiedNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsVerifiedNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsVerifiedNo->formatPattern()) ?>"<?= $Page->PlantsVerifiedNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsVerifiedNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { // PlantsReplaced ?>
    <div id="r_PlantsReplaced" class="row"<?= $Page->PlantsReplaced->rowAttributes() ?>>
        <label for="x_PlantsReplaced" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_PlantsReplaced"><?= $Page->PlantsReplaced->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_PlantsReplaced" id="z_PlantsReplaced" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlantsReplaced->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_PlantsReplaced" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PlantsReplaced->getInputTextType() ?>" name="x_PlantsReplaced" id="x_PlantsReplaced" data-table="farm_inspection" data-field="x_PlantsReplaced" value="<?= $Page->PlantsReplaced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsReplaced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsReplaced->formatPattern()) ?>"<?= $Page->PlantsReplaced->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlantsReplaced->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { // FungicidesReceived ?>
    <div id="r_FungicidesReceived" class="row"<?= $Page->FungicidesReceived->rowAttributes() ?>>
        <label for="x_FungicidesReceived" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_FungicidesReceived"><?= $Page->FungicidesReceived->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FungicidesReceived" id="z_FungicidesReceived" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FungicidesReceived->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_FungicidesReceived" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FungicidesReceived->getInputTextType() ?>" name="x_FungicidesReceived" id="x_FungicidesReceived" data-table="farm_inspection" data-field="x_FungicidesReceived" value="<?= $Page->FungicidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FungicidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FungicidesReceived->formatPattern()) ?>"<?= $Page->FungicidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FungicidesReceived->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { // PescticidesReceived ?>
    <div id="r_PescticidesReceived" class="row"<?= $Page->PescticidesReceived->rowAttributes() ?>>
        <label for="x_PescticidesReceived" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_PescticidesReceived"><?= $Page->PescticidesReceived->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_PescticidesReceived" id="z_PescticidesReceived" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PescticidesReceived->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_PescticidesReceived" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PescticidesReceived->getInputTextType() ?>" name="x_PescticidesReceived" id="x_PescticidesReceived" data-table="farm_inspection" data-field="x_PescticidesReceived" value="<?= $Page->PescticidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PescticidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PescticidesReceived->formatPattern()) ?>"<?= $Page->PescticidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PescticidesReceived->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { // DiseasePresence ?>
    <div id="r_DiseasePresence" class="row"<?= $Page->DiseasePresence->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_DiseasePresence"><?= $Page->DiseasePresence->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_DiseasePresence" id="z_DiseasePresence" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DiseasePresence->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_DiseasePresence" class="ew-search-field ew-search-field-single">
<template id="tp_x_DiseasePresence">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="farm_inspection" data-field="x_DiseasePresence" name="x_DiseasePresence" id="x_DiseasePresence"<?= $Page->DiseasePresence->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_DiseasePresence" class="ew-item-list"></div>
<selection-list hidden
    id="x_DiseasePresence[]"
    name="x_DiseasePresence[]"
    value="<?= HtmlEncode($Page->DiseasePresence->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_DiseasePresence"
    data-target="dsl_x_DiseasePresence"
    data-repeatcolumn="5"
    class="form-control<?= $Page->DiseasePresence->isInvalidClass() ?>"
    data-table="farm_inspection"
    data-field="x_DiseasePresence"
    data-value-separator="<?= $Page->DiseasePresence->displayValueSeparatorAttribute() ?>"
    <?= $Page->DiseasePresence->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->DiseasePresence->getErrorMessage(false) ?></div>
<?= $Page->DiseasePresence->Lookup->getParamTag($Page, "p_x_DiseasePresence") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AvailableLand->Visible) { // AvailableLand ?>
    <div id="r_AvailableLand" class="row"<?= $Page->AvailableLand->rowAttributes() ?>>
        <label for="x_AvailableLand" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_AvailableLand"><?= $Page->AvailableLand->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_AvailableLand" id="z_AvailableLand" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AvailableLand->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_AvailableLand" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AvailableLand->getInputTextType() ?>" name="x_AvailableLand" id="x_AvailableLand" data-table="farm_inspection" data-field="x_AvailableLand" value="<?= $Page->AvailableLand->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AvailableLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AvailableLand->formatPattern()) ?>"<?= $Page->AvailableLand->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AvailableLand->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->LandForCashewCleared->Visible) { // LandForCashewCleared ?>
    <div id="r_LandForCashewCleared" class="row"<?= $Page->LandForCashewCleared->rowAttributes() ?>>
        <label for="x_LandForCashewCleared" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_LandForCashewCleared"><?= $Page->LandForCashewCleared->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_LandForCashewCleared" id="z_LandForCashewCleared" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->LandForCashewCleared->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_LandForCashewCleared" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->LandForCashewCleared->getInputTextType() ?>" name="x_LandForCashewCleared" id="x_LandForCashewCleared" data-table="farm_inspection" data-field="x_LandForCashewCleared" value="<?= $Page->LandForCashewCleared->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->LandForCashewCleared->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LandForCashewCleared->formatPattern()) ?>"<?= $Page->LandForCashewCleared->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->LandForCashewCleared->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->HolesDug->Visible) { // HolesDug ?>
    <div id="r_HolesDug" class="row"<?= $Page->HolesDug->rowAttributes() ?>>
        <label for="x_HolesDug" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_HolesDug"><?= $Page->HolesDug->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_HolesDug" id="z_HolesDug" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->HolesDug->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_HolesDug" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->HolesDug->getInputTextType() ?>" name="x_HolesDug" id="x_HolesDug" data-table="farm_inspection" data-field="x_HolesDug" value="<?= $Page->HolesDug->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->HolesDug->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->HolesDug->formatPattern()) ?>"<?= $Page->HolesDug->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->HolesDug->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->VerifiedSeedlingArea->Visible) { // VerifiedSeedlingArea ?>
    <div id="r_VerifiedSeedlingArea" class="row"<?= $Page->VerifiedSeedlingArea->rowAttributes() ?>>
        <label for="x_VerifiedSeedlingArea" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_VerifiedSeedlingArea"><?= $Page->VerifiedSeedlingArea->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_VerifiedSeedlingArea" id="z_VerifiedSeedlingArea" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->VerifiedSeedlingArea->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_VerifiedSeedlingArea" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->VerifiedSeedlingArea->getInputTextType() ?>" name="x_VerifiedSeedlingArea" id="x_VerifiedSeedlingArea" data-table="farm_inspection" data-field="x_VerifiedSeedlingArea" value="<?= $Page->VerifiedSeedlingArea->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->VerifiedSeedlingArea->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->VerifiedSeedlingArea->formatPattern()) ?>"<?= $Page->VerifiedSeedlingArea->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->VerifiedSeedlingArea->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->OldTreesNo->Visible) { // OldTreesNo ?>
    <div id="r_OldTreesNo" class="row"<?= $Page->OldTreesNo->rowAttributes() ?>>
        <label for="x_OldTreesNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_OldTreesNo"><?= $Page->OldTreesNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_OldTreesNo" id="z_OldTreesNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->OldTreesNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_OldTreesNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->OldTreesNo->getInputTextType() ?>" name="x_OldTreesNo" id="x_OldTreesNo" data-table="farm_inspection" data-field="x_OldTreesNo" value="<?= $Page->OldTreesNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->OldTreesNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OldTreesNo->formatPattern()) ?>"<?= $Page->OldTreesNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OldTreesNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->InspectionReport->Visible) { // InspectionReport ?>
    <div id="r_InspectionReport" class="row"<?= $Page->InspectionReport->rowAttributes() ?>>
        <label for="x_InspectionReport" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_InspectionReport"><?= $Page->InspectionReport->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_InspectionReport" id="z_InspectionReport" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->InspectionReport->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_InspectionReport" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->InspectionReport->getInputTextType() ?>" name="x_InspectionReport" id="x_InspectionReport" data-table="farm_inspection" data-field="x_InspectionReport" value="<?= $Page->InspectionReport->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->InspectionReport->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InspectionReport->formatPattern()) ?>"<?= $Page->InspectionReport->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InspectionReport->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->InspectionDate->Visible) { // InspectionDate ?>
    <div id="r_InspectionDate" class="row"<?= $Page->InspectionDate->rowAttributes() ?>>
        <label for="x_InspectionDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_InspectionDate"><?= $Page->InspectionDate->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_InspectionDate" id="z_InspectionDate" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->InspectionDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_InspectionDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->InspectionDate->getInputTextType() ?>" name="x_InspectionDate" id="x_InspectionDate" data-table="farm_inspection" data-field="x_InspectionDate" value="<?= $Page->InspectionDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->InspectionDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InspectionDate->formatPattern()) ?>"<?= $Page->InspectionDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InspectionDate->getErrorMessage(false) ?></div>
<?php if (!$Page->InspectionDate->ReadOnly && !$Page->InspectionDate->Disabled && !isset($Page->InspectionDate->EditAttrs["readonly"]) && !isset($Page->InspectionDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffarm_inspectionsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffarm_inspectionsearch", "x_InspectionDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->InspectedBy->Visible) { // InspectedBy ?>
    <div id="r_InspectedBy" class="row"<?= $Page->InspectedBy->rowAttributes() ?>>
        <label for="x_InspectedBy" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_InspectedBy"><?= $Page->InspectedBy->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_InspectedBy" id="z_InspectedBy" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->InspectedBy->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_InspectedBy" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->InspectedBy->getInputTextType() ?>" name="x_InspectedBy" id="x_InspectedBy" data-table="farm_inspection" data-field="x_InspectedBy" value="<?= $Page->InspectedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->InspectedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InspectedBy->formatPattern()) ?>"<?= $Page->InspectedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InspectedBy->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AuthorisedBy->Visible) { // AuthorisedBy ?>
    <div id="r_AuthorisedBy" class="row"<?= $Page->AuthorisedBy->rowAttributes() ?>>
        <label for="x_AuthorisedBy" class="<?= $Page->LeftColumnClass ?>"><span id="elh_farm_inspection_AuthorisedBy"><?= $Page->AuthorisedBy->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_AuthorisedBy" id="z_AuthorisedBy" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AuthorisedBy->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_farm_inspection_AuthorisedBy" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AuthorisedBy->getInputTextType() ?>" name="x_AuthorisedBy" id="x_AuthorisedBy" data-table="farm_inspection" data-field="x_AuthorisedBy" value="<?= $Page->AuthorisedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorisedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorisedBy->formatPattern()) ?>"<?= $Page->AuthorisedBy->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AuthorisedBy->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffarm_inspectionsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarm_inspectionsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ffarm_inspectionsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_inspection");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
