<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("FarmInspectionGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var ffarm_inspectiongrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { farm_inspection: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarm_inspectiongrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null, ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["InspectionTransNo", [fields.InspectionTransNo.visible && fields.InspectionTransNo.required ? ew.Validators.required(fields.InspectionTransNo.caption) : null], fields.InspectionTransNo.isInvalid],
            ["PlantsDead", [fields.PlantsDead.visible && fields.PlantsDead.required ? ew.Validators.required(fields.PlantsDead.caption) : null, ew.Validators.integer], fields.PlantsDead.isInvalid],
            ["PlantsVerifiedNo", [fields.PlantsVerifiedNo.visible && fields.PlantsVerifiedNo.required ? ew.Validators.required(fields.PlantsVerifiedNo.caption) : null, ew.Validators.integer], fields.PlantsVerifiedNo.isInvalid],
            ["PlantsReplaced", [fields.PlantsReplaced.visible && fields.PlantsReplaced.required ? ew.Validators.required(fields.PlantsReplaced.caption) : null, ew.Validators.integer], fields.PlantsReplaced.isInvalid],
            ["FungicidesReceived", [fields.FungicidesReceived.visible && fields.FungicidesReceived.required ? ew.Validators.required(fields.FungicidesReceived.caption) : null, ew.Validators.float], fields.FungicidesReceived.isInvalid],
            ["PescticidesReceived", [fields.PescticidesReceived.visible && fields.PescticidesReceived.required ? ew.Validators.required(fields.PescticidesReceived.caption) : null, ew.Validators.float], fields.PescticidesReceived.isInvalid],
            ["DiseasePresence", [fields.DiseasePresence.visible && fields.DiseasePresence.required ? ew.Validators.required(fields.DiseasePresence.caption) : null], fields.DiseasePresence.isInvalid],
            ["AvailableLand", [fields.AvailableLand.visible && fields.AvailableLand.required ? ew.Validators.required(fields.AvailableLand.caption) : null, ew.Validators.float], fields.AvailableLand.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampCode",false],["VillageCode",false],["NRC",false],["FarmerNo",false],["FarmNo",false],["PlantsDead",false],["PlantsVerifiedNo",false],["PlantsReplaced",false],["FungicidesReceived",false],["PescticidesReceived",false],["DiseasePresence[]",false],["AvailableLand",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Grid->ProvinceCode->toClientList($Grid) ?>,
            "DistrictCode": <?= $Grid->DistrictCode->toClientList($Grid) ?>,
            "CampCode": <?= $Grid->CampCode->toClientList($Grid) ?>,
            "VillageCode": <?= $Grid->VillageCode->toClientList($Grid) ?>,
            "NRC": <?= $Grid->NRC->toClientList($Grid) ?>,
            "DiseasePresence": <?= $Grid->DiseasePresence->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="ffarm_inspectiongrid" class="ew-form ew-list-form">
<div id="gmp_farm_inspection" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_farm_inspectiongrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->headerCellClass() ?>"><div id="elh_farm_inspection_ProvinceCode" class="farm_inspection_ProvinceCode"><?= $Grid->renderFieldHeader($Grid->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Grid->DistrictCode->headerCellClass() ?>"><div id="elh_farm_inspection_DistrictCode" class="farm_inspection_DistrictCode"><?= $Grid->renderFieldHeader($Grid->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Grid->CampCode->headerCellClass() ?>"><div id="elh_farm_inspection_CampCode" class="farm_inspection_CampCode"><?= $Grid->renderFieldHeader($Grid->CampCode) ?></div></th>
<?php } ?>
<?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Grid->VillageCode->headerCellClass() ?>"><div id="elh_farm_inspection_VillageCode" class="farm_inspection_VillageCode"><?= $Grid->renderFieldHeader($Grid->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Grid->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Grid->NRC->headerCellClass() ?>"><div id="elh_farm_inspection_NRC" class="farm_inspection_NRC"><?= $Grid->renderFieldHeader($Grid->NRC) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Grid->FarmerNo->headerCellClass() ?>"><div id="elh_farm_inspection_FarmerNo" class="farm_inspection_FarmerNo"><?= $Grid->renderFieldHeader($Grid->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Grid->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Grid->FarmNo->headerCellClass() ?>"><div id="elh_farm_inspection_FarmNo" class="farm_inspection_FarmNo"><?= $Grid->renderFieldHeader($Grid->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Grid->InspectionTransNo->Visible) { // InspectionTransNo ?>
        <th data-name="InspectionTransNo" class="<?= $Grid->InspectionTransNo->headerCellClass() ?>"><div id="elh_farm_inspection_InspectionTransNo" class="farm_inspection_InspectionTransNo"><?= $Grid->renderFieldHeader($Grid->InspectionTransNo) ?></div></th>
<?php } ?>
<?php if ($Grid->PlantsDead->Visible) { // PlantsDead ?>
        <th data-name="PlantsDead" class="<?= $Grid->PlantsDead->headerCellClass() ?>"><div id="elh_farm_inspection_PlantsDead" class="farm_inspection_PlantsDead"><?= $Grid->renderFieldHeader($Grid->PlantsDead) ?></div></th>
<?php } ?>
<?php if ($Grid->PlantsVerifiedNo->Visible) { // PlantsVerifiedNo ?>
        <th data-name="PlantsVerifiedNo" class="<?= $Grid->PlantsVerifiedNo->headerCellClass() ?>"><div id="elh_farm_inspection_PlantsVerifiedNo" class="farm_inspection_PlantsVerifiedNo"><?= $Grid->renderFieldHeader($Grid->PlantsVerifiedNo) ?></div></th>
<?php } ?>
<?php if ($Grid->PlantsReplaced->Visible) { // PlantsReplaced ?>
        <th data-name="PlantsReplaced" class="<?= $Grid->PlantsReplaced->headerCellClass() ?>"><div id="elh_farm_inspection_PlantsReplaced" class="farm_inspection_PlantsReplaced"><?= $Grid->renderFieldHeader($Grid->PlantsReplaced) ?></div></th>
<?php } ?>
<?php if ($Grid->FungicidesReceived->Visible) { // FungicidesReceived ?>
        <th data-name="FungicidesReceived" class="<?= $Grid->FungicidesReceived->headerCellClass() ?>"><div id="elh_farm_inspection_FungicidesReceived" class="farm_inspection_FungicidesReceived"><?= $Grid->renderFieldHeader($Grid->FungicidesReceived) ?></div></th>
<?php } ?>
<?php if ($Grid->PescticidesReceived->Visible) { // PescticidesReceived ?>
        <th data-name="PescticidesReceived" class="<?= $Grid->PescticidesReceived->headerCellClass() ?>"><div id="elh_farm_inspection_PescticidesReceived" class="farm_inspection_PescticidesReceived"><?= $Grid->renderFieldHeader($Grid->PescticidesReceived) ?></div></th>
<?php } ?>
<?php if ($Grid->DiseasePresence->Visible) { // DiseasePresence ?>
        <th data-name="DiseasePresence" class="<?= $Grid->DiseasePresence->headerCellClass() ?>"><div id="elh_farm_inspection_DiseasePresence" class="farm_inspection_DiseasePresence"><?= $Grid->renderFieldHeader($Grid->DiseasePresence) ?></div></th>
<?php } ?>
<?php if ($Grid->AvailableLand->Visible) { // AvailableLand ?>
        <th data-name="AvailableLand" class="<?= $Grid->AvailableLand->headerCellClass() ?>"><div id="elh_farm_inspection_AvailableLand" class="farm_inspection_AvailableLand"><?= $Grid->renderFieldHeader($Grid->AvailableLand) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Grid->ProvinceCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_ProvinceCode" class="el_farm_inspection_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProvinceCode" id="o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_ProvinceCode" class="el_farm_inspection_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_ProvinceCode" class="el_farm_inspection_ProvinceCode">
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<?= $Grid->ProvinceCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_ProvinceCode" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_ProvinceCode" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_ProvinceCode" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Grid->DistrictCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_DistrictCode" class="el_farm_inspection_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DistrictCode" id="o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_DistrictCode" class="el_farm_inspection_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_DistrictCode" class="el_farm_inspection_DistrictCode">
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<?= $Grid->DistrictCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_DistrictCode" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_DistrictCode" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_DistrictCode" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_DistrictCode" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Grid->CampCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->CampCode->getSessionValue() != "") { ?>
<span<?= $Grid->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->CampCode->getDisplayValue($Grid->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_CampCode" name="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_CampCode" class="el_farm_inspection_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        <?php if (!$Grid->CampCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_CampCode"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<?php if (!$Grid->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_CampCode" id="o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->CampCode->getSessionValue() != "") { ?>
<span<?= $Grid->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->CampCode->getDisplayValue($Grid->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_CampCode" name="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_CampCode" class="el_farm_inspection_CampCode">
    <select
        id="x<?= $Grid->RowIndex ?>_CampCode"
        name="x<?= $Grid->RowIndex ?>_CampCode"
        class="form-select ew-select<?= $Grid->CampCode->isInvalidClass() ?>"
        <?php if (!$Grid->CampCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_CampCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_CampCode"
        data-value-separator="<?= $Grid->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->CampCode->editAttributes() ?>>
        <?= $Grid->CampCode->selectOptionListHtml("x{$Grid->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->CampCode->getErrorMessage() ?></div>
<?= $Grid->CampCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_CampCode") ?>
<?php if (!$Grid->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_CampCode", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_CampCode", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_CampCode" class="el_farm_inspection_CampCode">
<span<?= $Grid->CampCode->viewAttributes() ?>>
<?= $Grid->CampCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_CampCode" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_CampCode" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_CampCode" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_CampCode" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Grid->VillageCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->VillageCode->getSessionValue() != "") { ?>
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->VillageCode->getDisplayValue($Grid->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_VillageCode" name="x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_VillageCode" class="el_farm_inspection_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-select ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        <?php if (!$Grid->VillageCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_VillageCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_VillageCode"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<?php if (!$Grid->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_VillageCode" id="o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->VillageCode->getSessionValue() != "") { ?>
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->VillageCode->getDisplayValue($Grid->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_VillageCode" name="x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_VillageCode" class="el_farm_inspection_VillageCode">
    <select
        id="x<?= $Grid->RowIndex ?>_VillageCode"
        name="x<?= $Grid->RowIndex ?>_VillageCode"
        class="form-select ew-select<?= $Grid->VillageCode->isInvalidClass() ?>"
        <?php if (!$Grid->VillageCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_VillageCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_VillageCode"
        data-value-separator="<?= $Grid->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->VillageCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->VillageCode->editAttributes() ?>>
        <?= $Grid->VillageCode->selectOptionListHtml("x{$Grid->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->VillageCode->getErrorMessage() ?></div>
<?= $Grid->VillageCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_VillageCode") ?>
<?php if (!$Grid->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_VillageCode", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_VillageCode", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_VillageCode" class="el_farm_inspection_VillageCode">
<span<?= $Grid->VillageCode->viewAttributes() ?>>
<?= $Grid->VillageCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_VillageCode" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_VillageCode" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_VillageCode" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_VillageCode" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Grid->VillageCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Grid->NRC->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->NRC->getSessionValue() != "") { ?>
<span<?= $Grid->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->NRC->getDisplayValue($Grid->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_NRC" name="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_NRC" class="el_farm_inspection_NRC">
    <select
        id="x<?= $Grid->RowIndex ?>_NRC"
        name="x<?= $Grid->RowIndex ?>_NRC"
        class="form-select ew-select<?= $Grid->NRC->isInvalidClass() ?>"
        <?php if (!$Grid->NRC->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_NRC"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_NRC"
        data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->NRC->editAttributes() ?>>
        <?= $Grid->NRC->selectOptionListHtml("x{$Grid->RowIndex}_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
<?php if (!$Grid->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_NRC", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_NRC", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_NRC", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NRC" id="o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->NRC->getSessionValue() != "") { ?>
<span<?= $Grid->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->NRC->getDisplayValue($Grid->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_NRC" name="x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_NRC" class="el_farm_inspection_NRC">
    <select
        id="x<?= $Grid->RowIndex ?>_NRC"
        name="x<?= $Grid->RowIndex ?>_NRC"
        class="form-select ew-select<?= $Grid->NRC->isInvalidClass() ?>"
        <?php if (!$Grid->NRC->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_NRC"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_NRC"
        data-value-separator="<?= $Grid->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->NRC->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->NRC->editAttributes() ?>>
        <?= $Grid->NRC->selectOptionListHtml("x{$Grid->RowIndex}_NRC") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->NRC->getErrorMessage() ?></div>
<?= $Grid->NRC->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NRC") ?>
<?php if (!$Grid->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectiongrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_NRC", selectId: "ffarm_inspectiongrid_x<?= $Grid->RowIndex ?>_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectiongrid.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_NRC", form: "ffarm_inspectiongrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_NRC", form: "ffarm_inspectiongrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_NRC" class="el_farm_inspection_NRC">
<span<?= $Grid->NRC->viewAttributes() ?>>
<?= $Grid->NRC->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_NRC" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_NRC" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_NRC" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_NRC" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_NRC" value="<?= HtmlEncode($Grid->NRC->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Grid->FarmerNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FarmerNo" class="el_farm_inspection_FarmerNo">
<input type="<?= $Grid->FarmerNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmerNo" id="x<?= $Grid->RowIndex ?>_FarmerNo" data-table="farm_inspection" data-field="x_FarmerNo" value="<?= $Grid->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerNo->formatPattern()) ?>"<?= $Grid->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmerNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_FarmerNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmerNo" id="o<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FarmerNo" class="el_farm_inspection_FarmerNo">
<input type="<?= $Grid->FarmerNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmerNo" id="x<?= $Grid->RowIndex ?>_FarmerNo" data-table="farm_inspection" data-field="x_FarmerNo" value="<?= $Grid->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmerNo->formatPattern()) ?>"<?= $Grid->FarmerNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmerNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FarmerNo" class="el_farm_inspection_FarmerNo">
<span<?= $Grid->FarmerNo->viewAttributes() ?>>
<?= $Grid->FarmerNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_FarmerNo" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_FarmerNo" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_FarmerNo" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_FarmerNo" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_FarmerNo" value="<?= HtmlEncode($Grid->FarmerNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Grid->FarmNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->FarmNo->getSessionValue() != "") { ?>
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->FarmNo->getDisplayValue($Grid->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_FarmNo" name="x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FarmNo" class="el_farm_inspection_FarmNo">
<input type="<?= $Grid->FarmNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmNo" id="x<?= $Grid->RowIndex ?>_FarmNo" data-table="farm_inspection" data-field="x_FarmNo" value="<?= $Grid->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmNo->formatPattern()) ?>"<?= $Grid->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="farm_inspection" data-field="x_FarmNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FarmNo" id="o<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->FarmNo->getSessionValue() != "") { ?>
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->FarmNo->getDisplayValue($Grid->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_FarmNo" name="x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FarmNo" class="el_farm_inspection_FarmNo">
<input type="<?= $Grid->FarmNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FarmNo" id="x<?= $Grid->RowIndex ?>_FarmNo" data-table="farm_inspection" data-field="x_FarmNo" value="<?= $Grid->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FarmNo->formatPattern()) ?>"<?= $Grid->FarmNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FarmNo" class="el_farm_inspection_FarmNo">
<span<?= $Grid->FarmNo->viewAttributes() ?>>
<?= $Grid->FarmNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_FarmNo" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_FarmNo" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_FarmNo" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_FarmNo" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_FarmNo" value="<?= HtmlEncode($Grid->FarmNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->InspectionTransNo->Visible) { // InspectionTransNo ?>
        <td data-name="InspectionTransNo"<?= $Grid->InspectionTransNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_InspectionTransNo" class="el_farm_inspection_InspectionTransNo"></span>
<input type="hidden" data-table="farm_inspection" data-field="x_InspectionTransNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_InspectionTransNo" id="o<?= $Grid->RowIndex ?>_InspectionTransNo" value="<?= HtmlEncode($Grid->InspectionTransNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_InspectionTransNo" class="el_farm_inspection_InspectionTransNo">
<span<?= $Grid->InspectionTransNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->InspectionTransNo->getDisplayValue($Grid->InspectionTransNo->EditValue))) ?>"></span>
<input type="hidden" data-table="farm_inspection" data-field="x_InspectionTransNo" data-hidden="1" name="x<?= $Grid->RowIndex ?>_InspectionTransNo" id="x<?= $Grid->RowIndex ?>_InspectionTransNo" value="<?= HtmlEncode($Grid->InspectionTransNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_InspectionTransNo" class="el_farm_inspection_InspectionTransNo">
<span<?= $Grid->InspectionTransNo->viewAttributes() ?>>
<?= $Grid->InspectionTransNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_InspectionTransNo" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_InspectionTransNo" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_InspectionTransNo" value="<?= HtmlEncode($Grid->InspectionTransNo->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_InspectionTransNo" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_InspectionTransNo" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_InspectionTransNo" value="<?= HtmlEncode($Grid->InspectionTransNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="farm_inspection" data-field="x_InspectionTransNo" data-hidden="1" name="x<?= $Grid->RowIndex ?>_InspectionTransNo" id="x<?= $Grid->RowIndex ?>_InspectionTransNo" value="<?= HtmlEncode($Grid->InspectionTransNo->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->PlantsDead->Visible) { // PlantsDead ?>
        <td data-name="PlantsDead"<?= $Grid->PlantsDead->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsDead" class="el_farm_inspection_PlantsDead">
<input type="<?= $Grid->PlantsDead->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlantsDead" id="x<?= $Grid->RowIndex ?>_PlantsDead" data-table="farm_inspection" data-field="x_PlantsDead" value="<?= $Grid->PlantsDead->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->PlantsDead->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlantsDead->formatPattern()) ?>"<?= $Grid->PlantsDead->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlantsDead->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsDead" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PlantsDead" id="o<?= $Grid->RowIndex ?>_PlantsDead" value="<?= HtmlEncode($Grid->PlantsDead->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsDead" class="el_farm_inspection_PlantsDead">
<input type="<?= $Grid->PlantsDead->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlantsDead" id="x<?= $Grid->RowIndex ?>_PlantsDead" data-table="farm_inspection" data-field="x_PlantsDead" value="<?= $Grid->PlantsDead->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->PlantsDead->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlantsDead->formatPattern()) ?>"<?= $Grid->PlantsDead->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlantsDead->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsDead" class="el_farm_inspection_PlantsDead">
<span<?= $Grid->PlantsDead->viewAttributes() ?>>
<?= $Grid->PlantsDead->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsDead" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_PlantsDead" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_PlantsDead" value="<?= HtmlEncode($Grid->PlantsDead->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsDead" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_PlantsDead" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_PlantsDead" value="<?= HtmlEncode($Grid->PlantsDead->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PlantsVerifiedNo->Visible) { // PlantsVerifiedNo ?>
        <td data-name="PlantsVerifiedNo"<?= $Grid->PlantsVerifiedNo->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsVerifiedNo" class="el_farm_inspection_PlantsVerifiedNo">
<input type="<?= $Grid->PlantsVerifiedNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlantsVerifiedNo" id="x<?= $Grid->RowIndex ?>_PlantsVerifiedNo" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" value="<?= $Grid->PlantsVerifiedNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->PlantsVerifiedNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlantsVerifiedNo->formatPattern()) ?>"<?= $Grid->PlantsVerifiedNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlantsVerifiedNo->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PlantsVerifiedNo" id="o<?= $Grid->RowIndex ?>_PlantsVerifiedNo" value="<?= HtmlEncode($Grid->PlantsVerifiedNo->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsVerifiedNo" class="el_farm_inspection_PlantsVerifiedNo">
<input type="<?= $Grid->PlantsVerifiedNo->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlantsVerifiedNo" id="x<?= $Grid->RowIndex ?>_PlantsVerifiedNo" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" value="<?= $Grid->PlantsVerifiedNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->PlantsVerifiedNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlantsVerifiedNo->formatPattern()) ?>"<?= $Grid->PlantsVerifiedNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlantsVerifiedNo->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsVerifiedNo" class="el_farm_inspection_PlantsVerifiedNo">
<span<?= $Grid->PlantsVerifiedNo->viewAttributes() ?>>
<?= $Grid->PlantsVerifiedNo->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_PlantsVerifiedNo" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_PlantsVerifiedNo" value="<?= HtmlEncode($Grid->PlantsVerifiedNo->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_PlantsVerifiedNo" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_PlantsVerifiedNo" value="<?= HtmlEncode($Grid->PlantsVerifiedNo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PlantsReplaced->Visible) { // PlantsReplaced ?>
        <td data-name="PlantsReplaced"<?= $Grid->PlantsReplaced->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsReplaced" class="el_farm_inspection_PlantsReplaced">
<input type="<?= $Grid->PlantsReplaced->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlantsReplaced" id="x<?= $Grid->RowIndex ?>_PlantsReplaced" data-table="farm_inspection" data-field="x_PlantsReplaced" value="<?= $Grid->PlantsReplaced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->PlantsReplaced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlantsReplaced->formatPattern()) ?>"<?= $Grid->PlantsReplaced->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlantsReplaced->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsReplaced" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PlantsReplaced" id="o<?= $Grid->RowIndex ?>_PlantsReplaced" value="<?= HtmlEncode($Grid->PlantsReplaced->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsReplaced" class="el_farm_inspection_PlantsReplaced">
<input type="<?= $Grid->PlantsReplaced->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PlantsReplaced" id="x<?= $Grid->RowIndex ?>_PlantsReplaced" data-table="farm_inspection" data-field="x_PlantsReplaced" value="<?= $Grid->PlantsReplaced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->PlantsReplaced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PlantsReplaced->formatPattern()) ?>"<?= $Grid->PlantsReplaced->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PlantsReplaced->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PlantsReplaced" class="el_farm_inspection_PlantsReplaced">
<span<?= $Grid->PlantsReplaced->viewAttributes() ?>>
<?= $Grid->PlantsReplaced->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsReplaced" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_PlantsReplaced" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_PlantsReplaced" value="<?= HtmlEncode($Grid->PlantsReplaced->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_PlantsReplaced" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_PlantsReplaced" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_PlantsReplaced" value="<?= HtmlEncode($Grid->PlantsReplaced->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FungicidesReceived->Visible) { // FungicidesReceived ?>
        <td data-name="FungicidesReceived"<?= $Grid->FungicidesReceived->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FungicidesReceived" class="el_farm_inspection_FungicidesReceived">
<input type="<?= $Grid->FungicidesReceived->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FungicidesReceived" id="x<?= $Grid->RowIndex ?>_FungicidesReceived" data-table="farm_inspection" data-field="x_FungicidesReceived" value="<?= $Grid->FungicidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FungicidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FungicidesReceived->formatPattern()) ?>"<?= $Grid->FungicidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FungicidesReceived->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_FungicidesReceived" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FungicidesReceived" id="o<?= $Grid->RowIndex ?>_FungicidesReceived" value="<?= HtmlEncode($Grid->FungicidesReceived->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FungicidesReceived" class="el_farm_inspection_FungicidesReceived">
<input type="<?= $Grid->FungicidesReceived->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FungicidesReceived" id="x<?= $Grid->RowIndex ?>_FungicidesReceived" data-table="farm_inspection" data-field="x_FungicidesReceived" value="<?= $Grid->FungicidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FungicidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FungicidesReceived->formatPattern()) ?>"<?= $Grid->FungicidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FungicidesReceived->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_FungicidesReceived" class="el_farm_inspection_FungicidesReceived">
<span<?= $Grid->FungicidesReceived->viewAttributes() ?>>
<?= $Grid->FungicidesReceived->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_FungicidesReceived" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_FungicidesReceived" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_FungicidesReceived" value="<?= HtmlEncode($Grid->FungicidesReceived->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_FungicidesReceived" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_FungicidesReceived" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_FungicidesReceived" value="<?= HtmlEncode($Grid->FungicidesReceived->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PescticidesReceived->Visible) { // PescticidesReceived ?>
        <td data-name="PescticidesReceived"<?= $Grid->PescticidesReceived->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PescticidesReceived" class="el_farm_inspection_PescticidesReceived">
<input type="<?= $Grid->PescticidesReceived->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PescticidesReceived" id="x<?= $Grid->RowIndex ?>_PescticidesReceived" data-table="farm_inspection" data-field="x_PescticidesReceived" value="<?= $Grid->PescticidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->PescticidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PescticidesReceived->formatPattern()) ?>"<?= $Grid->PescticidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PescticidesReceived->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_PescticidesReceived" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PescticidesReceived" id="o<?= $Grid->RowIndex ?>_PescticidesReceived" value="<?= HtmlEncode($Grid->PescticidesReceived->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PescticidesReceived" class="el_farm_inspection_PescticidesReceived">
<input type="<?= $Grid->PescticidesReceived->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_PescticidesReceived" id="x<?= $Grid->RowIndex ?>_PescticidesReceived" data-table="farm_inspection" data-field="x_PescticidesReceived" value="<?= $Grid->PescticidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->PescticidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->PescticidesReceived->formatPattern()) ?>"<?= $Grid->PescticidesReceived->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->PescticidesReceived->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_PescticidesReceived" class="el_farm_inspection_PescticidesReceived">
<span<?= $Grid->PescticidesReceived->viewAttributes() ?>>
<?= $Grid->PescticidesReceived->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_PescticidesReceived" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_PescticidesReceived" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_PescticidesReceived" value="<?= HtmlEncode($Grid->PescticidesReceived->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_PescticidesReceived" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_PescticidesReceived" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_PescticidesReceived" value="<?= HtmlEncode($Grid->PescticidesReceived->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DiseasePresence->Visible) { // DiseasePresence ?>
        <td data-name="DiseasePresence"<?= $Grid->DiseasePresence->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_DiseasePresence" class="el_farm_inspection_DiseasePresence">
<template id="tp_x<?= $Grid->RowIndex ?>_DiseasePresence">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="farm_inspection" data-field="x_DiseasePresence" name="x<?= $Grid->RowIndex ?>_DiseasePresence" id="x<?= $Grid->RowIndex ?>_DiseasePresence"<?= $Grid->DiseasePresence->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_DiseasePresence" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_DiseasePresence[]"
    name="x<?= $Grid->RowIndex ?>_DiseasePresence[]"
    value="<?= HtmlEncode($Grid->DiseasePresence->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x<?= $Grid->RowIndex ?>_DiseasePresence"
    data-target="dsl_x<?= $Grid->RowIndex ?>_DiseasePresence"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->DiseasePresence->isInvalidClass() ?>"
    data-table="farm_inspection"
    data-field="x_DiseasePresence"
    data-value-separator="<?= $Grid->DiseasePresence->displayValueSeparatorAttribute() ?>"
    <?= $Grid->DiseasePresence->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->DiseasePresence->getErrorMessage() ?></div>
<?= $Grid->DiseasePresence->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DiseasePresence") ?>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_DiseasePresence" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DiseasePresence[]" id="o<?= $Grid->RowIndex ?>_DiseasePresence[]" value="<?= HtmlEncode($Grid->DiseasePresence->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_DiseasePresence" class="el_farm_inspection_DiseasePresence">
<template id="tp_x<?= $Grid->RowIndex ?>_DiseasePresence">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="farm_inspection" data-field="x_DiseasePresence" name="x<?= $Grid->RowIndex ?>_DiseasePresence" id="x<?= $Grid->RowIndex ?>_DiseasePresence"<?= $Grid->DiseasePresence->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x<?= $Grid->RowIndex ?>_DiseasePresence" class="ew-item-list"></div>
<selection-list hidden
    id="x<?= $Grid->RowIndex ?>_DiseasePresence[]"
    name="x<?= $Grid->RowIndex ?>_DiseasePresence[]"
    value="<?= HtmlEncode($Grid->DiseasePresence->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x<?= $Grid->RowIndex ?>_DiseasePresence"
    data-target="dsl_x<?= $Grid->RowIndex ?>_DiseasePresence"
    data-repeatcolumn="5"
    class="form-control<?= $Grid->DiseasePresence->isInvalidClass() ?>"
    data-table="farm_inspection"
    data-field="x_DiseasePresence"
    data-value-separator="<?= $Grid->DiseasePresence->displayValueSeparatorAttribute() ?>"
    <?= $Grid->DiseasePresence->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Grid->DiseasePresence->getErrorMessage() ?></div>
<?= $Grid->DiseasePresence->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DiseasePresence") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_DiseasePresence" class="el_farm_inspection_DiseasePresence">
<span<?= $Grid->DiseasePresence->viewAttributes() ?>>
<?= $Grid->DiseasePresence->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_DiseasePresence" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_DiseasePresence" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_DiseasePresence" value="<?= HtmlEncode($Grid->DiseasePresence->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_DiseasePresence" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_DiseasePresence[]" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_DiseasePresence[]" value="<?= HtmlEncode($Grid->DiseasePresence->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->AvailableLand->Visible) { // AvailableLand ?>
        <td data-name="AvailableLand"<?= $Grid->AvailableLand->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_AvailableLand" class="el_farm_inspection_AvailableLand">
<input type="<?= $Grid->AvailableLand->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AvailableLand" id="x<?= $Grid->RowIndex ?>_AvailableLand" data-table="farm_inspection" data-field="x_AvailableLand" value="<?= $Grid->AvailableLand->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->AvailableLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AvailableLand->formatPattern()) ?>"<?= $Grid->AvailableLand->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AvailableLand->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="farm_inspection" data-field="x_AvailableLand" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_AvailableLand" id="o<?= $Grid->RowIndex ?>_AvailableLand" value="<?= HtmlEncode($Grid->AvailableLand->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_AvailableLand" class="el_farm_inspection_AvailableLand">
<input type="<?= $Grid->AvailableLand->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_AvailableLand" id="x<?= $Grid->RowIndex ?>_AvailableLand" data-table="farm_inspection" data-field="x_AvailableLand" value="<?= $Grid->AvailableLand->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->AvailableLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->AvailableLand->formatPattern()) ?>"<?= $Grid->AvailableLand->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->AvailableLand->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_farm_inspection_AvailableLand" class="el_farm_inspection_AvailableLand">
<span<?= $Grid->AvailableLand->viewAttributes() ?>>
<?= $Grid->AvailableLand->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="farm_inspection" data-field="x_AvailableLand" data-hidden="1" name="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_AvailableLand" id="ffarm_inspectiongrid$x<?= $Grid->RowIndex ?>_AvailableLand" value="<?= HtmlEncode($Grid->AvailableLand->FormValue) ?>">
<input type="hidden" data-table="farm_inspection" data-field="x_AvailableLand" data-hidden="1" data-old name="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_AvailableLand" id="ffarm_inspectiongrid$o<?= $Grid->RowIndex ?>_AvailableLand" value="<?= HtmlEncode($Grid->AvailableLand->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["ffarm_inspectiongrid","load"], () => ffarm_inspectiongrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ffarm_inspectiongrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_inspection");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
