<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmInspectionAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm_inspection: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ffarm_inspectionadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarm_inspectionadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerNo", [fields.FarmerNo.visible && fields.FarmerNo.required ? ew.Validators.required(fields.FarmerNo.caption) : null, ew.Validators.integer], fields.FarmerNo.isInvalid],
            ["FarmNo", [fields.FarmNo.visible && fields.FarmNo.required ? ew.Validators.required(fields.FarmNo.caption) : null, ew.Validators.integer], fields.FarmNo.isInvalid],
            ["PlantsDead", [fields.PlantsDead.visible && fields.PlantsDead.required ? ew.Validators.required(fields.PlantsDead.caption) : null, ew.Validators.integer], fields.PlantsDead.isInvalid],
            ["PlantsVerifiedNo", [fields.PlantsVerifiedNo.visible && fields.PlantsVerifiedNo.required ? ew.Validators.required(fields.PlantsVerifiedNo.caption) : null, ew.Validators.integer], fields.PlantsVerifiedNo.isInvalid],
            ["PlantsReplaced", [fields.PlantsReplaced.visible && fields.PlantsReplaced.required ? ew.Validators.required(fields.PlantsReplaced.caption) : null, ew.Validators.integer], fields.PlantsReplaced.isInvalid],
            ["FungicidesReceived", [fields.FungicidesReceived.visible && fields.FungicidesReceived.required ? ew.Validators.required(fields.FungicidesReceived.caption) : null, ew.Validators.float], fields.FungicidesReceived.isInvalid],
            ["PescticidesReceived", [fields.PescticidesReceived.visible && fields.PescticidesReceived.required ? ew.Validators.required(fields.PescticidesReceived.caption) : null, ew.Validators.float], fields.PescticidesReceived.isInvalid],
            ["DiseasePresence", [fields.DiseasePresence.visible && fields.DiseasePresence.required ? ew.Validators.required(fields.DiseasePresence.caption) : null], fields.DiseasePresence.isInvalid],
            ["AvailableLand", [fields.AvailableLand.visible && fields.AvailableLand.required ? ew.Validators.required(fields.AvailableLand.caption) : null, ew.Validators.float], fields.AvailableLand.isInvalid],
            ["LandForCashewCleared", [fields.LandForCashewCleared.visible && fields.LandForCashewCleared.required ? ew.Validators.required(fields.LandForCashewCleared.caption) : null, ew.Validators.float], fields.LandForCashewCleared.isInvalid],
            ["HolesDug", [fields.HolesDug.visible && fields.HolesDug.required ? ew.Validators.required(fields.HolesDug.caption) : null, ew.Validators.integer], fields.HolesDug.isInvalid],
            ["VerifiedSeedlingArea", [fields.VerifiedSeedlingArea.visible && fields.VerifiedSeedlingArea.required ? ew.Validators.required(fields.VerifiedSeedlingArea.caption) : null, ew.Validators.float], fields.VerifiedSeedlingArea.isInvalid],
            ["OldTreesNo", [fields.OldTreesNo.visible && fields.OldTreesNo.required ? ew.Validators.required(fields.OldTreesNo.caption) : null, ew.Validators.integer], fields.OldTreesNo.isInvalid],
            ["InspectionReport", [fields.InspectionReport.visible && fields.InspectionReport.required ? ew.Validators.required(fields.InspectionReport.caption) : null], fields.InspectionReport.isInvalid],
            ["InspectionDate", [fields.InspectionDate.visible && fields.InspectionDate.required ? ew.Validators.required(fields.InspectionDate.caption) : null, ew.Validators.datetime(fields.InspectionDate.clientFormatPattern)], fields.InspectionDate.isInvalid],
            ["InspectedBy", [fields.InspectedBy.visible && fields.InspectedBy.required ? ew.Validators.required(fields.InspectedBy.caption) : null], fields.InspectedBy.isInvalid],
            ["AuthorisedBy", [fields.AuthorisedBy.visible && fields.AuthorisedBy.required ? ew.Validators.required(fields.AuthorisedBy.caption) : null], fields.AuthorisedBy.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "DiseasePresence": <?= $Page->DiseasePresence->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarm_inspectionadd" id="ffarm_inspectionadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm_inspection">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "farm") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="farm">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<input type="hidden" name="fk_VillageCode" value="<?= HtmlEncode($Page->VillageCode->getSessionValue()) ?>">
<input type="hidden" name="fk_NRC" value="<?= HtmlEncode($Page->NRC->getSessionValue()) ?>">
<input type="hidden" name="fk_FarmNo" value="<?= HtmlEncode($Page->FarmNo->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_farm_inspection_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x_ProvinceCode" name="x_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_inspection_ProvinceCode">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionadd_x_ProvinceCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <?= $Page->ProvinceCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionadd", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarm_inspectionadd_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionadd.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarm_inspectionadd" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarm_inspectionadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_farm_inspection_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x_DistrictCode" name="x_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_inspection_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionadd_x_DistrictCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionadd", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarm_inspectionadd_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionadd.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarm_inspectionadd" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarm_inspectionadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <label id="elh_farm_inspection_CampCode" for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CampCode->caption() ?><?= $Page->CampCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x_CampCode" name="x_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_inspection_CampCode">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionadd_x_CampCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <?= $Page->CampCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionadd", function() {
    var options = { name: "x_CampCode", selectId: "ffarm_inspectionadd_x_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionadd.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarm_inspectionadd" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarm_inspectionadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <label id="elh_farm_inspection_VillageCode" for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VillageCode->caption() ?><?= $Page->VillageCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x_VillageCode" name="x_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_inspection_VillageCode">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-select ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        <?php if (!$Page->VillageCode->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionadd_x_VillageCode"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_VillageCode"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <?= $Page->VillageCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<?php if (!$Page->VillageCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionadd", function() {
    var options = { name: "x_VillageCode", selectId: "ffarm_inspectionadd_x_VillageCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionadd.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarm_inspectionadd" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarm_inspectionadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.VillageCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_farm_inspection_NRC" for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->NRC->getSessionValue() != "") { ?>
<span<?= $Page->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->NRC->getDisplayValue($Page->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x_NRC" name="x_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_inspection_NRC">
    <select
        id="x_NRC"
        name="x_NRC"
        class="form-select ew-select<?= $Page->NRC->isInvalidClass() ?>"
        <?php if (!$Page->NRC->IsNativeSelect) { ?>
        data-select2-id="ffarm_inspectionadd_x_NRC"
        <?php } ?>
        data-table="farm_inspection"
        data-field="x_NRC"
        data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->NRC->editAttributes() ?>>
        <?= $Page->NRC->selectOptionListHtml("x_NRC") ?>
    </select>
    <?= $Page->NRC->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
<?php if (!$Page->NRC->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarm_inspectionadd", function() {
    var options = { name: "x_NRC", selectId: "ffarm_inspectionadd_x_NRC" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarm_inspectionadd.lists.NRC?.lookupOptions.length) {
        options.data = { id: "x_NRC", form: "ffarm_inspectionadd" };
    } else {
        options.ajax = { id: "x_NRC", form: "ffarm_inspectionadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm_inspection.fields.NRC.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
    <div id="r_FarmerNo"<?= $Page->FarmerNo->rowAttributes() ?>>
        <label id="elh_farm_inspection_FarmerNo" for="x_FarmerNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmerNo->caption() ?><?= $Page->FarmerNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmerNo->cellAttributes() ?>>
<span id="el_farm_inspection_FarmerNo">
<input type="<?= $Page->FarmerNo->getInputTextType() ?>" name="x_FarmerNo" id="x_FarmerNo" data-table="farm_inspection" data-field="x_FarmerNo" value="<?= $Page->FarmerNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmerNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerNo->formatPattern()) ?>"<?= $Page->FarmerNo->editAttributes() ?> aria-describedby="x_FarmerNo_help">
<?= $Page->FarmerNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmerNo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
    <div id="r_FarmNo"<?= $Page->FarmNo->rowAttributes() ?>>
        <label id="elh_farm_inspection_FarmNo" for="x_FarmNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmNo->caption() ?><?= $Page->FarmNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmNo->cellAttributes() ?>>
<?php if ($Page->FarmNo->getSessionValue() != "") { ?>
<span<?= $Page->FarmNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FarmNo->getDisplayValue($Page->FarmNo->ViewValue))) ?>"></span>
<input type="hidden" id="x_FarmNo" name="x_FarmNo" value="<?= HtmlEncode($Page->FarmNo->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_inspection_FarmNo">
<input type="<?= $Page->FarmNo->getInputTextType() ?>" name="x_FarmNo" id="x_FarmNo" data-table="farm_inspection" data-field="x_FarmNo" value="<?= $Page->FarmNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmNo->formatPattern()) ?>"<?= $Page->FarmNo->editAttributes() ?> aria-describedby="x_FarmNo_help">
<?= $Page->FarmNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmNo->getErrorMessage() ?></div>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PlantsDead->Visible) { // PlantsDead ?>
    <div id="r_PlantsDead"<?= $Page->PlantsDead->rowAttributes() ?>>
        <label id="elh_farm_inspection_PlantsDead" for="x_PlantsDead" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PlantsDead->caption() ?><?= $Page->PlantsDead->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PlantsDead->cellAttributes() ?>>
<span id="el_farm_inspection_PlantsDead">
<input type="<?= $Page->PlantsDead->getInputTextType() ?>" name="x_PlantsDead" id="x_PlantsDead" data-table="farm_inspection" data-field="x_PlantsDead" value="<?= $Page->PlantsDead->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsDead->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsDead->formatPattern()) ?>"<?= $Page->PlantsDead->editAttributes() ?> aria-describedby="x_PlantsDead_help">
<?= $Page->PlantsDead->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PlantsDead->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PlantsVerifiedNo->Visible) { // PlantsVerifiedNo ?>
    <div id="r_PlantsVerifiedNo"<?= $Page->PlantsVerifiedNo->rowAttributes() ?>>
        <label id="elh_farm_inspection_PlantsVerifiedNo" for="x_PlantsVerifiedNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PlantsVerifiedNo->caption() ?><?= $Page->PlantsVerifiedNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PlantsVerifiedNo->cellAttributes() ?>>
<span id="el_farm_inspection_PlantsVerifiedNo">
<input type="<?= $Page->PlantsVerifiedNo->getInputTextType() ?>" name="x_PlantsVerifiedNo" id="x_PlantsVerifiedNo" data-table="farm_inspection" data-field="x_PlantsVerifiedNo" value="<?= $Page->PlantsVerifiedNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsVerifiedNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsVerifiedNo->formatPattern()) ?>"<?= $Page->PlantsVerifiedNo->editAttributes() ?> aria-describedby="x_PlantsVerifiedNo_help">
<?= $Page->PlantsVerifiedNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PlantsVerifiedNo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PlantsReplaced->Visible) { // PlantsReplaced ?>
    <div id="r_PlantsReplaced"<?= $Page->PlantsReplaced->rowAttributes() ?>>
        <label id="elh_farm_inspection_PlantsReplaced" for="x_PlantsReplaced" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PlantsReplaced->caption() ?><?= $Page->PlantsReplaced->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PlantsReplaced->cellAttributes() ?>>
<span id="el_farm_inspection_PlantsReplaced">
<input type="<?= $Page->PlantsReplaced->getInputTextType() ?>" name="x_PlantsReplaced" id="x_PlantsReplaced" data-table="farm_inspection" data-field="x_PlantsReplaced" value="<?= $Page->PlantsReplaced->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlantsReplaced->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlantsReplaced->formatPattern()) ?>"<?= $Page->PlantsReplaced->editAttributes() ?> aria-describedby="x_PlantsReplaced_help">
<?= $Page->PlantsReplaced->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PlantsReplaced->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FungicidesReceived->Visible) { // FungicidesReceived ?>
    <div id="r_FungicidesReceived"<?= $Page->FungicidesReceived->rowAttributes() ?>>
        <label id="elh_farm_inspection_FungicidesReceived" for="x_FungicidesReceived" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FungicidesReceived->caption() ?><?= $Page->FungicidesReceived->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FungicidesReceived->cellAttributes() ?>>
<span id="el_farm_inspection_FungicidesReceived">
<input type="<?= $Page->FungicidesReceived->getInputTextType() ?>" name="x_FungicidesReceived" id="x_FungicidesReceived" data-table="farm_inspection" data-field="x_FungicidesReceived" value="<?= $Page->FungicidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FungicidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FungicidesReceived->formatPattern()) ?>"<?= $Page->FungicidesReceived->editAttributes() ?> aria-describedby="x_FungicidesReceived_help">
<?= $Page->FungicidesReceived->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FungicidesReceived->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PescticidesReceived->Visible) { // PescticidesReceived ?>
    <div id="r_PescticidesReceived"<?= $Page->PescticidesReceived->rowAttributes() ?>>
        <label id="elh_farm_inspection_PescticidesReceived" for="x_PescticidesReceived" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PescticidesReceived->caption() ?><?= $Page->PescticidesReceived->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PescticidesReceived->cellAttributes() ?>>
<span id="el_farm_inspection_PescticidesReceived">
<input type="<?= $Page->PescticidesReceived->getInputTextType() ?>" name="x_PescticidesReceived" id="x_PescticidesReceived" data-table="farm_inspection" data-field="x_PescticidesReceived" value="<?= $Page->PescticidesReceived->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PescticidesReceived->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PescticidesReceived->formatPattern()) ?>"<?= $Page->PescticidesReceived->editAttributes() ?> aria-describedby="x_PescticidesReceived_help">
<?= $Page->PescticidesReceived->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PescticidesReceived->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DiseasePresence->Visible) { // DiseasePresence ?>
    <div id="r_DiseasePresence"<?= $Page->DiseasePresence->rowAttributes() ?>>
        <label id="elh_farm_inspection_DiseasePresence" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DiseasePresence->caption() ?><?= $Page->DiseasePresence->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DiseasePresence->cellAttributes() ?>>
<span id="el_farm_inspection_DiseasePresence">
<template id="tp_x_DiseasePresence">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="farm_inspection" data-field="x_DiseasePresence" name="x_DiseasePresence" id="x_DiseasePresence"<?= $Page->DiseasePresence->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_DiseasePresence" class="ew-item-list"></div>
<selection-list hidden
    id="x_DiseasePresence[]"
    name="x_DiseasePresence[]"
    value="<?= HtmlEncode($Page->DiseasePresence->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_DiseasePresence"
    data-target="dsl_x_DiseasePresence"
    data-repeatcolumn="5"
    class="form-control<?= $Page->DiseasePresence->isInvalidClass() ?>"
    data-table="farm_inspection"
    data-field="x_DiseasePresence"
    data-value-separator="<?= $Page->DiseasePresence->displayValueSeparatorAttribute() ?>"
    <?= $Page->DiseasePresence->editAttributes() ?>></selection-list>
<?= $Page->DiseasePresence->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DiseasePresence->getErrorMessage() ?></div>
<?= $Page->DiseasePresence->Lookup->getParamTag($Page, "p_x_DiseasePresence") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->AvailableLand->Visible) { // AvailableLand ?>
    <div id="r_AvailableLand"<?= $Page->AvailableLand->rowAttributes() ?>>
        <label id="elh_farm_inspection_AvailableLand" for="x_AvailableLand" class="<?= $Page->LeftColumnClass ?>"><?= $Page->AvailableLand->caption() ?><?= $Page->AvailableLand->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->AvailableLand->cellAttributes() ?>>
<span id="el_farm_inspection_AvailableLand">
<input type="<?= $Page->AvailableLand->getInputTextType() ?>" name="x_AvailableLand" id="x_AvailableLand" data-table="farm_inspection" data-field="x_AvailableLand" value="<?= $Page->AvailableLand->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->AvailableLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AvailableLand->formatPattern()) ?>"<?= $Page->AvailableLand->editAttributes() ?> aria-describedby="x_AvailableLand_help">
<?= $Page->AvailableLand->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->AvailableLand->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->LandForCashewCleared->Visible) { // LandForCashewCleared ?>
    <div id="r_LandForCashewCleared"<?= $Page->LandForCashewCleared->rowAttributes() ?>>
        <label id="elh_farm_inspection_LandForCashewCleared" for="x_LandForCashewCleared" class="<?= $Page->LeftColumnClass ?>"><?= $Page->LandForCashewCleared->caption() ?><?= $Page->LandForCashewCleared->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->LandForCashewCleared->cellAttributes() ?>>
<span id="el_farm_inspection_LandForCashewCleared">
<input type="<?= $Page->LandForCashewCleared->getInputTextType() ?>" name="x_LandForCashewCleared" id="x_LandForCashewCleared" data-table="farm_inspection" data-field="x_LandForCashewCleared" value="<?= $Page->LandForCashewCleared->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->LandForCashewCleared->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LandForCashewCleared->formatPattern()) ?>"<?= $Page->LandForCashewCleared->editAttributes() ?> aria-describedby="x_LandForCashewCleared_help">
<?= $Page->LandForCashewCleared->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->LandForCashewCleared->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->HolesDug->Visible) { // HolesDug ?>
    <div id="r_HolesDug"<?= $Page->HolesDug->rowAttributes() ?>>
        <label id="elh_farm_inspection_HolesDug" for="x_HolesDug" class="<?= $Page->LeftColumnClass ?>"><?= $Page->HolesDug->caption() ?><?= $Page->HolesDug->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->HolesDug->cellAttributes() ?>>
<span id="el_farm_inspection_HolesDug">
<input type="<?= $Page->HolesDug->getInputTextType() ?>" name="x_HolesDug" id="x_HolesDug" data-table="farm_inspection" data-field="x_HolesDug" value="<?= $Page->HolesDug->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->HolesDug->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->HolesDug->formatPattern()) ?>"<?= $Page->HolesDug->editAttributes() ?> aria-describedby="x_HolesDug_help">
<?= $Page->HolesDug->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->HolesDug->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VerifiedSeedlingArea->Visible) { // VerifiedSeedlingArea ?>
    <div id="r_VerifiedSeedlingArea"<?= $Page->VerifiedSeedlingArea->rowAttributes() ?>>
        <label id="elh_farm_inspection_VerifiedSeedlingArea" for="x_VerifiedSeedlingArea" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VerifiedSeedlingArea->caption() ?><?= $Page->VerifiedSeedlingArea->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VerifiedSeedlingArea->cellAttributes() ?>>
<span id="el_farm_inspection_VerifiedSeedlingArea">
<input type="<?= $Page->VerifiedSeedlingArea->getInputTextType() ?>" name="x_VerifiedSeedlingArea" id="x_VerifiedSeedlingArea" data-table="farm_inspection" data-field="x_VerifiedSeedlingArea" value="<?= $Page->VerifiedSeedlingArea->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->VerifiedSeedlingArea->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->VerifiedSeedlingArea->formatPattern()) ?>"<?= $Page->VerifiedSeedlingArea->editAttributes() ?> aria-describedby="x_VerifiedSeedlingArea_help">
<?= $Page->VerifiedSeedlingArea->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->VerifiedSeedlingArea->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->OldTreesNo->Visible) { // OldTreesNo ?>
    <div id="r_OldTreesNo"<?= $Page->OldTreesNo->rowAttributes() ?>>
        <label id="elh_farm_inspection_OldTreesNo" for="x_OldTreesNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->OldTreesNo->caption() ?><?= $Page->OldTreesNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->OldTreesNo->cellAttributes() ?>>
<span id="el_farm_inspection_OldTreesNo">
<input type="<?= $Page->OldTreesNo->getInputTextType() ?>" name="x_OldTreesNo" id="x_OldTreesNo" data-table="farm_inspection" data-field="x_OldTreesNo" value="<?= $Page->OldTreesNo->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->OldTreesNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OldTreesNo->formatPattern()) ?>"<?= $Page->OldTreesNo->editAttributes() ?> aria-describedby="x_OldTreesNo_help">
<?= $Page->OldTreesNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->OldTreesNo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->InspectionReport->Visible) { // InspectionReport ?>
    <div id="r_InspectionReport"<?= $Page->InspectionReport->rowAttributes() ?>>
        <label id="elh_farm_inspection_InspectionReport" for="x_InspectionReport" class="<?= $Page->LeftColumnClass ?>"><?= $Page->InspectionReport->caption() ?><?= $Page->InspectionReport->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->InspectionReport->cellAttributes() ?>>
<span id="el_farm_inspection_InspectionReport">
<textarea data-table="farm_inspection" data-field="x_InspectionReport" name="x_InspectionReport" id="x_InspectionReport" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->InspectionReport->getPlaceHolder()) ?>"<?= $Page->InspectionReport->editAttributes() ?> aria-describedby="x_InspectionReport_help"><?= $Page->InspectionReport->EditValue ?></textarea>
<?= $Page->InspectionReport->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->InspectionReport->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->InspectionDate->Visible) { // InspectionDate ?>
    <div id="r_InspectionDate"<?= $Page->InspectionDate->rowAttributes() ?>>
        <label id="elh_farm_inspection_InspectionDate" for="x_InspectionDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->InspectionDate->caption() ?><?= $Page->InspectionDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->InspectionDate->cellAttributes() ?>>
<span id="el_farm_inspection_InspectionDate">
<input type="<?= $Page->InspectionDate->getInputTextType() ?>" name="x_InspectionDate" id="x_InspectionDate" data-table="farm_inspection" data-field="x_InspectionDate" value="<?= $Page->InspectionDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->InspectionDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InspectionDate->formatPattern()) ?>"<?= $Page->InspectionDate->editAttributes() ?> aria-describedby="x_InspectionDate_help">
<?= $Page->InspectionDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->InspectionDate->getErrorMessage() ?></div>
<?php if (!$Page->InspectionDate->ReadOnly && !$Page->InspectionDate->Disabled && !isset($Page->InspectionDate->EditAttrs["readonly"]) && !isset($Page->InspectionDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffarm_inspectionadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffarm_inspectionadd", "x_InspectionDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->InspectedBy->Visible) { // InspectedBy ?>
    <div id="r_InspectedBy"<?= $Page->InspectedBy->rowAttributes() ?>>
        <label id="elh_farm_inspection_InspectedBy" for="x_InspectedBy" class="<?= $Page->LeftColumnClass ?>"><?= $Page->InspectedBy->caption() ?><?= $Page->InspectedBy->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->InspectedBy->cellAttributes() ?>>
<span id="el_farm_inspection_InspectedBy">
<input type="<?= $Page->InspectedBy->getInputTextType() ?>" name="x_InspectedBy" id="x_InspectedBy" data-table="farm_inspection" data-field="x_InspectedBy" value="<?= $Page->InspectedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->InspectedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InspectedBy->formatPattern()) ?>"<?= $Page->InspectedBy->editAttributes() ?> aria-describedby="x_InspectedBy_help">
<?= $Page->InspectedBy->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->InspectedBy->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->AuthorisedBy->Visible) { // AuthorisedBy ?>
    <div id="r_AuthorisedBy"<?= $Page->AuthorisedBy->rowAttributes() ?>>
        <label id="elh_farm_inspection_AuthorisedBy" for="x_AuthorisedBy" class="<?= $Page->LeftColumnClass ?>"><?= $Page->AuthorisedBy->caption() ?><?= $Page->AuthorisedBy->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->AuthorisedBy->cellAttributes() ?>>
<span id="el_farm_inspection_AuthorisedBy">
<input type="<?= $Page->AuthorisedBy->getInputTextType() ?>" name="x_AuthorisedBy" id="x_AuthorisedBy" data-table="farm_inspection" data-field="x_AuthorisedBy" value="<?= $Page->AuthorisedBy->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->AuthorisedBy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AuthorisedBy->formatPattern()) ?>"<?= $Page->AuthorisedBy->editAttributes() ?> aria-describedby="x_AuthorisedBy_help">
<?= $Page->AuthorisedBy->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->AuthorisedBy->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffarm_inspectionadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarm_inspectionadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm_inspection");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
