<?php

namespace PHPMaker2024\cidp24;

// Page object
$FarmAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { farm: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ffarmadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffarmadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FieldType", [fields.FieldType.visible && fields.FieldType.required ? ew.Validators.required(fields.FieldType.caption) : null], fields.FieldType.isInvalid],
            ["Ownership", [fields.Ownership.visible && fields.Ownership.required ? ew.Validators.required(fields.Ownership.caption) : null], fields.Ownership.isInvalid],
            ["FarmSizeEstimated", [fields.FarmSizeEstimated.visible && fields.FarmSizeEstimated.required ? ew.Validators.required(fields.FarmSizeEstimated.caption) : null, ew.Validators.float], fields.FarmSizeEstimated.isInvalid],
            ["FarmSizeVerified", [fields.FarmSizeVerified.visible && fields.FarmSizeVerified.required ? ew.Validators.required(fields.FarmSizeVerified.caption) : null, ew.Validators.float], fields.FarmSizeVerified.isInvalid],
            ["TreesPlantedVerified", [fields.TreesPlantedVerified.visible && fields.TreesPlantedVerified.required ? ew.Validators.required(fields.TreesPlantedVerified.caption) : null, ew.Validators.float], fields.TreesPlantedVerified.isInvalid],
            ["SourcesOfSeedlings", [fields.SourcesOfSeedlings.visible && fields.SourcesOfSeedlings.required ? ew.Validators.required(fields.SourcesOfSeedlings.caption) : null], fields.SourcesOfSeedlings.isInvalid],
            ["InspecationReport", [fields.InspecationReport.visible && fields.InspecationReport.required ? ew.Validators.required(fields.InspecationReport.caption) : null], fields.InspecationReport.isInvalid],
            ["ClearedLand", [fields.ClearedLand.visible && fields.ClearedLand.required ? ew.Validators.required(fields.ClearedLand.caption) : null], fields.ClearedLand.isInvalid],
            ["OldTrees", [fields.OldTrees.visible && fields.OldTrees.required ? ew.Validators.required(fields.OldTrees.caption) : null], fields.OldTrees.isInvalid],
            ["FarmSize", [fields.FarmSize.visible && fields.FarmSize.required ? ew.Validators.required(fields.FarmSize.caption) : null], fields.FarmSize.isInvalid],
            ["Latitude", [fields.Latitude.visible && fields.Latitude.required ? ew.Validators.required(fields.Latitude.caption) : null, ew.Validators.float], fields.Latitude.isInvalid],
            ["Longitude", [fields.Longitude.visible && fields.Longitude.required ? ew.Validators.required(fields.Longitude.caption) : null, ew.Validators.float], fields.Longitude.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "NRC": <?= $Page->NRC->toClientList($Page) ?>,
            "FieldType": <?= $Page->FieldType->toClientList($Page) ?>,
            "Ownership": <?= $Page->Ownership->toClientList($Page) ?>,
            "SourcesOfSeedlings": <?= $Page->SourcesOfSeedlings->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Client script
    // Write your client script here, no need to add script tags.
    function success(position) {
    var latitude = position.coords.latitude;
    var longitude = position.coords.longitude;
    $("#x_Latitude").val(latitude);
    $("#x_Longitude").val(longitude);
    };

    function error() {
    $("#x_Latitude").val("");
    $("#x_Longitude").val("");
    };
    navigator.geolocation.getCurrentPosition(success, error);
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffarmadd" id="ffarmadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="farm">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "farmer") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="farmer">
<input type="hidden" name="fk_NRC" value="<?= HtmlEncode($Page->NRC->getSessionValue()) ?>">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "village") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="village">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<input type="hidden" name="fk_VillageCode" value="<?= HtmlEncode($Page->VillageCode->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_farm_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x_ProvinceCode" name="x_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_ProvinceCode">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ffarmadd_x_ProvinceCode"
        <?php } ?>
        data-table="farm"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <?= $Page->ProvinceCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmadd", function() {
    var options = { name: "x_ProvinceCode", selectId: "ffarmadd_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmadd.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ffarmadd" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ffarmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_farm_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x_DistrictCode" name="x_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="ffarmadd_x_DistrictCode"
        data-table="farm"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<script>
loadjs.ready("ffarmadd", function() {
    var options = { name: "x_DistrictCode", selectId: "ffarmadd_x_DistrictCode" };
    if (ffarmadd.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ffarmadd" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ffarmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <label id="elh_farm_CampCode" for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CampCode->caption() ?><?= $Page->CampCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x_CampCode" name="x_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_CampCode">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="ffarmadd_x_CampCode"
        data-table="farm"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <?= $Page->CampCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("ffarmadd", function() {
    var options = { name: "x_CampCode", selectId: "ffarmadd_x_CampCode" };
    if (ffarmadd.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ffarmadd" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ffarmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <label id="elh_farm_VillageCode" for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VillageCode->caption() ?><?= $Page->VillageCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->VillageCode->getSessionValue() != "") { ?>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->VillageCode->getDisplayValue($Page->VillageCode->ViewValue) ?></span></span>
<input type="hidden" id="x_VillageCode" name="x_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_VillageCode">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="ffarmadd_x_VillageCode"
        data-table="farm"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <?= $Page->VillageCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("ffarmadd", function() {
    var options = { name: "x_VillageCode", selectId: "ffarmadd_x_VillageCode" };
    if (ffarmadd.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ffarmadd" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ffarmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.farm.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_farm_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->NRC->getSessionValue() != "") { ?>
<span<?= $Page->NRC->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->NRC->getDisplayValue($Page->NRC->ViewValue) ?></span></span>
<input type="hidden" id="x_NRC" name="x_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_farm_NRC">
<?php
if (IsRTL()) {
    $Page->NRC->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_NRC" class="ew-auto-suggest">
    <input type="<?= $Page->NRC->getInputTextType() ?>" class="form-control" name="sv_x_NRC" id="sv_x_NRC" value="<?= RemoveHtml($Page->NRC->EditValue) ?>" autocomplete="off" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?> aria-describedby="x_NRC_help">
</span>
<selection-list hidden class="form-control" data-table="farm" data-field="x_NRC" data-input="sv_x_NRC" data-value-separator="<?= $Page->NRC->displayValueSeparatorAttribute() ?>" name="x_NRC" id="x_NRC" value="<?= HtmlEncode($Page->NRC->CurrentValue) ?>"></selection-list>
<?= $Page->NRC->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
<script>
loadjs.ready("ffarmadd", function() {
    ffarmadd.createAutoSuggest(Object.assign({"id":"x_NRC","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->NRC->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.farm.fields.NRC.autoSuggestOptions));
});
</script>
<?= $Page->NRC->Lookup->getParamTag($Page, "p_x_NRC") ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
    <div id="r_FieldType"<?= $Page->FieldType->rowAttributes() ?>>
        <label id="elh_farm_FieldType" for="x_FieldType" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FieldType->caption() ?><?= $Page->FieldType->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FieldType->cellAttributes() ?>>
<span id="el_farm_FieldType">
    <select
        id="x_FieldType"
        name="x_FieldType"
        class="form-select ew-select<?= $Page->FieldType->isInvalidClass() ?>"
        <?php if (!$Page->FieldType->IsNativeSelect) { ?>
        data-select2-id="ffarmadd_x_FieldType"
        <?php } ?>
        data-table="farm"
        data-field="x_FieldType"
        data-value-separator="<?= $Page->FieldType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->FieldType->getPlaceHolder()) ?>"
        <?= $Page->FieldType->editAttributes() ?>>
        <?= $Page->FieldType->selectOptionListHtml("x_FieldType") ?>
    </select>
    <?= $Page->FieldType->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->FieldType->getErrorMessage() ?></div>
<?= $Page->FieldType->Lookup->getParamTag($Page, "p_x_FieldType") ?>
<?php if (!$Page->FieldType->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmadd", function() {
    var options = { name: "x_FieldType", selectId: "ffarmadd_x_FieldType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmadd.lists.FieldType?.lookupOptions.length) {
        options.data = { id: "x_FieldType", form: "ffarmadd" };
    } else {
        options.ajax = { id: "x_FieldType", form: "ffarmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.FieldType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Ownership->Visible) { // Ownership ?>
    <div id="r_Ownership"<?= $Page->Ownership->rowAttributes() ?>>
        <label id="elh_farm_Ownership" for="x_Ownership" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Ownership->caption() ?><?= $Page->Ownership->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Ownership->cellAttributes() ?>>
<span id="el_farm_Ownership">
    <select
        id="x_Ownership"
        name="x_Ownership"
        class="form-select ew-select<?= $Page->Ownership->isInvalidClass() ?>"
        <?php if (!$Page->Ownership->IsNativeSelect) { ?>
        data-select2-id="ffarmadd_x_Ownership"
        <?php } ?>
        data-table="farm"
        data-field="x_Ownership"
        data-value-separator="<?= $Page->Ownership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Ownership->getPlaceHolder()) ?>"
        <?= $Page->Ownership->editAttributes() ?>>
        <?= $Page->Ownership->selectOptionListHtml("x_Ownership") ?>
    </select>
    <?= $Page->Ownership->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Ownership->getErrorMessage() ?></div>
<?= $Page->Ownership->Lookup->getParamTag($Page, "p_x_Ownership") ?>
<?php if (!$Page->Ownership->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmadd", function() {
    var options = { name: "x_Ownership", selectId: "ffarmadd_x_Ownership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmadd.lists.Ownership?.lookupOptions.length) {
        options.data = { id: "x_Ownership", form: "ffarmadd" };
    } else {
        options.ajax = { id: "x_Ownership", form: "ffarmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.Ownership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
    <div id="r_FarmSizeEstimated"<?= $Page->FarmSizeEstimated->rowAttributes() ?>>
        <label id="elh_farm_FarmSizeEstimated" for="x_FarmSizeEstimated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmSizeEstimated->caption() ?><?= $Page->FarmSizeEstimated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span id="el_farm_FarmSizeEstimated">
<input type="<?= $Page->FarmSizeEstimated->getInputTextType() ?>" name="x_FarmSizeEstimated" id="x_FarmSizeEstimated" data-table="farm" data-field="x_FarmSizeEstimated" value="<?= $Page->FarmSizeEstimated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmSizeEstimated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSizeEstimated->formatPattern()) ?>"<?= $Page->FarmSizeEstimated->editAttributes() ?> aria-describedby="x_FarmSizeEstimated_help">
<?= $Page->FarmSizeEstimated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmSizeEstimated->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
    <div id="r_FarmSizeVerified"<?= $Page->FarmSizeVerified->rowAttributes() ?>>
        <label id="elh_farm_FarmSizeVerified" for="x_FarmSizeVerified" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmSizeVerified->caption() ?><?= $Page->FarmSizeVerified->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span id="el_farm_FarmSizeVerified">
<input type="<?= $Page->FarmSizeVerified->getInputTextType() ?>" name="x_FarmSizeVerified" id="x_FarmSizeVerified" data-table="farm" data-field="x_FarmSizeVerified" value="<?= $Page->FarmSizeVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmSizeVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSizeVerified->formatPattern()) ?>"<?= $Page->FarmSizeVerified->editAttributes() ?> aria-describedby="x_FarmSizeVerified_help">
<?= $Page->FarmSizeVerified->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmSizeVerified->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
    <div id="r_TreesPlantedVerified"<?= $Page->TreesPlantedVerified->rowAttributes() ?>>
        <label id="elh_farm_TreesPlantedVerified" for="x_TreesPlantedVerified" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TreesPlantedVerified->caption() ?><?= $Page->TreesPlantedVerified->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span id="el_farm_TreesPlantedVerified">
<input type="<?= $Page->TreesPlantedVerified->getInputTextType() ?>" name="x_TreesPlantedVerified" id="x_TreesPlantedVerified" data-table="farm" data-field="x_TreesPlantedVerified" value="<?= $Page->TreesPlantedVerified->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesPlantedVerified->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesPlantedVerified->formatPattern()) ?>"<?= $Page->TreesPlantedVerified->editAttributes() ?> aria-describedby="x_TreesPlantedVerified_help">
<?= $Page->TreesPlantedVerified->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->TreesPlantedVerified->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
    <div id="r_SourcesOfSeedlings"<?= $Page->SourcesOfSeedlings->rowAttributes() ?>>
        <label id="elh_farm_SourcesOfSeedlings" for="x_SourcesOfSeedlings" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SourcesOfSeedlings->caption() ?><?= $Page->SourcesOfSeedlings->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SourcesOfSeedlings->cellAttributes() ?>>
<span id="el_farm_SourcesOfSeedlings">
    <select
        id="x_SourcesOfSeedlings"
        name="x_SourcesOfSeedlings"
        class="form-select ew-select<?= $Page->SourcesOfSeedlings->isInvalidClass() ?>"
        <?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
        data-select2-id="ffarmadd_x_SourcesOfSeedlings"
        <?php } ?>
        data-table="farm"
        data-field="x_SourcesOfSeedlings"
        data-value-separator="<?= $Page->SourcesOfSeedlings->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SourcesOfSeedlings->getPlaceHolder()) ?>"
        <?= $Page->SourcesOfSeedlings->editAttributes() ?>>
        <?= $Page->SourcesOfSeedlings->selectOptionListHtml("x_SourcesOfSeedlings") ?>
    </select>
    <?= $Page->SourcesOfSeedlings->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->SourcesOfSeedlings->getErrorMessage() ?></div>
<?= $Page->SourcesOfSeedlings->Lookup->getParamTag($Page, "p_x_SourcesOfSeedlings") ?>
<?php if (!$Page->SourcesOfSeedlings->IsNativeSelect) { ?>
<script>
loadjs.ready("ffarmadd", function() {
    var options = { name: "x_SourcesOfSeedlings", selectId: "ffarmadd_x_SourcesOfSeedlings" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffarmadd.lists.SourcesOfSeedlings?.lookupOptions.length) {
        options.data = { id: "x_SourcesOfSeedlings", form: "ffarmadd" };
    } else {
        options.ajax = { id: "x_SourcesOfSeedlings", form: "ffarmadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.farm.fields.SourcesOfSeedlings.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->InspecationReport->Visible) { // InspecationReport ?>
    <div id="r_InspecationReport"<?= $Page->InspecationReport->rowAttributes() ?>>
        <label id="elh_farm_InspecationReport" for="x_InspecationReport" class="<?= $Page->LeftColumnClass ?>"><?= $Page->InspecationReport->caption() ?><?= $Page->InspecationReport->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->InspecationReport->cellAttributes() ?>>
<span id="el_farm_InspecationReport">
<textarea data-table="farm" data-field="x_InspecationReport" name="x_InspecationReport" id="x_InspecationReport" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->InspecationReport->getPlaceHolder()) ?>"<?= $Page->InspecationReport->editAttributes() ?> aria-describedby="x_InspecationReport_help"><?= $Page->InspecationReport->EditValue ?></textarea>
<?= $Page->InspecationReport->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->InspecationReport->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ClearedLand->Visible) { // ClearedLand ?>
    <div id="r_ClearedLand"<?= $Page->ClearedLand->rowAttributes() ?>>
        <label id="elh_farm_ClearedLand" for="x_ClearedLand" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ClearedLand->caption() ?><?= $Page->ClearedLand->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ClearedLand->cellAttributes() ?>>
<span id="el_farm_ClearedLand">
<input type="<?= $Page->ClearedLand->getInputTextType() ?>" name="x_ClearedLand" id="x_ClearedLand" data-table="farm" data-field="x_ClearedLand" value="<?= $Page->ClearedLand->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->ClearedLand->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearedLand->formatPattern()) ?>"<?= $Page->ClearedLand->editAttributes() ?> aria-describedby="x_ClearedLand_help">
<?= $Page->ClearedLand->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ClearedLand->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->OldTrees->Visible) { // OldTrees ?>
    <div id="r_OldTrees"<?= $Page->OldTrees->rowAttributes() ?>>
        <label id="elh_farm_OldTrees" for="x_OldTrees" class="<?= $Page->LeftColumnClass ?>"><?= $Page->OldTrees->caption() ?><?= $Page->OldTrees->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->OldTrees->cellAttributes() ?>>
<span id="el_farm_OldTrees">
<input type="<?= $Page->OldTrees->getInputTextType() ?>" name="x_OldTrees" id="x_OldTrees" data-table="farm" data-field="x_OldTrees" value="<?= $Page->OldTrees->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->OldTrees->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OldTrees->formatPattern()) ?>"<?= $Page->OldTrees->editAttributes() ?> aria-describedby="x_OldTrees_help">
<?= $Page->OldTrees->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->OldTrees->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FarmSize->Visible) { // FarmSize ?>
    <div id="r_FarmSize"<?= $Page->FarmSize->rowAttributes() ?>>
        <label id="elh_farm_FarmSize" for="x_FarmSize" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FarmSize->caption() ?><?= $Page->FarmSize->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FarmSize->cellAttributes() ?>>
<span id="el_farm_FarmSize">
<input type="<?= $Page->FarmSize->getInputTextType() ?>" name="x_FarmSize" id="x_FarmSize" data-table="farm" data-field="x_FarmSize" value="<?= $Page->FarmSize->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmSize->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmSize->formatPattern()) ?>"<?= $Page->FarmSize->editAttributes() ?> aria-describedby="x_FarmSize_help">
<?= $Page->FarmSize->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FarmSize->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Latitude->Visible) { // Latitude ?>
    <div id="r_Latitude"<?= $Page->Latitude->rowAttributes() ?>>
        <label id="elh_farm_Latitude" for="x_Latitude" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Latitude->caption() ?><?= $Page->Latitude->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Latitude->cellAttributes() ?>>
<span id="el_farm_Latitude">
<input type="<?= $Page->Latitude->getInputTextType() ?>" name="x_Latitude" id="x_Latitude" data-table="farm" data-field="x_Latitude" value="<?= $Page->Latitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Latitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Latitude->formatPattern()) ?>"<?= $Page->Latitude->editAttributes() ?> aria-describedby="x_Latitude_help">
<?= $Page->Latitude->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Latitude->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Longitude->Visible) { // Longitude ?>
    <div id="r_Longitude"<?= $Page->Longitude->rowAttributes() ?>>
        <label id="elh_farm_Longitude" for="x_Longitude" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Longitude->caption() ?><?= $Page->Longitude->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Longitude->cellAttributes() ?>>
<span id="el_farm_Longitude">
<input type="<?= $Page->Longitude->getInputTextType() ?>" name="x_Longitude" id="x_Longitude" data-table="farm" data-field="x_Longitude" value="<?= $Page->Longitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Longitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Longitude->formatPattern()) ?>"<?= $Page->Longitude->editAttributes() ?> aria-describedby="x_Longitude_help">
<?= $Page->Longitude->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Longitude->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<?php
    $Page->DetailPages->ValidKeys = explode(",", $Page->getCurrentDetailTable());
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav<?= $Page->DetailPages->containerClasses() ?>" id="details_Page"><!-- tabs -->
    <ul class="<?= $Page->DetailPages->navClasses() ?>" role="tablist"><!-- .nav -->
<?php
    if (in_array("farm_seed_allocate", explode(",", $Page->getCurrentDetailTable())) && $farm_seed_allocate->DetailAdd) {
?>
        <li class="nav-item"><button class="<?= $Page->DetailPages->navLinkClasses("farm_seed_allocate") ?><?= $Page->DetailPages->activeClasses("farm_seed_allocate") ?>" data-bs-target="#tab_farm_seed_allocate" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_farm_seed_allocate" aria-selected="<?= JsonEncode($Page->DetailPages->isActive("farm_seed_allocate")) ?>"><?= $Language->tablePhrase("farm_seed_allocate", "TblCaption") ?></button></li>
<?php
    }
?>
<?php
    if (in_array("farm_inspection", explode(",", $Page->getCurrentDetailTable())) && $farm_inspection->DetailAdd) {
?>
        <li class="nav-item"><button class="<?= $Page->DetailPages->navLinkClasses("farm_inspection") ?><?= $Page->DetailPages->activeClasses("farm_inspection") ?>" data-bs-target="#tab_farm_inspection" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_farm_inspection" aria-selected="<?= JsonEncode($Page->DetailPages->isActive("farm_inspection")) ?>"><?= $Language->tablePhrase("farm_inspection", "TblCaption") ?></button></li>
<?php
    }
?>
<?php
    if (in_array("production_sales", explode(",", $Page->getCurrentDetailTable())) && $production_sales->DetailAdd) {
?>
        <li class="nav-item"><button class="<?= $Page->DetailPages->navLinkClasses("production_sales") ?><?= $Page->DetailPages->activeClasses("production_sales") ?>" data-bs-target="#tab_production_sales" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_production_sales" aria-selected="<?= JsonEncode($Page->DetailPages->isActive("production_sales")) ?>"><?= $Language->tablePhrase("production_sales", "TblCaption") ?></button></li>
<?php
    }
?>
    </ul><!-- /.nav -->
    <div class="<?= $Page->DetailPages->tabContentClasses() ?>"><!-- .tab-content -->
<?php
    if (in_array("farm_seed_allocate", explode(",", $Page->getCurrentDetailTable())) && $farm_seed_allocate->DetailAdd) {
?>
        <div class="<?= $Page->DetailPages->tabPaneClasses("farm_seed_allocate") ?><?= $Page->DetailPages->activeClasses("farm_seed_allocate") ?>" id="tab_farm_seed_allocate" role="tabpanel"><!-- page* -->
<?php include_once "FarmSeedAllocateGrid.php" ?>
        </div><!-- /page* -->
<?php } ?>
<?php
    if (in_array("farm_inspection", explode(",", $Page->getCurrentDetailTable())) && $farm_inspection->DetailAdd) {
?>
        <div class="<?= $Page->DetailPages->tabPaneClasses("farm_inspection") ?><?= $Page->DetailPages->activeClasses("farm_inspection") ?>" id="tab_farm_inspection" role="tabpanel"><!-- page* -->
<?php include_once "FarmInspectionGrid.php" ?>
        </div><!-- /page* -->
<?php } ?>
<?php
    if (in_array("production_sales", explode(",", $Page->getCurrentDetailTable())) && $production_sales->DetailAdd) {
?>
        <div class="<?= $Page->DetailPages->tabPaneClasses("production_sales") ?><?= $Page->DetailPages->activeClasses("production_sales") ?>" id="tab_production_sales" role="tabpanel"><!-- page* -->
<?php include_once "ProductionSalesGrid.php" ?>
        </div><!-- /page* -->
<?php } ?>
    </div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffarmadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffarmadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("farm");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
