<?php

namespace PHPMaker2024\cidp24;

// Page object
$DistrictSummaryViewSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { district_summary_view: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fdistrict_summary_viewsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fdistrict_summary_viewsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["DistrictCode", [ew.Validators.integer], fields.DistrictCode.isInvalid],
            ["DistrictName", [], fields.DistrictName.isInvalid],
            ["AgeGroup", [], fields.AgeGroup.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["NoOfBeneficiaries", [ew.Validators.integer], fields.NoOfBeneficiaries.isInvalid],
            ["TreesAllocated", [ew.Validators.float], fields.TreesAllocated.isInvalid],
            ["FarmingSeason", [ew.Validators.integer], fields.FarmingSeason.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fdistrict_summary_viewsearch" id="fdistrict_summary_viewsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="district_summary_view">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode" class="row"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_district_summary_view_DistrictCode"><?= $Page->DistrictCode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_DistrictCode" id="z_DistrictCode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictCode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_district_summary_view_DistrictCode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DistrictCode->getInputTextType() ?>" name="x_DistrictCode" id="x_DistrictCode" data-table="district_summary_view" data-field="x_DistrictCode" value="<?= $Page->DistrictCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictCode->formatPattern()) ?>"<?= $Page->DistrictCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
    <div id="r_DistrictName" class="row"<?= $Page->DistrictName->rowAttributes() ?>>
        <label for="x_DistrictName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_district_summary_view_DistrictName"><?= $Page->DistrictName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_DistrictName" id="z_DistrictName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_district_summary_view_DistrictName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DistrictName->getInputTextType() ?>" name="x_DistrictName" id="x_DistrictName" data-table="district_summary_view" data-field="x_DistrictName" value="<?= $Page->DistrictName->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictName->formatPattern()) ?>"<?= $Page->DistrictName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { // AgeGroup ?>
    <div id="r_AgeGroup" class="row"<?= $Page->AgeGroup->rowAttributes() ?>>
        <label for="x_AgeGroup" class="<?= $Page->LeftColumnClass ?>"><span id="elh_district_summary_view_AgeGroup"><?= $Page->AgeGroup->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_AgeGroup" id="z_AgeGroup" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AgeGroup->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_district_summary_view_AgeGroup" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AgeGroup->getInputTextType() ?>" name="x_AgeGroup" id="x_AgeGroup" data-table="district_summary_view" data-field="x_AgeGroup" value="<?= $Page->AgeGroup->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->AgeGroup->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AgeGroup->formatPattern()) ?>"<?= $Page->AgeGroup->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AgeGroup->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender" class="row"<?= $Page->Gender->rowAttributes() ?>>
        <label for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_district_summary_view_Gender"><?= $Page->Gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Gender" id="z_Gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_district_summary_view_Gender" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Gender->getInputTextType() ?>" name="x_Gender" id="x_Gender" data-table="district_summary_view" data-field="x_Gender" value="<?= $Page->Gender->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Gender->formatPattern()) ?>"<?= $Page->Gender->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { // NoOfBeneficiaries ?>
    <div id="r_NoOfBeneficiaries" class="row"<?= $Page->NoOfBeneficiaries->rowAttributes() ?>>
        <label for="x_NoOfBeneficiaries" class="<?= $Page->LeftColumnClass ?>"><span id="elh_district_summary_view_NoOfBeneficiaries"><?= $Page->NoOfBeneficiaries->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_NoOfBeneficiaries" id="z_NoOfBeneficiaries" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NoOfBeneficiaries->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_district_summary_view_NoOfBeneficiaries" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NoOfBeneficiaries->getInputTextType() ?>" name="x_NoOfBeneficiaries" id="x_NoOfBeneficiaries" data-table="district_summary_view" data-field="x_NoOfBeneficiaries" value="<?= $Page->NoOfBeneficiaries->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->NoOfBeneficiaries->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NoOfBeneficiaries->formatPattern()) ?>"<?= $Page->NoOfBeneficiaries->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NoOfBeneficiaries->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
    <div id="r_TreesAllocated" class="row"<?= $Page->TreesAllocated->rowAttributes() ?>>
        <label for="x_TreesAllocated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_district_summary_view_TreesAllocated"><?= $Page->TreesAllocated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_TreesAllocated" id="z_TreesAllocated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TreesAllocated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_district_summary_view_TreesAllocated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesAllocated->getInputTextType() ?>" name="x_TreesAllocated" id="x_TreesAllocated" data-table="district_summary_view" data-field="x_TreesAllocated" value="<?= $Page->TreesAllocated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesAllocated->formatPattern()) ?>"<?= $Page->TreesAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesAllocated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
    <div id="r_FarmingSeason" class="row"<?= $Page->FarmingSeason->rowAttributes() ?>>
        <label for="x_FarmingSeason" class="<?= $Page->LeftColumnClass ?>"><span id="elh_district_summary_view_FarmingSeason"><?= $Page->FarmingSeason->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmingSeason" id="z_FarmingSeason" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmingSeason->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_district_summary_view_FarmingSeason" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmingSeason->getInputTextType() ?>" name="x_FarmingSeason" id="x_FarmingSeason" data-table="district_summary_view" data-field="x_FarmingSeason" value="<?= $Page->FarmingSeason->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmingSeason->formatPattern()) ?>"<?= $Page->FarmingSeason->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fdistrict_summary_viewsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fdistrict_summary_viewsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fdistrict_summary_viewsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("district_summary_view");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
