<?php

namespace PHPMaker2024\cidp24;

// Page object
$DistrictSummaryViewSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { district_summary_view: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fdistrict_summary_viewsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fdistrict_summary_viewsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["DistrictCode", [ew.Validators.integer], fields.DistrictCode.isInvalid],
            ["DistrictName", [], fields.DistrictName.isInvalid],
            ["AgeGroup", [], fields.AgeGroup.isInvalid],
            ["Gender", [], fields.Gender.isInvalid],
            ["NoOfBeneficiaries", [ew.Validators.integer], fields.NoOfBeneficiaries.isInvalid],
            ["TreesAllocated", [ew.Validators.float], fields.TreesAllocated.isInvalid],
            ["FarmingSeason", [ew.Validators.integer], fields.FarmingSeason.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fdistrict_summary_viewsearch" id="fdistrict_summary_viewsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("DistrictSummaryViewList")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="district_summary_view">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_district_summary_view_DistrictCode" class="district_summary_viewsearch"><span id="el_district_summary_view_DistrictCode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DistrictCode->getInputTextType() ?>" name="x_DistrictCode" id="x_DistrictCode" data-table="district_summary_view" data-field="x_DistrictCode" value="<?= $Page->DistrictCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictCode->formatPattern()) ?>"<?= $Page->DistrictCode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_district_summary_view_DistrictName" class="district_summary_viewsearch"><span id="el_district_summary_view_DistrictName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DistrictName->getInputTextType() ?>" name="x_DistrictName" id="x_DistrictName" data-table="district_summary_view" data-field="x_DistrictName" value="<?= $Page->DistrictName->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictName->formatPattern()) ?>"<?= $Page->DistrictName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_district_summary_view_AgeGroup" class="district_summary_viewsearch"><span id="el_district_summary_view_AgeGroup" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AgeGroup->getInputTextType() ?>" name="x_AgeGroup" id="x_AgeGroup" data-table="district_summary_view" data-field="x_AgeGroup" value="<?= $Page->AgeGroup->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->AgeGroup->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AgeGroup->formatPattern()) ?>"<?= $Page->AgeGroup->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AgeGroup->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_district_summary_view_Gender" class="district_summary_viewsearch"><span id="el_district_summary_view_Gender" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Gender->getInputTextType() ?>" name="x_Gender" id="x_Gender" data-table="district_summary_view" data-field="x_Gender" value="<?= $Page->Gender->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Gender->formatPattern()) ?>"<?= $Page->Gender->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_district_summary_view_NoOfBeneficiaries" class="district_summary_viewsearch"><span id="el_district_summary_view_NoOfBeneficiaries" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NoOfBeneficiaries->getInputTextType() ?>" name="x_NoOfBeneficiaries" id="x_NoOfBeneficiaries" data-table="district_summary_view" data-field="x_NoOfBeneficiaries" value="<?= $Page->NoOfBeneficiaries->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->NoOfBeneficiaries->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NoOfBeneficiaries->formatPattern()) ?>"<?= $Page->NoOfBeneficiaries->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NoOfBeneficiaries->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_district_summary_view_TreesAllocated" class="district_summary_viewsearch"><span id="el_district_summary_view_TreesAllocated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TreesAllocated->getInputTextType() ?>" name="x_TreesAllocated" id="x_TreesAllocated" data-table="district_summary_view" data-field="x_TreesAllocated" value="<?= $Page->TreesAllocated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->TreesAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TreesAllocated->formatPattern()) ?>"<?= $Page->TreesAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TreesAllocated->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_district_summary_view_FarmingSeason" class="district_summary_viewsearch"><span id="el_district_summary_view_FarmingSeason" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmingSeason->getInputTextType() ?>" name="x_FarmingSeason" id="x_FarmingSeason" data-table="district_summary_view" data-field="x_FarmingSeason" value="<?= $Page->FarmingSeason->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmingSeason->formatPattern()) ?>"<?= $Page->FarmingSeason->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage(false) ?></div>
</span></template>
<div id="district_summary_view_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "DistrictCode",
                type: "integer",
                label: currentTable.fields.DistrictCode.caption,
                operators: currentTable.fields.DistrictCode.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fdistrict_summary_viewsearch.fields.DistrictCode.validators),
                data: {
                    format: currentTable.fields.DistrictCode.clientFormatPattern
                }
            },
            {
                id: "DistrictName",
                type: "string",
                label: currentTable.fields.DistrictName.caption,
                operators: currentTable.fields.DistrictName.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fdistrict_summary_viewsearch.fields.DistrictName.validators),
                data: {
                    format: currentTable.fields.DistrictName.clientFormatPattern
                }
            },
            {
                id: "AgeGroup",
                type: "string",
                label: currentTable.fields.AgeGroup.caption,
                operators: currentTable.fields.AgeGroup.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fdistrict_summary_viewsearch.fields.AgeGroup.validators),
                data: {
                    format: currentTable.fields.AgeGroup.clientFormatPattern
                }
            },
            {
                id: "Gender",
                type: "string",
                label: currentTable.fields.Gender.caption,
                operators: currentTable.fields.Gender.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fdistrict_summary_viewsearch.fields.Gender.validators),
                data: {
                    format: currentTable.fields.Gender.clientFormatPattern
                }
            },
            {
                id: "NoOfBeneficiaries",
                type: "integer",
                label: currentTable.fields.NoOfBeneficiaries.caption,
                operators: currentTable.fields.NoOfBeneficiaries.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fdistrict_summary_viewsearch.fields.NoOfBeneficiaries.validators),
                data: {
                    format: currentTable.fields.NoOfBeneficiaries.clientFormatPattern
                }
            },
            {
                id: "TreesAllocated",
                type: "double",
                label: currentTable.fields.TreesAllocated.caption,
                operators: currentTable.fields.TreesAllocated.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fdistrict_summary_viewsearch.fields.TreesAllocated.validators),
                data: {
                    format: currentTable.fields.TreesAllocated.clientFormatPattern
                }
            },
            {
                id: "FarmingSeason",
                type: "integer",
                label: currentTable.fields.FarmingSeason.caption,
                operators: currentTable.fields.FarmingSeason.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fdistrict_summary_viewsearch.fields.FarmingSeason.validators),
                data: {
                    format: currentTable.fields.FarmingSeason.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#district_summary_view_query_builder"),
        args = {},
        rules = ew.parseJson($("#fdistrict_summary_viewsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fdistrict_summary_viewsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fdistrict_summary_viewsearch" formaction="<?= HtmlEncode(GetUrl("DistrictSummaryViewList")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fdistrict_summary_viewsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fdistrict_summary_viewsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("district_summary_view");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
