<?php

namespace PHPMaker2024\cidp24;

// Page object
$DistrictSummaryViewList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { district_summary_view: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "AgeGroup": <?= $Page->AgeGroup->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.14.0", "preview");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fdistrict_summary_viewsrch" id="fdistrict_summary_viewsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fdistrict_summary_viewsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { district_summary_view: currentTable } });
var currentForm;
var fdistrict_summary_viewsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fdistrict_summary_viewsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "AgeGroup": <?= $Page->AgeGroup->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
<?php
if (!$Page->DistrictCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictCode"
            name="x_DistrictCode[]"
            class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
            data-select2-id="fdistrict_summary_viewsrch_x_DistrictCode"
            data-table="district_summary_view"
            data-field="x_DistrictCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictCode->editAttributes() ?>>
            <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fdistrict_summary_viewsrch", function() {
            var options = {
                name: "x_DistrictCode",
                selectId: "fdistrict_summary_viewsrch_x_DistrictCode",
                ajax: { id: "x_DistrictCode", form: "fdistrict_summary_viewsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.district_summary_view.fields.DistrictCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
<?php
if (!$Page->DistrictName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictName"
            name="x_DistrictName[]"
            class="form-control ew-select<?= $Page->DistrictName->isInvalidClass() ?>"
            data-select2-id="fdistrict_summary_viewsrch_x_DistrictName"
            data-table="district_summary_view"
            data-field="x_DistrictName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictName->editAttributes() ?>>
            <?= $Page->DistrictName->selectOptionListHtml("x_DistrictName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fdistrict_summary_viewsrch", function() {
            var options = {
                name: "x_DistrictName",
                selectId: "fdistrict_summary_viewsrch_x_DistrictName",
                ajax: { id: "x_DistrictName", form: "fdistrict_summary_viewsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.district_summary_view.fields.DistrictName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { // AgeGroup ?>
<?php
if (!$Page->AgeGroup->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_AgeGroup" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->AgeGroup->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_AgeGroup"
            name="x_AgeGroup[]"
            class="form-control ew-select<?= $Page->AgeGroup->isInvalidClass() ?>"
            data-select2-id="fdistrict_summary_viewsrch_x_AgeGroup"
            data-table="district_summary_view"
            data-field="x_AgeGroup"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->AgeGroup->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->AgeGroup->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->AgeGroup->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->AgeGroup->editAttributes() ?>>
            <?= $Page->AgeGroup->selectOptionListHtml("x_AgeGroup", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->AgeGroup->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fdistrict_summary_viewsrch", function() {
            var options = {
                name: "x_AgeGroup",
                selectId: "fdistrict_summary_viewsrch_x_AgeGroup",
                ajax: { id: "x_AgeGroup", form: "fdistrict_summary_viewsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.district_summary_view.fields.AgeGroup.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
<?php
if (!$Page->Gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Gender"
            name="x_Gender[]"
            class="form-control ew-select<?= $Page->Gender->isInvalidClass() ?>"
            data-select2-id="fdistrict_summary_viewsrch_x_Gender"
            data-table="district_summary_view"
            data-field="x_Gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Gender->editAttributes() ?>>
            <?= $Page->Gender->selectOptionListHtml("x_Gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fdistrict_summary_viewsrch", function() {
            var options = {
                name: "x_Gender",
                selectId: "fdistrict_summary_viewsrch_x_Gender",
                ajax: { id: "x_Gender", form: "fdistrict_summary_viewsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.district_summary_view.fields.Gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fdistrict_summary_viewsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fdistrict_summary_viewsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fdistrict_summary_viewsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fdistrict_summary_viewsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="district_summary_view">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_district_summary_view" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_district_summary_viewlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_district_summary_view_DistrictCode" class="district_summary_view_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <th data-name="DistrictName" class="<?= $Page->DistrictName->headerCellClass() ?>"><div id="elh_district_summary_view_DistrictName" class="district_summary_view_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></div></th>
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { // AgeGroup ?>
        <th data-name="AgeGroup" class="<?= $Page->AgeGroup->headerCellClass() ?>"><div id="elh_district_summary_view_AgeGroup" class="district_summary_view_AgeGroup"><?= $Page->renderFieldHeader($Page->AgeGroup) ?></div></th>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
        <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div id="elh_district_summary_view_Gender" class="district_summary_view_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { // NoOfBeneficiaries ?>
        <th data-name="NoOfBeneficiaries" class="<?= $Page->NoOfBeneficiaries->headerCellClass() ?>"><div id="elh_district_summary_view_NoOfBeneficiaries" class="district_summary_view_NoOfBeneficiaries"><?= $Page->renderFieldHeader($Page->NoOfBeneficiaries) ?></div></th>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
        <th data-name="TreesAllocated" class="<?= $Page->TreesAllocated->headerCellClass() ?>"><div id="elh_district_summary_view_TreesAllocated" class="district_summary_view_TreesAllocated"><?= $Page->renderFieldHeader($Page->TreesAllocated) ?></div></th>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <th data-name="FarmingSeason" class="<?= $Page->FarmingSeason->headerCellClass() ?>"><div id="elh_district_summary_view_FarmingSeason" class="district_summary_view_FarmingSeason"><?= $Page->renderFieldHeader($Page->FarmingSeason) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_district_summary_view_DistrictCode" class="el_district_summary_view_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <td data-name="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_district_summary_view_DistrictName" class="el_district_summary_view_DistrictName">
<span<?= $Page->DistrictName->viewAttributes() ?>>
<?= $Page->DistrictName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->AgeGroup->Visible) { // AgeGroup ?>
        <td data-name="AgeGroup"<?= $Page->AgeGroup->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_district_summary_view_AgeGroup" class="el_district_summary_view_AgeGroup">
<span<?= $Page->AgeGroup->viewAttributes() ?>>
<?= $Page->AgeGroup->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Gender->Visible) { // Gender ?>
        <td data-name="Gender"<?= $Page->Gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_district_summary_view_Gender" class="el_district_summary_view_Gender">
<span<?= $Page->Gender->viewAttributes() ?>>
<?= $Page->Gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NoOfBeneficiaries->Visible) { // NoOfBeneficiaries ?>
        <td data-name="NoOfBeneficiaries"<?= $Page->NoOfBeneficiaries->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_district_summary_view_NoOfBeneficiaries" class="el_district_summary_view_NoOfBeneficiaries">
<span<?= $Page->NoOfBeneficiaries->viewAttributes() ?>>
<?= $Page->NoOfBeneficiaries->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
        <td data-name="TreesAllocated"<?= $Page->TreesAllocated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_district_summary_view_TreesAllocated" class="el_district_summary_view_TreesAllocated">
<span<?= $Page->TreesAllocated->viewAttributes() ?>>
<?= $Page->TreesAllocated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <td data-name="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_district_summary_view_FarmingSeason" class="el_district_summary_view_FarmingSeason">
<span<?= $Page->FarmingSeason->viewAttributes() ?>>
<?= $Page->FarmingSeason->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("district_summary_view");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
