<?php

namespace PHPMaker2024\cidp24;

// Page object
$CurrentRefView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
<form name="fcurrent_refview" id="fcurrent_refview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { current_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fcurrent_refview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcurrent_refview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="current_ref">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->ID->Visible) { // ID ?>
    <tr id="r_ID"<?= $Page->ID->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_current_ref_ID"><?= $Page->ID->caption() ?></span></td>
        <td data-name="ID"<?= $Page->ID->cellAttributes() ?>>
<span id="el_current_ref_ID">
<span<?= $Page->ID->viewAttributes() ?>>
<?= $Page->ID->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->PlanYear->Visible) { // PlanYear ?>
    <tr id="r_PlanYear"<?= $Page->PlanYear->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_current_ref_PlanYear"><?= $Page->PlanYear->caption() ?></span></td>
        <td data-name="PlanYear"<?= $Page->PlanYear->cellAttributes() ?>>
<span id="el_current_ref_PlanYear">
<span<?= $Page->PlanYear->viewAttributes() ?>>
<?= $Page->PlanYear->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->PlanMonth->Visible) { // PlanMonth ?>
    <tr id="r_PlanMonth"<?= $Page->PlanMonth->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_current_ref_PlanMonth"><?= $Page->PlanMonth->caption() ?></span></td>
        <td data-name="PlanMonth"<?= $Page->PlanMonth->cellAttributes() ?>>
<span id="el_current_ref_PlanMonth">
<span<?= $Page->PlanMonth->viewAttributes() ?>>
<?= $Page->PlanMonth->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->DaysAfterMonthEnd->Visible) { // DaysAfterMonthEnd ?>
    <tr id="r_DaysAfterMonthEnd"<?= $Page->DaysAfterMonthEnd->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_current_ref_DaysAfterMonthEnd"><?= $Page->DaysAfterMonthEnd->caption() ?></span></td>
        <td data-name="DaysAfterMonthEnd"<?= $Page->DaysAfterMonthEnd->cellAttributes() ?>>
<span id="el_current_ref_DaysAfterMonthEnd">
<span<?= $Page->DaysAfterMonthEnd->viewAttributes() ?>>
<?= $Page->DaysAfterMonthEnd->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->PlanClosingDate->Visible) { // PlanClosingDate ?>
    <tr id="r_PlanClosingDate"<?= $Page->PlanClosingDate->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_current_ref_PlanClosingDate"><?= $Page->PlanClosingDate->caption() ?></span></td>
        <td data-name="PlanClosingDate"<?= $Page->PlanClosingDate->cellAttributes() ?>>
<span id="el_current_ref_PlanClosingDate">
<span<?= $Page->PlanClosingDate->viewAttributes() ?>>
<?= $Page->PlanClosingDate->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->CurrentMonthClosingDate->Visible) { // CurrentMonthClosingDate ?>
    <tr id="r_CurrentMonthClosingDate"<?= $Page->CurrentMonthClosingDate->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_current_ref_CurrentMonthClosingDate"><?= $Page->CurrentMonthClosingDate->caption() ?></span></td>
        <td data-name="CurrentMonthClosingDate"<?= $Page->CurrentMonthClosingDate->cellAttributes() ?>>
<span id="el_current_ref_CurrentMonthClosingDate">
<span<?= $Page->CurrentMonthClosingDate->viewAttributes() ?>>
<?= $Page->CurrentMonthClosingDate->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
<?php if (!$Page->IsModal) { ?>
<?php if (!$Page->isExport()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
