<?php

namespace PHPMaker2024\cidp24;

// Page object
$CurrentRefEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fcurrent_refedit" id="fcurrent_refedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { current_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fcurrent_refedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcurrent_refedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["ID", [fields.ID.visible && fields.ID.required ? ew.Validators.required(fields.ID.caption) : null], fields.ID.isInvalid],
            ["PlanYear", [fields.PlanYear.visible && fields.PlanYear.required ? ew.Validators.required(fields.PlanYear.caption) : null, ew.Validators.integer], fields.PlanYear.isInvalid],
            ["PlanMonth", [fields.PlanMonth.visible && fields.PlanMonth.required ? ew.Validators.required(fields.PlanMonth.caption) : null, ew.Validators.integer], fields.PlanMonth.isInvalid],
            ["DaysAfterMonthEnd", [fields.DaysAfterMonthEnd.visible && fields.DaysAfterMonthEnd.required ? ew.Validators.required(fields.DaysAfterMonthEnd.caption) : null, ew.Validators.integer], fields.DaysAfterMonthEnd.isInvalid],
            ["PlanClosingDate", [fields.PlanClosingDate.visible && fields.PlanClosingDate.required ? ew.Validators.required(fields.PlanClosingDate.caption) : null, ew.Validators.datetime(fields.PlanClosingDate.clientFormatPattern)], fields.PlanClosingDate.isInvalid],
            ["CurrentMonthClosingDate", [fields.CurrentMonthClosingDate.visible && fields.CurrentMonthClosingDate.required ? ew.Validators.required(fields.CurrentMonthClosingDate.caption) : null, ew.Validators.datetime(fields.CurrentMonthClosingDate.clientFormatPattern)], fields.CurrentMonthClosingDate.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="current_ref">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->ID->Visible) { // ID ?>
    <div id="r_ID"<?= $Page->ID->rowAttributes() ?>>
        <label id="elh_current_ref_ID" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ID->caption() ?><?= $Page->ID->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ID->cellAttributes() ?>>
<span id="el_current_ref_ID">
<span<?= $Page->ID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->ID->getDisplayValue($Page->ID->EditValue))) ?>"></span>
<input type="hidden" data-table="current_ref" data-field="x_ID" data-hidden="1" name="x_ID" id="x_ID" value="<?= HtmlEncode($Page->ID->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PlanYear->Visible) { // PlanYear ?>
    <div id="r_PlanYear"<?= $Page->PlanYear->rowAttributes() ?>>
        <label id="elh_current_ref_PlanYear" for="x_PlanYear" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PlanYear->caption() ?><?= $Page->PlanYear->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PlanYear->cellAttributes() ?>>
<span id="el_current_ref_PlanYear">
<input type="<?= $Page->PlanYear->getInputTextType() ?>" name="x_PlanYear" id="x_PlanYear" data-table="current_ref" data-field="x_PlanYear" value="<?= $Page->PlanYear->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlanYear->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanYear->formatPattern()) ?>"<?= $Page->PlanYear->editAttributes() ?> aria-describedby="x_PlanYear_help">
<?= $Page->PlanYear->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PlanYear->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PlanMonth->Visible) { // PlanMonth ?>
    <div id="r_PlanMonth"<?= $Page->PlanMonth->rowAttributes() ?>>
        <label id="elh_current_ref_PlanMonth" for="x_PlanMonth" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PlanMonth->caption() ?><?= $Page->PlanMonth->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PlanMonth->cellAttributes() ?>>
<span id="el_current_ref_PlanMonth">
<input type="<?= $Page->PlanMonth->getInputTextType() ?>" name="x_PlanMonth" id="x_PlanMonth" data-table="current_ref" data-field="x_PlanMonth" value="<?= $Page->PlanMonth->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->PlanMonth->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanMonth->formatPattern()) ?>"<?= $Page->PlanMonth->editAttributes() ?> aria-describedby="x_PlanMonth_help">
<?= $Page->PlanMonth->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PlanMonth->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DaysAfterMonthEnd->Visible) { // DaysAfterMonthEnd ?>
    <div id="r_DaysAfterMonthEnd"<?= $Page->DaysAfterMonthEnd->rowAttributes() ?>>
        <label id="elh_current_ref_DaysAfterMonthEnd" for="x_DaysAfterMonthEnd" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DaysAfterMonthEnd->caption() ?><?= $Page->DaysAfterMonthEnd->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DaysAfterMonthEnd->cellAttributes() ?>>
<span id="el_current_ref_DaysAfterMonthEnd">
<input type="<?= $Page->DaysAfterMonthEnd->getInputTextType() ?>" name="x_DaysAfterMonthEnd" id="x_DaysAfterMonthEnd" data-table="current_ref" data-field="x_DaysAfterMonthEnd" value="<?= $Page->DaysAfterMonthEnd->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->DaysAfterMonthEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DaysAfterMonthEnd->formatPattern()) ?>"<?= $Page->DaysAfterMonthEnd->editAttributes() ?> aria-describedby="x_DaysAfterMonthEnd_help">
<?= $Page->DaysAfterMonthEnd->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DaysAfterMonthEnd->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PlanClosingDate->Visible) { // PlanClosingDate ?>
    <div id="r_PlanClosingDate"<?= $Page->PlanClosingDate->rowAttributes() ?>>
        <label id="elh_current_ref_PlanClosingDate" for="x_PlanClosingDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PlanClosingDate->caption() ?><?= $Page->PlanClosingDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PlanClosingDate->cellAttributes() ?>>
<span id="el_current_ref_PlanClosingDate">
<input type="<?= $Page->PlanClosingDate->getInputTextType() ?>" name="x_PlanClosingDate" id="x_PlanClosingDate" data-table="current_ref" data-field="x_PlanClosingDate" value="<?= $Page->PlanClosingDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->PlanClosingDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanClosingDate->formatPattern()) ?>"<?= $Page->PlanClosingDate->editAttributes() ?> aria-describedby="x_PlanClosingDate_help">
<?= $Page->PlanClosingDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PlanClosingDate->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CurrentMonthClosingDate->Visible) { // CurrentMonthClosingDate ?>
    <div id="r_CurrentMonthClosingDate"<?= $Page->CurrentMonthClosingDate->rowAttributes() ?>>
        <label id="elh_current_ref_CurrentMonthClosingDate" for="x_CurrentMonthClosingDate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CurrentMonthClosingDate->caption() ?><?= $Page->CurrentMonthClosingDate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CurrentMonthClosingDate->cellAttributes() ?>>
<span id="el_current_ref_CurrentMonthClosingDate">
<input type="<?= $Page->CurrentMonthClosingDate->getInputTextType() ?>" name="x_CurrentMonthClosingDate" id="x_CurrentMonthClosingDate" data-table="current_ref" data-field="x_CurrentMonthClosingDate" value="<?= $Page->CurrentMonthClosingDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->CurrentMonthClosingDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->CurrentMonthClosingDate->formatPattern()) ?>"<?= $Page->CurrentMonthClosingDate->editAttributes() ?> aria-describedby="x_CurrentMonthClosingDate_help">
<?= $Page->CurrentMonthClosingDate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->CurrentMonthClosingDate->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcurrent_refedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcurrent_refedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("current_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
