<?php

namespace PHPMaker2024\cidp24;

// Page object
$CidpDataList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cidp_data: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["DistrictName", [fields.DistrictName.visible && fields.DistrictName.required ? ew.Validators.required(fields.DistrictName.caption) : null], fields.DistrictName.isInvalid],
            ["GRNCode", [fields.GRNCode.visible && fields.GRNCode.required ? ew.Validators.required(fields.GRNCode.caption) : null], fields.GRNCode.isInvalid],
            ["GRN", [fields.GRN.visible && fields.GRN.required ? ew.Validators.required(fields.GRN.caption) : null], fields.GRN.isInvalid],
            ["SupplierCode", [fields.SupplierCode.visible && fields.SupplierCode.required ? ew.Validators.required(fields.SupplierCode.caption) : null, ew.Validators.integer], fields.SupplierCode.isInvalid],
            ["Supplier", [fields.Supplier.visible && fields.Supplier.required ? ew.Validators.required(fields.Supplier.caption) : null], fields.Supplier.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["Camp", [fields.Camp.visible && fields.Camp.required ? ew.Validators.required(fields.Camp.caption) : null], fields.Camp.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["Village", [fields.Village.visible && fields.Village.required ? ew.Validators.required(fields.Village.caption) : null], fields.Village.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["FarmerName", [fields.FarmerName.visible && fields.FarmerName.required ? ew.Validators.required(fields.FarmerName.caption) : null], fields.FarmerName.isInvalid],
            ["DOB", [fields.DOB.visible && fields.DOB.required ? ew.Validators.required(fields.DOB.caption) : null], fields.DOB.isInvalid],
            ["Age", [fields.Age.visible && fields.Age.required ? ew.Validators.required(fields.Age.caption) : null, ew.Validators.float], fields.Age.isInvalid],
            ["Group", [fields.Group.visible && fields.Group.required ? ew.Validators.required(fields.Group.caption) : null], fields.Group.isInvalid],
            ["Gender", [fields.Gender.visible && fields.Gender.required ? ew.Validators.required(fields.Gender.caption) : null], fields.Gender.isInvalid],
            ["Seedlings", [fields.Seedlings.visible && fields.Seedlings.required ? ew.Validators.required(fields.Seedlings.caption) : null, ew.Validators.float], fields.Seedlings.isInvalid],
            ["Seeds", [fields.Seeds.visible && fields.Seeds.required ? ew.Validators.required(fields.Seeds.caption) : null], fields.Seeds.isInvalid],
            ["Type", [fields.Type.visible && fields.Type.required ? ew.Validators.required(fields.Type.caption) : null], fields.Type.isInvalid],
            ["DateAllocated", [fields.DateAllocated.visible && fields.DateAllocated.required ? ew.Validators.required(fields.DateAllocated.caption) : null], fields.DateAllocated.isInvalid],
            ["ID", [fields.ID.visible && fields.ID.required ? ew.Validators.required(fields.ID.caption) : null], fields.ID.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["DistrictCode",false],["DistrictName",false],["GRNCode",false],["GRN",false],["SupplierCode",false],["Supplier",false],["CampCode",false],["Camp",false],["VillageCode",false],["Village",false],["NRC",false],["FarmerName",false],["DOB",false],["Age",false],["Group[]",false],["Gender",false],["Seedlings",false],["Seeds",false],["Type",false],["DateAllocated",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "GRNCode": <?= $Page->GRNCode->toClientList($Page) ?>,
            "SupplierCode": <?= $Page->SupplierCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "Group": <?= $Page->Group->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "Type": <?= $Page->Type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.14.0", "preview");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fcidp_datasrch" id="fcidp_datasrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fcidp_datasrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cidp_data: currentTable } });
var currentForm;
var fcidp_datasrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcidp_datasrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fcidp_datasrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fcidp_datasrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fcidp_datasrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fcidp_datasrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cidp_data">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_cidp_data" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_cidp_datalist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Page->DistrictCode->headerCellClass() ?>"><div id="elh_cidp_data_DistrictCode" class="cidp_data_DistrictCode"><?= $Page->renderFieldHeader($Page->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <th data-name="DistrictName" class="<?= $Page->DistrictName->headerCellClass() ?>"><div id="elh_cidp_data_DistrictName" class="cidp_data_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></div></th>
<?php } ?>
<?php if ($Page->GRNCode->Visible) { // GRNCode ?>
        <th data-name="GRNCode" class="<?= $Page->GRNCode->headerCellClass() ?>"><div id="elh_cidp_data_GRNCode" class="cidp_data_GRNCode"><?= $Page->renderFieldHeader($Page->GRNCode) ?></div></th>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
        <th data-name="GRN" class="<?= $Page->GRN->headerCellClass() ?>"><div id="elh_cidp_data_GRN" class="cidp_data_GRN"><?= $Page->renderFieldHeader($Page->GRN) ?></div></th>
<?php } ?>
<?php if ($Page->SupplierCode->Visible) { // SupplierCode ?>
        <th data-name="SupplierCode" class="<?= $Page->SupplierCode->headerCellClass() ?>"><div id="elh_cidp_data_SupplierCode" class="cidp_data_SupplierCode"><?= $Page->renderFieldHeader($Page->SupplierCode) ?></div></th>
<?php } ?>
<?php if ($Page->Supplier->Visible) { // Supplier ?>
        <th data-name="Supplier" class="<?= $Page->Supplier->headerCellClass() ?>"><div id="elh_cidp_data_Supplier" class="cidp_data_Supplier"><?= $Page->renderFieldHeader($Page->Supplier) ?></div></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Page->CampCode->headerCellClass() ?>"><div id="elh_cidp_data_CampCode" class="cidp_data_CampCode"><?= $Page->renderFieldHeader($Page->CampCode) ?></div></th>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
        <th data-name="Camp" class="<?= $Page->Camp->headerCellClass() ?>"><div id="elh_cidp_data_Camp" class="cidp_data_Camp"><?= $Page->renderFieldHeader($Page->Camp) ?></div></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th data-name="VillageCode" class="<?= $Page->VillageCode->headerCellClass() ?>"><div id="elh_cidp_data_VillageCode" class="cidp_data_VillageCode"><?= $Page->renderFieldHeader($Page->VillageCode) ?></div></th>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
        <th data-name="Village" class="<?= $Page->Village->headerCellClass() ?>"><div id="elh_cidp_data_Village" class="cidp_data_Village"><?= $Page->renderFieldHeader($Page->Village) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_cidp_data_NRC" class="cidp_data_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <th data-name="FarmerName" class="<?= $Page->FarmerName->headerCellClass() ?>"><div id="elh_cidp_data_FarmerName" class="cidp_data_FarmerName"><?= $Page->renderFieldHeader($Page->FarmerName) ?></div></th>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
        <th data-name="DOB" class="<?= $Page->DOB->headerCellClass() ?>"><div id="elh_cidp_data_DOB" class="cidp_data_DOB"><?= $Page->renderFieldHeader($Page->DOB) ?></div></th>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
        <th data-name="Age" class="<?= $Page->Age->headerCellClass() ?>"><div id="elh_cidp_data_Age" class="cidp_data_Age"><?= $Page->renderFieldHeader($Page->Age) ?></div></th>
<?php } ?>
<?php if ($Page->Group->Visible) { // Group ?>
        <th data-name="Group" class="<?= $Page->Group->headerCellClass() ?>"><div id="elh_cidp_data_Group" class="cidp_data_Group"><?= $Page->renderFieldHeader($Page->Group) ?></div></th>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
        <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div id="elh_cidp_data_Gender" class="cidp_data_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { // Seedlings ?>
        <th data-name="Seedlings" class="<?= $Page->Seedlings->headerCellClass() ?>"><div id="elh_cidp_data_Seedlings" class="cidp_data_Seedlings"><?= $Page->renderFieldHeader($Page->Seedlings) ?></div></th>
<?php } ?>
<?php if ($Page->Seeds->Visible) { // Seeds ?>
        <th data-name="Seeds" class="<?= $Page->Seeds->headerCellClass() ?>"><div id="elh_cidp_data_Seeds" class="cidp_data_Seeds"><?= $Page->renderFieldHeader($Page->Seeds) ?></div></th>
<?php } ?>
<?php if ($Page->Type->Visible) { // Type ?>
        <th data-name="Type" class="<?= $Page->Type->headerCellClass() ?>"><div id="elh_cidp_data_Type" class="cidp_data_Type"><?= $Page->renderFieldHeader($Page->Type) ?></div></th>
<?php } ?>
<?php if ($Page->DateAllocated->Visible) { // DateAllocated ?>
        <th data-name="DateAllocated" class="<?= $Page->DateAllocated->headerCellClass() ?>"><div id="elh_cidp_data_DateAllocated" class="cidp_data_DateAllocated"><?= $Page->renderFieldHeader($Page->DateAllocated) ?></div></th>
<?php } ?>
<?php if ($Page->ID->Visible) { // ID ?>
        <th data-name="ID" class="<?= $Page->ID->headerCellClass() ?>"><div id="elh_cidp_data_ID" class="cidp_data_ID"><?= $Page->renderFieldHeader($Page->ID) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DistrictCode" class="el_cidp_data_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        data-table="cidp_data"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" };
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DistrictCode" id="o<?= $Page->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DistrictCode" class="el_cidp_data_DistrictCode">
    <select
        id="x<?= $Page->RowIndex ?>_DistrictCode"
        name="x<?= $Page->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode"
        data-table="cidp_data"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x{$Page->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_DistrictCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_DistrictCode" };
    if (<?= $Page->FormName ?>.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_DistrictCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DistrictCode" class="el_cidp_data_DistrictCode">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <td data-name="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DistrictName" class="el_cidp_data_DistrictName">
<input type="<?= $Page->DistrictName->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DistrictName" id="x<?= $Page->RowIndex ?>_DistrictName" data-table="cidp_data" data-field="x_DistrictName" value="<?= $Page->DistrictName->EditValue ?>" size="30" maxlength="80" placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictName->formatPattern()) ?>"<?= $Page->DistrictName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_DistrictName" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DistrictName" id="o<?= $Page->RowIndex ?>_DistrictName" value="<?= HtmlEncode($Page->DistrictName->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DistrictName" class="el_cidp_data_DistrictName">
<input type="<?= $Page->DistrictName->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DistrictName" id="x<?= $Page->RowIndex ?>_DistrictName" data-table="cidp_data" data-field="x_DistrictName" value="<?= $Page->DistrictName->EditValue ?>" size="30" maxlength="80" placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictName->formatPattern()) ?>"<?= $Page->DistrictName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DistrictName" class="el_cidp_data_DistrictName">
<span<?= $Page->DistrictName->viewAttributes() ?>>
<?= $Page->DistrictName->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->GRNCode->Visible) { // GRNCode ?>
        <td data-name="GRNCode"<?= $Page->GRNCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_GRNCode" class="el_cidp_data_GRNCode">
    <select
        id="x<?= $Page->RowIndex ?>_GRNCode"
        name="x<?= $Page->RowIndex ?>_GRNCode"
        class="form-control ew-select<?= $Page->GRNCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_GRNCode"
        data-table="cidp_data"
        data-field="x_GRNCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->GRNCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->GRNCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->GRNCode->getPlaceHolder()) ?>"
        <?= $Page->GRNCode->editAttributes() ?>>
        <?= $Page->GRNCode->selectOptionListHtml("x{$Page->RowIndex}_GRNCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->GRNCode->getErrorMessage() ?></div>
<?= $Page->GRNCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_GRNCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_GRNCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_GRNCode" };
    if (<?= $Page->FormName ?>.lists.GRNCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_GRNCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_GRNCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.GRNCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_GRNCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_GRNCode" id="o<?= $Page->RowIndex ?>_GRNCode" value="<?= HtmlEncode($Page->GRNCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_GRNCode" class="el_cidp_data_GRNCode">
    <select
        id="x<?= $Page->RowIndex ?>_GRNCode"
        name="x<?= $Page->RowIndex ?>_GRNCode"
        class="form-control ew-select<?= $Page->GRNCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_GRNCode"
        data-table="cidp_data"
        data-field="x_GRNCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->GRNCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->GRNCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->GRNCode->getPlaceHolder()) ?>"
        <?= $Page->GRNCode->editAttributes() ?>>
        <?= $Page->GRNCode->selectOptionListHtml("x{$Page->RowIndex}_GRNCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->GRNCode->getErrorMessage() ?></div>
<?= $Page->GRNCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_GRNCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_GRNCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_GRNCode" };
    if (<?= $Page->FormName ?>.lists.GRNCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_GRNCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_GRNCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.GRNCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_GRNCode" class="el_cidp_data_GRNCode">
<span<?= $Page->GRNCode->viewAttributes() ?>>
<?= $Page->GRNCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->GRN->Visible) { // GRN ?>
        <td data-name="GRN"<?= $Page->GRN->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_GRN" class="el_cidp_data_GRN">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_GRN" id="x<?= $Page->RowIndex ?>_GRN" data-table="cidp_data" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_GRN" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_GRN" id="o<?= $Page->RowIndex ?>_GRN" value="<?= HtmlEncode($Page->GRN->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_GRN" class="el_cidp_data_GRN">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_GRN" id="x<?= $Page->RowIndex ?>_GRN" data-table="cidp_data" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_GRN" class="el_cidp_data_GRN">
<span<?= $Page->GRN->viewAttributes() ?>>
<?= $Page->GRN->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->SupplierCode->Visible) { // SupplierCode ?>
        <td data-name="SupplierCode"<?= $Page->SupplierCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_SupplierCode" class="el_cidp_data_SupplierCode">
    <select
        id="x<?= $Page->RowIndex ?>_SupplierCode"
        name="x<?= $Page->RowIndex ?>_SupplierCode"
        class="form-control ew-select<?= $Page->SupplierCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SupplierCode"
        data-table="cidp_data"
        data-field="x_SupplierCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->SupplierCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->SupplierCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SupplierCode->getPlaceHolder()) ?>"
        <?= $Page->SupplierCode->editAttributes() ?>>
        <?= $Page->SupplierCode->selectOptionListHtml("x{$Page->RowIndex}_SupplierCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SupplierCode->getErrorMessage() ?></div>
<?= $Page->SupplierCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SupplierCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SupplierCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SupplierCode" };
    if (<?= $Page->FormName ?>.lists.SupplierCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SupplierCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SupplierCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.SupplierCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_SupplierCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_SupplierCode" id="o<?= $Page->RowIndex ?>_SupplierCode" value="<?= HtmlEncode($Page->SupplierCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_SupplierCode" class="el_cidp_data_SupplierCode">
    <select
        id="x<?= $Page->RowIndex ?>_SupplierCode"
        name="x<?= $Page->RowIndex ?>_SupplierCode"
        class="form-control ew-select<?= $Page->SupplierCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SupplierCode"
        data-table="cidp_data"
        data-field="x_SupplierCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->SupplierCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->SupplierCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SupplierCode->getPlaceHolder()) ?>"
        <?= $Page->SupplierCode->editAttributes() ?>>
        <?= $Page->SupplierCode->selectOptionListHtml("x{$Page->RowIndex}_SupplierCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SupplierCode->getErrorMessage() ?></div>
<?= $Page->SupplierCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_SupplierCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_SupplierCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_SupplierCode" };
    if (<?= $Page->FormName ?>.lists.SupplierCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_SupplierCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_SupplierCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.SupplierCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_SupplierCode" class="el_cidp_data_SupplierCode">
<span<?= $Page->SupplierCode->viewAttributes() ?>>
<?= $Page->SupplierCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Supplier->Visible) { // Supplier ?>
        <td data-name="Supplier"<?= $Page->Supplier->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Supplier" class="el_cidp_data_Supplier">
<input type="<?= $Page->Supplier->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Supplier" id="x<?= $Page->RowIndex ?>_Supplier" data-table="cidp_data" data-field="x_Supplier" value="<?= $Page->Supplier->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Supplier->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Supplier->formatPattern()) ?>"<?= $Page->Supplier->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Supplier->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Supplier" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Supplier" id="o<?= $Page->RowIndex ?>_Supplier" value="<?= HtmlEncode($Page->Supplier->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Supplier" class="el_cidp_data_Supplier">
<input type="<?= $Page->Supplier->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Supplier" id="x<?= $Page->RowIndex ?>_Supplier" data-table="cidp_data" data-field="x_Supplier" value="<?= $Page->Supplier->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Supplier->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Supplier->formatPattern()) ?>"<?= $Page->Supplier->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Supplier->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Supplier" class="el_cidp_data_Supplier">
<span<?= $Page->Supplier->viewAttributes() ?>>
<?= $Page->Supplier->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_CampCode" class="el_cidp_data_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        data-table="cidp_data"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" };
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_CampCode" id="o<?= $Page->RowIndex ?>_CampCode" value="<?= HtmlEncode($Page->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_CampCode" class="el_cidp_data_CampCode">
    <select
        id="x<?= $Page->RowIndex ?>_CampCode"
        name="x<?= $Page->RowIndex ?>_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode"
        data-table="cidp_data"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x{$Page->RowIndex}_CampCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_CampCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_CampCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_CampCode" };
    if (<?= $Page->FormName ?>.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_CampCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_CampCode" class="el_cidp_data_CampCode">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Camp->Visible) { // Camp ?>
        <td data-name="Camp"<?= $Page->Camp->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Camp" class="el_cidp_data_Camp">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Camp" id="x<?= $Page->RowIndex ?>_Camp" data-table="cidp_data" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Camp" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Camp" id="o<?= $Page->RowIndex ?>_Camp" value="<?= HtmlEncode($Page->Camp->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Camp" class="el_cidp_data_Camp">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Camp" id="x<?= $Page->RowIndex ?>_Camp" data-table="cidp_data" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Camp" class="el_cidp_data_Camp">
<span<?= $Page->Camp->viewAttributes() ?>>
<?= $Page->Camp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td data-name="VillageCode"<?= $Page->VillageCode->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_VillageCode" class="el_cidp_data_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        data-table="cidp_data"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" };
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_VillageCode" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_VillageCode" id="o<?= $Page->RowIndex ?>_VillageCode" value="<?= HtmlEncode($Page->VillageCode->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_VillageCode" class="el_cidp_data_VillageCode">
    <select
        id="x<?= $Page->RowIndex ?>_VillageCode"
        name="x<?= $Page->RowIndex ?>_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode"
        data-table="cidp_data"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x{$Page->RowIndex}_VillageCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_VillageCode") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_VillageCode", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_VillageCode" };
    if (<?= $Page->FormName ?>.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_VillageCode", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cidp_data.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_VillageCode" class="el_cidp_data_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Village->Visible) { // Village ?>
        <td data-name="Village"<?= $Page->Village->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Village" class="el_cidp_data_Village">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Village" id="x<?= $Page->RowIndex ?>_Village" data-table="cidp_data" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Village" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Village" id="o<?= $Page->RowIndex ?>_Village" value="<?= HtmlEncode($Page->Village->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Village" class="el_cidp_data_Village">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Village" id="x<?= $Page->RowIndex ?>_Village" data-table="cidp_data" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Village" class="el_cidp_data_Village">
<span<?= $Page->Village->viewAttributes() ?>>
<?= $Page->Village->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_NRC" class="el_cidp_data_NRC">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" data-table="cidp_data" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_NRC" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_NRC" id="o<?= $Page->RowIndex ?>_NRC" value="<?= HtmlEncode($Page->NRC->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_NRC" class="el_cidp_data_NRC">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_NRC" id="x<?= $Page->RowIndex ?>_NRC" data-table="cidp_data" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_NRC" class="el_cidp_data_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <td data-name="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_FarmerName" class="el_cidp_data_FarmerName">
<input type="<?= $Page->FarmerName->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerName" id="x<?= $Page->RowIndex ?>_FarmerName" data-table="cidp_data" data-field="x_FarmerName" value="<?= $Page->FarmerName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerName->formatPattern()) ?>"<?= $Page->FarmerName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_FarmerName" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_FarmerName" id="o<?= $Page->RowIndex ?>_FarmerName" value="<?= HtmlEncode($Page->FarmerName->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_FarmerName" class="el_cidp_data_FarmerName">
<input type="<?= $Page->FarmerName->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_FarmerName" id="x<?= $Page->RowIndex ?>_FarmerName" data-table="cidp_data" data-field="x_FarmerName" value="<?= $Page->FarmerName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmerName->formatPattern()) ?>"<?= $Page->FarmerName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_FarmerName" class="el_cidp_data_FarmerName">
<span<?= $Page->FarmerName->viewAttributes() ?>>
<?= $Page->FarmerName->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DOB->Visible) { // DOB ?>
        <td data-name="DOB"<?= $Page->DOB->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DOB" class="el_cidp_data_DOB">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DOB" id="x<?= $Page->RowIndex ?>_DOB" data-table="cidp_data" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_DOB" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DOB" id="o<?= $Page->RowIndex ?>_DOB" value="<?= HtmlEncode($Page->DOB->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DOB" class="el_cidp_data_DOB">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DOB" id="x<?= $Page->RowIndex ?>_DOB" data-table="cidp_data" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DOB" class="el_cidp_data_DOB">
<span<?= $Page->DOB->viewAttributes() ?>>
<?= $Page->DOB->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Age->Visible) { // Age ?>
        <td data-name="Age"<?= $Page->Age->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Age" class="el_cidp_data_Age">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Age" id="x<?= $Page->RowIndex ?>_Age" data-table="cidp_data" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Age" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Age" id="o<?= $Page->RowIndex ?>_Age" value="<?= HtmlEncode($Page->Age->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Age" class="el_cidp_data_Age">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Age" id="x<?= $Page->RowIndex ?>_Age" data-table="cidp_data" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Age" class="el_cidp_data_Age">
<span<?= $Page->Age->viewAttributes() ?>>
<?= $Page->Age->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Group->Visible) { // Group ?>
        <td data-name="Group"<?= $Page->Group->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Group" class="el_cidp_data_Group">
    <select
        id="x<?= $Page->RowIndex ?>_Group[]"
        name="x<?= $Page->RowIndex ?>_Group[]"
        class="form-select ew-select<?= $Page->Group->isInvalidClass() ?>"
        <?php if (!$Page->Group->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Group[]"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Group"
        multiple
        size="1"
        data-value-separator="<?= $Page->Group->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Group->getPlaceHolder()) ?>"
        <?= $Page->Group->editAttributes() ?>>
        <?= $Page->Group->selectOptionListHtml("x{$Page->RowIndex}_Group[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Group->getErrorMessage() ?></div>
<?php if (!$Page->Group->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Group[]", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Group[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Group?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Group[]", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Group[]", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Group.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Group" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Group[]" id="o<?= $Page->RowIndex ?>_Group[]" value="<?= HtmlEncode($Page->Group->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Group" class="el_cidp_data_Group">
    <select
        id="x<?= $Page->RowIndex ?>_Group[]"
        name="x<?= $Page->RowIndex ?>_Group[]"
        class="form-select ew-select<?= $Page->Group->isInvalidClass() ?>"
        <?php if (!$Page->Group->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Group[]"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Group"
        multiple
        size="1"
        data-value-separator="<?= $Page->Group->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Group->getPlaceHolder()) ?>"
        <?= $Page->Group->editAttributes() ?>>
        <?= $Page->Group->selectOptionListHtml("x{$Page->RowIndex}_Group[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Group->getErrorMessage() ?></div>
<?php if (!$Page->Group->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Group[]", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Group[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Group?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Group[]", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Group[]", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Group.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Group" class="el_cidp_data_Group">
<span<?= $Page->Group->viewAttributes() ?>>
<?= $Page->Group->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Gender->Visible) { // Gender ?>
        <td data-name="Gender"<?= $Page->Gender->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Gender" class="el_cidp_data_Gender">
    <select
        id="x<?= $Page->RowIndex ?>_Gender"
        name="x<?= $Page->RowIndex ?>_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Gender"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x{$Page->RowIndex}_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Gender", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Gender", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Gender", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Gender" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Gender" id="o<?= $Page->RowIndex ?>_Gender" value="<?= HtmlEncode($Page->Gender->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Gender" class="el_cidp_data_Gender">
    <select
        id="x<?= $Page->RowIndex ?>_Gender"
        name="x<?= $Page->RowIndex ?>_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Gender"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x{$Page->RowIndex}_Gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Gender", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Gender", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Gender", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Gender" class="el_cidp_data_Gender">
<span<?= $Page->Gender->viewAttributes() ?>>
<?= $Page->Gender->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Seedlings->Visible) { // Seedlings ?>
        <td data-name="Seedlings"<?= $Page->Seedlings->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Seedlings" class="el_cidp_data_Seedlings">
<input type="<?= $Page->Seedlings->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Seedlings" id="x<?= $Page->RowIndex ?>_Seedlings" data-table="cidp_data" data-field="x_Seedlings" value="<?= $Page->Seedlings->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Seedlings->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seedlings->formatPattern()) ?>"<?= $Page->Seedlings->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Seedlings->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Seedlings" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Seedlings" id="o<?= $Page->RowIndex ?>_Seedlings" value="<?= HtmlEncode($Page->Seedlings->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Seedlings" class="el_cidp_data_Seedlings">
<input type="<?= $Page->Seedlings->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Seedlings" id="x<?= $Page->RowIndex ?>_Seedlings" data-table="cidp_data" data-field="x_Seedlings" value="<?= $Page->Seedlings->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Seedlings->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seedlings->formatPattern()) ?>"<?= $Page->Seedlings->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Seedlings->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Seedlings" class="el_cidp_data_Seedlings">
<span<?= $Page->Seedlings->viewAttributes() ?>>
<?= $Page->Seedlings->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Seeds->Visible) { // Seeds ?>
        <td data-name="Seeds"<?= $Page->Seeds->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Seeds" class="el_cidp_data_Seeds">
<input type="<?= $Page->Seeds->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Seeds" id="x<?= $Page->RowIndex ?>_Seeds" data-table="cidp_data" data-field="x_Seeds" value="<?= $Page->Seeds->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Seeds->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seeds->formatPattern()) ?>"<?= $Page->Seeds->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Seeds->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Seeds" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Seeds" id="o<?= $Page->RowIndex ?>_Seeds" value="<?= HtmlEncode($Page->Seeds->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Seeds" class="el_cidp_data_Seeds">
<input type="<?= $Page->Seeds->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Seeds" id="x<?= $Page->RowIndex ?>_Seeds" data-table="cidp_data" data-field="x_Seeds" value="<?= $Page->Seeds->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Seeds->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seeds->formatPattern()) ?>"<?= $Page->Seeds->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Seeds->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Seeds" class="el_cidp_data_Seeds">
<span<?= $Page->Seeds->viewAttributes() ?>>
<?= $Page->Seeds->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Type->Visible) { // Type ?>
        <td data-name="Type"<?= $Page->Type->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Type" class="el_cidp_data_Type">
    <select
        id="x<?= $Page->RowIndex ?>_Type"
        name="x<?= $Page->RowIndex ?>_Type"
        class="form-select ew-select<?= $Page->Type->isInvalidClass() ?>"
        <?php if (!$Page->Type->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Type"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Type"
        data-value-separator="<?= $Page->Type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Type->getPlaceHolder()) ?>"
        <?= $Page->Type->editAttributes() ?>>
        <?= $Page->Type->selectOptionListHtml("x{$Page->RowIndex}_Type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Type->getErrorMessage() ?></div>
<?= $Page->Type->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Type") ?>
<?php if (!$Page->Type->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Type", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Type?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Type", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Type", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_Type" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Type" id="o<?= $Page->RowIndex ?>_Type" value="<?= HtmlEncode($Page->Type->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Type" class="el_cidp_data_Type">
    <select
        id="x<?= $Page->RowIndex ?>_Type"
        name="x<?= $Page->RowIndex ?>_Type"
        class="form-select ew-select<?= $Page->Type->isInvalidClass() ?>"
        <?php if (!$Page->Type->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Type"
        <?php } ?>
        data-table="cidp_data"
        data-field="x_Type"
        data-value-separator="<?= $Page->Type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Type->getPlaceHolder()) ?>"
        <?= $Page->Type->editAttributes() ?>>
        <?= $Page->Type->selectOptionListHtml("x{$Page->RowIndex}_Type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Type->getErrorMessage() ?></div>
<?= $Page->Type->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_Type") ?>
<?php if (!$Page->Type->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_Type", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_Type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.Type?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_Type", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_Type", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cidp_data.fields.Type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_Type" class="el_cidp_data_Type">
<span<?= $Page->Type->viewAttributes() ?>>
<?= $Page->Type->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->DateAllocated->Visible) { // DateAllocated ?>
        <td data-name="DateAllocated"<?= $Page->DateAllocated->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DateAllocated" class="el_cidp_data_DateAllocated">
<input type="<?= $Page->DateAllocated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DateAllocated" id="x<?= $Page->RowIndex ?>_DateAllocated" data-table="cidp_data" data-field="x_DateAllocated" value="<?= $Page->DateAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DateAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateAllocated->formatPattern()) ?>"<?= $Page->DateAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateAllocated->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="cidp_data" data-field="x_DateAllocated" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_DateAllocated" id="o<?= $Page->RowIndex ?>_DateAllocated" value="<?= HtmlEncode($Page->DateAllocated->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DateAllocated" class="el_cidp_data_DateAllocated">
<input type="<?= $Page->DateAllocated->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_DateAllocated" id="x<?= $Page->RowIndex ?>_DateAllocated" data-table="cidp_data" data-field="x_DateAllocated" value="<?= $Page->DateAllocated->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DateAllocated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateAllocated->formatPattern()) ?>"<?= $Page->DateAllocated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateAllocated->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_DateAllocated" class="el_cidp_data_DateAllocated">
<span<?= $Page->DateAllocated->viewAttributes() ?>>
<?= $Page->DateAllocated->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->ID->Visible) { // ID ?>
        <td data-name="ID"<?= $Page->ID->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_ID" class="el_cidp_data_ID"></span>
<input type="hidden" data-table="cidp_data" data-field="x_ID" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ID" id="o<?= $Page->RowIndex ?>_ID" value="<?= HtmlEncode($Page->ID->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_ID" class="el_cidp_data_ID">
<span<?= $Page->ID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->ID->getDisplayValue($Page->ID->EditValue))) ?>"></span>
<input type="hidden" data-table="cidp_data" data-field="x_ID" data-hidden="1" name="x<?= $Page->RowIndex ?>_ID" id="x<?= $Page->RowIndex ?>_ID" value="<?= HtmlEncode($Page->ID->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cidp_data_ID" class="el_cidp_data_ID">
<span<?= $Page->ID->viewAttributes() ?>>
<?= $Page->ID->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="cidp_data" data-field="x_ID" data-hidden="1" name="x<?= $Page->RowIndex ?>_ID" id="x<?= $Page->RowIndex ?>_ID" value="<?= HtmlEncode($Page->ID->CurrentValue) ?>">
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isEdit()) { ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cidp_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
