<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("CampGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fcampgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { camp: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcampgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["CampName", [fields.CampName.visible && fields.CampName.required ? ew.Validators.required(fields.CampName.caption) : null], fields.CampName.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["CampName",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Grid->ProvinceCode->toClientList($Grid) ?>,
            "DistrictCode": <?= $Grid->DistrictCode->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fcampgrid" class="ew-form ew-list-form">
<div id="gmp_camp" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_campgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->headerCellClass() ?>"><div id="elh_camp_ProvinceCode" class="camp_ProvinceCode"><?= $Grid->renderFieldHeader($Grid->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Grid->DistrictCode->headerCellClass() ?>"><div id="elh_camp_DistrictCode" class="camp_DistrictCode"><?= $Grid->renderFieldHeader($Grid->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <th data-name="CampCode" class="<?= $Grid->CampCode->headerCellClass() ?>"><div id="elh_camp_CampCode" class="camp_CampCode"><?= $Grid->renderFieldHeader($Grid->CampCode) ?></div></th>
<?php } ?>
<?php if ($Grid->CampName->Visible) { // CampName ?>
        <th data-name="CampName" class="<?= $Grid->CampName->headerCellClass() ?>"><div id="elh_camp_CampName" class="camp_CampName"><?= $Grid->renderFieldHeader($Grid->CampName) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Grid->ProvinceCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_ProvinceCode" class="el_camp_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fcampgrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="camp"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fcampgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "fcampgrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcampgrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fcampgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fcampgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.camp.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="camp" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProvinceCode" id="o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_ProvinceCode" class="el_camp_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fcampgrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="camp"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fcampgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "fcampgrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcampgrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fcampgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fcampgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.camp.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_ProvinceCode" class="el_camp_ProvinceCode">
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<?= $Grid->ProvinceCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="camp" data-field="x_ProvinceCode" data-hidden="1" name="fcampgrid$x<?= $Grid->RowIndex ?>_ProvinceCode" id="fcampgrid$x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->FormValue) ?>">
<input type="hidden" data-table="camp" data-field="x_ProvinceCode" data-hidden="1" data-old name="fcampgrid$o<?= $Grid->RowIndex ?>_ProvinceCode" id="fcampgrid$o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Grid->DistrictCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_DistrictCode" class="el_camp_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fcampgrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        data-table="camp"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("fcampgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "fcampgrid_x<?= $Grid->RowIndex ?>_DistrictCode" };
    if (fcampgrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fcampgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fcampgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.camp.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="camp" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DistrictCode" id="o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_DistrictCode" class="el_camp_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-control ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fcampgrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        data-table="camp"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<script>
loadjs.ready("fcampgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "fcampgrid_x<?= $Grid->RowIndex ?>_DistrictCode" };
    if (fcampgrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fcampgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fcampgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.camp.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_DistrictCode" class="el_camp_DistrictCode">
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<?= $Grid->DistrictCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="camp" data-field="x_DistrictCode" data-hidden="1" name="fcampgrid$x<?= $Grid->RowIndex ?>_DistrictCode" id="fcampgrid$x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->FormValue) ?>">
<input type="hidden" data-table="camp" data-field="x_DistrictCode" data-hidden="1" data-old name="fcampgrid$o<?= $Grid->RowIndex ?>_DistrictCode" id="fcampgrid$o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->CampCode->Visible) { // CampCode ?>
        <td data-name="CampCode"<?= $Grid->CampCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_CampCode" class="el_camp_CampCode"></span>
<input type="hidden" data-table="camp" data-field="x_CampCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_CampCode" id="o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_CampCode" class="el_camp_CampCode">
<span<?= $Grid->CampCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->CampCode->getDisplayValue($Grid->CampCode->EditValue))) ?>"></span>
<input type="hidden" data-table="camp" data-field="x_CampCode" data-hidden="1" name="x<?= $Grid->RowIndex ?>_CampCode" id="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_CampCode" class="el_camp_CampCode">
<span<?= $Grid->CampCode->viewAttributes() ?>>
<?= $Grid->CampCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="camp" data-field="x_CampCode" data-hidden="1" name="fcampgrid$x<?= $Grid->RowIndex ?>_CampCode" id="fcampgrid$x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->FormValue) ?>">
<input type="hidden" data-table="camp" data-field="x_CampCode" data-hidden="1" data-old name="fcampgrid$o<?= $Grid->RowIndex ?>_CampCode" id="fcampgrid$o<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="camp" data-field="x_CampCode" data-hidden="1" name="x<?= $Grid->RowIndex ?>_CampCode" id="x<?= $Grid->RowIndex ?>_CampCode" value="<?= HtmlEncode($Grid->CampCode->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->CampName->Visible) { // CampName ?>
        <td data-name="CampName"<?= $Grid->CampName->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_CampName" class="el_camp_CampName">
<input type="<?= $Grid->CampName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_CampName" id="x<?= $Grid->RowIndex ?>_CampName" data-table="camp" data-field="x_CampName" value="<?= $Grid->CampName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->CampName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->CampName->formatPattern()) ?>"<?= $Grid->CampName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->CampName->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="camp" data-field="x_CampName" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_CampName" id="o<?= $Grid->RowIndex ?>_CampName" value="<?= HtmlEncode($Grid->CampName->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_CampName" class="el_camp_CampName">
<input type="<?= $Grid->CampName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_CampName" id="x<?= $Grid->RowIndex ?>_CampName" data-table="camp" data-field="x_CampName" value="<?= $Grid->CampName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->CampName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->CampName->formatPattern()) ?>"<?= $Grid->CampName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->CampName->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_camp_CampName" class="el_camp_CampName">
<span<?= $Grid->CampName->viewAttributes() ?>>
<?= $Grid->CampName->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="camp" data-field="x_CampName" data-hidden="1" name="fcampgrid$x<?= $Grid->RowIndex ?>_CampName" id="fcampgrid$x<?= $Grid->RowIndex ?>_CampName" value="<?= HtmlEncode($Grid->CampName->FormValue) ?>">
<input type="hidden" data-table="camp" data-field="x_CampName" data-hidden="1" data-old name="fcampgrid$o<?= $Grid->RowIndex ?>_CampName" id="fcampgrid$o<?= $Grid->RowIndex ?>_CampName" value="<?= HtmlEncode($Grid->CampName->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fcampgrid","load"], () => fcampgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fcampgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("camp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
