<?php

namespace PHPMaker2024\cidp24;

// Page object
$BeneficiaryBySupplierSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { beneficiary_by_supplier: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbeneficiary_by_suppliersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbeneficiary_by_suppliersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["DistrictName", [], fields.DistrictName.isInvalid],
            ["NoOfBeneficiaries", [ew.Validators.integer], fields.NoOfBeneficiaries.isInvalid],
            ["GRN", [], fields.GRN.isInvalid],
            ["Seedlings", [ew.Validators.float], fields.Seedlings.isInvalid],
            ["FarmingSeason", [ew.Validators.integer], fields.FarmingSeason.isInvalid],
            ["SeedType", [], fields.SeedType.isInvalid],
            ["NurseryName", [], fields.NurseryName.isInvalid],
            ["Age", [], fields.Age.isInvalid],
            ["Gender", [], fields.Gender.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbeneficiary_by_suppliersearch" id="fbeneficiary_by_suppliersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="beneficiary_by_supplier">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
    <div id="r_DistrictName" class="row"<?= $Page->DistrictName->rowAttributes() ?>>
        <label for="x_DistrictName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_DistrictName"><?= $Page->DistrictName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_DistrictName" id="z_DistrictName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->DistrictName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_DistrictName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DistrictName->getInputTextType() ?>" name="x_DistrictName" id="x_DistrictName" data-table="beneficiary_by_supplier" data-field="x_DistrictName" value="<?= $Page->DistrictName->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DistrictName->formatPattern()) ?>"<?= $Page->DistrictName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { // NoOfBeneficiaries ?>
    <div id="r_NoOfBeneficiaries" class="row"<?= $Page->NoOfBeneficiaries->rowAttributes() ?>>
        <label for="x_NoOfBeneficiaries" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_NoOfBeneficiaries"><?= $Page->NoOfBeneficiaries->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_NoOfBeneficiaries" id="z_NoOfBeneficiaries" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NoOfBeneficiaries->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_NoOfBeneficiaries" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NoOfBeneficiaries->getInputTextType() ?>" name="x_NoOfBeneficiaries" id="x_NoOfBeneficiaries" data-table="beneficiary_by_supplier" data-field="x_NoOfBeneficiaries" value="<?= $Page->NoOfBeneficiaries->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->NoOfBeneficiaries->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NoOfBeneficiaries->formatPattern()) ?>"<?= $Page->NoOfBeneficiaries->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NoOfBeneficiaries->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
    <div id="r_GRN" class="row"<?= $Page->GRN->rowAttributes() ?>>
        <label for="x_GRN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_GRN"><?= $Page->GRN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_GRN" id="z_GRN" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->GRN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_GRN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->GRN->getInputTextType() ?>" name="x_GRN" id="x_GRN" data-table="beneficiary_by_supplier" data-field="x_GRN" value="<?= $Page->GRN->EditValue ?>" size="30" maxlength="25" placeholder="<?= HtmlEncode($Page->GRN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->GRN->formatPattern()) ?>"<?= $Page->GRN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->GRN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Seedlings->Visible) { // Seedlings ?>
    <div id="r_Seedlings" class="row"<?= $Page->Seedlings->rowAttributes() ?>>
        <label for="x_Seedlings" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_Seedlings"><?= $Page->Seedlings->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Seedlings" id="z_Seedlings" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Seedlings->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_Seedlings" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Seedlings->getInputTextType() ?>" name="x_Seedlings" id="x_Seedlings" data-table="beneficiary_by_supplier" data-field="x_Seedlings" value="<?= $Page->Seedlings->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Seedlings->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Seedlings->formatPattern()) ?>"<?= $Page->Seedlings->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Seedlings->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
    <div id="r_FarmingSeason" class="row"<?= $Page->FarmingSeason->rowAttributes() ?>>
        <label for="x_FarmingSeason" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_FarmingSeason"><?= $Page->FarmingSeason->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_FarmingSeason" id="z_FarmingSeason" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FarmingSeason->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_FarmingSeason" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FarmingSeason->getInputTextType() ?>" name="x_FarmingSeason" id="x_FarmingSeason" data-table="beneficiary_by_supplier" data-field="x_FarmingSeason" value="<?= $Page->FarmingSeason->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FarmingSeason->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FarmingSeason->formatPattern()) ?>"<?= $Page->FarmingSeason->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FarmingSeason->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
    <div id="r_SeedType" class="row"<?= $Page->SeedType->rowAttributes() ?>>
        <label for="x_SeedType" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_SeedType"><?= $Page->SeedType->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_SeedType" id="z_SeedType" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SeedType->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_SeedType" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SeedType->getInputTextType() ?>" name="x_SeedType" id="x_SeedType" data-table="beneficiary_by_supplier" data-field="x_SeedType" value="<?= $Page->SeedType->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->SeedType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SeedType->formatPattern()) ?>"<?= $Page->SeedType->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SeedType->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NurseryName->Visible) { // NurseryName ?>
    <div id="r_NurseryName" class="row"<?= $Page->NurseryName->rowAttributes() ?>>
        <label for="x_NurseryName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_NurseryName"><?= $Page->NurseryName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NurseryName" id="z_NurseryName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NurseryName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_NurseryName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NurseryName->getInputTextType() ?>" name="x_NurseryName" id="x_NurseryName" data-table="beneficiary_by_supplier" data-field="x_NurseryName" value="<?= $Page->NurseryName->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NurseryName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NurseryName->formatPattern()) ?>"<?= $Page->NurseryName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NurseryName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
    <div id="r_Age" class="row"<?= $Page->Age->rowAttributes() ?>>
        <label for="x_Age" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_Age"><?= $Page->Age->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Age" id="z_Age" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Age->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_Age" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Age->getInputTextType() ?>" name="x_Age" id="x_Age" data-table="beneficiary_by_supplier" data-field="x_Age" value="<?= $Page->Age->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Age->formatPattern()) ?>"<?= $Page->Age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Age->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender" class="row"<?= $Page->Gender->rowAttributes() ?>>
        <label for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_beneficiary_by_supplier_Gender"><?= $Page->Gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Gender" id="z_Gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_beneficiary_by_supplier_Gender" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Gender->getInputTextType() ?>" name="x_Gender" id="x_Gender" data-table="beneficiary_by_supplier" data-field="x_Gender" value="<?= $Page->Gender->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Gender->formatPattern()) ?>"<?= $Page->Gender->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbeneficiary_by_suppliersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbeneficiary_by_suppliersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbeneficiary_by_suppliersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("beneficiary_by_supplier");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
