<?php

namespace PHPMaker2024\cidp24;

// Page object
$BeneficiaryByGenderView2List = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { beneficiary_by_gender_view2: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "FarmerName": <?= $Page->FarmerName->toClientList($Page) ?>,
            "Age": <?= $Page->Age->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
            "FarmerOrganisation": <?= $Page->FarmerOrganisation->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.14.0", "preview");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbeneficiary_by_gender_view2srch" id="fbeneficiary_by_gender_view2srch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fbeneficiary_by_gender_view2srch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { beneficiary_by_gender_view2: currentTable } });
var currentForm;
var fbeneficiary_by_gender_view2srch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbeneficiary_by_gender_view2srch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "FarmerName": <?= $Page->FarmerName->toClientList($Page) ?>,
            "Age": <?= $Page->Age->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
            "FarmerOrganisation": <?= $Page->FarmerOrganisation->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
<?php
if (!$Page->DistrictName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictName"
            name="x_DistrictName[]"
            class="form-control ew-select<?= $Page->DistrictName->isInvalidClass() ?>"
            data-select2-id="fbeneficiary_by_gender_view2srch_x_DistrictName"
            data-table="beneficiary_by_gender_view2"
            data-field="x_DistrictName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictName->editAttributes() ?>>
            <?= $Page->DistrictName->selectOptionListHtml("x_DistrictName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbeneficiary_by_gender_view2srch", function() {
            var options = {
                name: "x_DistrictName",
                selectId: "fbeneficiary_by_gender_view2srch_x_DistrictName",
                ajax: { id: "x_DistrictName", form: "fbeneficiary_by_gender_view2srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.beneficiary_by_gender_view2.fields.DistrictName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
<?php
if (!$Page->FarmerName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmerName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmerName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmerName"
            name="x_FarmerName[]"
            class="form-control ew-select<?= $Page->FarmerName->isInvalidClass() ?>"
            data-select2-id="fbeneficiary_by_gender_view2srch_x_FarmerName"
            data-table="beneficiary_by_gender_view2"
            data-field="x_FarmerName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmerName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmerName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmerName->editAttributes() ?>>
            <?= $Page->FarmerName->selectOptionListHtml("x_FarmerName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmerName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbeneficiary_by_gender_view2srch", function() {
            var options = {
                name: "x_FarmerName",
                selectId: "fbeneficiary_by_gender_view2srch_x_FarmerName",
                ajax: { id: "x_FarmerName", form: "fbeneficiary_by_gender_view2srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.beneficiary_by_gender_view2.fields.FarmerName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
<?php
if (!$Page->Age->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Age" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Age->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Age"
            name="x_Age[]"
            class="form-control ew-select<?= $Page->Age->isInvalidClass() ?>"
            data-select2-id="fbeneficiary_by_gender_view2srch_x_Age"
            data-table="beneficiary_by_gender_view2"
            data-field="x_Age"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Age->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Age->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Age->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Age->editAttributes() ?>>
            <?= $Page->Age->selectOptionListHtml("x_Age", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Age->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbeneficiary_by_gender_view2srch", function() {
            var options = {
                name: "x_Age",
                selectId: "fbeneficiary_by_gender_view2srch_x_Age",
                ajax: { id: "x_Age", form: "fbeneficiary_by_gender_view2srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.beneficiary_by_gender_view2.fields.Age.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
<?php
if (!$Page->Gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Gender"
            name="x_Gender[]"
            class="form-control ew-select<?= $Page->Gender->isInvalidClass() ?>"
            data-select2-id="fbeneficiary_by_gender_view2srch_x_Gender"
            data-table="beneficiary_by_gender_view2"
            data-field="x_Gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Gender->editAttributes() ?>>
            <?= $Page->Gender->selectOptionListHtml("x_Gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbeneficiary_by_gender_view2srch", function() {
            var options = {
                name: "x_Gender",
                selectId: "fbeneficiary_by_gender_view2srch_x_Gender",
                ajax: { id: "x_Gender", form: "fbeneficiary_by_gender_view2srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.beneficiary_by_gender_view2.fields.Gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
<?php
if (!$Page->MaritalStatus->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_MaritalStatus" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->MaritalStatus->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_MaritalStatus"
            name="x_MaritalStatus[]"
            class="form-control ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
            data-select2-id="fbeneficiary_by_gender_view2srch_x_MaritalStatus"
            data-table="beneficiary_by_gender_view2"
            data-field="x_MaritalStatus"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->MaritalStatus->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->MaritalStatus->editAttributes() ?>>
            <?= $Page->MaritalStatus->selectOptionListHtml("x_MaritalStatus", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbeneficiary_by_gender_view2srch", function() {
            var options = {
                name: "x_MaritalStatus",
                selectId: "fbeneficiary_by_gender_view2srch_x_MaritalStatus",
                ajax: { id: "x_MaritalStatus", form: "fbeneficiary_by_gender_view2srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.beneficiary_by_gender_view2.fields.MaritalStatus.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FarmerOrganisation->Visible) { // FarmerOrganisation ?>
<?php
if (!$Page->FarmerOrganisation->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FarmerOrganisation" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FarmerOrganisation->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FarmerOrganisation"
            name="x_FarmerOrganisation[]"
            class="form-control ew-select<?= $Page->FarmerOrganisation->isInvalidClass() ?>"
            data-select2-id="fbeneficiary_by_gender_view2srch_x_FarmerOrganisation"
            data-table="beneficiary_by_gender_view2"
            data-field="x_FarmerOrganisation"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FarmerOrganisation->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FarmerOrganisation->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FarmerOrganisation->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FarmerOrganisation->editAttributes() ?>>
            <?= $Page->FarmerOrganisation->selectOptionListHtml("x_FarmerOrganisation", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FarmerOrganisation->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fbeneficiary_by_gender_view2srch", function() {
            var options = {
                name: "x_FarmerOrganisation",
                selectId: "fbeneficiary_by_gender_view2srch_x_FarmerOrganisation",
                ajax: { id: "x_FarmerOrganisation", form: "fbeneficiary_by_gender_view2srch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.beneficiary_by_gender_view2.fields.FarmerOrganisation.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
</div><!-- /.row -->
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbeneficiary_by_gender_view2srch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbeneficiary_by_gender_view2srch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbeneficiary_by_gender_view2srch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbeneficiary_by_gender_view2srch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="beneficiary_by_gender_view2">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_beneficiary_by_gender_view2" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_beneficiary_by_gender_view2list" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <th data-name="DistrictName" class="<?= $Page->DistrictName->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_DistrictName" class="beneficiary_by_gender_view2_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <th data-name="FarmerNo" class="<?= $Page->FarmerNo->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmerNo" class="beneficiary_by_gender_view2_FarmerNo"><?= $Page->renderFieldHeader($Page->FarmerNo) ?></div></th>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
        <th data-name="NRC" class="<?= $Page->NRC->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_NRC" class="beneficiary_by_gender_view2_NRC"><?= $Page->renderFieldHeader($Page->NRC) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <th data-name="FarmerName" class="<?= $Page->FarmerName->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmerName" class="beneficiary_by_gender_view2_FarmerName"><?= $Page->renderFieldHeader($Page->FarmerName) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerType->Visible) { // FarmerType ?>
        <th data-name="FarmerType" class="<?= $Page->FarmerType->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmerType" class="beneficiary_by_gender_view2_FarmerType"><?= $Page->renderFieldHeader($Page->FarmerType) ?></div></th>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
        <th data-name="DOB" class="<?= $Page->DOB->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_DOB" class="beneficiary_by_gender_view2_DOB"><?= $Page->renderFieldHeader($Page->DOB) ?></div></th>
<?php } ?>
<?php if ($Page->Age->Visible) { // Age ?>
        <th data-name="Age" class="<?= $Page->Age->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_Age" class="beneficiary_by_gender_view2_Age"><?= $Page->renderFieldHeader($Page->Age) ?></div></th>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
        <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_Gender" class="beneficiary_by_gender_view2_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
        <th data-name="MaritalStatus" class="<?= $Page->MaritalStatus->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_MaritalStatus" class="beneficiary_by_gender_view2_MaritalStatus"><?= $Page->renderFieldHeader($Page->MaritalStatus) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerOrganisation->Visible) { // FarmerOrganisation ?>
        <th data-name="FarmerOrganisation" class="<?= $Page->FarmerOrganisation->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmerOrganisation" class="beneficiary_by_gender_view2_FarmerOrganisation"><?= $Page->renderFieldHeader($Page->FarmerOrganisation) ?></div></th>
<?php } ?>
<?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <th data-name="FarmNo" class="<?= $Page->FarmNo->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmNo" class="beneficiary_by_gender_view2_FarmNo"><?= $Page->renderFieldHeader($Page->FarmNo) ?></div></th>
<?php } ?>
<?php if ($Page->FieldType->Visible) { // FieldType ?>
        <th data-name="FieldType" class="<?= $Page->FieldType->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FieldType" class="beneficiary_by_gender_view2_FieldType"><?= $Page->renderFieldHeader($Page->FieldType) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
        <th data-name="FarmSizeEstimated" class="<?= $Page->FarmSizeEstimated->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmSizeEstimated" class="beneficiary_by_gender_view2_FarmSizeEstimated"><?= $Page->renderFieldHeader($Page->FarmSizeEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <th data-name="TreesPlantedEstimated" class="<?= $Page->TreesPlantedEstimated->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_TreesPlantedEstimated" class="beneficiary_by_gender_view2_TreesPlantedEstimated"><?= $Page->renderFieldHeader($Page->TreesPlantedEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <th data-name="TreesPlantedVerified" class="<?= $Page->TreesPlantedVerified->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_TreesPlantedVerified" class="beneficiary_by_gender_view2_TreesPlantedVerified"><?= $Page->renderFieldHeader($Page->TreesPlantedVerified) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
        <th data-name="FarmSizeVerified" class="<?= $Page->FarmSizeVerified->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmSizeVerified" class="beneficiary_by_gender_view2_FarmSizeVerified"><?= $Page->renderFieldHeader($Page->FarmSizeVerified) ?></div></th>
<?php } ?>
<?php if ($Page->TransNo->Visible) { // TransNo ?>
        <th data-name="TransNo" class="<?= $Page->TransNo->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_TransNo" class="beneficiary_by_gender_view2_TransNo"><?= $Page->renderFieldHeader($Page->TransNo) ?></div></th>
<?php } ?>
<?php if ($Page->GRN->Visible) { // GRN ?>
        <th data-name="GRN" class="<?= $Page->GRN->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_GRN" class="beneficiary_by_gender_view2_GRN"><?= $Page->renderFieldHeader($Page->GRN) ?></div></th>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
        <th data-name="TreesAllocated" class="<?= $Page->TreesAllocated->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_TreesAllocated" class="beneficiary_by_gender_view2_TreesAllocated"><?= $Page->renderFieldHeader($Page->TreesAllocated) ?></div></th>
<?php } ?>
<?php if ($Page->EstimatedLandSizePlanted->Visible) { // EstimatedLandSizePlanted ?>
        <th data-name="EstimatedLandSizePlanted" class="<?= $Page->EstimatedLandSizePlanted->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_EstimatedLandSizePlanted" class="beneficiary_by_gender_view2_EstimatedLandSizePlanted"><?= $Page->renderFieldHeader($Page->EstimatedLandSizePlanted) ?></div></th>
<?php } ?>
<?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <th data-name="FarmingSeason" class="<?= $Page->FarmingSeason->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmingSeason" class="beneficiary_by_gender_view2_FarmingSeason"><?= $Page->renderFieldHeader($Page->FarmingSeason) ?></div></th>
<?php } ?>
<?php if ($Page->SeedType->Visible) { // SeedType ?>
        <th data-name="SeedType" class="<?= $Page->SeedType->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_SeedType" class="beneficiary_by_gender_view2_SeedType"><?= $Page->renderFieldHeader($Page->SeedType) ?></div></th>
<?php } ?>
<?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <th data-name="SourcesOfSeedlings" class="<?= $Page->SourcesOfSeedlings->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_SourcesOfSeedlings" class="beneficiary_by_gender_view2_SourcesOfSeedlings"><?= $Page->renderFieldHeader($Page->SourcesOfSeedlings) ?></div></th>
<?php } ?>
<?php if ($Page->FarmerTypeName->Visible) { // FarmerTypeName ?>
        <th data-name="FarmerTypeName" class="<?= $Page->FarmerTypeName->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_FarmerTypeName" class="beneficiary_by_gender_view2_FarmerTypeName"><?= $Page->renderFieldHeader($Page->FarmerTypeName) ?></div></th>
<?php } ?>
<?php if ($Page->NurseryName->Visible) { // NurseryName ?>
        <th data-name="NurseryName" class="<?= $Page->NurseryName->headerCellClass() ?>"><div id="elh_beneficiary_by_gender_view2_NurseryName" class="beneficiary_by_gender_view2_NurseryName"><?= $Page->renderFieldHeader($Page->NurseryName) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->DistrictName->Visible) { // DistrictName ?>
        <td data-name="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_DistrictName" class="el_beneficiary_by_gender_view2_DistrictName">
<span<?= $Page->DistrictName->viewAttributes() ?>>
<?= $Page->DistrictName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerNo->Visible) { // FarmerNo ?>
        <td data-name="FarmerNo"<?= $Page->FarmerNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmerNo" class="el_beneficiary_by_gender_view2_FarmerNo">
<span<?= $Page->FarmerNo->viewAttributes() ?>>
<?= $Page->FarmerNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NRC->Visible) { // NRC ?>
        <td data-name="NRC"<?= $Page->NRC->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_NRC" class="el_beneficiary_by_gender_view2_NRC">
<span<?= $Page->NRC->viewAttributes() ?>>
<?= $Page->NRC->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerName->Visible) { // FarmerName ?>
        <td data-name="FarmerName"<?= $Page->FarmerName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmerName" class="el_beneficiary_by_gender_view2_FarmerName">
<span<?= $Page->FarmerName->viewAttributes() ?>>
<?= $Page->FarmerName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerType->Visible) { // FarmerType ?>
        <td data-name="FarmerType"<?= $Page->FarmerType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmerType" class="el_beneficiary_by_gender_view2_FarmerType">
<span<?= $Page->FarmerType->viewAttributes() ?>>
<?= $Page->FarmerType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->DOB->Visible) { // DOB ?>
        <td data-name="DOB"<?= $Page->DOB->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_DOB" class="el_beneficiary_by_gender_view2_DOB">
<span<?= $Page->DOB->viewAttributes() ?>>
<?= $Page->DOB->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Age->Visible) { // Age ?>
        <td data-name="Age"<?= $Page->Age->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_Age" class="el_beneficiary_by_gender_view2_Age">
<span<?= $Page->Age->viewAttributes() ?>>
<?= $Page->Age->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Gender->Visible) { // Gender ?>
        <td data-name="Gender"<?= $Page->Gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_Gender" class="el_beneficiary_by_gender_view2_Gender">
<span<?= $Page->Gender->viewAttributes() ?>>
<?= $Page->Gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
        <td data-name="MaritalStatus"<?= $Page->MaritalStatus->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_MaritalStatus" class="el_beneficiary_by_gender_view2_MaritalStatus">
<span<?= $Page->MaritalStatus->viewAttributes() ?>>
<?= $Page->MaritalStatus->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerOrganisation->Visible) { // FarmerOrganisation ?>
        <td data-name="FarmerOrganisation"<?= $Page->FarmerOrganisation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmerOrganisation" class="el_beneficiary_by_gender_view2_FarmerOrganisation">
<span<?= $Page->FarmerOrganisation->viewAttributes() ?>>
<?= $Page->FarmerOrganisation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmNo->Visible) { // FarmNo ?>
        <td data-name="FarmNo"<?= $Page->FarmNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmNo" class="el_beneficiary_by_gender_view2_FarmNo">
<span<?= $Page->FarmNo->viewAttributes() ?>>
<?= $Page->FarmNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FieldType->Visible) { // FieldType ?>
        <td data-name="FieldType"<?= $Page->FieldType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FieldType" class="el_beneficiary_by_gender_view2_FieldType">
<span<?= $Page->FieldType->viewAttributes() ?>>
<?= $Page->FieldType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmSizeEstimated->Visible) { // FarmSizeEstimated ?>
        <td data-name="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmSizeEstimated" class="el_beneficiary_by_gender_view2_FarmSizeEstimated">
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TreesPlantedEstimated->Visible) { // TreesPlantedEstimated ?>
        <td data-name="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_TreesPlantedEstimated" class="el_beneficiary_by_gender_view2_TreesPlantedEstimated">
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TreesPlantedVerified->Visible) { // TreesPlantedVerified ?>
        <td data-name="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_TreesPlantedVerified" class="el_beneficiary_by_gender_view2_TreesPlantedVerified">
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmSizeVerified->Visible) { // FarmSizeVerified ?>
        <td data-name="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmSizeVerified" class="el_beneficiary_by_gender_view2_FarmSizeVerified">
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TransNo->Visible) { // TransNo ?>
        <td data-name="TransNo"<?= $Page->TransNo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_TransNo" class="el_beneficiary_by_gender_view2_TransNo">
<span<?= $Page->TransNo->viewAttributes() ?>>
<?= $Page->TransNo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->GRN->Visible) { // GRN ?>
        <td data-name="GRN"<?= $Page->GRN->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_GRN" class="el_beneficiary_by_gender_view2_GRN">
<span<?= $Page->GRN->viewAttributes() ?>>
<?= $Page->GRN->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->TreesAllocated->Visible) { // TreesAllocated ?>
        <td data-name="TreesAllocated"<?= $Page->TreesAllocated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_TreesAllocated" class="el_beneficiary_by_gender_view2_TreesAllocated">
<span<?= $Page->TreesAllocated->viewAttributes() ?>>
<?= $Page->TreesAllocated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->EstimatedLandSizePlanted->Visible) { // EstimatedLandSizePlanted ?>
        <td data-name="EstimatedLandSizePlanted"<?= $Page->EstimatedLandSizePlanted->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_EstimatedLandSizePlanted" class="el_beneficiary_by_gender_view2_EstimatedLandSizePlanted">
<span<?= $Page->EstimatedLandSizePlanted->viewAttributes() ?>>
<?= $Page->EstimatedLandSizePlanted->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmingSeason->Visible) { // FarmingSeason ?>
        <td data-name="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmingSeason" class="el_beneficiary_by_gender_view2_FarmingSeason">
<span<?= $Page->FarmingSeason->viewAttributes() ?>>
<?= $Page->FarmingSeason->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SeedType->Visible) { // SeedType ?>
        <td data-name="SeedType"<?= $Page->SeedType->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_SeedType" class="el_beneficiary_by_gender_view2_SeedType">
<span<?= $Page->SeedType->viewAttributes() ?>>
<?= $Page->SeedType->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->SourcesOfSeedlings->Visible) { // SourcesOfSeedlings ?>
        <td data-name="SourcesOfSeedlings"<?= $Page->SourcesOfSeedlings->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_SourcesOfSeedlings" class="el_beneficiary_by_gender_view2_SourcesOfSeedlings">
<span<?= $Page->SourcesOfSeedlings->viewAttributes() ?>>
<?= $Page->SourcesOfSeedlings->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FarmerTypeName->Visible) { // FarmerTypeName ?>
        <td data-name="FarmerTypeName"<?= $Page->FarmerTypeName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_FarmerTypeName" class="el_beneficiary_by_gender_view2_FarmerTypeName">
<span<?= $Page->FarmerTypeName->viewAttributes() ?>>
<?= $Page->FarmerTypeName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NurseryName->Visible) { // NurseryName ?>
        <td data-name="NurseryName"<?= $Page->NurseryName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_beneficiary_by_gender_view2_NurseryName" class="el_beneficiary_by_gender_view2_NurseryName">
<span<?= $Page->NurseryName->viewAttributes() ?>>
<?= $Page->NurseryName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("beneficiary_by_gender_view2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
