<?php

namespace PHPMaker2024\cidp24;

// Page object
$AwpSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { awp: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fawpsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fawpsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["Component", [], fields.Component.isInvalid],
            ["Subcomponent", [], fields.Subcomponent.isInvalid],
            ["InvestmentCost", [], fields.InvestmentCost.isInvalid],
            ["Type", [], fields.Type.isInvalid],
            ["CategoryofExpenditure", [], fields.CategoryofExpenditure.isInvalid],
            ["Activity", [], fields.Activity.isInvalid],
            ["Implementer", [], fields.Implementer.isInvalid],
            ["Indicator", [], fields.Indicator.isInvalid],
            ["ProjectTarget", [ew.Validators.float], fields.ProjectTarget.isInvalid],
            ["_2017Target", [ew.Validators.float], fields._2017Target.isInvalid],
            ["ProjectBudget", [ew.Validators.float], fields.ProjectBudget.isInvalid],
            ["StartMonth", [], fields.StartMonth.isInvalid],
            ["EndMonth", [], fields.EndMonth.isInvalid],
            ["LineNo", [ew.Validators.integer], fields.LineNo.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "StartMonth": <?= $Page->StartMonth->toClientList($Page) ?>,
            "EndMonth": <?= $Page->EndMonth->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fawpsearch" id="fawpsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="awp">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->Component->Visible) { // Component ?>
    <div id="r_Component" class="row"<?= $Page->Component->rowAttributes() ?>>
        <label for="x_Component" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_Component"><?= $Page->Component->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Component" id="z_Component" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Component->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_Component" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Component->getInputTextType() ?>" name="x_Component" id="x_Component" data-table="awp" data-field="x_Component" value="<?= $Page->Component->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Component->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Component->formatPattern()) ?>"<?= $Page->Component->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Component->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Subcomponent->Visible) { // Sub component ?>
    <div id="r_Subcomponent" class="row"<?= $Page->Subcomponent->rowAttributes() ?>>
        <label for="x_Subcomponent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_Subcomponent"><?= $Page->Subcomponent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Subcomponent" id="z_Subcomponent" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Subcomponent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_Subcomponent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Subcomponent->getInputTextType() ?>" name="x_Subcomponent" id="x_Subcomponent" data-table="awp" data-field="x_Subcomponent" value="<?= $Page->Subcomponent->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Subcomponent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Subcomponent->formatPattern()) ?>"<?= $Page->Subcomponent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Subcomponent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->InvestmentCost->Visible) { // Investment Cost ?>
    <div id="r_InvestmentCost" class="row"<?= $Page->InvestmentCost->rowAttributes() ?>>
        <label for="x_InvestmentCost" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_InvestmentCost"><?= $Page->InvestmentCost->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_InvestmentCost" id="z_InvestmentCost" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->InvestmentCost->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_InvestmentCost" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->InvestmentCost->getInputTextType() ?>" name="x_InvestmentCost" id="x_InvestmentCost" data-table="awp" data-field="x_InvestmentCost" value="<?= $Page->InvestmentCost->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->InvestmentCost->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InvestmentCost->formatPattern()) ?>"<?= $Page->InvestmentCost->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InvestmentCost->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Type->Visible) { // Type ?>
    <div id="r_Type" class="row"<?= $Page->Type->rowAttributes() ?>>
        <label for="x_Type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_Type"><?= $Page->Type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Type" id="z_Type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_Type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Type->getInputTextType() ?>" name="x_Type" id="x_Type" data-table="awp" data-field="x_Type" value="<?= $Page->Type->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Type->formatPattern()) ?>"<?= $Page->Type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CategoryofExpenditure->Visible) { // Category of Expenditure ?>
    <div id="r_CategoryofExpenditure" class="row"<?= $Page->CategoryofExpenditure->rowAttributes() ?>>
        <label for="x_CategoryofExpenditure" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_CategoryofExpenditure"><?= $Page->CategoryofExpenditure->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_CategoryofExpenditure" id="z_CategoryofExpenditure" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CategoryofExpenditure->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_CategoryofExpenditure" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->CategoryofExpenditure->getInputTextType() ?>" name="x_CategoryofExpenditure" id="x_CategoryofExpenditure" data-table="awp" data-field="x_CategoryofExpenditure" value="<?= $Page->CategoryofExpenditure->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->CategoryofExpenditure->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->CategoryofExpenditure->formatPattern()) ?>"<?= $Page->CategoryofExpenditure->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->CategoryofExpenditure->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Activity->Visible) { // Activity ?>
    <div id="r_Activity" class="row"<?= $Page->Activity->rowAttributes() ?>>
        <label for="x_Activity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_Activity"><?= $Page->Activity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Activity" id="z_Activity" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Activity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_Activity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Activity->getInputTextType() ?>" name="x_Activity" id="x_Activity" data-table="awp" data-field="x_Activity" value="<?= $Page->Activity->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Activity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Activity->formatPattern()) ?>"<?= $Page->Activity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Activity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Implementer->Visible) { // Implementer ?>
    <div id="r_Implementer" class="row"<?= $Page->Implementer->rowAttributes() ?>>
        <label for="x_Implementer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_Implementer"><?= $Page->Implementer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Implementer" id="z_Implementer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Implementer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_Implementer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Implementer->getInputTextType() ?>" name="x_Implementer" id="x_Implementer" data-table="awp" data-field="x_Implementer" value="<?= $Page->Implementer->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Implementer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Implementer->formatPattern()) ?>"<?= $Page->Implementer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Implementer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Indicator->Visible) { // Indicator ?>
    <div id="r_Indicator" class="row"<?= $Page->Indicator->rowAttributes() ?>>
        <label for="x_Indicator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_Indicator"><?= $Page->Indicator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Indicator" id="z_Indicator" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Indicator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_Indicator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Indicator->getInputTextType() ?>" name="x_Indicator" id="x_Indicator" data-table="awp" data-field="x_Indicator" value="<?= $Page->Indicator->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Indicator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Indicator->formatPattern()) ?>"<?= $Page->Indicator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Indicator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectTarget->Visible) { // Project Target ?>
    <div id="r_ProjectTarget" class="row"<?= $Page->ProjectTarget->rowAttributes() ?>>
        <label for="x_ProjectTarget" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_ProjectTarget"><?= $Page->ProjectTarget->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProjectTarget" id="z_ProjectTarget" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectTarget->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_ProjectTarget" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProjectTarget->getInputTextType() ?>" name="x_ProjectTarget" id="x_ProjectTarget" data-table="awp" data-field="x_ProjectTarget" value="<?= $Page->ProjectTarget->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectTarget->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectTarget->formatPattern()) ?>"<?= $Page->ProjectTarget->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectTarget->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_2017Target->Visible) { // 2017 Target ?>
    <div id="r__2017Target" class="row"<?= $Page->_2017Target->rowAttributes() ?>>
        <label for="x__2017Target" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp__2017Target"><?= $Page->_2017Target->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__2017Target" id="z__2017Target" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_2017Target->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp__2017Target" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_2017Target->getInputTextType() ?>" name="x__2017Target" id="x__2017Target" data-table="awp" data-field="x__2017Target" value="<?= $Page->_2017Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_2017Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2017Target->formatPattern()) ?>"<?= $Page->_2017Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_2017Target->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectBudget->Visible) { // Project Budget ?>
    <div id="r_ProjectBudget" class="row"<?= $Page->ProjectBudget->rowAttributes() ?>>
        <label for="x_ProjectBudget" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_ProjectBudget"><?= $Page->ProjectBudget->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProjectBudget" id="z_ProjectBudget" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectBudget->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_ProjectBudget" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProjectBudget->getInputTextType() ?>" name="x_ProjectBudget" id="x_ProjectBudget" data-table="awp" data-field="x_ProjectBudget" value="<?= $Page->ProjectBudget->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectBudget->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectBudget->formatPattern()) ?>"<?= $Page->ProjectBudget->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectBudget->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->StartMonth->Visible) { // StartMonth ?>
    <div id="r_StartMonth" class="row"<?= $Page->StartMonth->rowAttributes() ?>>
        <label for="x_StartMonth" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_StartMonth"><?= $Page->StartMonth->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_StartMonth" id="z_StartMonth" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->StartMonth->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_StartMonth" class="ew-search-field ew-search-field-single">
    <select
        id="x_StartMonth"
        name="x_StartMonth"
        class="form-select ew-select<?= $Page->StartMonth->isInvalidClass() ?>"
        <?php if (!$Page->StartMonth->IsNativeSelect) { ?>
        data-select2-id="fawpsearch_x_StartMonth"
        <?php } ?>
        data-table="awp"
        data-field="x_StartMonth"
        data-value-separator="<?= $Page->StartMonth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->StartMonth->getPlaceHolder()) ?>"
        <?= $Page->StartMonth->editAttributes() ?>>
        <?= $Page->StartMonth->selectOptionListHtml("x_StartMonth") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->StartMonth->getErrorMessage(false) ?></div>
<?= $Page->StartMonth->Lookup->getParamTag($Page, "p_x_StartMonth") ?>
<?php if (!$Page->StartMonth->IsNativeSelect) { ?>
<script>
loadjs.ready("fawpsearch", function() {
    var options = { name: "x_StartMonth", selectId: "fawpsearch_x_StartMonth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fawpsearch.lists.StartMonth?.lookupOptions.length) {
        options.data = { id: "x_StartMonth", form: "fawpsearch" };
    } else {
        options.ajax = { id: "x_StartMonth", form: "fawpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.awp.fields.StartMonth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->EndMonth->Visible) { // EndMonth ?>
    <div id="r_EndMonth" class="row"<?= $Page->EndMonth->rowAttributes() ?>>
        <label for="x_EndMonth" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_EndMonth"><?= $Page->EndMonth->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_EndMonth" id="z_EndMonth" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->EndMonth->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_EndMonth" class="ew-search-field ew-search-field-single">
    <select
        id="x_EndMonth"
        name="x_EndMonth"
        class="form-select ew-select<?= $Page->EndMonth->isInvalidClass() ?>"
        <?php if (!$Page->EndMonth->IsNativeSelect) { ?>
        data-select2-id="fawpsearch_x_EndMonth"
        <?php } ?>
        data-table="awp"
        data-field="x_EndMonth"
        data-value-separator="<?= $Page->EndMonth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->EndMonth->getPlaceHolder()) ?>"
        <?= $Page->EndMonth->editAttributes() ?>>
        <?= $Page->EndMonth->selectOptionListHtml("x_EndMonth") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->EndMonth->getErrorMessage(false) ?></div>
<?= $Page->EndMonth->Lookup->getParamTag($Page, "p_x_EndMonth") ?>
<?php if (!$Page->EndMonth->IsNativeSelect) { ?>
<script>
loadjs.ready("fawpsearch", function() {
    var options = { name: "x_EndMonth", selectId: "fawpsearch_x_EndMonth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fawpsearch.lists.EndMonth?.lookupOptions.length) {
        options.data = { id: "x_EndMonth", form: "fawpsearch" };
    } else {
        options.ajax = { id: "x_EndMonth", form: "fawpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.awp.fields.EndMonth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->LineNo->Visible) { // LineNo ?>
    <div id="r_LineNo" class="row"<?= $Page->LineNo->rowAttributes() ?>>
        <label for="x_LineNo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_awp_LineNo"><?= $Page->LineNo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_LineNo" id="z_LineNo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->LineNo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_awp_LineNo" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->LineNo->getInputTextType() ?>" name="x_LineNo" id="x_LineNo" data-table="awp" data-field="x_LineNo" value="<?= $Page->LineNo->EditValue ?>" placeholder="<?= HtmlEncode($Page->LineNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LineNo->formatPattern()) ?>"<?= $Page->LineNo->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->LineNo->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fawpsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fawpsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fawpsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("awp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
