<?php

namespace PHPMaker2024\cidp24;

// Page object
$AwpList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { awp: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["Component", [fields.Component.visible && fields.Component.required ? ew.Validators.required(fields.Component.caption) : null], fields.Component.isInvalid],
            ["Subcomponent", [fields.Subcomponent.visible && fields.Subcomponent.required ? ew.Validators.required(fields.Subcomponent.caption) : null], fields.Subcomponent.isInvalid],
            ["InvestmentCost", [fields.InvestmentCost.visible && fields.InvestmentCost.required ? ew.Validators.required(fields.InvestmentCost.caption) : null], fields.InvestmentCost.isInvalid],
            ["Type", [fields.Type.visible && fields.Type.required ? ew.Validators.required(fields.Type.caption) : null], fields.Type.isInvalid],
            ["CategoryofExpenditure", [fields.CategoryofExpenditure.visible && fields.CategoryofExpenditure.required ? ew.Validators.required(fields.CategoryofExpenditure.caption) : null], fields.CategoryofExpenditure.isInvalid],
            ["Activity", [fields.Activity.visible && fields.Activity.required ? ew.Validators.required(fields.Activity.caption) : null], fields.Activity.isInvalid],
            ["Implementer", [fields.Implementer.visible && fields.Implementer.required ? ew.Validators.required(fields.Implementer.caption) : null], fields.Implementer.isInvalid],
            ["Indicator", [fields.Indicator.visible && fields.Indicator.required ? ew.Validators.required(fields.Indicator.caption) : null], fields.Indicator.isInvalid],
            ["ProjectTarget", [fields.ProjectTarget.visible && fields.ProjectTarget.required ? ew.Validators.required(fields.ProjectTarget.caption) : null, ew.Validators.float], fields.ProjectTarget.isInvalid],
            ["_2017Target", [fields._2017Target.visible && fields._2017Target.required ? ew.Validators.required(fields._2017Target.caption) : null, ew.Validators.float], fields._2017Target.isInvalid],
            ["ProjectBudget", [fields.ProjectBudget.visible && fields.ProjectBudget.required ? ew.Validators.required(fields.ProjectBudget.caption) : null, ew.Validators.float], fields.ProjectBudget.isInvalid],
            ["StartMonth", [fields.StartMonth.visible && fields.StartMonth.required ? ew.Validators.required(fields.StartMonth.caption) : null], fields.StartMonth.isInvalid],
            ["EndMonth", [fields.EndMonth.visible && fields.EndMonth.required ? ew.Validators.required(fields.EndMonth.caption) : null], fields.EndMonth.isInvalid],
            ["LineNo", [fields.LineNo.visible && fields.LineNo.required ? ew.Validators.required(fields.LineNo.caption) : null], fields.LineNo.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["Component",false],["Subcomponent",false],["InvestmentCost",false],["Type",false],["CategoryofExpenditure",false],["Activity",false],["Implementer",false],["Indicator",false],["ProjectTarget",false],["_2017Target",false],["ProjectBudget",false],["StartMonth",false],["EndMonth",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "StartMonth": <?= $Page->StartMonth->toClientList($Page) ?>,
            "EndMonth": <?= $Page->EndMonth->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.14.0", "preview");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fawpsrch" id="fawpsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fawpsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { awp: currentTable } });
var currentForm;
var fawpsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fawpsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fawpsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fawpsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fawpsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fawpsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="awp">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_awp" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_awplist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->Component->Visible) { // Component ?>
        <th data-name="Component" class="<?= $Page->Component->headerCellClass() ?>"><div id="elh_awp_Component" class="awp_Component"><?= $Page->renderFieldHeader($Page->Component) ?></div></th>
<?php } ?>
<?php if ($Page->Subcomponent->Visible) { // Sub component ?>
        <th data-name="Subcomponent" class="<?= $Page->Subcomponent->headerCellClass() ?>"><div id="elh_awp_Subcomponent" class="awp_Subcomponent"><?= $Page->renderFieldHeader($Page->Subcomponent) ?></div></th>
<?php } ?>
<?php if ($Page->InvestmentCost->Visible) { // Investment Cost ?>
        <th data-name="InvestmentCost" class="<?= $Page->InvestmentCost->headerCellClass() ?>"><div id="elh_awp_InvestmentCost" class="awp_InvestmentCost"><?= $Page->renderFieldHeader($Page->InvestmentCost) ?></div></th>
<?php } ?>
<?php if ($Page->Type->Visible) { // Type ?>
        <th data-name="Type" class="<?= $Page->Type->headerCellClass() ?>"><div id="elh_awp_Type" class="awp_Type"><?= $Page->renderFieldHeader($Page->Type) ?></div></th>
<?php } ?>
<?php if ($Page->CategoryofExpenditure->Visible) { // Category of Expenditure ?>
        <th data-name="CategoryofExpenditure" class="<?= $Page->CategoryofExpenditure->headerCellClass() ?>"><div id="elh_awp_CategoryofExpenditure" class="awp_CategoryofExpenditure"><?= $Page->renderFieldHeader($Page->CategoryofExpenditure) ?></div></th>
<?php } ?>
<?php if ($Page->Activity->Visible) { // Activity ?>
        <th data-name="Activity" class="<?= $Page->Activity->headerCellClass() ?>"><div id="elh_awp_Activity" class="awp_Activity"><?= $Page->renderFieldHeader($Page->Activity) ?></div></th>
<?php } ?>
<?php if ($Page->Implementer->Visible) { // Implementer ?>
        <th data-name="Implementer" class="<?= $Page->Implementer->headerCellClass() ?>"><div id="elh_awp_Implementer" class="awp_Implementer"><?= $Page->renderFieldHeader($Page->Implementer) ?></div></th>
<?php } ?>
<?php if ($Page->Indicator->Visible) { // Indicator ?>
        <th data-name="Indicator" class="<?= $Page->Indicator->headerCellClass() ?>"><div id="elh_awp_Indicator" class="awp_Indicator"><?= $Page->renderFieldHeader($Page->Indicator) ?></div></th>
<?php } ?>
<?php if ($Page->ProjectTarget->Visible) { // Project Target ?>
        <th data-name="ProjectTarget" class="<?= $Page->ProjectTarget->headerCellClass() ?>"><div id="elh_awp_ProjectTarget" class="awp_ProjectTarget"><?= $Page->renderFieldHeader($Page->ProjectTarget) ?></div></th>
<?php } ?>
<?php if ($Page->_2017Target->Visible) { // 2017 Target ?>
        <th data-name="_2017Target" class="<?= $Page->_2017Target->headerCellClass() ?>"><div id="elh_awp__2017Target" class="awp__2017Target"><?= $Page->renderFieldHeader($Page->_2017Target) ?></div></th>
<?php } ?>
<?php if ($Page->ProjectBudget->Visible) { // Project Budget ?>
        <th data-name="ProjectBudget" class="<?= $Page->ProjectBudget->headerCellClass() ?>"><div id="elh_awp_ProjectBudget" class="awp_ProjectBudget"><?= $Page->renderFieldHeader($Page->ProjectBudget) ?></div></th>
<?php } ?>
<?php if ($Page->StartMonth->Visible) { // StartMonth ?>
        <th data-name="StartMonth" class="<?= $Page->StartMonth->headerCellClass() ?>"><div id="elh_awp_StartMonth" class="awp_StartMonth"><?= $Page->renderFieldHeader($Page->StartMonth) ?></div></th>
<?php } ?>
<?php if ($Page->EndMonth->Visible) { // EndMonth ?>
        <th data-name="EndMonth" class="<?= $Page->EndMonth->headerCellClass() ?>"><div id="elh_awp_EndMonth" class="awp_EndMonth"><?= $Page->renderFieldHeader($Page->EndMonth) ?></div></th>
<?php } ?>
<?php if ($Page->LineNo->Visible) { // LineNo ?>
        <th data-name="LineNo" class="<?= $Page->LineNo->headerCellClass() ?>"><div id="elh_awp_LineNo" class="awp_LineNo"><?= $Page->renderFieldHeader($Page->LineNo) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->Component->Visible) { // Component ?>
        <td data-name="Component"<?= $Page->Component->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Component" class="el_awp_Component">
<textarea data-table="awp" data-field="x_Component" name="x<?= $Page->RowIndex ?>_Component" id="x<?= $Page->RowIndex ?>_Component" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Component->getPlaceHolder()) ?>"<?= $Page->Component->editAttributes() ?>><?= $Page->Component->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->Component->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_Component" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Component" id="o<?= $Page->RowIndex ?>_Component" value="<?= HtmlEncode($Page->Component->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Component" class="el_awp_Component">
<textarea data-table="awp" data-field="x_Component" name="x<?= $Page->RowIndex ?>_Component" id="x<?= $Page->RowIndex ?>_Component" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Component->getPlaceHolder()) ?>"<?= $Page->Component->editAttributes() ?>><?= $Page->Component->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->Component->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Component" class="el_awp_Component">
<span<?= $Page->Component->viewAttributes() ?>>
<?= $Page->Component->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Subcomponent->Visible) { // Sub component ?>
        <td data-name="Subcomponent"<?= $Page->Subcomponent->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Subcomponent" class="el_awp_Subcomponent">
<textarea data-table="awp" data-field="x_Subcomponent" name="x<?= $Page->RowIndex ?>_Subcomponent" id="x<?= $Page->RowIndex ?>_Subcomponent" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Subcomponent->getPlaceHolder()) ?>"<?= $Page->Subcomponent->editAttributes() ?>><?= $Page->Subcomponent->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->Subcomponent->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_Subcomponent" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Subcomponent" id="o<?= $Page->RowIndex ?>_Subcomponent" value="<?= HtmlEncode($Page->Subcomponent->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Subcomponent" class="el_awp_Subcomponent">
<textarea data-table="awp" data-field="x_Subcomponent" name="x<?= $Page->RowIndex ?>_Subcomponent" id="x<?= $Page->RowIndex ?>_Subcomponent" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Subcomponent->getPlaceHolder()) ?>"<?= $Page->Subcomponent->editAttributes() ?>><?= $Page->Subcomponent->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->Subcomponent->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Subcomponent" class="el_awp_Subcomponent">
<span<?= $Page->Subcomponent->viewAttributes() ?>>
<?= $Page->Subcomponent->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->InvestmentCost->Visible) { // Investment Cost ?>
        <td data-name="InvestmentCost"<?= $Page->InvestmentCost->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_InvestmentCost" class="el_awp_InvestmentCost">
<input type="<?= $Page->InvestmentCost->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_InvestmentCost" id="x<?= $Page->RowIndex ?>_InvestmentCost" data-table="awp" data-field="x_InvestmentCost" value="<?= $Page->InvestmentCost->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->InvestmentCost->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InvestmentCost->formatPattern()) ?>"<?= $Page->InvestmentCost->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InvestmentCost->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_InvestmentCost" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_InvestmentCost" id="o<?= $Page->RowIndex ?>_InvestmentCost" value="<?= HtmlEncode($Page->InvestmentCost->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_InvestmentCost" class="el_awp_InvestmentCost">
<input type="<?= $Page->InvestmentCost->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_InvestmentCost" id="x<?= $Page->RowIndex ?>_InvestmentCost" data-table="awp" data-field="x_InvestmentCost" value="<?= $Page->InvestmentCost->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->InvestmentCost->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->InvestmentCost->formatPattern()) ?>"<?= $Page->InvestmentCost->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->InvestmentCost->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_InvestmentCost" class="el_awp_InvestmentCost">
<span<?= $Page->InvestmentCost->viewAttributes() ?>>
<?= $Page->InvestmentCost->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Type->Visible) { // Type ?>
        <td data-name="Type"<?= $Page->Type->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Type" class="el_awp_Type">
<input type="<?= $Page->Type->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Type" id="x<?= $Page->RowIndex ?>_Type" data-table="awp" data-field="x_Type" value="<?= $Page->Type->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Type->formatPattern()) ?>"<?= $Page->Type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Type->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_Type" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Type" id="o<?= $Page->RowIndex ?>_Type" value="<?= HtmlEncode($Page->Type->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Type" class="el_awp_Type">
<input type="<?= $Page->Type->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Type" id="x<?= $Page->RowIndex ?>_Type" data-table="awp" data-field="x_Type" value="<?= $Page->Type->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Type->formatPattern()) ?>"<?= $Page->Type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Type->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Type" class="el_awp_Type">
<span<?= $Page->Type->viewAttributes() ?>>
<?= $Page->Type->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->CategoryofExpenditure->Visible) { // Category of Expenditure ?>
        <td data-name="CategoryofExpenditure"<?= $Page->CategoryofExpenditure->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_CategoryofExpenditure" class="el_awp_CategoryofExpenditure">
<textarea data-table="awp" data-field="x_CategoryofExpenditure" name="x<?= $Page->RowIndex ?>_CategoryofExpenditure" id="x<?= $Page->RowIndex ?>_CategoryofExpenditure" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->CategoryofExpenditure->getPlaceHolder()) ?>"<?= $Page->CategoryofExpenditure->editAttributes() ?>><?= $Page->CategoryofExpenditure->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->CategoryofExpenditure->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_CategoryofExpenditure" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_CategoryofExpenditure" id="o<?= $Page->RowIndex ?>_CategoryofExpenditure" value="<?= HtmlEncode($Page->CategoryofExpenditure->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_CategoryofExpenditure" class="el_awp_CategoryofExpenditure">
<textarea data-table="awp" data-field="x_CategoryofExpenditure" name="x<?= $Page->RowIndex ?>_CategoryofExpenditure" id="x<?= $Page->RowIndex ?>_CategoryofExpenditure" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->CategoryofExpenditure->getPlaceHolder()) ?>"<?= $Page->CategoryofExpenditure->editAttributes() ?>><?= $Page->CategoryofExpenditure->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->CategoryofExpenditure->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_CategoryofExpenditure" class="el_awp_CategoryofExpenditure">
<span<?= $Page->CategoryofExpenditure->viewAttributes() ?>>
<?= $Page->CategoryofExpenditure->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Activity->Visible) { // Activity ?>
        <td data-name="Activity"<?= $Page->Activity->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Activity" class="el_awp_Activity">
<textarea data-table="awp" data-field="x_Activity" name="x<?= $Page->RowIndex ?>_Activity" id="x<?= $Page->RowIndex ?>_Activity" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Activity->getPlaceHolder()) ?>"<?= $Page->Activity->editAttributes() ?>><?= $Page->Activity->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->Activity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_Activity" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Activity" id="o<?= $Page->RowIndex ?>_Activity" value="<?= HtmlEncode($Page->Activity->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Activity" class="el_awp_Activity">
<textarea data-table="awp" data-field="x_Activity" name="x<?= $Page->RowIndex ?>_Activity" id="x<?= $Page->RowIndex ?>_Activity" cols="50" rows="1" placeholder="<?= HtmlEncode($Page->Activity->getPlaceHolder()) ?>"<?= $Page->Activity->editAttributes() ?>><?= $Page->Activity->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Page->Activity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Activity" class="el_awp_Activity">
<span<?= $Page->Activity->viewAttributes() ?>>
<?= $Page->Activity->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Implementer->Visible) { // Implementer ?>
        <td data-name="Implementer"<?= $Page->Implementer->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Implementer" class="el_awp_Implementer">
<input type="<?= $Page->Implementer->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Implementer" id="x<?= $Page->RowIndex ?>_Implementer" data-table="awp" data-field="x_Implementer" value="<?= $Page->Implementer->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Implementer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Implementer->formatPattern()) ?>"<?= $Page->Implementer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Implementer->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_Implementer" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Implementer" id="o<?= $Page->RowIndex ?>_Implementer" value="<?= HtmlEncode($Page->Implementer->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Implementer" class="el_awp_Implementer">
<input type="<?= $Page->Implementer->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Implementer" id="x<?= $Page->RowIndex ?>_Implementer" data-table="awp" data-field="x_Implementer" value="<?= $Page->Implementer->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Implementer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Implementer->formatPattern()) ?>"<?= $Page->Implementer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Implementer->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Implementer" class="el_awp_Implementer">
<span<?= $Page->Implementer->viewAttributes() ?>>
<?= $Page->Implementer->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->Indicator->Visible) { // Indicator ?>
        <td data-name="Indicator"<?= $Page->Indicator->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Indicator" class="el_awp_Indicator">
<input type="<?= $Page->Indicator->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Indicator" id="x<?= $Page->RowIndex ?>_Indicator" data-table="awp" data-field="x_Indicator" value="<?= $Page->Indicator->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Indicator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Indicator->formatPattern()) ?>"<?= $Page->Indicator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Indicator->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_Indicator" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_Indicator" id="o<?= $Page->RowIndex ?>_Indicator" value="<?= HtmlEncode($Page->Indicator->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Indicator" class="el_awp_Indicator">
<input type="<?= $Page->Indicator->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_Indicator" id="x<?= $Page->RowIndex ?>_Indicator" data-table="awp" data-field="x_Indicator" value="<?= $Page->Indicator->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->Indicator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Indicator->formatPattern()) ?>"<?= $Page->Indicator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Indicator->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_Indicator" class="el_awp_Indicator">
<span<?= $Page->Indicator->viewAttributes() ?>>
<?= $Page->Indicator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->ProjectTarget->Visible) { // Project Target ?>
        <td data-name="ProjectTarget"<?= $Page->ProjectTarget->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_ProjectTarget" class="el_awp_ProjectTarget">
<input type="<?= $Page->ProjectTarget->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ProjectTarget" id="x<?= $Page->RowIndex ?>_ProjectTarget" data-table="awp" data-field="x_ProjectTarget" value="<?= $Page->ProjectTarget->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectTarget->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectTarget->formatPattern()) ?>"<?= $Page->ProjectTarget->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectTarget->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_ProjectTarget" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ProjectTarget" id="o<?= $Page->RowIndex ?>_ProjectTarget" value="<?= HtmlEncode($Page->ProjectTarget->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_ProjectTarget" class="el_awp_ProjectTarget">
<input type="<?= $Page->ProjectTarget->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ProjectTarget" id="x<?= $Page->RowIndex ?>_ProjectTarget" data-table="awp" data-field="x_ProjectTarget" value="<?= $Page->ProjectTarget->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectTarget->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectTarget->formatPattern()) ?>"<?= $Page->ProjectTarget->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectTarget->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_ProjectTarget" class="el_awp_ProjectTarget">
<span<?= $Page->ProjectTarget->viewAttributes() ?>>
<?= $Page->ProjectTarget->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->_2017Target->Visible) { // 2017 Target ?>
        <td data-name="_2017Target"<?= $Page->_2017Target->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp__2017Target" class="el_awp__2017Target">
<input type="<?= $Page->_2017Target->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>__2017Target" id="x<?= $Page->RowIndex ?>__2017Target" data-table="awp" data-field="x__2017Target" value="<?= $Page->_2017Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_2017Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2017Target->formatPattern()) ?>"<?= $Page->_2017Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_2017Target->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x__2017Target" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>__2017Target" id="o<?= $Page->RowIndex ?>__2017Target" value="<?= HtmlEncode($Page->_2017Target->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp__2017Target" class="el_awp__2017Target">
<input type="<?= $Page->_2017Target->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>__2017Target" id="x<?= $Page->RowIndex ?>__2017Target" data-table="awp" data-field="x__2017Target" value="<?= $Page->_2017Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_2017Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_2017Target->formatPattern()) ?>"<?= $Page->_2017Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_2017Target->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp__2017Target" class="el_awp__2017Target">
<span<?= $Page->_2017Target->viewAttributes() ?>>
<?= $Page->_2017Target->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->ProjectBudget->Visible) { // Project Budget ?>
        <td data-name="ProjectBudget"<?= $Page->ProjectBudget->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_ProjectBudget" class="el_awp_ProjectBudget">
<input type="<?= $Page->ProjectBudget->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ProjectBudget" id="x<?= $Page->RowIndex ?>_ProjectBudget" data-table="awp" data-field="x_ProjectBudget" value="<?= $Page->ProjectBudget->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectBudget->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectBudget->formatPattern()) ?>"<?= $Page->ProjectBudget->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectBudget->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="awp" data-field="x_ProjectBudget" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_ProjectBudget" id="o<?= $Page->RowIndex ?>_ProjectBudget" value="<?= HtmlEncode($Page->ProjectBudget->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_ProjectBudget" class="el_awp_ProjectBudget">
<input type="<?= $Page->ProjectBudget->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_ProjectBudget" id="x<?= $Page->RowIndex ?>_ProjectBudget" data-table="awp" data-field="x_ProjectBudget" value="<?= $Page->ProjectBudget->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ProjectBudget->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectBudget->formatPattern()) ?>"<?= $Page->ProjectBudget->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectBudget->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_ProjectBudget" class="el_awp_ProjectBudget">
<span<?= $Page->ProjectBudget->viewAttributes() ?>>
<?= $Page->ProjectBudget->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->StartMonth->Visible) { // StartMonth ?>
        <td data-name="StartMonth"<?= $Page->StartMonth->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_StartMonth" class="el_awp_StartMonth">
    <select
        id="x<?= $Page->RowIndex ?>_StartMonth"
        name="x<?= $Page->RowIndex ?>_StartMonth"
        class="form-select ew-select<?= $Page->StartMonth->isInvalidClass() ?>"
        <?php if (!$Page->StartMonth->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_StartMonth"
        <?php } ?>
        data-table="awp"
        data-field="x_StartMonth"
        data-value-separator="<?= $Page->StartMonth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->StartMonth->getPlaceHolder()) ?>"
        <?= $Page->StartMonth->editAttributes() ?>>
        <?= $Page->StartMonth->selectOptionListHtml("x{$Page->RowIndex}_StartMonth") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->StartMonth->getErrorMessage() ?></div>
<?= $Page->StartMonth->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_StartMonth") ?>
<?php if (!$Page->StartMonth->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_StartMonth", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_StartMonth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.StartMonth?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_StartMonth", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_StartMonth", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.awp.fields.StartMonth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="awp" data-field="x_StartMonth" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_StartMonth" id="o<?= $Page->RowIndex ?>_StartMonth" value="<?= HtmlEncode($Page->StartMonth->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_StartMonth" class="el_awp_StartMonth">
    <select
        id="x<?= $Page->RowIndex ?>_StartMonth"
        name="x<?= $Page->RowIndex ?>_StartMonth"
        class="form-select ew-select<?= $Page->StartMonth->isInvalidClass() ?>"
        <?php if (!$Page->StartMonth->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_StartMonth"
        <?php } ?>
        data-table="awp"
        data-field="x_StartMonth"
        data-value-separator="<?= $Page->StartMonth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->StartMonth->getPlaceHolder()) ?>"
        <?= $Page->StartMonth->editAttributes() ?>>
        <?= $Page->StartMonth->selectOptionListHtml("x{$Page->RowIndex}_StartMonth") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->StartMonth->getErrorMessage() ?></div>
<?= $Page->StartMonth->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_StartMonth") ?>
<?php if (!$Page->StartMonth->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_StartMonth", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_StartMonth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.StartMonth?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_StartMonth", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_StartMonth", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.awp.fields.StartMonth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_StartMonth" class="el_awp_StartMonth">
<span<?= $Page->StartMonth->viewAttributes() ?>>
<?= $Page->StartMonth->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->EndMonth->Visible) { // EndMonth ?>
        <td data-name="EndMonth"<?= $Page->EndMonth->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_EndMonth" class="el_awp_EndMonth">
    <select
        id="x<?= $Page->RowIndex ?>_EndMonth"
        name="x<?= $Page->RowIndex ?>_EndMonth"
        class="form-select ew-select<?= $Page->EndMonth->isInvalidClass() ?>"
        <?php if (!$Page->EndMonth->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_EndMonth"
        <?php } ?>
        data-table="awp"
        data-field="x_EndMonth"
        data-value-separator="<?= $Page->EndMonth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->EndMonth->getPlaceHolder()) ?>"
        <?= $Page->EndMonth->editAttributes() ?>>
        <?= $Page->EndMonth->selectOptionListHtml("x{$Page->RowIndex}_EndMonth") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->EndMonth->getErrorMessage() ?></div>
<?= $Page->EndMonth->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_EndMonth") ?>
<?php if (!$Page->EndMonth->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_EndMonth", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_EndMonth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.EndMonth?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_EndMonth", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_EndMonth", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.awp.fields.EndMonth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="awp" data-field="x_EndMonth" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_EndMonth" id="o<?= $Page->RowIndex ?>_EndMonth" value="<?= HtmlEncode($Page->EndMonth->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_EndMonth" class="el_awp_EndMonth">
    <select
        id="x<?= $Page->RowIndex ?>_EndMonth"
        name="x<?= $Page->RowIndex ?>_EndMonth"
        class="form-select ew-select<?= $Page->EndMonth->isInvalidClass() ?>"
        <?php if (!$Page->EndMonth->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_EndMonth"
        <?php } ?>
        data-table="awp"
        data-field="x_EndMonth"
        data-value-separator="<?= $Page->EndMonth->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->EndMonth->getPlaceHolder()) ?>"
        <?= $Page->EndMonth->editAttributes() ?>>
        <?= $Page->EndMonth->selectOptionListHtml("x{$Page->RowIndex}_EndMonth") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->EndMonth->getErrorMessage() ?></div>
<?= $Page->EndMonth->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_EndMonth") ?>
<?php if (!$Page->EndMonth->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_EndMonth", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_EndMonth" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.EndMonth?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_EndMonth", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_EndMonth", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.awp.fields.EndMonth.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_EndMonth" class="el_awp_EndMonth">
<span<?= $Page->EndMonth->viewAttributes() ?>>
<?= $Page->EndMonth->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->LineNo->Visible) { // LineNo ?>
        <td data-name="LineNo"<?= $Page->LineNo->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_LineNo" class="el_awp_LineNo"></span>
<input type="hidden" data-table="awp" data-field="x_LineNo" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_LineNo" id="o<?= $Page->RowIndex ?>_LineNo" value="<?= HtmlEncode($Page->LineNo->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_LineNo" class="el_awp_LineNo">
<span<?= $Page->LineNo->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->LineNo->getDisplayValue($Page->LineNo->EditValue))) ?>"></span>
<input type="hidden" data-table="awp" data-field="x_LineNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_LineNo" id="x<?= $Page->RowIndex ?>_LineNo" value="<?= HtmlEncode($Page->LineNo->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_awp_LineNo" class="el_awp_LineNo">
<span<?= $Page->LineNo->viewAttributes() ?>>
<?= $Page->LineNo->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="awp" data-field="x_LineNo" data-hidden="1" name="x<?= $Page->RowIndex ?>_LineNo" id="x<?= $Page->RowIndex ?>_LineNo" value="<?= HtmlEncode($Page->LineNo->CurrentValue) ?>">
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("awp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
