<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "village" table
 */
#[Entity]
#[Table(name: "village")]
class Village extends AbstractEntity
{
    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "Camp", type: "string", nullable: true)]
    private ?string $camp;

    #[Id]
    #[Column(name: "VillageCode", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $villageCode;

    #[Column(name: "Village", type: "string", nullable: true)]
    private ?string $village;

    public function __construct()
    {
        $this->provinceCode = 0;
        $this->districtCode = 0;
    }

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getCamp(): ?string
    {
        return HtmlDecode($this->camp);
    }

    public function setCamp(?string $value): static
    {
        $this->camp = RemoveXss($value);
        return $this;
    }

    public function getVillageCode(): int
    {
        return $this->villageCode;
    }

    public function setVillageCode(int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }

    public function getVillage(): ?string
    {
        return HtmlDecode($this->village);
    }

    public function setVillage(?string $value): static
    {
        $this->village = RemoveXss($value);
        return $this;
    }
}
