<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "user_status" table
 */
#[Entity]
#[Table(name: "user_status")]
class UserStatus extends AbstractEntity
{
    #[Id]
    #[Column(name: "UserStatus", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $userStatus;

    #[Column(name: "UserStatusDescription", type: "string")]
    private string $userStatusDescription;

    public function getUserStatus(): int
    {
        return $this->userStatus;
    }

    public function setUserStatus(int $value): static
    {
        $this->userStatus = $value;
        return $this;
    }

    public function getUserStatusDescription(): string
    {
        return HtmlDecode($this->userStatusDescription);
    }

    public function setUserStatusDescription(string $value): static
    {
        $this->userStatusDescription = RemoveXss($value);
        return $this;
    }
}
