<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "supplier_summary_view" table
 */
#[Entity]
#[Table(name: "supplier_summary_view")]
class SupplierSummaryView extends AbstractEntity
{
    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Column(name: "NoOfBeneficiaries", type: "bigint")]
    private string $noOfBeneficiaries;

    #[Column(name: "Seedlings", type: "decimal", nullable: true)]
    private ?string $seedlings;

    #[Column(name: "FarmingSeason", type: "smallint", nullable: true)]
    private ?int $farmingSeason;

    #[Column(name: "SeedType", type: "string", nullable: true)]
    private ?string $seedType;

    #[Column(name: "NurseryName", type: "string", nullable: true)]
    private ?string $nurseryName;

    public function __construct()
    {
        $this->noOfBeneficiaries = "0";
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getNoOfBeneficiaries(): string
    {
        return $this->noOfBeneficiaries;
    }

    public function setNoOfBeneficiaries(string $value): static
    {
        $this->noOfBeneficiaries = $value;
        return $this;
    }

    public function getSeedlings(): ?string
    {
        return $this->seedlings;
    }

    public function setSeedlings(?string $value): static
    {
        $this->seedlings = $value;
        return $this;
    }

    public function getFarmingSeason(): ?int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(?int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }

    public function getSeedType(): ?string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(?string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getNurseryName(): ?string
    {
        return HtmlDecode($this->nurseryName);
    }

    public function setNurseryName(?string $value): static
    {
        $this->nurseryName = RemoveXss($value);
        return $this;
    }
}
