<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "sex" table
 */
#[Entity]
#[Table(name: "sex")]
class Sex extends AbstractEntity
{
    #[Id]
    #[Column(name: "Gender", type: "string", unique: true)]
    private string $gender;

    #[Column(name: "Sex", type: "string")]
    private string $sex;

    public function getGender(): string
    {
        return $this->gender;
    }

    public function setGender(string $value): static
    {
        $this->gender = $value;
        return $this;
    }

    public function getSex(): string
    {
        return HtmlDecode($this->sex);
    }

    public function setSex(string $value): static
    {
        $this->sex = RemoveXss($value);
        return $this;
    }
}
