<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "seed_allocate_view" table
 */
#[Entity]
#[Table(name: "seed_allocate_view")]
class SeedAllocateView extends AbstractEntity
{
    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Column(name: "CampName", type: "string", nullable: true)]
    private ?string $campName;

    #[Column(name: "Village", type: "string", nullable: true)]
    private ?string $village;

    #[Column(name: "FieldType", type: "integer", nullable: true)]
    private ?int $fieldType;

    #[Column(name: "Ownership", type: "integer", nullable: true)]
    private ?int $ownership;

    #[Column(name: "FarmSize", type: "string", nullable: true)]
    private ?string $farmSize;

    #[Column(name: "FarmSizeEstimated", type: "float", nullable: true)]
    private ?float $farmSizeEstimated;

    #[Column(name: "TreesPlantedEstimated", type: "float", nullable: true)]
    private ?float $treesPlantedEstimated;

    #[Column(name: "FarmSizeVerified", type: "float", nullable: true)]
    private ?float $farmSizeVerified;

    #[Column(name: "TreesPlantedVerified", type: "float", nullable: true)]
    private ?float $treesPlantedVerified;

    #[Id]
    #[Column(name: "FarmNo", type: "integer")]
    #[GeneratedValue]
    private int $farmNo;

    #[Id]
    #[Column(name: "TransNo", type: "integer")]
    #[GeneratedValue]
    private int $transNo;

    #[Column(name: "GRN", type: "string", nullable: true)]
    private ?string $grn;

    #[Column(name: "TreesAllocated", type: "integer", nullable: true)]
    private ?int $treesAllocated;

    #[Column(name: "FarmingSeason", type: "smallint", nullable: true)]
    private ?int $farmingSeason;

    #[Column(name: "SeedType", type: "string", nullable: true)]
    private ?string $seedType;

    #[Column(name: "SourcesOfSeedlings", type: "integer", nullable: true)]
    private ?int $sourcesOfSeedlings;

    #[Column(name: "TransDate", type: "date", nullable: true)]
    private ?DateTime $transDate;

    #[Column(name: "PreparedBy", type: "string", nullable: true)]
    private ?string $preparedBy;

    #[Column(name: "AuthorisedBy", type: "string", nullable: true)]
    private ?string $authorisedBy;

    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Column(name: "FarmerName", type: "string")]
    private string $farmerName;

    #[Column(name: "DOB", type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(name: "Age", type: "float", nullable: true)]
    private ?float $age;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "MaritalStatus", type: "integer", nullable: true)]
    private ?int $maritalStatus;

    #[Column(name: "PhoneNo", type: "string", nullable: true)]
    private ?string $phoneNo;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "Dependants", type: "integer", nullable: true)]
    private ?int $dependants;

    #[Column(name: "MaleChildren", type: "integer", nullable: true)]
    private ?int $maleChildren;

    #[Column(name: "FemaleChildren", type: "integer", nullable: true)]
    private ?int $femaleChildren;

    #[Column(name: "HouseholdHead", type: "integer", nullable: true)]
    private ?int $householdHead;

    #[Column(name: "FarmerOrg", type: "string", nullable: true)]
    private ?string $farmerOrg;

    #[Column(name: "FarmerOrgPosition", type: "string", nullable: true)]
    private ?string $farmerOrgPosition;

    #[Column(name: "JoiningDate", type: "date", nullable: true)]
    private ?DateTime $joiningDate;

    #[Column(name: "NurseryName", type: "string", nullable: true)]
    private ?string $nurseryName;

    #[Column(name: "NurseryType", type: "integer", nullable: true)]
    private ?int $nurseryType;

    #[Column(name: "NurseryOwnership", type: "integer", nullable: true)]
    private ?int $nurseryOwnership;

    #[Column(name: "NumberOfMembers", type: "integer", nullable: true)]
    private ?int $numberOfMembers;

    #[Column(name: "Longitude", type: "decimal")]
    private string $longitude;

    #[Column(name: "Latitude", type: "decimal")]
    private string $latitude;

    public function __construct(int $farmNo, int $transNo)
    {
        $this->farmNo = $farmNo;
        $this->transNo = $transNo;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getCampName(): ?string
    {
        return HtmlDecode($this->campName);
    }

    public function setCampName(?string $value): static
    {
        $this->campName = RemoveXss($value);
        return $this;
    }

    public function getVillage(): ?string
    {
        return HtmlDecode($this->village);
    }

    public function setVillage(?string $value): static
    {
        $this->village = RemoveXss($value);
        return $this;
    }

    public function getFieldType(): ?int
    {
        return $this->fieldType;
    }

    public function setFieldType(?int $value): static
    {
        $this->fieldType = $value;
        return $this;
    }

    public function getOwnership(): ?int
    {
        return $this->ownership;
    }

    public function setOwnership(?int $value): static
    {
        $this->ownership = $value;
        return $this;
    }

    public function getFarmSize(): ?string
    {
        return HtmlDecode($this->farmSize);
    }

    public function setFarmSize(?string $value): static
    {
        $this->farmSize = RemoveXss($value);
        return $this;
    }

    public function getFarmSizeEstimated(): ?float
    {
        return $this->farmSizeEstimated;
    }

    public function setFarmSizeEstimated(?float $value): static
    {
        $this->farmSizeEstimated = $value;
        return $this;
    }

    public function getTreesPlantedEstimated(): ?float
    {
        return $this->treesPlantedEstimated;
    }

    public function setTreesPlantedEstimated(?float $value): static
    {
        $this->treesPlantedEstimated = $value;
        return $this;
    }

    public function getFarmSizeVerified(): ?float
    {
        return $this->farmSizeVerified;
    }

    public function setFarmSizeVerified(?float $value): static
    {
        $this->farmSizeVerified = $value;
        return $this;
    }

    public function getTreesPlantedVerified(): ?float
    {
        return $this->treesPlantedVerified;
    }

    public function setTreesPlantedVerified(?float $value): static
    {
        $this->treesPlantedVerified = $value;
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getTransNo(): int
    {
        return $this->transNo;
    }

    public function setTransNo(int $value): static
    {
        $this->transNo = $value;
        return $this;
    }

    public function getGrn(): ?string
    {
        return HtmlDecode($this->grn);
    }

    public function setGrn(?string $value): static
    {
        $this->grn = RemoveXss($value);
        return $this;
    }

    public function getTreesAllocated(): ?int
    {
        return $this->treesAllocated;
    }

    public function setTreesAllocated(?int $value): static
    {
        $this->treesAllocated = $value;
        return $this;
    }

    public function getFarmingSeason(): ?int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(?int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }

    public function getSeedType(): ?string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(?string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getSourcesOfSeedlings(): ?int
    {
        return $this->sourcesOfSeedlings;
    }

    public function setSourcesOfSeedlings(?int $value): static
    {
        $this->sourcesOfSeedlings = $value;
        return $this;
    }

    public function getTransDate(): ?DateTime
    {
        return $this->transDate;
    }

    public function setTransDate(?DateTime $value): static
    {
        $this->transDate = $value;
        return $this;
    }

    public function getPreparedBy(): ?string
    {
        return HtmlDecode($this->preparedBy);
    }

    public function setPreparedBy(?string $value): static
    {
        $this->preparedBy = RemoveXss($value);
        return $this;
    }

    public function getAuthorisedBy(): ?string
    {
        return HtmlDecode($this->authorisedBy);
    }

    public function setAuthorisedBy(?string $value): static
    {
        $this->authorisedBy = RemoveXss($value);
        return $this;
    }

    public function getNrc(): string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerName(): string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getAge(): ?float
    {
        return $this->age;
    }

    public function setAge(?float $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getMaritalStatus(): ?int
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?int $value): static
    {
        $this->maritalStatus = $value;
        return $this;
    }

    public function getPhoneNo(): ?string
    {
        return HtmlDecode($this->phoneNo);
    }

    public function setPhoneNo(?string $value): static
    {
        $this->phoneNo = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getDependants(): ?int
    {
        return $this->dependants;
    }

    public function setDependants(?int $value): static
    {
        $this->dependants = $value;
        return $this;
    }

    public function getMaleChildren(): ?int
    {
        return $this->maleChildren;
    }

    public function setMaleChildren(?int $value): static
    {
        $this->maleChildren = $value;
        return $this;
    }

    public function getFemaleChildren(): ?int
    {
        return $this->femaleChildren;
    }

    public function setFemaleChildren(?int $value): static
    {
        $this->femaleChildren = $value;
        return $this;
    }

    public function getHouseholdHead(): ?int
    {
        return $this->householdHead;
    }

    public function setHouseholdHead(?int $value): static
    {
        $this->householdHead = $value;
        return $this;
    }

    public function getFarmerOrg(): ?string
    {
        return HtmlDecode($this->farmerOrg);
    }

    public function setFarmerOrg(?string $value): static
    {
        $this->farmerOrg = RemoveXss($value);
        return $this;
    }

    public function getFarmerOrgPosition(): ?string
    {
        return HtmlDecode($this->farmerOrgPosition);
    }

    public function setFarmerOrgPosition(?string $value): static
    {
        $this->farmerOrgPosition = RemoveXss($value);
        return $this;
    }

    public function getJoiningDate(): ?DateTime
    {
        return $this->joiningDate;
    }

    public function setJoiningDate(?DateTime $value): static
    {
        $this->joiningDate = $value;
        return $this;
    }

    public function getNurseryName(): ?string
    {
        return HtmlDecode($this->nurseryName);
    }

    public function setNurseryName(?string $value): static
    {
        $this->nurseryName = RemoveXss($value);
        return $this;
    }

    public function getNurseryType(): ?int
    {
        return $this->nurseryType;
    }

    public function setNurseryType(?int $value): static
    {
        $this->nurseryType = $value;
        return $this;
    }

    public function getNurseryOwnership(): ?int
    {
        return $this->nurseryOwnership;
    }

    public function setNurseryOwnership(?int $value): static
    {
        $this->nurseryOwnership = $value;
        return $this;
    }

    public function getNumberOfMembers(): ?int
    {
        return $this->numberOfMembers;
    }

    public function setNumberOfMembers(?int $value): static
    {
        $this->numberOfMembers = $value;
        return $this;
    }

    public function getLongitude(): string
    {
        return $this->longitude;
    }

    public function setLongitude(string $value): static
    {
        $this->longitude = $value;
        return $this;
    }

    public function getLatitude(): string
    {
        return $this->latitude;
    }

    public function setLatitude(string $value): static
    {
        $this->latitude = $value;
        return $this;
    }
}
