<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "seed_allocate_src" table
 */
#[Entity]
#[Table(name: "seed_allocate_src")]
class SeedAllocateSrc extends AbstractEntity
{
    #[Column(name: "FarmerName", type: "string", nullable: true)]
    private ?string $farmerName;

    #[Column(name: "NRC", type: "string", nullable: true)]
    private ?string $nrc;

    #[Column(name: "Seedlings", type: "float", nullable: true)]
    private ?float $seedlings;

    #[Column(name: "Seeds", type: "float", nullable: true)]
    private ?float $seeds;

    #[Column(name: "Type", type: "string", nullable: true)]
    private ?string $type;

    #[Column(name: "Supplier", type: "string", nullable: true)]
    private ?string $supplier;

    #[Column(name: "DateAllocated", type: "string", nullable: true)]
    private ?string $dateAllocated;

    #[Column(name: "GRN", type: "string", nullable: true)]
    private ?string $grn;

    #[Column(type: "smallint")]
    private int $season;

    #[Id]
    #[Column(name: "ID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "NurseryCode", type: "integer")]
    private int $nurseryCode;

    public function getFarmerName(): ?string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(?string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getSeedlings(): ?float
    {
        return $this->seedlings;
    }

    public function setSeedlings(?float $value): static
    {
        $this->seedlings = $value;
        return $this;
    }

    public function getSeeds(): ?float
    {
        return $this->seeds;
    }

    public function setSeeds(?float $value): static
    {
        $this->seeds = $value;
        return $this;
    }

    public function getType(): ?string
    {
        return HtmlDecode($this->type);
    }

    public function setType(?string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getSupplier(): ?string
    {
        return HtmlDecode($this->supplier);
    }

    public function setSupplier(?string $value): static
    {
        $this->supplier = RemoveXss($value);
        return $this;
    }

    public function getDateAllocated(): ?string
    {
        return HtmlDecode($this->dateAllocated);
    }

    public function setDateAllocated(?string $value): static
    {
        $this->dateAllocated = RemoveXss($value);
        return $this;
    }

    public function getGrn(): ?string
    {
        return HtmlDecode($this->grn);
    }

    public function setGrn(?string $value): static
    {
        $this->grn = RemoveXss($value);
        return $this;
    }

    public function getSeason(): int
    {
        return $this->season;
    }

    public function setSeason(int $value): static
    {
        $this->season = $value;
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getNurseryCode(): int
    {
        return $this->nurseryCode;
    }

    public function setNurseryCode(int $value): static
    {
        $this->nurseryCode = $value;
        return $this;
    }
}
