<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "quarter_ref" table
 */
#[Entity]
#[Table(name: "quarter_ref")]
class QuarterRef extends AbstractEntity
{
    #[Id]
    #[Column(name: "QuarterCode", type: "integer", unique: true)]
    private int $quarterCode;

    #[Column(name: "QuarterName", type: "string")]
    private string $quarterName;

    #[Column(name: "QuarterShort", type: "string")]
    private string $quarterShort;

    public function getQuarterCode(): int
    {
        return $this->quarterCode;
    }

    public function setQuarterCode(int $value): static
    {
        $this->quarterCode = $value;
        return $this;
    }

    public function getQuarterName(): string
    {
        return HtmlDecode($this->quarterName);
    }

    public function setQuarterName(string $value): static
    {
        $this->quarterName = RemoveXss($value);
        return $this;
    }

    public function getQuarterShort(): string
    {
        return HtmlDecode($this->quarterShort);
    }

    public function setQuarterShort(string $value): static
    {
        $this->quarterShort = RemoveXss($value);
        return $this;
    }
}
