<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "production_sales" table
 */
#[Entity]
#[Table(name: "production_sales")]
class ProductionSale extends AbstractEntity
{
    #[Id]
    #[Column(name: "FarmNo", type: "integer")]
    private int $farmNo;

    #[Id]
    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Id]
    #[Column(name: "SeasonYear", type: "smallint")]
    private int $seasonYear;

    #[Column(name: "CashewProduced", type: "float", nullable: true)]
    private ?float $cashewProduced;

    #[Column(name: "AmountRealised", type: "float", nullable: true)]
    private ?float $amountRealised;

    #[Column(name: "SoldTo", type: "string", nullable: true)]
    private ?string $soldTo;

    #[Column(name: "Comments", type: "string", nullable: true)]
    private ?string $comments;

    public function __construct(int $farmNo, string $nrc, int $seasonYear)
    {
        $this->farmNo = $farmNo;
        $this->nrc = $nrc;
        $this->seasonYear = $seasonYear;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getNrc(): string
    {
        return $this->nrc;
    }

    public function setNrc(string $value): static
    {
        $this->nrc = $value;
        return $this;
    }

    public function getSeasonYear(): int
    {
        return $this->seasonYear;
    }

    public function setSeasonYear(int $value): static
    {
        $this->seasonYear = $value;
        return $this;
    }

    public function getCashewProduced(): ?float
    {
        return $this->cashewProduced;
    }

    public function setCashewProduced(?float $value): static
    {
        $this->cashewProduced = $value;
        return $this;
    }

    public function getAmountRealised(): ?float
    {
        return $this->amountRealised;
    }

    public function setAmountRealised(?float $value): static
    {
        $this->amountRealised = $value;
        return $this;
    }

    public function getSoldTo(): ?string
    {
        return HtmlDecode($this->soldTo);
    }

    public function setSoldTo(?string $value): static
    {
        $this->soldTo = RemoveXss($value);
        return $this;
    }

    public function getComments(): ?string
    {
        return HtmlDecode($this->comments);
    }

    public function setComments(?string $value): static
    {
        $this->comments = RemoveXss($value);
        return $this;
    }
}
