<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "period_type" table
 */
#[Entity]
#[Table(name: "period_type")]
class PeriodType extends AbstractEntity
{
    #[Id]
    #[Column(name: "Period_Type", type: "string", unique: true)]
    private string $periodType;

    #[Column(name: "PeriodTypeName", type: "string")]
    private string $periodTypeName;

    #[Column(name: "PeriodLength", type: "integer")]
    private int $periodLength;

    #[Column(name: "UnitOfMeasure", type: "string")]
    private string $unitOfMeasure;

    public function __construct()
    {
        $this->periodLength = 0;
        $this->unitOfMeasure = "month";
    }

    public function getPeriodType(): string
    {
        return $this->periodType;
    }

    public function setPeriodType(string $value): static
    {
        $this->periodType = $value;
        return $this;
    }

    public function getPeriodTypeName(): string
    {
        return HtmlDecode($this->periodTypeName);
    }

    public function setPeriodTypeName(string $value): static
    {
        $this->periodTypeName = RemoveXss($value);
        return $this;
    }

    public function getPeriodLength(): int
    {
        return $this->periodLength;
    }

    public function setPeriodLength(int $value): static
    {
        $this->periodLength = $value;
        return $this;
    }

    public function getUnitOfMeasure(): string
    {
        return HtmlDecode($this->unitOfMeasure);
    }

    public function setUnitOfMeasure(string $value): static
    {
        $this->unitOfMeasure = RemoveXss($value);
        return $this;
    }
}
