<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "ownership" table
 */
#[Entity]
#[Table(name: "ownership")]
class Ownership extends AbstractEntity
{
    #[Id]
    #[Column(name: "OwnershipType", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $ownershipType;

    #[Column(name: "Ownership", type: "string")]
    private string $ownership;

    public function getOwnershipType(): int
    {
        return $this->ownershipType;
    }

    public function setOwnershipType(int $value): static
    {
        $this->ownershipType = $value;
        return $this;
    }

    public function getOwnership(): string
    {
        return HtmlDecode($this->ownership);
    }

    public function setOwnership(string $value): static
    {
        $this->ownership = RemoveXss($value);
        return $this;
    }
}
