<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "musers" table
 */
#[Entity]
#[Table(name: "musers")]
class Muser extends AbstractEntity
{
    #[Id]
    #[Column(name: "UserCode", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $userCode;

    #[Column(name: "UserName", type: "string", unique: true)]
    private string $userName;

    #[Column(name: "Password", type: "string")]
    private string $password;

    #[Column(name: "ConfirmPwd", type: "string", nullable: true)]
    private ?string $confirmPwd;

    #[Column(name: "FirstName", type: "string")]
    private string $firstName;

    #[Column(name: "LastName", type: "string")]
    private string $lastName;

    #[Column(name: "Level", type: "integer")]
    private int $level;

    #[Column(name: "Role", type: "string")]
    private string $role;

    #[Column(name: "Clearance", type: "integer")]
    private int $clearance;

    #[Column(name: "Active", type: "integer")]
    private int $active;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "Telephone", type: "string", nullable: true)]
    private ?string $telephone;

    #[Column(name: "Mobile", type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(name: "Position", type: "string", nullable: true)]
    private ?string $position;

    #[Column(name: "ReportsTo", type: "integer", nullable: true)]
    private ?int $reportsTo;

    #[Column(name: "Profile", type: "text", nullable: true)]
    private ?string $profile;

    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode;

    public function __construct()
    {
        $this->level = 0;
        $this->clearance = 0;
        $this->active = 1;
    }

    public function getUserCode(): int
    {
        return $this->userCode;
    }

    public function setUserCode(int $value): static
    {
        $this->userCode = $value;
        return $this;
    }

    public function getUserName(): string
    {
        return $this->userName;
    }

    public function setUserName(string $value): static
    {
        $this->userName = $value;
        return $this;
    }

    public function getPassword(): string
    {
        return $this->password;
    }

    public function setPassword(string $value): static
    {
        $this->password = EncryptPassword(Config("CASE_SENSITIVE_PASSWORD") ? $value : strtolower($value));
        return $this;
    }

    public function getConfirmPwd(): ?string
    {
        return HtmlDecode($this->confirmPwd);
    }

    public function setConfirmPwd(?string $value): static
    {
        $this->confirmPwd = RemoveXss($value);
        return $this;
    }

    public function getFirstName(): string
    {
        return HtmlDecode($this->firstName);
    }

    public function setFirstName(string $value): static
    {
        $this->firstName = RemoveXss($value);
        return $this;
    }

    public function getLastName(): string
    {
        return HtmlDecode($this->lastName);
    }

    public function setLastName(string $value): static
    {
        $this->lastName = RemoveXss($value);
        return $this;
    }

    public function getLevel(): int
    {
        return $this->level;
    }

    public function setLevel(int $value): static
    {
        $this->level = $value;
        return $this;
    }

    public function getRole(): string
    {
        return HtmlDecode($this->role);
    }

    public function setRole(string $value): static
    {
        $this->role = RemoveXss($value);
        return $this;
    }

    public function getClearance(): int
    {
        return $this->clearance;
    }

    public function setClearance(int $value): static
    {
        $this->clearance = $value;
        return $this;
    }

    public function getActive(): int
    {
        return $this->active;
    }

    public function setActive(int $value): static
    {
        $this->active = $value;
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getTelephone(): ?string
    {
        return HtmlDecode($this->telephone);
    }

    public function setTelephone(?string $value): static
    {
        $this->telephone = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getPosition(): ?string
    {
        return HtmlDecode($this->position);
    }

    public function setPosition(?string $value): static
    {
        $this->position = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): ?int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(?int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getProfile(): ?string
    {
        return HtmlDecode($this->profile);
    }

    public function setProfile(?string $value): static
    {
        $this->profile = RemoveXss($value);
        return $this;
    }

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    // Get login arguments
    public function getLoginArguments(): array
    {
        return [
            "userName" => $this->get('UserName'),
            "userId" => $this->get('UserCode'),
            "parentUserId" => $this->get('UserCode'),
            "userLevel" => $this->get('Level') ?? AdvancedSecurity::ANONYMOUS_USER_LEVEL_ID,
            "userPrimaryKey" => $this->get('UserCode'),
        ];
    }
}
