<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "month_ref" table
 */
#[Entity]
#[Table(name: "month_ref")]
class MonthRef extends AbstractEntity
{
    #[Id]
    #[Column(name: "MonthCode", type: "integer", unique: true)]
    private int $monthCode;

    #[Column(name: "MonthName", type: "string")]
    private string $monthName;

    #[Column(name: "MonthShort", type: "string")]
    private string $monthShort;

    public function getMonthCode(): int
    {
        return $this->monthCode;
    }

    public function setMonthCode(int $value): static
    {
        $this->monthCode = $value;
        return $this;
    }

    public function getMonthName(): string
    {
        return HtmlDecode($this->monthName);
    }

    public function setMonthName(string $value): static
    {
        $this->monthName = RemoveXss($value);
        return $this;
    }

    public function getMonthShort(): string
    {
        return HtmlDecode($this->monthShort);
    }

    public function setMonthShort(string $value): static
    {
        $this->monthShort = RemoveXss($value);
        return $this;
    }
}
