<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "monguvillages" table
 */
#[Entity]
#[Table(name: "monguvillages")]
class Monguvillage extends AbstractEntity
{
    #[Column(name: "CAMP", type: "string", nullable: true)]
    private ?string $camp;

    #[Column(name: "VILLAGE", type: "string", nullable: true)]
    private ?string $village;

    public function getCamp(): ?string
    {
        return HtmlDecode($this->camp);
    }

    public function setCamp(?string $value): static
    {
        $this->camp = RemoveXss($value);
        return $this;
    }

    public function getVillage(): ?string
    {
        return HtmlDecode($this->village);
    }

    public function setVillage(?string $value): static
    {
        $this->village = RemoveXss($value);
        return $this;
    }
}
