<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "field_type" table
 */
#[Entity]
#[Table(name: "field_type")]
class FieldType extends AbstractEntity
{
    #[Id]
    #[Column(name: "FieldType", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $fieldType;

    #[Column(name: "FieldTypeName", type: "string")]
    private string $fieldTypeName;

    public function getFieldType(): int
    {
        return $this->fieldType;
    }

    public function setFieldType(int $value): static
    {
        $this->fieldType = $value;
        return $this;
    }

    public function getFieldTypeName(): string
    {
        return HtmlDecode($this->fieldTypeName);
    }

    public function setFieldTypeName(string $value): static
    {
        $this->fieldTypeName = RemoveXss($value);
        return $this;
    }
}
