<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farmer2" table
 */
#[Entity]
#[Table(name: "farmer2")]
class Farmer2 extends AbstractEntity
{
    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode;

    #[Column(name: "Camp", type: "string", nullable: true)]
    private ?string $camp;

    #[Column(name: "Village", type: "string", nullable: true)]
    private ?string $village;

    #[Column(name: "FarmerName", type: "string", nullable: true)]
    private ?string $farmerName;

    #[Column(name: "DOB", type: "bytes", nullable: true)]
    private ?string $dob;

    #[Column(name: "Age", type: "float", nullable: true)]
    private ?float $age;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "NRC", type: "string", nullable: true)]
    private ?string $nrc;

    #[Column(name: "FarmerOrg", type: "string", nullable: true)]
    private ?string $farmerOrg;

    public function __construct()
    {
        $this->provinceCode = 0;
        $this->districtCode = 0;
    }

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCamp(): ?string
    {
        return HtmlDecode($this->camp);
    }

    public function setCamp(?string $value): static
    {
        $this->camp = RemoveXss($value);
        return $this;
    }

    public function getVillage(): ?string
    {
        return HtmlDecode($this->village);
    }

    public function setVillage(?string $value): static
    {
        $this->village = RemoveXss($value);
        return $this;
    }

    public function getFarmerName(): ?string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(?string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?string
    {
        return $this->dob;
    }

    public function setDob(?string $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getAge(): ?float
    {
        return $this->age;
    }

    public function setAge(?float $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerOrg(): ?string
    {
        return HtmlDecode($this->farmerOrg);
    }

    public function setFarmerOrg(?string $value): static
    {
        $this->farmerOrg = RemoveXss($value);
        return $this;
    }
}
