<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farm_seed_allocate_offline" table
 */
#[Entity]
#[Table(name: "farm_seed_allocate_offline")]
class FarmSeedAllocateOffline extends AbstractEntity
{
    #[Column(name: "ProvinceCode", type: "integer", nullable: true)]
    private ?int $provinceCode;

    #[Column(name: "DistrictCode", type: "integer", nullable: true)]
    private ?int $districtCode;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "VillageCode", type: "integer", nullable: true)]
    private ?int $villageCode;

    #[Column(name: "NRC", type: "string", nullable: true)]
    private ?string $nrc;

    #[Column(name: "FarmerNo", type: "integer", nullable: true)]
    private ?int $farmerNo;

    #[Column(name: "FarmNo", type: "integer")]
    private int $farmNo;

    #[Column(name: "TransNo", type: "integer")]
    private int $transNo;

    #[Column(name: "GRN", type: "string", nullable: true)]
    private ?string $grn;

    #[Column(name: "TreesAllocated", type: "string", nullable: true)]
    private ?string $treesAllocated;

    #[Column(name: "FarmingSeason", type: "smallint", nullable: true)]
    private ?int $farmingSeason;

    #[Column(name: "SeedType", type: "string", nullable: true)]
    private ?string $seedType;

    #[Column(name: "SourcesOfSeedlings", type: "integer", nullable: true)]
    private ?int $sourcesOfSeedlings;

    #[Column(name: "TransDate", type: "date", nullable: true)]
    private ?DateTime $transDate;

    #[Column(name: "PreparedBy", type: "string", nullable: true)]
    private ?string $preparedBy;

    #[Column(name: "AuthorisedBy", type: "string", nullable: true)]
    private ?string $authorisedBy;

    #[Column(name: "GoodsReceived", type: "text", nullable: true)]
    private ?string $goodsReceived;

    public function __construct()
    {
        $this->transNo = 0;
    }

    public function getProvinceCode(): ?int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(?int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): ?int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(?int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getVillageCode(): ?int
    {
        return $this->villageCode;
    }

    public function setVillageCode(?int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerNo(): ?int
    {
        return $this->farmerNo;
    }

    public function setFarmerNo(?int $value): static
    {
        $this->farmerNo = $value;
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getTransNo(): int
    {
        return $this->transNo;
    }

    public function setTransNo(int $value): static
    {
        $this->transNo = $value;
        return $this;
    }

    public function getGrn(): ?string
    {
        return HtmlDecode($this->grn);
    }

    public function setGrn(?string $value): static
    {
        $this->grn = RemoveXss($value);
        return $this;
    }

    public function getTreesAllocated(): ?string
    {
        return HtmlDecode($this->treesAllocated);
    }

    public function setTreesAllocated(?string $value): static
    {
        $this->treesAllocated = RemoveXss($value);
        return $this;
    }

    public function getFarmingSeason(): ?int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(?int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }

    public function getSeedType(): ?string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(?string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getSourcesOfSeedlings(): ?int
    {
        return $this->sourcesOfSeedlings;
    }

    public function setSourcesOfSeedlings(?int $value): static
    {
        $this->sourcesOfSeedlings = $value;
        return $this;
    }

    public function getTransDate(): ?DateTime
    {
        return $this->transDate;
    }

    public function setTransDate(?DateTime $value): static
    {
        $this->transDate = $value;
        return $this;
    }

    public function getPreparedBy(): ?string
    {
        return HtmlDecode($this->preparedBy);
    }

    public function setPreparedBy(?string $value): static
    {
        $this->preparedBy = RemoveXss($value);
        return $this;
    }

    public function getAuthorisedBy(): ?string
    {
        return HtmlDecode($this->authorisedBy);
    }

    public function setAuthorisedBy(?string $value): static
    {
        $this->authorisedBy = RemoveXss($value);
        return $this;
    }

    public function getGoodsReceived(): ?string
    {
        return HtmlDecode($this->goodsReceived);
    }

    public function setGoodsReceived(?string $value): static
    {
        $this->goodsReceived = RemoveXss($value);
        return $this;
    }
}
