<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farm_notfarmerno" table
 */
#[Entity]
#[Table(name: "farm_notfarmerno")]
class FarmNotfarmerno extends AbstractEntity
{
    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "VillageCode", type: "integer", nullable: true)]
    private ?int $villageCode;

    #[Column(name: "NRC", type: "string", nullable: true)]
    private ?string $nrc;

    #[Column(name: "FarmerNo", type: "integer")]
    private int $farmerNo;

    #[Column(name: "FarmNo", type: "integer")]
    private int $farmNo;

    #[Column(name: "Coordinates", type: "geometry", nullable: true)]
    private ?string $coordinates;

    #[Column(name: "Latitude", type: "decimal")]
    private string $latitude;

    #[Column(name: "Longitude", type: "decimal")]
    private string $longitude;

    #[Column(name: "FieldType", type: "integer", nullable: true)]
    private ?int $fieldType;

    #[Column(name: "Ownership", type: "integer", nullable: true)]
    private ?int $ownership;

    #[Column(name: "FarmSize", type: "string", nullable: true)]
    private ?string $farmSize;

    #[Column(name: "FarmSizeEstimated", type: "float", nullable: true)]
    private ?float $farmSizeEstimated;

    #[Column(name: "TreesPlantedEstimated", type: "float", nullable: true)]
    private ?float $treesPlantedEstimated;

    #[Column(name: "FarmSizeVerified", type: "float", nullable: true)]
    private ?float $farmSizeVerified;

    #[Column(name: "TreesPlantedVerified", type: "float", nullable: true)]
    private ?float $treesPlantedVerified;

    #[Column(name: "SourcesOfSeedlings", type: "integer", nullable: true)]
    private ?int $sourcesOfSeedlings;

    #[Column(name: "InspecationReport", type: "text", nullable: true)]
    private ?string $inspecationReport;

    #[Column(name: "ClearedLand", type: "string", nullable: true)]
    private ?string $clearedLand;

    #[Column(name: "SeedlingsAllocated", type: "float", nullable: true)]
    private ?float $seedlingsAllocated;

    #[Column(name: "OldTrees", type: "string", nullable: true)]
    private ?string $oldTrees;

    public function __construct()
    {
        $this->provinceCode = 0;
        $this->districtCode = 0;
        $this->farmNo = 0;
    }

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getVillageCode(): ?int
    {
        return $this->villageCode;
    }

    public function setVillageCode(?int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerNo(): int
    {
        return $this->farmerNo;
    }

    public function setFarmerNo(int $value): static
    {
        $this->farmerNo = $value;
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getCoordinates(): ?string
    {
        return $this->coordinates;
    }

    public function setCoordinates(?string $value): static
    {
        $this->coordinates = $value;
        return $this;
    }

    public function getLatitude(): string
    {
        return $this->latitude;
    }

    public function setLatitude(string $value): static
    {
        $this->latitude = $value;
        return $this;
    }

    public function getLongitude(): string
    {
        return $this->longitude;
    }

    public function setLongitude(string $value): static
    {
        $this->longitude = $value;
        return $this;
    }

    public function getFieldType(): ?int
    {
        return $this->fieldType;
    }

    public function setFieldType(?int $value): static
    {
        $this->fieldType = $value;
        return $this;
    }

    public function getOwnership(): ?int
    {
        return $this->ownership;
    }

    public function setOwnership(?int $value): static
    {
        $this->ownership = $value;
        return $this;
    }

    public function getFarmSize(): ?string
    {
        return HtmlDecode($this->farmSize);
    }

    public function setFarmSize(?string $value): static
    {
        $this->farmSize = RemoveXss($value);
        return $this;
    }

    public function getFarmSizeEstimated(): ?float
    {
        return $this->farmSizeEstimated;
    }

    public function setFarmSizeEstimated(?float $value): static
    {
        $this->farmSizeEstimated = $value;
        return $this;
    }

    public function getTreesPlantedEstimated(): ?float
    {
        return $this->treesPlantedEstimated;
    }

    public function setTreesPlantedEstimated(?float $value): static
    {
        $this->treesPlantedEstimated = $value;
        return $this;
    }

    public function getFarmSizeVerified(): ?float
    {
        return $this->farmSizeVerified;
    }

    public function setFarmSizeVerified(?float $value): static
    {
        $this->farmSizeVerified = $value;
        return $this;
    }

    public function getTreesPlantedVerified(): ?float
    {
        return $this->treesPlantedVerified;
    }

    public function setTreesPlantedVerified(?float $value): static
    {
        $this->treesPlantedVerified = $value;
        return $this;
    }

    public function getSourcesOfSeedlings(): ?int
    {
        return $this->sourcesOfSeedlings;
    }

    public function setSourcesOfSeedlings(?int $value): static
    {
        $this->sourcesOfSeedlings = $value;
        return $this;
    }

    public function getInspecationReport(): ?string
    {
        return HtmlDecode($this->inspecationReport);
    }

    public function setInspecationReport(?string $value): static
    {
        $this->inspecationReport = RemoveXss($value);
        return $this;
    }

    public function getClearedLand(): ?string
    {
        return HtmlDecode($this->clearedLand);
    }

    public function setClearedLand(?string $value): static
    {
        $this->clearedLand = RemoveXss($value);
        return $this;
    }

    public function getSeedlingsAllocated(): ?float
    {
        return $this->seedlingsAllocated;
    }

    public function setSeedlingsAllocated(?float $value): static
    {
        $this->seedlingsAllocated = $value;
        return $this;
    }

    public function getOldTrees(): ?string
    {
        return HtmlDecode($this->oldTrees);
    }

    public function setOldTrees(?string $value): static
    {
        $this->oldTrees = RemoveXss($value);
        return $this;
    }
}
