<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "district_summary_view" table
 */
#[Entity]
#[Table(name: "district_summary_view")]
class DistrictSummaryView extends AbstractEntity
{
    #[Column(name: "DistrictCode", type: "integer", nullable: true)]
    private ?int $districtCode;

    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Column(name: "AgeGroup", type: "string", nullable: true)]
    private ?string $ageGroup;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "NoOfBeneficiaries", type: "bigint")]
    private string $noOfBeneficiaries;

    #[Column(name: "TreesAllocated", type: "decimal", nullable: true)]
    private ?string $treesAllocated;

    #[Column(name: "FarmingSeason", type: "smallint", nullable: true)]
    private ?int $farmingSeason;

    public function __construct()
    {
        $this->noOfBeneficiaries = "0";
    }

    public function getDistrictCode(): ?int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(?int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getAgeGroup(): ?string
    {
        return HtmlDecode($this->ageGroup);
    }

    public function setAgeGroup(?string $value): static
    {
        $this->ageGroup = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getNoOfBeneficiaries(): string
    {
        return $this->noOfBeneficiaries;
    }

    public function setNoOfBeneficiaries(string $value): static
    {
        $this->noOfBeneficiaries = $value;
        return $this;
    }

    public function getTreesAllocated(): ?string
    {
        return $this->treesAllocated;
    }

    public function setTreesAllocated(?string $value): static
    {
        $this->treesAllocated = $value;
        return $this;
    }

    public function getFarmingSeason(): ?int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(?int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }
}
