<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "beneficiary_by_gender" table
 */
#[Entity]
#[Table(name: "beneficiary_by_gender")]
class BeneficiaryByGender extends AbstractEntity
{
    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Id]
    #[Column(name: "FarmerNo", type: "integer")]
    #[GeneratedValue]
    private int $farmerNo;

    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Column(name: "FarmerName", type: "string")]
    private string $farmerName;

    #[Column(name: "FarmerType", type: "integer")]
    private int $farmerType;

    #[Column(name: "DOB", type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Id]
    #[Column(name: "FarmNo", type: "integer")]
    #[GeneratedValue]
    private int $farmNo;

    #[Column(name: "GRN", type: "string", nullable: true)]
    private ?string $grn;

    #[Column(name: "NurseryName", type: "string", nullable: true)]
    private ?string $nurseryName;

    #[Column(name: "Seedlings", type: "integer", nullable: true)]
    private ?int $seedlings;

    #[Column(name: "FarmingSeason", type: "smallint", nullable: true)]
    private ?int $farmingSeason;

    #[Column(name: "SeedType", type: "string", nullable: true)]
    private ?string $seedType;

    #[Column(name: "Age", type: "string", nullable: true)]
    private ?string $age;

    public function __construct(int $farmerNo, int $farmNo)
    {
        $this->farmerNo = $farmerNo;
        $this->farmNo = $farmNo;
        $this->farmerType = 1;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getFarmerNo(): int
    {
        return $this->farmerNo;
    }

    public function setFarmerNo(int $value): static
    {
        $this->farmerNo = $value;
        return $this;
    }

    public function getNrc(): string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerName(): string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getFarmerType(): int
    {
        return $this->farmerType;
    }

    public function setFarmerType(int $value): static
    {
        $this->farmerType = $value;
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getGrn(): ?string
    {
        return HtmlDecode($this->grn);
    }

    public function setGrn(?string $value): static
    {
        $this->grn = RemoveXss($value);
        return $this;
    }

    public function getNurseryName(): ?string
    {
        return HtmlDecode($this->nurseryName);
    }

    public function setNurseryName(?string $value): static
    {
        $this->nurseryName = RemoveXss($value);
        return $this;
    }

    public function getSeedlings(): ?int
    {
        return $this->seedlings;
    }

    public function setSeedlings(?int $value): static
    {
        $this->seedlings = $value;
        return $this;
    }

    public function getFarmingSeason(): ?int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(?int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }

    public function getSeedType(): ?string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(?string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getAge(): ?string
    {
        return HtmlDecode($this->age);
    }

    public function setAge(?string $value): static
    {
        $this->age = RemoveXss($value);
        return $this;
    }
}
