<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "awp" table
 */
#[Entity]
#[Table(name: "awp")]
class Awp extends AbstractEntity
{
    #[Column(name: "Component", type: "string", nullable: true)]
    private ?string $component;

    #[Column(name: "`Sub component`", options: ["name" => "Sub component"], type: "string", nullable: true)]
    private ?string $subcomponent;

    #[Column(name: "`Investment Cost`", options: ["name" => "Investment Cost"], type: "string", nullable: true)]
    private ?string $investmentCost;

    #[Column(name: "Type", type: "string", nullable: true)]
    private ?string $type;

    #[Column(name: "`Category of Expenditure`", options: ["name" => "Category of Expenditure"], type: "string", nullable: true)]
    private ?string $categoryofExpenditure;

    #[Column(name: "Activity", type: "string", nullable: true)]
    private ?string $activity;

    #[Column(name: "Implementer", type: "string", nullable: true)]
    private ?string $implementer;

    #[Column(name: "Indicator", type: "string", nullable: true)]
    private ?string $indicator;

    #[Column(name: "`Project Target`", options: ["name" => "Project Target"], type: "float", nullable: true)]
    private ?float $projectTarget;

    #[Column(name: "`2017 Target`", options: ["name" => "2017 Target"], type: "float", nullable: true)]
    private ?float $2017Target;

    #[Column(name: "`Project Budget`", options: ["name" => "Project Budget"], type: "float", nullable: true)]
    private ?float $projectBudget;

    #[Column(name: "StartMonth", type: "float", nullable: true)]
    private ?float $startMonth;

    #[Column(name: "EndMonth", type: "float", nullable: true)]
    private ?float $endMonth;

    #[Id]
    #[Column(name: "LineNo", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $lineNo;

    public function getComponent(): ?string
    {
        return HtmlDecode($this->component);
    }

    public function setComponent(?string $value): static
    {
        $this->component = RemoveXss($value);
        return $this;
    }

    public function getSubcomponent(): ?string
    {
        return HtmlDecode($this->subcomponent);
    }

    public function setSubcomponent(?string $value): static
    {
        $this->subcomponent = RemoveXss($value);
        return $this;
    }

    public function getInvestmentCost(): ?string
    {
        return HtmlDecode($this->investmentCost);
    }

    public function setInvestmentCost(?string $value): static
    {
        $this->investmentCost = RemoveXss($value);
        return $this;
    }

    public function getType(): ?string
    {
        return HtmlDecode($this->type);
    }

    public function setType(?string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getCategoryofExpenditure(): ?string
    {
        return HtmlDecode($this->categoryofExpenditure);
    }

    public function setCategoryofExpenditure(?string $value): static
    {
        $this->categoryofExpenditure = RemoveXss($value);
        return $this;
    }

    public function getActivity(): ?string
    {
        return HtmlDecode($this->activity);
    }

    public function setActivity(?string $value): static
    {
        $this->activity = RemoveXss($value);
        return $this;
    }

    public function getImplementer(): ?string
    {
        return HtmlDecode($this->implementer);
    }

    public function setImplementer(?string $value): static
    {
        $this->implementer = RemoveXss($value);
        return $this;
    }

    public function getIndicator(): ?string
    {
        return HtmlDecode($this->indicator);
    }

    public function setIndicator(?string $value): static
    {
        $this->indicator = RemoveXss($value);
        return $this;
    }

    public function getProjectTarget(): ?float
    {
        return $this->projectTarget;
    }

    public function setProjectTarget(?float $value): static
    {
        $this->projectTarget = $value;
        return $this;
    }

    public function get2017Target(): ?float
    {
        return $this->2017Target;
    }

    public function set2017Target(?float $value): static
    {
        $this->2017Target = $value;
        return $this;
    }

    public function getProjectBudget(): ?float
    {
        return $this->projectBudget;
    }

    public function setProjectBudget(?float $value): static
    {
        $this->projectBudget = $value;
        return $this;
    }

    public function getStartMonth(): ?float
    {
        return $this->startMonth;
    }

    public function setStartMonth(?float $value): static
    {
        $this->startMonth = $value;
        return $this;
    }

    public function getEndMonth(): ?float
    {
        return $this->endMonth;
    }

    public function setEndMonth(?float $value): static
    {
        $this->endMonth = $value;
        return $this;
    }

    public function getLineNo(): int
    {
        return $this->lineNo;
    }

    public function setLineNo(int $value): static
    {
        $this->lineNo = $value;
        return $this;
    }
}
