<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class SeedAllocateSrcEdit extends SeedAllocateSrc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SeedAllocateSrcEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "SeedAllocateSrcEdit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->FarmerName->setVisibility();
        $this->NRC->setVisibility();
        $this->Seedlings->setVisibility();
        $this->Seeds->setVisibility();
        $this->Type->setVisibility();
        $this->Supplier->setVisibility();
        $this->DateAllocated->setVisibility();
        $this->GRN->setVisibility();
        $this->season->setVisibility();
        $this->ID->setVisibility();
        $this->NurseryCode->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'seed_allocate_src';
        $this->TableName = 'seed_allocate_src';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (seed_allocate_src)
        if (!isset($GLOBALS["seed_allocate_src"]) || $GLOBALS["seed_allocate_src"]::class == PROJECT_NAMESPACE . "seed_allocate_src") {
            $GLOBALS["seed_allocate_src"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'seed_allocate_src');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "SeedAllocateSrcView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ID->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Load record by position
        $loadByPosition = false;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("ID") ?? Key(0) ?? Route(2)) !== null) {
                $this->ID->setQueryStringValue($keyValue);
                $this->ID->setOldValue($this->ID->QueryStringValue);
            } elseif (Post("ID") !== null) {
                $this->ID->setFormValue(Post("ID"));
                $this->ID->setOldValue($this->ID->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("ID") ?? Route("ID")) !== null) {
                    $this->ID->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->ID->CurrentValue = null;
                }
                if (!$loadByQuery || Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NUMBER")) !== null) {
                    $loadByPosition = true;
                }
            }

            // Load result set
            if ($this->isShow()) {
                if (!$this->IsModal) { // Normal edit page
                    $this->StartRecord = 1; // Initialize start position
                    $this->Recordset = $this->loadRecordset(); // Load records
                    if ($this->TotalRecords <= 0) { // No record found
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("SeedAllocateSrcList"); // Return to list page
                        return;
                    } elseif ($loadByPosition) { // Load record by position
                        $this->setupStartRecord(); // Set up start record position
                        // Point to current record
                        if ($this->StartRecord <= $this->TotalRecords) {
                            $this->fetch($this->StartRecord);
                            // Redirect to correct record
                            $this->loadRowValues($this->CurrentRow);
                            $url = $this->getCurrentUrl();
                            $this->terminate($url);
                            return;
                        }
                    } else { // Match key values
                        if ($this->ID->CurrentValue != null) {
                            while ($this->fetch()) {
                                if (SameString($this->ID->CurrentValue, $this->CurrentRow['ID'])) {
                                    $this->setStartRecordNumber($this->StartRecord); // Save record position
                                    $loaded = true;
                                    break;
                                } else {
                                    $this->StartRecord++;
                                }
                            }
                        }
                    }

                    // Load current row values
                    if ($loaded) {
                        $this->loadRowValues($this->CurrentRow);
                    }
                } else {
                    // Load current record
                    $loaded = $this->loadRow();
                } // End modal checking
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->IsModal) { // Normal edit page
                    if (!$loaded) {
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("SeedAllocateSrcList"); // Return to list page
                        return;
                    } else {
                    }
                } else { // Modal edit page
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("SeedAllocateSrcList"); // No matching record, return to list
                        return;
                    }
                } // End modal checking
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "SeedAllocateSrcList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "SeedAllocateSrcList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "SeedAllocateSrcList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();
        if (!$this->IsModal) { // Normal view page
            $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager, false, false);
            $this->Pager->PageNumberName = Config("TABLE_PAGE_NUMBER");
            $this->Pager->PagePhraseId = "Record"; // Show as record
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'FarmerName' first before field var 'x_FarmerName'
        $val = $CurrentForm->hasValue("FarmerName") ? $CurrentForm->getValue("FarmerName") : $CurrentForm->getValue("x_FarmerName");
        if (!$this->FarmerName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmerName->Visible = false; // Disable update for API request
            } else {
                $this->FarmerName->setFormValue($val);
            }
        }

        // Check field name 'NRC' first before field var 'x_NRC'
        $val = $CurrentForm->hasValue("NRC") ? $CurrentForm->getValue("NRC") : $CurrentForm->getValue("x_NRC");
        if (!$this->NRC->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NRC->Visible = false; // Disable update for API request
            } else {
                $this->NRC->setFormValue($val);
            }
        }

        // Check field name 'Seedlings' first before field var 'x_Seedlings'
        $val = $CurrentForm->hasValue("Seedlings") ? $CurrentForm->getValue("Seedlings") : $CurrentForm->getValue("x_Seedlings");
        if (!$this->Seedlings->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Seedlings->Visible = false; // Disable update for API request
            } else {
                $this->Seedlings->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Seeds' first before field var 'x_Seeds'
        $val = $CurrentForm->hasValue("Seeds") ? $CurrentForm->getValue("Seeds") : $CurrentForm->getValue("x_Seeds");
        if (!$this->Seeds->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Seeds->Visible = false; // Disable update for API request
            } else {
                $this->Seeds->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Type' first before field var 'x_Type'
        $val = $CurrentForm->hasValue("Type") ? $CurrentForm->getValue("Type") : $CurrentForm->getValue("x_Type");
        if (!$this->Type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Type->Visible = false; // Disable update for API request
            } else {
                $this->Type->setFormValue($val);
            }
        }

        // Check field name 'Supplier' first before field var 'x_Supplier'
        $val = $CurrentForm->hasValue("Supplier") ? $CurrentForm->getValue("Supplier") : $CurrentForm->getValue("x_Supplier");
        if (!$this->Supplier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Supplier->Visible = false; // Disable update for API request
            } else {
                $this->Supplier->setFormValue($val);
            }
        }

        // Check field name 'DateAllocated' first before field var 'x_DateAllocated'
        $val = $CurrentForm->hasValue("DateAllocated") ? $CurrentForm->getValue("DateAllocated") : $CurrentForm->getValue("x_DateAllocated");
        if (!$this->DateAllocated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DateAllocated->Visible = false; // Disable update for API request
            } else {
                $this->DateAllocated->setFormValue($val);
            }
        }

        // Check field name 'GRN' first before field var 'x_GRN'
        $val = $CurrentForm->hasValue("GRN") ? $CurrentForm->getValue("GRN") : $CurrentForm->getValue("x_GRN");
        if (!$this->GRN->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GRN->Visible = false; // Disable update for API request
            } else {
                $this->GRN->setFormValue($val);
            }
        }

        // Check field name 'season' first before field var 'x_season'
        $val = $CurrentForm->hasValue("season") ? $CurrentForm->getValue("season") : $CurrentForm->getValue("x_season");
        if (!$this->season->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->season->Visible = false; // Disable update for API request
            } else {
                $this->season->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ID' first before field var 'x_ID'
        $val = $CurrentForm->hasValue("ID") ? $CurrentForm->getValue("ID") : $CurrentForm->getValue("x_ID");
        if (!$this->ID->IsDetailKey) {
            $this->ID->setFormValue($val);
        }

        // Check field name 'NurseryCode' first before field var 'x_NurseryCode'
        $val = $CurrentForm->hasValue("NurseryCode") ? $CurrentForm->getValue("NurseryCode") : $CurrentForm->getValue("x_NurseryCode");
        if (!$this->NurseryCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NurseryCode->Visible = false; // Disable update for API request
            } else {
                $this->NurseryCode->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->FarmerName->CurrentValue = $this->FarmerName->FormValue;
        $this->NRC->CurrentValue = $this->NRC->FormValue;
        $this->Seedlings->CurrentValue = $this->Seedlings->FormValue;
        $this->Seeds->CurrentValue = $this->Seeds->FormValue;
        $this->Type->CurrentValue = $this->Type->FormValue;
        $this->Supplier->CurrentValue = $this->Supplier->FormValue;
        $this->DateAllocated->CurrentValue = $this->DateAllocated->FormValue;
        $this->GRN->CurrentValue = $this->GRN->FormValue;
        $this->season->CurrentValue = $this->season->FormValue;
        $this->ID->CurrentValue = $this->ID->FormValue;
        $this->NurseryCode->CurrentValue = $this->NurseryCode->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->FarmerName->setDbValue($row['FarmerName']);
        $this->NRC->setDbValue($row['NRC']);
        $this->Seedlings->setDbValue($row['Seedlings']);
        $this->Seeds->setDbValue($row['Seeds']);
        $this->Type->setDbValue($row['Type']);
        $this->Supplier->setDbValue($row['Supplier']);
        $this->DateAllocated->setDbValue($row['DateAllocated']);
        $this->GRN->setDbValue($row['GRN']);
        $this->season->setDbValue($row['season']);
        $this->ID->setDbValue($row['ID']);
        $this->NurseryCode->setDbValue($row['NurseryCode']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['FarmerName'] = $this->FarmerName->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['Seedlings'] = $this->Seedlings->DefaultValue;
        $row['Seeds'] = $this->Seeds->DefaultValue;
        $row['Type'] = $this->Type->DefaultValue;
        $row['Supplier'] = $this->Supplier->DefaultValue;
        $row['DateAllocated'] = $this->DateAllocated->DefaultValue;
        $row['GRN'] = $this->GRN->DefaultValue;
        $row['season'] = $this->season->DefaultValue;
        $row['ID'] = $this->ID->DefaultValue;
        $row['NurseryCode'] = $this->NurseryCode->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // FarmerName
        $this->FarmerName->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // Seedlings
        $this->Seedlings->RowCssClass = "row";

        // Seeds
        $this->Seeds->RowCssClass = "row";

        // Type
        $this->Type->RowCssClass = "row";

        // Supplier
        $this->Supplier->RowCssClass = "row";

        // DateAllocated
        $this->DateAllocated->RowCssClass = "row";

        // GRN
        $this->GRN->RowCssClass = "row";

        // season
        $this->season->RowCssClass = "row";

        // ID
        $this->ID->RowCssClass = "row";

        // NurseryCode
        $this->NurseryCode->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // FarmerName
            $this->FarmerName->ViewValue = $this->FarmerName->CurrentValue;

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;

            // Seedlings
            $this->Seedlings->ViewValue = $this->Seedlings->CurrentValue;
            $this->Seedlings->ViewValue = FormatNumber($this->Seedlings->ViewValue, $this->Seedlings->formatPattern());

            // Seeds
            $this->Seeds->ViewValue = $this->Seeds->CurrentValue;
            $this->Seeds->ViewValue = FormatNumber($this->Seeds->ViewValue, $this->Seeds->formatPattern());

            // Type
            $this->Type->ViewValue = $this->Type->CurrentValue;

            // Supplier
            $this->Supplier->ViewValue = $this->Supplier->CurrentValue;

            // DateAllocated
            $this->DateAllocated->ViewValue = $this->DateAllocated->CurrentValue;

            // GRN
            $this->GRN->ViewValue = $this->GRN->CurrentValue;

            // season
            $this->season->ViewValue = $this->season->CurrentValue;
            $this->season->ViewValue = FormatNumber($this->season->ViewValue, $this->season->formatPattern());

            // ID
            $this->ID->ViewValue = $this->ID->CurrentValue;

            // NurseryCode
            $this->NurseryCode->ViewValue = $this->NurseryCode->CurrentValue;
            $this->NurseryCode->ViewValue = FormatNumber($this->NurseryCode->ViewValue, $this->NurseryCode->formatPattern());

            // FarmerName
            $this->FarmerName->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // Seedlings
            $this->Seedlings->HrefValue = "";

            // Seeds
            $this->Seeds->HrefValue = "";

            // Type
            $this->Type->HrefValue = "";

            // Supplier
            $this->Supplier->HrefValue = "";

            // DateAllocated
            $this->DateAllocated->HrefValue = "";

            // GRN
            $this->GRN->HrefValue = "";

            // season
            $this->season->HrefValue = "";

            // ID
            $this->ID->HrefValue = "";

            // NurseryCode
            $this->NurseryCode->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // FarmerName
            $this->FarmerName->setupEditAttributes();
            if (!$this->FarmerName->Raw) {
                $this->FarmerName->CurrentValue = HtmlDecode($this->FarmerName->CurrentValue);
            }
            $this->FarmerName->EditValue = HtmlEncode($this->FarmerName->CurrentValue);
            $this->FarmerName->PlaceHolder = RemoveHtml($this->FarmerName->caption());

            // NRC
            $this->NRC->setupEditAttributes();
            if (!$this->NRC->Raw) {
                $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
            }
            $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // Seedlings
            $this->Seedlings->setupEditAttributes();
            $this->Seedlings->EditValue = $this->Seedlings->CurrentValue;
            $this->Seedlings->PlaceHolder = RemoveHtml($this->Seedlings->caption());
            if (strval($this->Seedlings->EditValue) != "" && is_numeric($this->Seedlings->EditValue)) {
                $this->Seedlings->EditValue = FormatNumber($this->Seedlings->EditValue, null);
            }

            // Seeds
            $this->Seeds->setupEditAttributes();
            $this->Seeds->EditValue = $this->Seeds->CurrentValue;
            $this->Seeds->PlaceHolder = RemoveHtml($this->Seeds->caption());
            if (strval($this->Seeds->EditValue) != "" && is_numeric($this->Seeds->EditValue)) {
                $this->Seeds->EditValue = FormatNumber($this->Seeds->EditValue, null);
            }

            // Type
            $this->Type->setupEditAttributes();
            if (!$this->Type->Raw) {
                $this->Type->CurrentValue = HtmlDecode($this->Type->CurrentValue);
            }
            $this->Type->EditValue = HtmlEncode($this->Type->CurrentValue);
            $this->Type->PlaceHolder = RemoveHtml($this->Type->caption());

            // Supplier
            $this->Supplier->setupEditAttributes();
            if (!$this->Supplier->Raw) {
                $this->Supplier->CurrentValue = HtmlDecode($this->Supplier->CurrentValue);
            }
            $this->Supplier->EditValue = HtmlEncode($this->Supplier->CurrentValue);
            $this->Supplier->PlaceHolder = RemoveHtml($this->Supplier->caption());

            // DateAllocated
            $this->DateAllocated->setupEditAttributes();
            if (!$this->DateAllocated->Raw) {
                $this->DateAllocated->CurrentValue = HtmlDecode($this->DateAllocated->CurrentValue);
            }
            $this->DateAllocated->EditValue = HtmlEncode($this->DateAllocated->CurrentValue);
            $this->DateAllocated->PlaceHolder = RemoveHtml($this->DateAllocated->caption());

            // GRN
            $this->GRN->setupEditAttributes();
            if (!$this->GRN->Raw) {
                $this->GRN->CurrentValue = HtmlDecode($this->GRN->CurrentValue);
            }
            $this->GRN->EditValue = HtmlEncode($this->GRN->CurrentValue);
            $this->GRN->PlaceHolder = RemoveHtml($this->GRN->caption());

            // season
            $this->season->setupEditAttributes();
            $this->season->EditValue = $this->season->CurrentValue;
            $this->season->PlaceHolder = RemoveHtml($this->season->caption());
            if (strval($this->season->EditValue) != "" && is_numeric($this->season->EditValue)) {
                $this->season->EditValue = FormatNumber($this->season->EditValue, null);
            }

            // ID
            $this->ID->setupEditAttributes();
            $this->ID->EditValue = $this->ID->CurrentValue;

            // NurseryCode
            $this->NurseryCode->setupEditAttributes();
            $this->NurseryCode->EditValue = $this->NurseryCode->CurrentValue;
            $this->NurseryCode->PlaceHolder = RemoveHtml($this->NurseryCode->caption());
            if (strval($this->NurseryCode->EditValue) != "" && is_numeric($this->NurseryCode->EditValue)) {
                $this->NurseryCode->EditValue = FormatNumber($this->NurseryCode->EditValue, null);
            }

            // Edit refer script

            // FarmerName
            $this->FarmerName->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // Seedlings
            $this->Seedlings->HrefValue = "";

            // Seeds
            $this->Seeds->HrefValue = "";

            // Type
            $this->Type->HrefValue = "";

            // Supplier
            $this->Supplier->HrefValue = "";

            // DateAllocated
            $this->DateAllocated->HrefValue = "";

            // GRN
            $this->GRN->HrefValue = "";

            // season
            $this->season->HrefValue = "";

            // ID
            $this->ID->HrefValue = "";

            // NurseryCode
            $this->NurseryCode->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->FarmerName->Visible && $this->FarmerName->Required) {
                if (!$this->FarmerName->IsDetailKey && EmptyValue($this->FarmerName->FormValue)) {
                    $this->FarmerName->addErrorMessage(str_replace("%s", $this->FarmerName->caption(), $this->FarmerName->RequiredErrorMessage));
                }
            }
            if ($this->NRC->Visible && $this->NRC->Required) {
                if (!$this->NRC->IsDetailKey && EmptyValue($this->NRC->FormValue)) {
                    $this->NRC->addErrorMessage(str_replace("%s", $this->NRC->caption(), $this->NRC->RequiredErrorMessage));
                }
            }
            if ($this->Seedlings->Visible && $this->Seedlings->Required) {
                if (!$this->Seedlings->IsDetailKey && EmptyValue($this->Seedlings->FormValue)) {
                    $this->Seedlings->addErrorMessage(str_replace("%s", $this->Seedlings->caption(), $this->Seedlings->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Seedlings->FormValue)) {
                $this->Seedlings->addErrorMessage($this->Seedlings->getErrorMessage(false));
            }
            if ($this->Seeds->Visible && $this->Seeds->Required) {
                if (!$this->Seeds->IsDetailKey && EmptyValue($this->Seeds->FormValue)) {
                    $this->Seeds->addErrorMessage(str_replace("%s", $this->Seeds->caption(), $this->Seeds->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Seeds->FormValue)) {
                $this->Seeds->addErrorMessage($this->Seeds->getErrorMessage(false));
            }
            if ($this->Type->Visible && $this->Type->Required) {
                if (!$this->Type->IsDetailKey && EmptyValue($this->Type->FormValue)) {
                    $this->Type->addErrorMessage(str_replace("%s", $this->Type->caption(), $this->Type->RequiredErrorMessage));
                }
            }
            if ($this->Supplier->Visible && $this->Supplier->Required) {
                if (!$this->Supplier->IsDetailKey && EmptyValue($this->Supplier->FormValue)) {
                    $this->Supplier->addErrorMessage(str_replace("%s", $this->Supplier->caption(), $this->Supplier->RequiredErrorMessage));
                }
            }
            if ($this->DateAllocated->Visible && $this->DateAllocated->Required) {
                if (!$this->DateAllocated->IsDetailKey && EmptyValue($this->DateAllocated->FormValue)) {
                    $this->DateAllocated->addErrorMessage(str_replace("%s", $this->DateAllocated->caption(), $this->DateAllocated->RequiredErrorMessage));
                }
            }
            if ($this->GRN->Visible && $this->GRN->Required) {
                if (!$this->GRN->IsDetailKey && EmptyValue($this->GRN->FormValue)) {
                    $this->GRN->addErrorMessage(str_replace("%s", $this->GRN->caption(), $this->GRN->RequiredErrorMessage));
                }
            }
            if ($this->season->Visible && $this->season->Required) {
                if (!$this->season->IsDetailKey && EmptyValue($this->season->FormValue)) {
                    $this->season->addErrorMessage(str_replace("%s", $this->season->caption(), $this->season->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->season->FormValue)) {
                $this->season->addErrorMessage($this->season->getErrorMessage(false));
            }
            if ($this->ID->Visible && $this->ID->Required) {
                if (!$this->ID->IsDetailKey && EmptyValue($this->ID->FormValue)) {
                    $this->ID->addErrorMessage(str_replace("%s", $this->ID->caption(), $this->ID->RequiredErrorMessage));
                }
            }
            if ($this->NurseryCode->Visible && $this->NurseryCode->Required) {
                if (!$this->NurseryCode->IsDetailKey && EmptyValue($this->NurseryCode->FormValue)) {
                    $this->NurseryCode->addErrorMessage(str_replace("%s", $this->NurseryCode->caption(), $this->NurseryCode->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->NurseryCode->FormValue)) {
                $this->NurseryCode->addErrorMessage($this->NurseryCode->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // FarmerName
        $this->FarmerName->setDbValueDef($rsnew, $this->FarmerName->CurrentValue, $this->FarmerName->ReadOnly);

        // NRC
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, $this->NRC->ReadOnly);

        // Seedlings
        $this->Seedlings->setDbValueDef($rsnew, $this->Seedlings->CurrentValue, $this->Seedlings->ReadOnly);

        // Seeds
        $this->Seeds->setDbValueDef($rsnew, $this->Seeds->CurrentValue, $this->Seeds->ReadOnly);

        // Type
        $this->Type->setDbValueDef($rsnew, $this->Type->CurrentValue, $this->Type->ReadOnly);

        // Supplier
        $this->Supplier->setDbValueDef($rsnew, $this->Supplier->CurrentValue, $this->Supplier->ReadOnly);

        // DateAllocated
        $this->DateAllocated->setDbValueDef($rsnew, $this->DateAllocated->CurrentValue, $this->DateAllocated->ReadOnly);

        // GRN
        $this->GRN->setDbValueDef($rsnew, $this->GRN->CurrentValue, $this->GRN->ReadOnly);

        // season
        $this->season->setDbValueDef($rsnew, $this->season->CurrentValue, $this->season->ReadOnly);

        // NurseryCode
        $this->NurseryCode->setDbValueDef($rsnew, $this->NurseryCode->CurrentValue, $this->NurseryCode->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['FarmerName'])) { // FarmerName
            $this->FarmerName->CurrentValue = $row['FarmerName'];
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->CurrentValue = $row['NRC'];
        }
        if (isset($row['Seedlings'])) { // Seedlings
            $this->Seedlings->CurrentValue = $row['Seedlings'];
        }
        if (isset($row['Seeds'])) { // Seeds
            $this->Seeds->CurrentValue = $row['Seeds'];
        }
        if (isset($row['Type'])) { // Type
            $this->Type->CurrentValue = $row['Type'];
        }
        if (isset($row['Supplier'])) { // Supplier
            $this->Supplier->CurrentValue = $row['Supplier'];
        }
        if (isset($row['DateAllocated'])) { // DateAllocated
            $this->DateAllocated->CurrentValue = $row['DateAllocated'];
        }
        if (isset($row['GRN'])) { // GRN
            $this->GRN->CurrentValue = $row['GRN'];
        }
        if (isset($row['season'])) { // season
            $this->season->CurrentValue = $row['season'];
        }
        if (isset($row['NurseryCode'])) { // NurseryCode
            $this->NurseryCode->CurrentValue = $row['NurseryCode'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("SeedAllocateSrcList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
