<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Table class for nursery_ref
 */
class NurseryRef extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ProvinceCode;
    public $DistrictCode;
    public $NurseryCode;
    public $NurseryName;
    public $NurseryType;
    public $PhysicalAddress;
    public $PostalAddress;
    public $Phone;
    public $_Email;
    public $NurseryOwnership;
    public $SeedVariety;
    public $NumberOfMembers;
    public $FemaleMembers;
    public $MaleMembers;
    public $YoungFemales;
    public $YoungMales;
    public $FemalesInManagement;
    public $MalesInManagement;
    public $Latitude;
    public $Longitude;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "nursery_ref";
        $this->TableName = 'nursery_ref';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "nursery_ref";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ProvinceCode
        $this->ProvinceCode = new DbField(
            $this, // Table
            'x_ProvinceCode', // Variable name
            'ProvinceCode', // Name
            '`ProvinceCode`', // Expression
            '`ProvinceCode`', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProvinceCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProvinceCode->InputTextType = "text";
        $this->ProvinceCode->Raw = true;
        $this->ProvinceCode->Nullable = false; // NOT NULL field
        $this->ProvinceCode->Required = true; // Required field
        $this->ProvinceCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProvinceCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ProvinceCode'] = &$this->ProvinceCode;

        // DistrictCode
        $this->DistrictCode = new DbField(
            $this, // Table
            'x_DistrictCode', // Variable name
            'DistrictCode', // Name
            '`DistrictCode`', // Expression
            '`DistrictCode`', // Basic search expression
            3, // Type
            2, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DistrictCode->InputTextType = "text";
        $this->DistrictCode->Raw = true;
        $this->DistrictCode->Nullable = false; // NOT NULL field
        $this->DistrictCode->Required = true; // Required field
        $this->DistrictCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->DistrictCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['DistrictCode'] = &$this->DistrictCode;

        // NurseryCode
        $this->NurseryCode = new DbField(
            $this, // Table
            'x_NurseryCode', // Variable name
            'NurseryCode', // Name
            '`NurseryCode`', // Expression
            '`NurseryCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NurseryCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NurseryCode->InputTextType = "text";
        $this->NurseryCode->Raw = true;
        $this->NurseryCode->Nullable = false; // NOT NULL field
        $this->NurseryCode->Required = true; // Required field
        $this->NurseryCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->NurseryCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['NurseryCode'] = &$this->NurseryCode;

        // NurseryName
        $this->NurseryName = new DbField(
            $this, // Table
            'x_NurseryName', // Variable name
            'NurseryName', // Name
            '`NurseryName`', // Expression
            '`NurseryName`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NurseryName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NurseryName->InputTextType = "text";
        $this->NurseryName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NurseryName'] = &$this->NurseryName;

        // NurseryType
        $this->NurseryType = new DbField(
            $this, // Table
            'x_NurseryType', // Variable name
            'NurseryType', // Name
            '`NurseryType`', // Expression
            '`NurseryType`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NurseryType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NurseryType->InputTextType = "text";
        $this->NurseryType->Raw = true;
        $this->NurseryType->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->NurseryType->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['NurseryType'] = &$this->NurseryType;

        // PhysicalAddress
        $this->PhysicalAddress = new DbField(
            $this, // Table
            'x_PhysicalAddress', // Variable name
            'PhysicalAddress', // Name
            '`PhysicalAddress`', // Expression
            '`PhysicalAddress`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PhysicalAddress`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PhysicalAddress->InputTextType = "text";
        $this->PhysicalAddress->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PhysicalAddress'] = &$this->PhysicalAddress;

        // PostalAddress
        $this->PostalAddress = new DbField(
            $this, // Table
            'x_PostalAddress', // Variable name
            'PostalAddress', // Name
            '`PostalAddress`', // Expression
            '`PostalAddress`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PostalAddress`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PostalAddress->InputTextType = "text";
        $this->PostalAddress->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PostalAddress'] = &$this->PostalAddress;

        // Phone
        $this->Phone = new DbField(
            $this, // Table
            'x_Phone', // Variable name
            'Phone', // Name
            '`Phone`', // Expression
            '`Phone`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Phone`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Phone->InputTextType = "text";
        $this->Phone->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Phone'] = &$this->Phone;

        // Email
        $this->_Email = new DbField(
            $this, // Table
            'x__Email', // Variable name
            'Email', // Name
            '`Email`', // Expression
            '`Email`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_Email->InputTextType = "text";
        $this->_Email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Email'] = &$this->_Email;

        // NurseryOwnership
        $this->NurseryOwnership = new DbField(
            $this, // Table
            'x_NurseryOwnership', // Variable name
            'NurseryOwnership', // Name
            '`NurseryOwnership`', // Expression
            '`NurseryOwnership`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NurseryOwnership`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NurseryOwnership->InputTextType = "text";
        $this->NurseryOwnership->Raw = true;
        $this->NurseryOwnership->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->NurseryOwnership->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['NurseryOwnership'] = &$this->NurseryOwnership;

        // SeedVariety
        $this->SeedVariety = new DbField(
            $this, // Table
            'x_SeedVariety', // Variable name
            'SeedVariety', // Name
            '`SeedVariety`', // Expression
            '`SeedVariety`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedVariety`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedVariety->InputTextType = "text";
        $this->SeedVariety->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['SeedVariety'] = &$this->SeedVariety;

        // NumberOfMembers
        $this->NumberOfMembers = new DbField(
            $this, // Table
            'x_NumberOfMembers', // Variable name
            'NumberOfMembers', // Name
            '`NumberOfMembers`', // Expression
            '`NumberOfMembers`', // Basic search expression
            3, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NumberOfMembers`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NumberOfMembers->InputTextType = "text";
        $this->NumberOfMembers->Raw = true;
        $this->NumberOfMembers->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->NumberOfMembers->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['NumberOfMembers'] = &$this->NumberOfMembers;

        // FemaleMembers
        $this->FemaleMembers = new DbField(
            $this, // Table
            'x_FemaleMembers', // Variable name
            'FemaleMembers', // Name
            '`FemaleMembers`', // Expression
            '`FemaleMembers`', // Basic search expression
            3, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FemaleMembers`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FemaleMembers->InputTextType = "text";
        $this->FemaleMembers->Raw = true;
        $this->FemaleMembers->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FemaleMembers->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FemaleMembers'] = &$this->FemaleMembers;

        // MaleMembers
        $this->MaleMembers = new DbField(
            $this, // Table
            'x_MaleMembers', // Variable name
            'MaleMembers', // Name
            '`MaleMembers`', // Expression
            '`MaleMembers`', // Basic search expression
            3, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaleMembers`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaleMembers->InputTextType = "text";
        $this->MaleMembers->Raw = true;
        $this->MaleMembers->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaleMembers->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['MaleMembers'] = &$this->MaleMembers;

        // YoungFemales
        $this->YoungFemales = new DbField(
            $this, // Table
            'x_YoungFemales', // Variable name
            'YoungFemales', // Name
            '`YoungFemales`', // Expression
            '`YoungFemales`', // Basic search expression
            3, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`YoungFemales`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->YoungFemales->InputTextType = "text";
        $this->YoungFemales->Raw = true;
        $this->YoungFemales->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->YoungFemales->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['YoungFemales'] = &$this->YoungFemales;

        // YoungMales
        $this->YoungMales = new DbField(
            $this, // Table
            'x_YoungMales', // Variable name
            'YoungMales', // Name
            '`YoungMales`', // Expression
            '`YoungMales`', // Basic search expression
            3, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`YoungMales`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->YoungMales->InputTextType = "text";
        $this->YoungMales->Raw = true;
        $this->YoungMales->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->YoungMales->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['YoungMales'] = &$this->YoungMales;

        // FemalesInManagement
        $this->FemalesInManagement = new DbField(
            $this, // Table
            'x_FemalesInManagement', // Variable name
            'FemalesInManagement', // Name
            '`FemalesInManagement`', // Expression
            '`FemalesInManagement`', // Basic search expression
            3, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FemalesInManagement`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FemalesInManagement->InputTextType = "text";
        $this->FemalesInManagement->Raw = true;
        $this->FemalesInManagement->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FemalesInManagement->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FemalesInManagement'] = &$this->FemalesInManagement;

        // MalesInManagement
        $this->MalesInManagement = new DbField(
            $this, // Table
            'x_MalesInManagement', // Variable name
            'MalesInManagement', // Name
            '`MalesInManagement`', // Expression
            '`MalesInManagement`', // Basic search expression
            3, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MalesInManagement`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MalesInManagement->InputTextType = "text";
        $this->MalesInManagement->Raw = true;
        $this->MalesInManagement->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MalesInManagement->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['MalesInManagement'] = &$this->MalesInManagement;

        // Latitude
        $this->Latitude = new DbField(
            $this, // Table
            'x_Latitude', // Variable name
            'Latitude', // Name
            '`Latitude`', // Expression
            '`Latitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Latitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Latitude->InputTextType = "text";
        $this->Latitude->Raw = true;
        $this->Latitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Latitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Latitude'] = &$this->Latitude;

        // Longitude
        $this->Longitude = new DbField(
            $this, // Table
            'x_Longitude', // Variable name
            'Longitude', // Name
            '`Longitude`', // Expression
            '`Longitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Longitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Longitude->InputTextType = "text";
        $this->Longitude->Raw = true;
        $this->Longitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Longitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Longitude'] = &$this->Longitude;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "nursery_ref";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ProvinceCode->DbValue = $row['ProvinceCode'];
        $this->DistrictCode->DbValue = $row['DistrictCode'];
        $this->NurseryCode->DbValue = $row['NurseryCode'];
        $this->NurseryName->DbValue = $row['NurseryName'];
        $this->NurseryType->DbValue = $row['NurseryType'];
        $this->PhysicalAddress->DbValue = $row['PhysicalAddress'];
        $this->PostalAddress->DbValue = $row['PostalAddress'];
        $this->Phone->DbValue = $row['Phone'];
        $this->_Email->DbValue = $row['Email'];
        $this->NurseryOwnership->DbValue = $row['NurseryOwnership'];
        $this->SeedVariety->DbValue = $row['SeedVariety'];
        $this->NumberOfMembers->DbValue = $row['NumberOfMembers'];
        $this->FemaleMembers->DbValue = $row['FemaleMembers'];
        $this->MaleMembers->DbValue = $row['MaleMembers'];
        $this->YoungFemales->DbValue = $row['YoungFemales'];
        $this->YoungMales->DbValue = $row['YoungMales'];
        $this->FemalesInManagement->DbValue = $row['FemalesInManagement'];
        $this->MalesInManagement->DbValue = $row['MalesInManagement'];
        $this->Latitude->DbValue = $row['Latitude'];
        $this->Longitude->DbValue = $row['Longitude'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("NurseryRefList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "NurseryRefView" => $Language->phrase("View"),
            "NurseryRefEdit" => $Language->phrase("Edit"),
            "NurseryRefAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "NurseryRefList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "NurseryRefView",
            Config("API_ADD_ACTION") => "NurseryRefAdd",
            Config("API_EDIT_ACTION") => "NurseryRefEdit",
            Config("API_DELETE_ACTION") => "NurseryRefDelete",
            Config("API_LIST_ACTION") => "NurseryRefList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "NurseryRefList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("NurseryRefView", $parm);
        } else {
            $url = $this->keyUrl("NurseryRefView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "NurseryRefAdd?" . $parm;
        } else {
            $url = "NurseryRefAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("NurseryRefEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("NurseryRefList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("NurseryRefAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("NurseryRefList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("NurseryRefDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->NurseryCode->setDbValue($row['NurseryCode']);
        $this->NurseryName->setDbValue($row['NurseryName']);
        $this->NurseryType->setDbValue($row['NurseryType']);
        $this->PhysicalAddress->setDbValue($row['PhysicalAddress']);
        $this->PostalAddress->setDbValue($row['PostalAddress']);
        $this->Phone->setDbValue($row['Phone']);
        $this->_Email->setDbValue($row['Email']);
        $this->NurseryOwnership->setDbValue($row['NurseryOwnership']);
        $this->SeedVariety->setDbValue($row['SeedVariety']);
        $this->NumberOfMembers->setDbValue($row['NumberOfMembers']);
        $this->FemaleMembers->setDbValue($row['FemaleMembers']);
        $this->MaleMembers->setDbValue($row['MaleMembers']);
        $this->YoungFemales->setDbValue($row['YoungFemales']);
        $this->YoungMales->setDbValue($row['YoungMales']);
        $this->FemalesInManagement->setDbValue($row['FemalesInManagement']);
        $this->MalesInManagement->setDbValue($row['MalesInManagement']);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "NurseryRefList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ProvinceCode

        // DistrictCode

        // NurseryCode

        // NurseryName

        // NurseryType

        // PhysicalAddress

        // PostalAddress

        // Phone

        // Email

        // NurseryOwnership

        // SeedVariety

        // NumberOfMembers

        // FemaleMembers

        // MaleMembers

        // YoungFemales

        // YoungMales

        // FemalesInManagement

        // MalesInManagement

        // Latitude

        // Longitude

        // ProvinceCode
        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
        $this->ProvinceCode->ViewValue = FormatNumber($this->ProvinceCode->ViewValue, $this->ProvinceCode->formatPattern());

        // DistrictCode
        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
        $this->DistrictCode->ViewValue = FormatNumber($this->DistrictCode->ViewValue, $this->DistrictCode->formatPattern());

        // NurseryCode
        $this->NurseryCode->ViewValue = $this->NurseryCode->CurrentValue;
        $this->NurseryCode->ViewValue = FormatNumber($this->NurseryCode->ViewValue, $this->NurseryCode->formatPattern());

        // NurseryName
        $this->NurseryName->ViewValue = $this->NurseryName->CurrentValue;

        // NurseryType
        $this->NurseryType->ViewValue = $this->NurseryType->CurrentValue;
        $this->NurseryType->ViewValue = FormatNumber($this->NurseryType->ViewValue, $this->NurseryType->formatPattern());

        // PhysicalAddress
        $this->PhysicalAddress->ViewValue = $this->PhysicalAddress->CurrentValue;

        // PostalAddress
        $this->PostalAddress->ViewValue = $this->PostalAddress->CurrentValue;

        // Phone
        $this->Phone->ViewValue = $this->Phone->CurrentValue;

        // Email
        $this->_Email->ViewValue = $this->_Email->CurrentValue;

        // NurseryOwnership
        $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->CurrentValue;
        $this->NurseryOwnership->ViewValue = FormatNumber($this->NurseryOwnership->ViewValue, $this->NurseryOwnership->formatPattern());

        // SeedVariety
        $this->SeedVariety->ViewValue = $this->SeedVariety->CurrentValue;

        // NumberOfMembers
        $this->NumberOfMembers->ViewValue = $this->NumberOfMembers->CurrentValue;
        $this->NumberOfMembers->ViewValue = FormatNumber($this->NumberOfMembers->ViewValue, $this->NumberOfMembers->formatPattern());

        // FemaleMembers
        $this->FemaleMembers->ViewValue = $this->FemaleMembers->CurrentValue;
        $this->FemaleMembers->ViewValue = FormatNumber($this->FemaleMembers->ViewValue, $this->FemaleMembers->formatPattern());

        // MaleMembers
        $this->MaleMembers->ViewValue = $this->MaleMembers->CurrentValue;
        $this->MaleMembers->ViewValue = FormatNumber($this->MaleMembers->ViewValue, $this->MaleMembers->formatPattern());

        // YoungFemales
        $this->YoungFemales->ViewValue = $this->YoungFemales->CurrentValue;
        $this->YoungFemales->ViewValue = FormatNumber($this->YoungFemales->ViewValue, $this->YoungFemales->formatPattern());

        // YoungMales
        $this->YoungMales->ViewValue = $this->YoungMales->CurrentValue;
        $this->YoungMales->ViewValue = FormatNumber($this->YoungMales->ViewValue, $this->YoungMales->formatPattern());

        // FemalesInManagement
        $this->FemalesInManagement->ViewValue = $this->FemalesInManagement->CurrentValue;
        $this->FemalesInManagement->ViewValue = FormatNumber($this->FemalesInManagement->ViewValue, $this->FemalesInManagement->formatPattern());

        // MalesInManagement
        $this->MalesInManagement->ViewValue = $this->MalesInManagement->CurrentValue;
        $this->MalesInManagement->ViewValue = FormatNumber($this->MalesInManagement->ViewValue, $this->MalesInManagement->formatPattern());

        // Latitude
        $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
        $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

        // Longitude
        $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
        $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

        // ProvinceCode
        $this->ProvinceCode->HrefValue = "";
        $this->ProvinceCode->TooltipValue = "";

        // DistrictCode
        $this->DistrictCode->HrefValue = "";
        $this->DistrictCode->TooltipValue = "";

        // NurseryCode
        $this->NurseryCode->HrefValue = "";
        $this->NurseryCode->TooltipValue = "";

        // NurseryName
        $this->NurseryName->HrefValue = "";
        $this->NurseryName->TooltipValue = "";

        // NurseryType
        $this->NurseryType->HrefValue = "";
        $this->NurseryType->TooltipValue = "";

        // PhysicalAddress
        $this->PhysicalAddress->HrefValue = "";
        $this->PhysicalAddress->TooltipValue = "";

        // PostalAddress
        $this->PostalAddress->HrefValue = "";
        $this->PostalAddress->TooltipValue = "";

        // Phone
        $this->Phone->HrefValue = "";
        $this->Phone->TooltipValue = "";

        // Email
        $this->_Email->HrefValue = "";
        $this->_Email->TooltipValue = "";

        // NurseryOwnership
        $this->NurseryOwnership->HrefValue = "";
        $this->NurseryOwnership->TooltipValue = "";

        // SeedVariety
        $this->SeedVariety->HrefValue = "";
        $this->SeedVariety->TooltipValue = "";

        // NumberOfMembers
        $this->NumberOfMembers->HrefValue = "";
        $this->NumberOfMembers->TooltipValue = "";

        // FemaleMembers
        $this->FemaleMembers->HrefValue = "";
        $this->FemaleMembers->TooltipValue = "";

        // MaleMembers
        $this->MaleMembers->HrefValue = "";
        $this->MaleMembers->TooltipValue = "";

        // YoungFemales
        $this->YoungFemales->HrefValue = "";
        $this->YoungFemales->TooltipValue = "";

        // YoungMales
        $this->YoungMales->HrefValue = "";
        $this->YoungMales->TooltipValue = "";

        // FemalesInManagement
        $this->FemalesInManagement->HrefValue = "";
        $this->FemalesInManagement->TooltipValue = "";

        // MalesInManagement
        $this->MalesInManagement->HrefValue = "";
        $this->MalesInManagement->TooltipValue = "";

        // Latitude
        $this->Latitude->HrefValue = "";
        $this->Latitude->TooltipValue = "";

        // Longitude
        $this->Longitude->HrefValue = "";
        $this->Longitude->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ProvinceCode
        $this->ProvinceCode->setupEditAttributes();
        $this->ProvinceCode->EditValue = $this->ProvinceCode->CurrentValue;
        $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
        if (strval($this->ProvinceCode->EditValue) != "" && is_numeric($this->ProvinceCode->EditValue)) {
            $this->ProvinceCode->EditValue = FormatNumber($this->ProvinceCode->EditValue, null);
        }

        // DistrictCode
        $this->DistrictCode->setupEditAttributes();
        $this->DistrictCode->EditValue = $this->DistrictCode->CurrentValue;
        $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
        if (strval($this->DistrictCode->EditValue) != "" && is_numeric($this->DistrictCode->EditValue)) {
            $this->DistrictCode->EditValue = FormatNumber($this->DistrictCode->EditValue, null);
        }

        // NurseryCode
        $this->NurseryCode->setupEditAttributes();
        $this->NurseryCode->EditValue = $this->NurseryCode->CurrentValue;
        $this->NurseryCode->PlaceHolder = RemoveHtml($this->NurseryCode->caption());
        if (strval($this->NurseryCode->EditValue) != "" && is_numeric($this->NurseryCode->EditValue)) {
            $this->NurseryCode->EditValue = FormatNumber($this->NurseryCode->EditValue, null);
        }

        // NurseryName
        $this->NurseryName->setupEditAttributes();
        if (!$this->NurseryName->Raw) {
            $this->NurseryName->CurrentValue = HtmlDecode($this->NurseryName->CurrentValue);
        }
        $this->NurseryName->EditValue = $this->NurseryName->CurrentValue;
        $this->NurseryName->PlaceHolder = RemoveHtml($this->NurseryName->caption());

        // NurseryType
        $this->NurseryType->setupEditAttributes();
        $this->NurseryType->EditValue = $this->NurseryType->CurrentValue;
        $this->NurseryType->PlaceHolder = RemoveHtml($this->NurseryType->caption());
        if (strval($this->NurseryType->EditValue) != "" && is_numeric($this->NurseryType->EditValue)) {
            $this->NurseryType->EditValue = FormatNumber($this->NurseryType->EditValue, null);
        }

        // PhysicalAddress
        $this->PhysicalAddress->setupEditAttributes();
        if (!$this->PhysicalAddress->Raw) {
            $this->PhysicalAddress->CurrentValue = HtmlDecode($this->PhysicalAddress->CurrentValue);
        }
        $this->PhysicalAddress->EditValue = $this->PhysicalAddress->CurrentValue;
        $this->PhysicalAddress->PlaceHolder = RemoveHtml($this->PhysicalAddress->caption());

        // PostalAddress
        $this->PostalAddress->setupEditAttributes();
        if (!$this->PostalAddress->Raw) {
            $this->PostalAddress->CurrentValue = HtmlDecode($this->PostalAddress->CurrentValue);
        }
        $this->PostalAddress->EditValue = $this->PostalAddress->CurrentValue;
        $this->PostalAddress->PlaceHolder = RemoveHtml($this->PostalAddress->caption());

        // Phone
        $this->Phone->setupEditAttributes();
        if (!$this->Phone->Raw) {
            $this->Phone->CurrentValue = HtmlDecode($this->Phone->CurrentValue);
        }
        $this->Phone->EditValue = $this->Phone->CurrentValue;
        $this->Phone->PlaceHolder = RemoveHtml($this->Phone->caption());

        // Email
        $this->_Email->setupEditAttributes();
        if (!$this->_Email->Raw) {
            $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
        }
        $this->_Email->EditValue = $this->_Email->CurrentValue;
        $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

        // NurseryOwnership
        $this->NurseryOwnership->setupEditAttributes();
        $this->NurseryOwnership->EditValue = $this->NurseryOwnership->CurrentValue;
        $this->NurseryOwnership->PlaceHolder = RemoveHtml($this->NurseryOwnership->caption());
        if (strval($this->NurseryOwnership->EditValue) != "" && is_numeric($this->NurseryOwnership->EditValue)) {
            $this->NurseryOwnership->EditValue = FormatNumber($this->NurseryOwnership->EditValue, null);
        }

        // SeedVariety
        $this->SeedVariety->setupEditAttributes();
        if (!$this->SeedVariety->Raw) {
            $this->SeedVariety->CurrentValue = HtmlDecode($this->SeedVariety->CurrentValue);
        }
        $this->SeedVariety->EditValue = $this->SeedVariety->CurrentValue;
        $this->SeedVariety->PlaceHolder = RemoveHtml($this->SeedVariety->caption());

        // NumberOfMembers
        $this->NumberOfMembers->setupEditAttributes();
        $this->NumberOfMembers->EditValue = $this->NumberOfMembers->CurrentValue;
        $this->NumberOfMembers->PlaceHolder = RemoveHtml($this->NumberOfMembers->caption());
        if (strval($this->NumberOfMembers->EditValue) != "" && is_numeric($this->NumberOfMembers->EditValue)) {
            $this->NumberOfMembers->EditValue = FormatNumber($this->NumberOfMembers->EditValue, null);
        }

        // FemaleMembers
        $this->FemaleMembers->setupEditAttributes();
        $this->FemaleMembers->EditValue = $this->FemaleMembers->CurrentValue;
        $this->FemaleMembers->PlaceHolder = RemoveHtml($this->FemaleMembers->caption());
        if (strval($this->FemaleMembers->EditValue) != "" && is_numeric($this->FemaleMembers->EditValue)) {
            $this->FemaleMembers->EditValue = FormatNumber($this->FemaleMembers->EditValue, null);
        }

        // MaleMembers
        $this->MaleMembers->setupEditAttributes();
        $this->MaleMembers->EditValue = $this->MaleMembers->CurrentValue;
        $this->MaleMembers->PlaceHolder = RemoveHtml($this->MaleMembers->caption());
        if (strval($this->MaleMembers->EditValue) != "" && is_numeric($this->MaleMembers->EditValue)) {
            $this->MaleMembers->EditValue = FormatNumber($this->MaleMembers->EditValue, null);
        }

        // YoungFemales
        $this->YoungFemales->setupEditAttributes();
        $this->YoungFemales->EditValue = $this->YoungFemales->CurrentValue;
        $this->YoungFemales->PlaceHolder = RemoveHtml($this->YoungFemales->caption());
        if (strval($this->YoungFemales->EditValue) != "" && is_numeric($this->YoungFemales->EditValue)) {
            $this->YoungFemales->EditValue = FormatNumber($this->YoungFemales->EditValue, null);
        }

        // YoungMales
        $this->YoungMales->setupEditAttributes();
        $this->YoungMales->EditValue = $this->YoungMales->CurrentValue;
        $this->YoungMales->PlaceHolder = RemoveHtml($this->YoungMales->caption());
        if (strval($this->YoungMales->EditValue) != "" && is_numeric($this->YoungMales->EditValue)) {
            $this->YoungMales->EditValue = FormatNumber($this->YoungMales->EditValue, null);
        }

        // FemalesInManagement
        $this->FemalesInManagement->setupEditAttributes();
        $this->FemalesInManagement->EditValue = $this->FemalesInManagement->CurrentValue;
        $this->FemalesInManagement->PlaceHolder = RemoveHtml($this->FemalesInManagement->caption());
        if (strval($this->FemalesInManagement->EditValue) != "" && is_numeric($this->FemalesInManagement->EditValue)) {
            $this->FemalesInManagement->EditValue = FormatNumber($this->FemalesInManagement->EditValue, null);
        }

        // MalesInManagement
        $this->MalesInManagement->setupEditAttributes();
        $this->MalesInManagement->EditValue = $this->MalesInManagement->CurrentValue;
        $this->MalesInManagement->PlaceHolder = RemoveHtml($this->MalesInManagement->caption());
        if (strval($this->MalesInManagement->EditValue) != "" && is_numeric($this->MalesInManagement->EditValue)) {
            $this->MalesInManagement->EditValue = FormatNumber($this->MalesInManagement->EditValue, null);
        }

        // Latitude
        $this->Latitude->setupEditAttributes();
        $this->Latitude->EditValue = $this->Latitude->CurrentValue;
        $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
        if (strval($this->Latitude->EditValue) != "" && is_numeric($this->Latitude->EditValue)) {
            $this->Latitude->EditValue = FormatNumber($this->Latitude->EditValue, null);
        }

        // Longitude
        $this->Longitude->setupEditAttributes();
        $this->Longitude->EditValue = $this->Longitude->CurrentValue;
        $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
        if (strval($this->Longitude->EditValue) != "" && is_numeric($this->Longitude->EditValue)) {
            $this->Longitude->EditValue = FormatNumber($this->Longitude->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->NurseryCode);
                    $doc->exportCaption($this->NurseryName);
                    $doc->exportCaption($this->NurseryType);
                    $doc->exportCaption($this->PhysicalAddress);
                    $doc->exportCaption($this->PostalAddress);
                    $doc->exportCaption($this->Phone);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->NurseryOwnership);
                    $doc->exportCaption($this->SeedVariety);
                    $doc->exportCaption($this->NumberOfMembers);
                    $doc->exportCaption($this->FemaleMembers);
                    $doc->exportCaption($this->MaleMembers);
                    $doc->exportCaption($this->YoungFemales);
                    $doc->exportCaption($this->YoungMales);
                    $doc->exportCaption($this->FemalesInManagement);
                    $doc->exportCaption($this->MalesInManagement);
                    $doc->exportCaption($this->Latitude);
                    $doc->exportCaption($this->Longitude);
                } else {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->NurseryCode);
                    $doc->exportCaption($this->NurseryName);
                    $doc->exportCaption($this->NurseryType);
                    $doc->exportCaption($this->PhysicalAddress);
                    $doc->exportCaption($this->PostalAddress);
                    $doc->exportCaption($this->Phone);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->NurseryOwnership);
                    $doc->exportCaption($this->SeedVariety);
                    $doc->exportCaption($this->NumberOfMembers);
                    $doc->exportCaption($this->FemaleMembers);
                    $doc->exportCaption($this->MaleMembers);
                    $doc->exportCaption($this->YoungFemales);
                    $doc->exportCaption($this->YoungMales);
                    $doc->exportCaption($this->FemalesInManagement);
                    $doc->exportCaption($this->MalesInManagement);
                    $doc->exportCaption($this->Latitude);
                    $doc->exportCaption($this->Longitude);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->NurseryCode);
                        $doc->exportField($this->NurseryName);
                        $doc->exportField($this->NurseryType);
                        $doc->exportField($this->PhysicalAddress);
                        $doc->exportField($this->PostalAddress);
                        $doc->exportField($this->Phone);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->NurseryOwnership);
                        $doc->exportField($this->SeedVariety);
                        $doc->exportField($this->NumberOfMembers);
                        $doc->exportField($this->FemaleMembers);
                        $doc->exportField($this->MaleMembers);
                        $doc->exportField($this->YoungFemales);
                        $doc->exportField($this->YoungMales);
                        $doc->exportField($this->FemalesInManagement);
                        $doc->exportField($this->MalesInManagement);
                        $doc->exportField($this->Latitude);
                        $doc->exportField($this->Longitude);
                    } else {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->NurseryCode);
                        $doc->exportField($this->NurseryName);
                        $doc->exportField($this->NurseryType);
                        $doc->exportField($this->PhysicalAddress);
                        $doc->exportField($this->PostalAddress);
                        $doc->exportField($this->Phone);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->NurseryOwnership);
                        $doc->exportField($this->SeedVariety);
                        $doc->exportField($this->NumberOfMembers);
                        $doc->exportField($this->FemaleMembers);
                        $doc->exportField($this->MaleMembers);
                        $doc->exportField($this->YoungFemales);
                        $doc->exportField($this->YoungMales);
                        $doc->exportField($this->FemalesInManagement);
                        $doc->exportField($this->MalesInManagement);
                        $doc->exportField($this->Latitude);
                        $doc->exportField($this->Longitude);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
